.TL
HOW TO ADD NEW PROGRAMS TO THE CARL SOFTWARE DISTRIBUTION
.AU
Gareth Loy
.PP
So you have a program you want to put in the CARL Software
Distribution?  Well, proceed as follows.
.SH
Read the Documentation
.PP
First, read the companion documents:
.I
Introduction to CARL Programming,
.R
and
.I
Computer Audio Research Laboratory Software Writers Guide.  
.R
(For on-line versions of these papers at CARL, see the Appendix below.)
The first deals with the user perspective of CARL programs, the latter
with the programmer's.  The appendix of the latter article contains a
code example that embodies many of the principles of the CARL programming
discipline.
.NH 1
First, a word about the layout of the CARL filesystem.  Wherever
possible, all files developed at CARL are quarantined to the /carl
filesystem.  We especially try to avoid putting any local files in
directories that are rewritten when new versions of UNIX are installed.
Sometimes this can't be helped, but it can be alleviated by judicious
use of symbolic links.
.LP
Some of the interesting subdirectories of /carl are:
.DS
bin	holds released binaries,
include	symbolic link from /usr/include/carl,
lib	symbolic link from /usr/local/lib,
man	holds released manual pages,
new	holds unreleased binaries,
src	top of source directories,
staff	top of staff home directories.
.DE
.LP
Under /carl/src are the subdirectories
.DS
carl	exported code
import	imported code
local	unexported code.
.DE
Non-exported programs go in /carl/src/local (locally modified
UNIX code, custom device drivers, shell scripts for local consumption,
etc.)  /carl/src/import is where we stick all code we receive from
elsewhere.  /carl/src/carl is where we put our export code.
(This logical layout leads to some seemingly redundant names, however,
such as /carl/src/carl/src, which is the top of the source files
of the CARL Software Distribution.  This is historical, and could
have been avoided by naming it /carl/src/export/src, which at least
breaks up the cycling.)
.LP
When CARL software is shipped, one puts on the tape all
directories at and below /carl/src/carl.  
(There is a Makefile to do this in /carl/src/carl/local.)
When a target site
imports this code, they might put it in /TargetName/src/import/carl.
When they install it, code, include files
and libraries might go in /TargetName/{bin,include,lib}, respectively.
.NH 1
Makefiles
.PP
If you are installing a program (as opposed to a library), 
get a copy of the CARL template for the makefile with the mm(1carl)
command.  The mm command creates a file named Makefile.m4 in your
directory.  If you already have
written a makefile, convert it to use the macro names as found in Makefile.m4,
and overwrite Makefile.m4 with your file.  
Then issue the mm command again to turn the template Makefile.m4 into
the file Makefile, which make(1) can run.
.PP
If you are creating a library, to be included in libcarl, look at the
structure of the sub-libraries of libcarl for how to do this.  
Libraries incorporated into libcarl are in subdirectories of
/carl/src/carl/src/lib.
Basically,
each sub-library (such as libfrm, libdgl, libprocom, etc.) builds itself
in the usual way, then runs ar(1) to incorporate the sub-library in libcarl.
The Makefile.m4 for libcarl in /carl/src/carl/src/lib will have to be modified
to run the makefile in your sub-library directory when libcarl is made.
.NH 1
Where to Put It?
.PP
Put any include files in /carl/src/carl/include/carl.  When a system is
being built at a host site, these are extracted to /usr/include/carl.
Sources should go in a subdirectory of /carl/src/carl/src.  If you are
installing a single program, examine the directories there for any that
may already be appropriately named for this function.  If one is found,
put the sources for your program there, and modify the Makefile.m4
in that directory so your program is compiled too.  
.PP
If no existing
directory is suitable, or the sources are spread over several files,
make a new directory under /carl/src/carl/src and copy your sources into it,
including your own Makefile.m4.  Fix up the file /carl/src/carl/src/Makefile.m4
to be sure it will visit your subdirectories too.
.NH 1
Documentation
.PP
CARL programs typically come with files for help(1carl) and man(1).
.PP
For help(1carl), put a copy of the help file in one of the subdirectories of
/carl/src/carl/src/help/helpfiles, depending on which topic the program fits.
Refer to help(1carl) for format of help files.
Also make a copy of your help page in the local CARL help subdirectory,
/carl/lib/help.
.PP
For man(1) pages, put a copy of the manual page in /carl/src/carl/man/man1.
Where the manual page refers to a sampling rate, use the terms DHISR,
DLOSR and DEFSR to refer to the default high sampling rate (49152 at CARL),
default low sampling rate (16384) and the default sampling rate to use
when none is specified (DLOSR at CARL).  When being installed on a host
machine, a sed(1) script is run on these pages to convert the macros to
the values given in the file /carl/src/carl/man/manc/srcvt.
Also put a copy of your manual page (with the macros converted to the
correct numbers) in the local directory for CARL manual pages: /usr/man/man1.
.PP
You should also tell the help(1carl) program about the source for your
program.  Make a file in the /carl/src/carl/src/help/helpfiles/sources
subdirectory that has the name of your program.  The contents of the
file should be the name of the principle source file in the distribution
area.
.PP
If there is other documentation for your program, it should go in a
subdirectory of /carl/src/carl/doc.  Look at what is there already to get
a flavor of where it should go.
.SH
And That's All There Is To It!
.PP
The copy in the distribution area (/carl/src/carl) will be copied out whenever
a new distribution tape is made.  This is also presumed to be the source
code for the currently running version at CARL.  For this to
be true depends on you!  As a way to guard this, you should never work
on a program in the distribution area.  Copy it out somewhere and copy
it back when your fix is known to work.  Intermediate, possibly buggy,
versions of programs should NEVER be distributed.  Programs, even by
expert programmers, should be allowed a trial period before being distributed.
.PP
To facilitate these considerations,
a typical practice is to maintain an experimental version of a program
in one's own area.  Experimental versions are published in /carl/new.
This way allows production users who may want stability more than bug fixes
to work unhindered.  
.PP
.NH 1
Makeing a CARL Distribution Tape
.PP
Mount a 1200 foot magtape.
Change directory to /carl/src/carl/local and say make.
.PP
CARL software is all in the public domain.
If you don't like this, don't put it on our tape.
.SH
APPENDIX
.PP
A summary of subdirectories and files relevant to CARL software.
.DS L
<carl/*.h>	include files
/carl/src/carl	root of Carl Software Distribution at CARL
subdirectories of /carl/src/carl:
	man	manual pages
	doc	all CARL documentation, tutorials and the Carl Startup Kit
	include	prototype include files
	local	procedures to make a CARL Software Distribution tape
	misc	copies of distribution letter
	src	program sources, master copy of Makefile.m4
program sources are divided as follows:
	sys	device drivers and other UNIX-related code
	lib	sources for libraries
	other	all other software
.DE
