.TL 
MANAGING BAD BLOCKS ON A CSOUND FILE SYSTEM
.PP
Files with names of the form BADBLOCKxx (where the 
.I xx 
is a trailing unique number or letter combination) are taken as files which
cover the location of a damaged portion of the disk.  These files will not
be moved by 
.B burpsf.
In all other respects, they are taken as normal files.
.PP
The method of locating a bad block must (unfortunately) be done by hand.
You must do this work logged in (or su'ed) as the 
.I csound 
superuser
(named disk at CARL).
.PP
When a disk hits a hard error, the block number, as reported on the console,
must be converted to a cylinder number by dividing the block number by
the number of blocks per cylinder.  (In Berkeley UNIX, blocks are 1024
bytes, and on a CDC 9766 disk, a cylinder is 311296 bytes).
.PP
The resulting cylinder number must
then be found by examining the free list.  
There is one free list for every csound file system, named /snd/dskcyls,
/snd1/dskcyls, etc.
(Since accessing a file with a bad block
terminates the i/o, one's attention is usually drawn to this file, which
provides an additional cross reference).  
The file with the bad block must
be deleted with 
.I rmsf.  
.PP
Then the free list must be manipulated by hand to isolate the
cylinder with the bad block.  Use your favorite text editor.
After isolating the block,
mark it as "used" by putting the
character 'u' at the beginning of the line.
Exit the text editor.
.PP
Then create a file, owned by the csound superuser, that is one cylinder
long, which has a unique name of the form BADBLOCKxx.  A command such
as
.DS
% sndout /snd/disk/BADBLOCK01
.DE
followed by ^D, will do.
Of course the
free storage system will put it at an arbitrary place other than where
you have isolated the bad block.  
.PP
What we are going to do now is to substitute the real bad block for the
block that was claimed by the creation of the BADBLOCKxx file.
.IP 1)
Edit the free list.
Change the allocation status of the cylinder block claimed by the
new file BADBLOCKxx to "not-used" by
placing 'n' at the head of the line.
.IP 2)
Change the filename of the real bad block to be the same as the BADBLOCKxx
file just created.  (It does not matter that two BADBLOCKxx files occur,
since the first one is now claimed to be unused).
.IP 3)
Now edit the SDF file for BADBLOCKxx.  Change the cylinder block pointer
line that begins with the letter 'v' to point at the bad block on the
free list.
.IP 4)
run 
.B sfck
to make sure you got everything ok.
.PP
After this, 
.B burpsf
will skip around this file in attempting to compact the disk.  
.SH 
BUGS
.PP
.B lsf
will still list it, so an attempt might be made to dump it under the
normal dumping scheme described in the document "Managing a Csound
Tape Dump Regimen."  
If the BADBLOCKxx file is zero length, however, the cylinder will
not be accessed at all, and the dump will succeed.
An alternate
solution is to filter the dump level output
of 
.B lsf
through 
.B sed
to remove all lines containing /BADBLOCK/ prior to dumping.
