
#import	"sndio.h"

int SNDReadHeaderFromStream(SNDSoundStruct **snd,FILE *stream)

{
    int		head[HEADNOINFO];
    int		info_size;
    char	*info;
    int		err = SND_ERR_NONE;

    fread((void *) &head,sizeof(int),HEADNOINFO,stream);

    if(head[0] == SND_MAGIC) {

	info_size = head[1] - (sizeof(int) * HEADNOINFO);

	if(info_size < 4)	info_size = 4;

	info = (char *) malloc(sizeof(char) * info_size);

	fread((void *) info,sizeof(char),info_size,stream);

	err = SNDAlloc(snd,head[2],head[3],head[4],head[5],info_size);

	if(err != SND_ERR_NONE)		return(err);

	strncpy((*snd)->info,info,info_size - 1);
    }
    else {
	rewind(stream);

	(*snd) = NULL;

	err = SND_ERR_NOT_SOUND;
    }
    return(err);
}
