
#import	"sndio.h"

int setchan(char *cs,int nc)	// array chans will be !=0 for each channel that is to be output

{
    char	*c,*d;
    int		i,j,
		numofhit = 0,		// number of output channels
		inc = 0;

    chans = (char *) calloc((unsigned) nc,sizeof(char));

    if(cs == NULL) {				// no channels specified? default to all channels
	for(i = 0; i < nc; i++) {
	    chans[i]++;
	    numofhit++;
	}
	return(numofhit);
    }
    for(c = cs; *c != '\0'; cs = ++c) {		// pick up specified channel numbers

	c = index(cs,',');

	if(c != NULL)	*c = '\0';

	if((d = index(cs,'x')) != NULL) {	// pickup chan inc
	    inc = sfexpr(d + 1,1.0);
	    *d = '\0';
	}
	i = sfexpr(cs,1.0);

	if(inc != 0) {
	    for(j = i; j <= nc; j += inc)	chans[j - 1]++;
	    inc = 0;
	}
	else {
	    if(0 < i && i <= nc)	chans[i - 1]++;
	}
	if(c == NULL)	break;
    }
    for(i = 0; i < nc; i++) {
	if(chans[i])	numofhit++;
    }
    return(numofhit);
}
