/* Soundfile Lookup Generator */

#include "mm.head.h"
#include "ug.head.h"

#if defined nextsf

#import <sound/sound.h>
#import <sys/file.h>
#import <sys/types.h>
#import <sys/stat.h>

SNDSoundStruct * snd ;

# endif nextsf

#define	AMP	1
#define	INCR	2
#define	FNAME	3
#define	CHANNEL	4
#define	FSTART	5
#define	FEND	6
#define	FRAME	7
#define	NCHAN	8
#define	SAMPS	9
#define	OFFSET	10
#define	FILEPTR	11

sndfile

#if defined nextsf
UGHEAD {
    UGINIT ;
    float sample, sample1, sample2 ;
    long nchan, size, offset ;
    long last, chan, nsamp ;
    FILE * fptr ;
    float interpsnd() ;
    struct stat buf ;

    if( STARTNOTE ) {
	if ( ( fptr = FPLOC( FILEPTR ) = fopen( SLOC( FNAME ), "r" ) ) == NULL) {
	    Error++ ;
	    PROUT( "SNDFILE: Error opening file '%s'", SLOC( FNAME ) ) ;
	    return ;
	}
	snd = ( SNDSoundStruct * ) calloc( 1, sizeof(SNDSoundStruct) ) ;
	fread( snd, sizeof(SNDSoundStruct), 1, fptr ) ;
	nchan = LVAL(NCHAN) = snd->channelCount ;
	stat( SLOC( FNAME ), &buf ) ;
	LVAL(SAMPS) = ( buf.st_size - sizeof(SNDSoundStruct) ) >> 1 ;
	chan = VAL( CHANNEL ) ;
	LVAL(OFFSET) = snd->dataLocation + ( chan << 1 ) ;	// from rb fix file
//	LVAL(OFFSET) = snd->dataLocation + ( ( (long) VAL( FSTART )*nchan + chan ) << 1 ) ;
	free( snd ) ;
	if( VAL( CHANNEL ) + 1 > snd->channelCount ) {
	    Error++ ;
	    PROUT( "SNDFILE: File does not contain '%.0f' channels",VAL( CHANNEL ) + 1. ) ;
	    return ;
	}
	VAL( FRAME ) = VAL( FSTART ) ;
    }
    fptr = FPLOC( FILEPTR ) ;
    nsamp = LVAL( SAMPS ) ;
    chan = VAL( CHANNEL ) ;
    nchan = LVAL( NCHAN ) ;
    offset = LVAL( OFFSET ) ;
    if( VAL( FEND ) < 0. ) VAL( FEND ) = nsamp/nchan - 1 ;
    size = VAL( FEND ) - VAL( FSTART ) + 1 ;
    last = VAL( FEND ) ;
    { double frame = VAL( FRAME ) ;
	UGLOOP {
	    VAL( OUT )++ = VAL( AMP ) * interpsnd( fptr, frame, size, last, nchan, offset ) ;
	    frame += VAL( INCR ) ;
	    while ( frame >= VAL( FEND ) ) frame -= size ;
	    while ( frame <= VAL(FSTART) ) frame += size ;
	    UGEND(1) ;
	}
	VAL( FRAME ) = frame ;
    }
    if ( ENDNOTE ) {
	fclose( fptr ) ;
    }
}
float interpsnd( fp, frame, size, last, nchan, offset )
 FILE * fp ; double frame ; long size, last, nchan, offset ; 
{
 long Int ;
 static int first = 1 ;
 static long P1, P2 ;
 static float S1, S2, Frac, Diff, floatsam ;
 static FILE * FP = NULL ;
 short sample ;
    if ( first ) {
	first = 0 ;
	floatsam = 1./32767. ;
    }
    if ( fp != FP ) {
	FP = fp ;
	P1 = -1 ;
	P2 = -2 ;
    }
    if ( ( Int = frame ) != P1 ) {
	if ( Int == P2 ) {
	    P1 = P2 ;
	    S1 = S2 ;
	} else {
	    P2 = P1 = Int ;
	    fseek( fp, offset + ( ( P1*nchan ) << 1 ), 0 ) ;
	    fread( &sample, sizeof(short), 1, fp ) ;
	    S1 = sample*floatsam ;
	}
	if ( ++P2 > last )
	    P2 -= size ;
	fseek( fp, offset + ( ( P2*nchan ) << 1 ), 0 ) ;
	fread( &sample, sizeof(short), 1, fp ) ;
	Diff = ( S2 = sample*floatsam ) - S1 ;
    }
    if ( ( Frac = frame - Int ) == 0.0 )
	return( S1 ) ;
    else
	return( S1 + Frac*Diff ) ;
}
# endif nextsf
# if !defined nextsf
UGHEAD {
    UGINIT ;
    fprintf( stderr," Unimplemented Unit Generator: SNDFILE\n" ) ;
}
#endif !nextsf
