
/* Generated by Interface Builder */

#import "DSP.h"

#define READ_TAG 1

#define DATA_SIZE (32*1024)
#define DMASIZE 4096
#define TWOPOW23 8388608
#define TWOPOW15 32768

static port_t cmd_port;


@implementation DSP

- setTitles:aTitle
{
    titles = aTitle ;
    [self start:self];
	    min[0] = 0; max[0] = 2730;
	    min[1] = - TWOPOW23; max[1] = TWOPOW23-1;
	    min[2] = - TWOPOW23; max[2] = TWOPOW23-1;
	    min[3] = - TWOPOW23; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"Time Lag"];
	    [[titles selectCellWithTag:1] setStringValue:"Filter Coef1"];
	    [[titles selectCellWithTag:2] setStringValue:"Filter Coef2"];
	    [[titles selectCellWithTag:3] setStringValue:"Filter Coef3"];
    return self;
}

-start:sender
{
    int s_err;
    int i ;

    netname_look_up(name_server_port,"","sound", &dev_port);
    DSPMKEnableSmallBuffers();
    DSPMKInitWithSoundOut(0);
    owner_port = DSPGetOwnerPort();
    cmd_port = DSPGetHostMessagePort();

    SNDReadDSPfile("FIR.lod", &Effect, NULL);

    s_err = SNDBootDSP(dev_port, owner_port, Effect);
    if (s_err != SND_ERR_NONE) {
	fprintf(stderr,"Cannot boot dsp : %s\n", SNDSoundError(s_err));
	exit(1);
    }
    printf("DSP booted\n");

return self; 
}




- update:sender
{
float value;
int tag,j;
int DSPCommand;

    tag = [[sender selectedCell] tag];
    DSPCommand = 20 + tag;
    value = [[sender selectedCell] floatValue];
    j = (int) ( min[tag] + (max[tag] - min[tag]) * value ) ;
	snddriver_dsp_write(cmd_port,&j,1,sizeof(int),SNDDRIVER_HIGH_PRIORITY);
	snddriver_dsp_host_cmd(cmd_port,DSPCommand,SNDDRIVER_MED_PRIORITY);
    return self;
}

- effect:sender
{
int tag,i;

    tag = [[sender selectedCell] tag];
    switch(tag)
    {
	case 0 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("FIR.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = 1; max[0] = 2730;
	    min[1] = - TWOPOW23; max[1] = TWOPOW23-1;
	    min[2] = - TWOPOW23; max[2] = TWOPOW23-1;
	    min[3] = - TWOPOW23; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"Time Lag"];
	    [[titles selectCellWithTag:1] setStringValue:"Filter Coef1"];
	    [[titles selectCellWithTag:2] setStringValue:"Filter Coef2"];
	    [[titles selectCellWithTag:3] setStringValue:"Filter Coef3"];
	    break;
	case 1 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("IIR.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = 1; max[0] = 40;
	    min[1] = - TWOPOW23; max[1] = TWOPOW23-1;
	    min[2] = - TWOPOW23 *.7; max[2] = 0;
	    min[3] = 0; max[3] = TWOPOW23/2;
	    [[titles selectCellWithTag:0] setStringValue:"Time Lag"];
	    [[titles selectCellWithTag:1] setStringValue:"Filter Coef1"];
	    [[titles selectCellWithTag:2] setStringValue:"Filter Coef2"];
	    [[titles selectCellWithTag:3] setStringValue:"Gain"];
	    break;
	case 2 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("AllPass.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = 1; max[0] = 2047;
	    min[1] = 0; max[1] = TWOPOW23-1;
	    min[2] = 0; max[2] = TWOPOW23-1;
	    min[3] = 0; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"Time_lag"];
	    [[titles selectCellWithTag:1] setStringValue:"Coeff"];
	    [[titles selectCellWithTag:2] setStringValue:""];
	    [[titles selectCellWithTag:3] setStringValue:""];
	    break;
	case 3 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("Mult.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = 0; max[0] = 1000000;
	    min[1] = 0; max[1] = TWOPOW23-1;
	    min[2] = 0; max[2] = TWOPOW23-1;
	    min[3] = 0; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"Freq Coar."];
	    [[titles selectCellWithTag:1] setStringValue:"Direct"];
	    [[titles selectCellWithTag:2] setStringValue:"Modulation"];
	    [[titles selectCellWithTag:3] setStringValue:""];
	    break;
	case 4 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("Shift.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = 0; max[0] = 200000;
	    min[1] = 0; max[1] = TWOPOW23-1;
	    min[2] = 0; max[2] = TWOPOW23-1;
	    min[3] = 0; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"Shift"];
	    [[titles selectCellWithTag:1] setStringValue:"Mix"];
	    [[titles selectCellWithTag:2] setStringValue:""];
	    [[titles selectCellWithTag:3] setStringValue:""];
	    break;
	case 5 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("Phasing.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = 0; max[0] = 2000;
	    min[1] = 0; max[1] = 4000;
	    min[2] = 0; max[2] = TWOPOW23 * 0.01;
	    min[3] = 0; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"Frequ"];
	    [[titles selectCellWithTag:1] setStringValue:"Time_lag"];
	    [[titles selectCellWithTag:2] setStringValue:"Dev"];
	    [[titles selectCellWithTag:3] setStringValue:"Mod"];
	    break;
	case 6 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("Stereo.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = 0; max[0] = 2047;
	    min[1] = 0; max[1] = TWOPOW23-1;
	    min[2] = 0; max[2] = 2047;
	    min[3] = 0; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"Lag R"];
	    [[titles selectCellWithTag:1] setStringValue:"Coeff R"];
	    [[titles selectCellWithTag:2] setStringValue:"Lag L"];
	    [[titles selectCellWithTag:3] setStringValue:"Coeff L"];
	    break;
	case 7 :    
	    snddriver_dsp_host_cmd(cmd_port,30,SNDDRIVER_MED_PRIORITY);
	    i = SNDReadDSPfile("perso.lod", &Effect, NULL);
	    if(i != 0) return;
	    SNDBootDSP(dev_port, owner_port, Effect);
	    min[0] = -100; max[0] = 100;
	    min[1] = 0; max[1] = 10000;
	    min[2] = 0; max[2] = TWOPOW23-1;
	    min[3] = 0; max[3] = TWOPOW23-1;
	    [[titles selectCellWithTag:0] setStringValue:"+-100"];
	    [[titles selectCellWithTag:1] setStringValue:"0_10000"];
	    [[titles selectCellWithTag:2] setStringValue:"float"];
	    [[titles selectCellWithTag:3] setStringValue:"float"];
	    break;
	case 8 :    
	    snddriver_dsp_host_cmd(cmd_port,0,SNDDRIVER_MED_PRIORITY);
	    break;
	default : break;
    }
    
    
}

@end
