/* Handle notifications
   Copyright (C) 1992 Free Software Foundation

This file is part of the GNU Hurd.

The GNU Hurd is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

The GNU Hurd is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with the GNU Hurd; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Michael I. Bushnell.  */

/* We ask for dead name notifications when tasks die.  */
do_mach_notify_dead_name (notify_port_t notify,
			  mach_port_name_t task)
{
  struct proc *p = task_find (task);
  
  if (!p)
    {
      /* O gee, whaddawe do? */
      printf ("proc: spurious dead name notification\n");
      return 0;
    }
  
  if (!p->p_exiting)
    p->p_status = W_EXITCODE (0, SIGKILL);

  if (p->p_parentset
      && p->p_parent->p_waiting
      && (p->p_parent->p_wc.pw_pid == p->p_pid
	  || p->p_parent->p_wc.pw_pid == 0
	  || p->p_parent->p_wc.pw_pid == - p->p_pgrp->pg_pgid))
    {
      complete_wait (p, p->p_status);
      proc_destroy (p, 0);
    }
  else if (p->p_parentset)
    p->p_exited = 1;
  else
    proc_destroy (p, 0);
}

