# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/* 
 * Mach Operating System
 * Copyright (c) 1991,1990 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	lexxer.l,v $
 * Revision 2.5  91/08/28  11:17:01  jsb
 * 	Added syServerDemux.
 * 	[91/08/13            rpd]
 * 
 * 	Removed syMsgKind, syCamelot, syCamelotRoutine, syTrapRoutine,
 * 	syTrapSimpleRoutine.  Added syMsgSeqno.
 * 	[91/08/11            rpd]
 * 
 * Revision 2.4  91/07/31  18:09:31  dbg
 * 	Add 'serverCopy' keyword.
 * 	[91/06/05            dbg]
 * 
 * 	Add 'c_string' keyword.
 * 	[91/04/03            dbg]
 * 
 * Revision 2.3  91/02/05  17:54:51  mrt
 * 	Changed to new Mach copyright
 * 	[91/02/01  17:54:35  mrt]
 * 
 * Revision 2.2  90/06/02  15:04:54  rpd
 * 	Created for new IPC.
 * 	[90/03/26  21:11:34  rpd]
 * 
 * 07-Apr-89  Richard Draves (rpd) at Carnegie-Mellon University
 *	Extensive revamping.  Added polymorphic arguments.
 *	Allow multiple variable-sized inline arguments in messages.
 *
 * 27-May-87  Richard Draves (rpd) at Carnegie-Mellon University
 *	Created.
 */

#include <mach/message.h>
#include "string.h"
#include "type.h"
#include "statement.h"
#include "global.h"
#include "parser.h"
#include "lexxer.h"

#ifdef	LDEBUG
#define RETURN(sym)							\
{									\
    printf("yylex: returning 'sym' (%d)\n", (sym));			\
    return (sym);							\
}
#else	LDEBUG
#define RETURN(sym)	return (sym)
#endif	LDEBUG

#define	TPRETURN(intype, outtype, tsize)				\
{									\
    yylval.symtype.innumber = (intype);					\
    yylval.symtype.instr = "intype";					\
    yylval.symtype.outnumber = (outtype);				\
    yylval.symtype.outstr = "outtype";					\
    yylval.symtype.size = (tsize);					\
    RETURN(sySymbolicType);						\
}

#define	TRETURN(type, tsize)	TPRETURN(type,type,tsize)

#define	FRETURN(val)							\
{									\
    yylval.flag = (val);						\
    RETURN(syIPCFlag);							\
}

static struct yysvf *oldYYBegin;

static void doSharp(); /* process body of # directives */
# define Normal 2
# define String 4
# define FileName 6
# define QString 8
# define SkipToEOL 10
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	RETURN(syRoutine);
break;
case 2:
RETURN(syFunction);
break;
case 3:
RETURN(syProcedure);
break;
case 4:
RETURN(sySimpleProcedure);
break;
case 5:
RETURN(sySimpleRoutine);
break;
case 6:
RETURN(sySubsystem);
break;
case 7:
RETURN(syMsgOption);
break;
case 8:
RETURN(syMsgSeqno);
break;
case 9:
RETURN(syWaitTime);
break;
case 10:
RETURN(syNoWaitTime);
break;
case 11:
			RETURN(syIn);
break;
case 12:
			RETURN(syOut);
break;
case 13:
		RETURN(syInOut);
break;
case 14:
RETURN(syRequestPort);
break;
case 15:
	RETURN(syReplyPort);
break;
case 16:
RETURN(syUReplyPort);
break;
case 17:
RETURN(sySReplyPort);
break;
case 18:
		RETURN(syArray);
break;
case 19:
			RETURN(syOf);
break;
case 20:
		RETURN(syErrorProc);
break;
case 21:
RETURN(syServerPrefix);
break;
case 22:
RETURN(syUserPrefix);
break;
case 23:
RETURN(syServerDemux);
break;
case 24:
		RETURN(syRCSId);
break;
case 25:
	RETURN(syImport);
break;
case 26:
	RETURN(syUImport);
break;
case 27:
	RETURN(sySImport);
break;
case 28:
		RETURN(syType);
break;
case 29:
RETURN(syKernelServer);
break;
case 30:
RETURN(syKernelUser);
break;
case 31:
		RETURN(sySkip);
break;
case 32:
	RETURN(syStruct);
break;
case 33:
	RETURN(syInTran);
break;
case 34:
	RETURN(syOutTran);
break;
case 35:
RETURN(syDestructor);
break;
case 36:
			RETURN(syCType);
break;
case 37:
	RETURN(syCUserType);
break;
case 38:
RETURN(syCServerType);
break;
case 39:
		RETURN(syCString);
break;
case 40:
	FRETURN(flLong);
break;
case 41:
FRETURN(flNotLong);
break;
case 42:
	FRETURN(flDealloc);
break;
case 43:
FRETURN(flNotDealloc);
break;
case 44:
FRETURN(flServerCopy);
break;
case 45:
TRETURN(MACH_MSG_TYPE_POLYMORPHIC,32);
break;
case 46:
TRETURN(MACH_MSG_TYPE_UNSTRUCTURED,0);
break;
case 47:
	TRETURN(MACH_MSG_TYPE_BIT,1);
break;
case 48:
	TRETURN(MACH_MSG_TYPE_BOOLEAN,32);
break;
case 49:
TRETURN(MACH_MSG_TYPE_INTEGER_16,16);
break;
case 50:
TRETURN(MACH_MSG_TYPE_INTEGER_32,32);
break;
case 51:
	TRETURN(MACH_MSG_TYPE_CHAR,8);
break;
case 52:
	TRETURN(MACH_MSG_TYPE_BYTE,8);
break;
case 53:
TRETURN(MACH_MSG_TYPE_INTEGER_8,8);
break;
case 54:
	TRETURN(MACH_MSG_TYPE_REAL,0);
break;
case 55:
	TRETURN(MACH_MSG_TYPE_STRING,0);
break;
case 56:
TRETURN(MACH_MSG_TYPE_STRING_C,0);
break;
case 57:
TPRETURN(MACH_MSG_TYPE_MOVE_RECEIVE,MACH_MSG_TYPE_PORT_RECEIVE,32);
break;
case 58:
TPRETURN(MACH_MSG_TYPE_COPY_SEND,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 59:
TPRETURN(MACH_MSG_TYPE_MAKE_SEND,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 60:
TPRETURN(MACH_MSG_TYPE_MOVE_SEND,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 61:
TPRETURN(MACH_MSG_TYPE_MAKE_SEND_ONCE,MACH_MSG_TYPE_PORT_SEND_ONCE,32);
break;
case 62:
TPRETURN(MACH_MSG_TYPE_MOVE_SEND_ONCE,MACH_MSG_TYPE_PORT_SEND_ONCE,32);
break;
case 63:
TRETURN(MACH_MSG_TYPE_PORT_NAME,32);
break;
case 64:
TPRETURN(MACH_MSG_TYPE_POLYMORPHIC,MACH_MSG_TYPE_PORT_RECEIVE,32);
break;
case 65:
TPRETURN(MACH_MSG_TYPE_POLYMORPHIC,MACH_MSG_TYPE_PORT_SEND,32);
break;
case 66:
TPRETURN(MACH_MSG_TYPE_POLYMORPHIC,MACH_MSG_TYPE_PORT_SEND_ONCE,32);
break;
case 67:
TRETURN(MACH_MSG_TYPE_POLYMORPHIC,0);
break;
case 68:
	RETURN(syColon);
break;
case 69:
	RETURN(sySemi);
break;
case 70:
	RETURN(syComma);
break;
case 71:
	RETURN(syPlus);
break;
case 72:
	RETURN(syMinus);
break;
case 73:
	RETURN(syStar);
break;
case 74:
	RETURN(syDiv);
break;
case 75:
	RETURN(syLParen);
break;
case 76:
	RETURN(syRParen);
break;
case 77:
	RETURN(syEqual);
break;
case 78:
	RETURN(syCaret);
break;
case 79:
	RETURN(syTilde);
break;
case 80:
	RETURN(syLAngle);
break;
case 81:
	RETURN(syRAngle);
break;
case 82:
	RETURN(syLBrack);
break;
case 83:
	RETURN(syRBrack);
break;
case 84:
	RETURN(syBar);
break;
case 85:
	{ yylval.identifier = strmake(yytext);
			  RETURN(syIdentifier); }
break;
case 86:
{ yylval.number = atoi(yytext); RETURN(syNumber); }
break;
case 87:
{ yylval.string = strmake(yytext);
			  BEGIN Normal; RETURN(syString); }
break;
case 88:
{ yylval.string = strmake(yytext);
			  BEGIN Normal; RETURN(syFileName); }
break;
case 89:
{ yylval.string = strmake(yytext);
			  BEGIN Normal; RETURN(syQString); }
break;
case 90:
{ doSharp(yytext+1);
					  oldYYBegin = yybgin;
					  BEGIN SkipToEOL; }
break;
case 91:
			{ doSharp(yytext+1);
					  oldYYBegin = yybgin;
					  BEGIN SkipToEOL; }
break;
case 92:
				{ yyerror("illegal # directive");
					  oldYYBegin = yybgin;
					  BEGIN SkipToEOL; }
break;
case 93:
	yybgin = oldYYBegin;
break;
case 94:
	;
break;
case 95:
		;
break;
case 96:
		{ BEGIN Normal; RETURN(syError); }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

extern void
LookNormal()
{
    BEGIN Normal;
}

extern void
LookString()
{
    BEGIN String;
}

extern void
LookQString()
{
    BEGIN QString;
}

extern void
LookFileName()
{
    BEGIN FileName;
}

static void
doSharp(body)
    char *body;
{
    register char *startName;

    yylineno = atoi(body);
    startName = index(body, '"');
    if (startName != NULL)
    {
	*rindex(body, '"') = '\0';
	strfree(yyinname);
	yyinname = strmake(startName+1);
    }
}
int yyvstop[] ={
0,

96,
0,

95,
96,
0,

95,
0,

92,
96,
0,

75,
96,
0,

76,
96,
0,

73,
96,
0,

71,
96,
0,

70,
96,
0,

72,
96,
0,

74,
96,
0,

86,
96,
0,

68,
96,
0,

69,
96,
0,

80,
96,
0,

77,
96,
0,

81,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

85,
96,
0,

82,
96,
0,

83,
96,
0,

78,
96,
0,

85,
96,
0,

84,
96,
0,

79,
96,
0,

87,
96,
0,

96,
0,

96,
0,

96,
0,

94,
96,
0,

94,
95,
96,
0,

93,
95,
0,

92,
94,
96,
0,

91,
0,

86,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

11,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

19,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

87,
0,

88,
0,

89,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

12,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

90,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

31,
85,
0,

85,
0,

85,
0,

85,
0,

28,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

18,
85,
0,

85,
0,

36,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

20,
85,
0,

85,
0,

85,
0,

13,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

24,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

25,
85,
0,

33,
85,
0,

40,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

32,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

42,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

34,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

1,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

27,
85,
0,

85,
0,

85,
0,

26,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

39,
85,
0,

85,
0,

2,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

8,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

9,
85,
0,

85,
0,

37,
85,
0,

85,
0,

41,
85,
0,

85,
0,

85,
0,

85,
0,

7,
85,
0,

85,
0,

85,
0,

85,
0,

3,
85,
0,

15,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

6,
85,
0,

85,
0,

85,
0,

85,
0,

35,
85,
0,

85,
0,

30,
85,
0,

85,
0,

43,
85,
0,

10,
85,
0,

85,
0,

85,
0,

44,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

17,
85,
0,

16,
85,
0,

22,
85,
0,

38,
85,
0,

85,
0,

85,
0,

45,
85,
0,

14,
85,
0,

23,
85,
0,

85,
0,

85,
0,

85,
0,

29,
85,
0,

85,
0,

21,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

5,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

4,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

47,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

52,
85,
0,

51,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

54,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

55,
85,
0,

85,
0,

48,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

56,
85,
0,

85,
0,

58,
85,
0,

85,
0,

85,
0,

53,
85,
0,

59,
85,
0,

85,
0,

60,
85,
0,

85,
0,

63,
85,
0,

85,
0,

65,
85,
0,

85,
0,

49,
85,
0,

50,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

67,
85,
0,

85,
0,

85,
0,

85,
0,

85,
0,

57,
85,
0,

85,
0,

64,
85,
0,

85,
0,

46,
85,
0,

85,
0,

85,
0,

85,
0,

61,
85,
0,

62,
85,
0,

66,
85,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,13,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,14,	1,15,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	100,0,	
102,0,	103,0,	63,106,	106,106,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,13,	
2,16,	1,13,	7,54,	8,54,	
8,16,	9,56,	10,56,	10,16,	
12,60,	63,106,	106,106,	63,107,	
106,107,	1,13,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
24,64,	24,64,	24,64,	24,64,	
0,0,	0,0,	0,0,	1,13,	
7,55,	8,55,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	1,13,	
1,13,	1,13,	1,13,	3,13,	
0,0,	31,65,	0,0,	34,72,	
46,98,	65,65,	0,0,	3,14,	
3,15,	0,0,	0,0,	0,0,	
38,78,	0,0,	0,0,	32,65,	
32,67,	32,68,	32,69,	35,65,	
39,80,	46,65,	35,73,	39,65,	
0,0,	0,0,	0,0,	0,0,	
32,70,	38,65,	38,79,	0,0,	
3,13,	31,65,	3,13,	34,72,	
46,98,	65,65,	3,17,	3,18,	
3,19,	3,20,	3,21,	3,22,	
0,0,	3,23,	3,24,	32,65,	
32,67,	32,68,	32,69,	35,65,	
39,80,	46,65,	35,73,	39,65,	
3,25,	3,26,	3,27,	3,28,	
3,29,	38,65,	38,79,	3,30,	
3,31,	3,32,	3,33,	3,34,	
3,35,	3,31,	3,31,	3,36,	
3,31,	3,37,	3,31,	3,38,	
3,39,	3,40,	3,41,	3,31,	
3,42,	3,43,	3,44,	3,45,	
3,31,	3,46,	3,31,	3,31,	
4,16,	3,47,	0,0,	3,48,	
3,49,	4,17,	4,18,	4,19,	
4,20,	4,21,	4,22,	41,83,	
4,23,	66,108,	41,84,	44,65,	
33,71,	37,77,	72,115,	3,50,	
40,81,	77,122,	44,94,	4,25,	
4,26,	4,27,	4,28,	0,0,	
0,0,	33,65,	37,65,	0,0,	
40,65,	68,65,	3,51,	40,82,	
3,52,	16,61,	50,65,	50,79,	
68,110,	81,65,	0,0,	41,83,	
0,0,	66,108,	41,84,	44,65,	
33,71,	37,77,	72,115,	0,0,	
40,81,	77,122,	44,94,	88,134,	
4,47,	0,0,	4,48,	4,49,	
16,62,	33,65,	37,65,	5,53,	
40,65,	68,65,	0,0,	40,82,	
0,0,	0,0,	50,65,	50,79,	
68,110,	81,65,	4,50,	5,53,	
16,63,	16,63,	16,63,	16,63,	
16,63,	16,63,	16,63,	16,63,	
16,63,	16,63,	0,0,	88,134,	
74,117,	4,51,	74,65,	4,52,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	5,53,	5,53,	5,53,	
5,53,	6,16,	6,53,	61,61,	
74,117,	0,0,	74,65,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	6,53,	0,0,	
0,0,	0,0,	0,0,	61,105,	
61,105,	61,105,	61,105,	61,105,	
61,105,	61,105,	61,105,	61,105,	
61,105,	0,0,	0,0,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
6,53,	6,53,	6,53,	6,53,	
11,57,	0,0,	42,85,	0,0,	
42,86,	36,74,	36,75,	67,109,	
11,58,	11,59,	36,65,	36,76,	
43,88,	45,95,	42,87,	0,0,	
43,89,	42,65,	43,90,	92,138,	
67,65,	75,118,	45,96,	45,97,	
75,65,	43,91,	75,119,	43,92,	
43,93,	0,0,	69,65,	69,111,	
0,0,	11,57,	42,85,	11,57,	
42,86,	36,74,	36,75,	67,109,	
0,0,	0,0,	36,65,	36,76,	
43,88,	45,95,	42,87,	11,57,	
43,89,	42,65,	43,90,	92,138,	
67,65,	75,118,	45,96,	45,97,	
75,65,	43,91,	75,119,	43,92,	
43,93,	11,57,	69,65,	69,111,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	11,57,	11,57,	11,57,	
11,57,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	0,0,	
70,65,	70,112,	109,147,	82,65,	
0,0,	82,127,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,66,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
70,65,	70,112,	109,147,	82,65,	
30,65,	82,127,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,66,	
30,65,	30,65,	30,65,	30,65,	
30,65,	30,65,	30,65,	30,65,	
53,99,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
78,123,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	0,0,	78,65,	
73,116,	85,65,	85,130,	0,0,	
73,65,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	78,65,	
73,116,	85,65,	85,130,	53,99,	
73,65,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	53,99,	
53,99,	53,99,	53,99,	54,100,	
0,0,	71,113,	0,0,	76,120,	
79,124,	76,121,	83,128,	54,100,	
54,0,	76,65,	93,139,	80,65,	
83,65,	80,125,	0,0,	79,65,	
80,126,	84,129,	71,65,	71,114,	
84,65,	86,131,	86,132,	86,65,	
87,65,	89,135,	93,65,	87,133,	
0,0,	119,157,	89,65,	0,0,	
54,101,	71,113,	54,100,	76,120,	
79,124,	76,121,	83,128,	0,0,	
0,0,	76,65,	93,139,	80,65,	
83,65,	80,125,	54,100,	79,65,	
80,126,	84,129,	71,65,	71,114,	
84,65,	86,131,	86,132,	86,65,	
87,65,	89,135,	93,65,	87,133,	
54,100,	119,157,	89,65,	54,100,	
54,100,	54,100,	54,100,	54,100,	
54,100,	54,100,	54,100,	54,100,	
54,100,	54,100,	54,100,	54,100,	
54,100,	54,100,	54,100,	54,100,	
54,100,	54,100,	54,100,	54,100,	
54,100,	54,100,	54,100,	54,100,	
55,102,	0,0,	90,136,	0,0,	
91,137,	94,140,	96,142,	94,65,	
55,102,	55,0,	97,143,	90,65,	
98,144,	95,141,	108,146,	0,0,	
125,164,	91,65,	95,65,	96,65,	
110,148,	98,65,	110,65,	97,65,	
112,65,	114,65,	112,150,	114,152,	
143,182,	0,0,	125,65,	108,65,	
0,0,	55,102,	90,136,	55,102,	
91,137,	94,140,	96,142,	94,65,	
0,0,	0,0,	97,143,	90,65,	
98,144,	95,141,	108,146,	55,102,	
125,164,	91,65,	95,65,	96,65,	
110,148,	98,65,	110,65,	97,65,	
112,65,	114,65,	112,150,	114,152,	
143,182,	55,101,	125,65,	108,65,	
55,102,	55,102,	55,102,	55,102,	
55,102,	55,102,	55,102,	55,102,	
55,102,	55,102,	55,102,	55,102,	
55,102,	55,102,	55,102,	55,102,	
55,102,	55,102,	55,102,	55,102,	
55,102,	55,102,	55,102,	55,102,	
55,102,	56,103,	0,0,	0,0,	
0,0,	123,161,	149,187,	113,151,	
115,153,	56,103,	56,0,	115,65,	
105,106,	113,65,	116,154,	123,65,	
0,0,	129,168,	111,149,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	116,65,	0,0,	111,65,	
129,65,	0,0,	56,104,	105,106,	
56,103,	105,107,	149,187,	113,151,	
115,153,	0,0,	0,0,	115,65,	
0,0,	113,65,	116,154,	123,65,	
56,103,	129,168,	111,149,	105,105,	
105,105,	105,105,	105,105,	105,105,	
105,105,	105,105,	105,105,	105,105,	
105,105,	116,65,	56,103,	111,65,	
129,65,	56,103,	56,103,	56,103,	
56,103,	56,103,	56,103,	56,103,	
56,103,	56,103,	56,103,	56,103,	
56,103,	56,103,	56,103,	56,103,	
56,103,	56,103,	56,103,	56,103,	
56,103,	56,103,	56,103,	56,103,	
56,103,	56,103,	107,107,	0,0,	
117,155,	0,0,	118,65,	117,65,	
126,165,	118,156,	107,107,	107,107,	
120,158,	121,159,	122,160,	120,65,	
121,65,	0,0,	122,65,	124,162,	
128,65,	130,169,	124,65,	124,163,	
127,65,	126,65,	127,166,	128,167,	
150,188,	132,65,	130,65,	0,0,	
132,171,	152,190,	0,0,	107,145,	
117,155,	107,107,	118,65,	117,65,	
126,165,	118,156,	0,0,	0,0,	
120,158,	121,159,	122,160,	120,65,	
121,65,	107,107,	122,65,	124,162,	
128,65,	130,169,	124,65,	124,163,	
127,65,	126,65,	127,166,	128,167,	
150,188,	132,65,	130,65,	107,107,	
132,171,	152,190,	107,107,	107,107,	
107,107,	107,107,	107,107,	107,107,	
107,107,	107,107,	107,107,	107,107,	
107,107,	107,107,	107,107,	107,107,	
107,107,	107,107,	107,107,	107,107,	
107,107,	107,107,	107,107,	107,107,	
107,107,	107,107,	107,107,	131,170,	
133,65,	0,0,	133,172,	134,65,	
135,174,	131,65,	135,65,	134,173,	
136,175,	137,176,	136,65,	137,65,	
138,65,	139,65,	139,178,	138,177,	
140,179,	141,180,	142,181,	141,65,	
142,65,	144,65,	0,0,	144,183,	
147,65,	0,0,	146,65,	153,191,	
147,185,	140,65,	0,0,	131,170,	
133,65,	146,184,	133,172,	134,65,	
135,174,	131,65,	135,65,	134,173,	
136,175,	137,176,	136,65,	137,65,	
138,65,	139,65,	139,178,	138,177,	
140,179,	141,180,	142,181,	141,65,	
142,65,	144,65,	148,186,	144,183,	
147,65,	151,189,	146,65,	153,191,	
147,185,	140,65,	154,65,	151,65,	
154,192,	146,184,	155,193,	148,65,	
156,65,	158,196,	156,194,	157,195,	
159,65,	158,65,	159,197,	166,204,	
165,203,	160,198,	161,65,	162,200,	
163,201,	162,65,	167,205,	0,0,	
164,202,	165,65,	148,186,	167,65,	
157,65,	151,189,	160,65,	161,199,	
0,0,	163,65,	154,65,	151,65,	
154,192,	164,65,	155,193,	148,65,	
156,65,	158,196,	156,194,	157,195,	
159,65,	158,65,	159,197,	166,204,	
165,203,	160,198,	161,65,	162,200,	
163,201,	162,65,	167,205,	168,206,	
164,202,	165,65,	169,207,	167,65,	
157,65,	171,209,	160,65,	170,65,	
172,210,	163,65,	173,211,	175,65,	
168,65,	164,65,	170,208,	176,214,	
169,65,	172,65,	171,65,	174,212,	
177,215,	176,65,	174,213,	173,65,	
179,65,	174,65,	178,65,	180,217,	
184,65,	0,0,	180,65,	168,206,	
181,218,	178,216,	169,207,	177,65,	
0,0,	171,209,	181,65,	170,65,	
172,210,	186,65,	173,211,	175,65,	
168,65,	191,65,	170,208,	176,214,	
169,65,	172,65,	171,65,	174,212,	
177,215,	176,65,	174,213,	173,65,	
179,65,	174,65,	178,65,	180,217,	
184,65,	182,219,	180,65,	182,65,	
181,218,	178,216,	183,65,	177,65,	
183,220,	185,221,	181,65,	188,223,	
187,65,	186,65,	187,222,	189,224,	
190,65,	191,65,	189,65,	190,225,	
188,65,	192,226,	185,65,	193,65,	
194,65,	193,227,	196,229,	195,228,	
197,230,	0,0,	192,65,	195,65,	
202,235,	182,219,	197,65,	182,65,	
198,231,	196,65,	183,65,	0,0,	
183,220,	185,221,	198,65,	188,223,	
187,65,	0,0,	187,222,	189,224,	
190,65,	202,65,	189,65,	190,225,	
188,65,	192,226,	185,65,	193,65,	
194,65,	193,227,	196,229,	195,228,	
197,230,	204,237,	192,65,	195,65,	
202,235,	199,232,	197,65,	207,65,	
198,231,	196,65,	199,65,	200,65,	
206,239,	200,233,	198,65,	201,234,	
201,65,	203,65,	204,65,	203,236,	
205,238,	202,65,	208,240,	205,65,	
208,65,	210,242,	206,65,	209,65,	
209,241,	210,65,	211,243,	213,245,	
0,0,	204,237,	214,65,	215,65,	
217,249,	215,247,	0,0,	207,65,	
212,244,	214,246,	199,65,	200,65,	
206,239,	200,233,	219,251,	201,234,	
201,65,	203,65,	204,65,	203,236,	
205,238,	212,65,	208,240,	205,65,	
208,65,	210,242,	206,65,	209,65,	
209,241,	210,65,	211,243,	213,245,	
216,65,	216,248,	214,65,	215,65,	
217,249,	215,247,	218,65,	220,252,	
212,244,	214,246,	221,253,	222,65,	
224,256,	218,250,	219,251,	223,255,	
220,65,	227,65,	222,254,	223,65,	
225,257,	212,65,	226,258,	228,65,	
229,65,	226,65,	230,259,	224,65,	
0,0,	230,65,	0,0,	0,0,	
216,65,	216,248,	0,0,	225,65,	
232,65,	232,262,	218,65,	220,252,	
235,265,	0,0,	221,253,	222,65,	
224,256,	218,250,	235,65,	223,255,	
220,65,	227,65,	222,254,	223,65,	
225,257,	238,268,	226,258,	228,65,	
229,65,	226,65,	230,259,	224,65,	
233,263,	230,65,	231,65,	231,260,	
247,65,	231,261,	234,264,	225,65,	
232,65,	233,65,	234,65,	236,65,	
235,265,	236,266,	239,65,	237,267,	
242,272,	239,269,	235,65,	237,65,	
240,270,	256,65,	241,65,	240,65,	
241,271,	238,268,	0,0,	267,65,	
244,276,	242,65,	244,277,	245,65,	
233,263,	245,278,	231,65,	231,260,	
247,65,	231,261,	234,264,	0,0,	
0,0,	233,65,	234,65,	236,65,	
0,0,	236,266,	239,65,	237,267,	
242,272,	239,269,	0,0,	237,65,	
240,270,	256,65,	241,65,	240,65,	
241,271,	243,273,	243,274,	267,65,	
244,276,	242,65,	244,277,	245,65,	
246,279,	245,278,	246,65,	248,65,	
251,283,	248,280,	243,275,	249,65,	
243,65,	249,281,	250,282,	252,284,	
250,65,	253,65,	0,0,	253,285,	
252,65,	251,65,	254,286,	255,287,	
254,65,	257,65,	269,299,	257,288,	
258,289,	243,273,	243,274,	259,290,	
258,65,	0,0,	255,65,	259,65,	
246,279,	260,291,	246,65,	248,65,	
251,283,	248,280,	243,275,	249,65,	
243,65,	249,281,	250,282,	252,284,	
250,65,	253,65,	260,65,	253,285,	
252,65,	251,65,	254,286,	255,287,	
254,65,	257,65,	269,299,	257,288,	
258,289,	261,65,	261,292,	259,290,	
258,65,	262,293,	255,65,	259,65,	
263,294,	260,291,	264,295,	263,65,	
265,296,	264,65,	266,297,	268,298,	
262,65,	268,65,	265,65,	270,300,	
272,65,	275,304,	260,65,	266,65,	
271,301,	273,302,	271,65,	276,305,	
273,65,	277,306,	278,65,	0,0,	
277,65,	261,65,	261,292,	279,307,	
281,65,	0,0,	279,65,	0,0,	
263,294,	274,303,	264,295,	263,65,	
265,296,	264,65,	266,297,	268,298,	
262,65,	268,65,	265,65,	270,300,	
272,65,	275,304,	274,65,	266,65,	
271,301,	273,302,	271,65,	276,305,	
273,65,	277,306,	278,65,	280,308,	
277,65,	283,310,	282,309,	279,307,	
281,65,	282,65,	279,65,	284,311,	
285,65,	274,303,	286,313,	287,65,	
280,65,	283,65,	288,314,	285,312,	
289,65,	288,65,	290,315,	291,316,	
284,65,	295,65,	274,65,	286,65,	
296,320,	292,317,	294,319,	296,65,	
293,65,	290,65,	294,65,	280,308,	
0,0,	283,310,	282,309,	0,0,	
0,0,	282,65,	292,65,	284,311,	
285,65,	293,318,	286,313,	287,65,	
280,65,	283,65,	288,314,	285,312,	
289,65,	288,65,	290,315,	291,316,	
284,65,	295,65,	298,322,	286,65,	
296,320,	292,317,	294,319,	296,65,	
293,65,	290,65,	294,65,	297,321,	
298,65,	299,323,	304,328,	300,65,	
297,65,	300,324,	292,65,	301,325,	
303,327,	302,326,	301,65,	302,65,	
307,331,	303,65,	299,65,	304,65,	
305,329,	306,65,	308,332,	305,65,	
306,330,	309,333,	298,322,	308,65,	
311,65,	312,335,	313,65,	312,65,	
314,336,	310,334,	315,65,	297,321,	
298,65,	299,323,	304,328,	300,65,	
297,65,	300,324,	310,65,	301,325,	
303,327,	302,326,	301,65,	302,65,	
307,331,	303,65,	299,65,	304,65,	
305,329,	306,65,	308,332,	305,65,	
306,330,	309,333,	317,338,	308,65,	
311,65,	312,335,	313,65,	312,65,	
314,336,	310,334,	315,65,	316,65,	
318,65,	319,65,	318,339,	316,337,	
320,340,	321,341,	310,65,	322,342,	
323,65,	324,65,	325,343,	327,65,	
328,346,	326,65,	327,345,	329,347,	
322,65,	332,65,	321,65,	320,65,	
326,344,	330,65,	317,338,	330,348,	
328,65,	331,65,	333,65,	331,349,	
333,350,	0,0,	329,65,	316,65,	
318,65,	319,65,	336,65,	316,337,	
320,340,	321,341,	338,65,	322,342,	
323,65,	324,65,	325,343,	327,65,	
328,346,	326,65,	327,345,	329,347,	
322,65,	332,65,	321,65,	320,65,	
326,344,	330,65,	340,65,	330,348,	
328,65,	331,65,	333,65,	331,349,	
333,350,	334,65,	329,65,	335,352,	
337,353,	339,65,	336,65,	334,351,	
341,65,	342,355,	338,65,	343,65,	
339,354,	343,356,	344,65,	345,65,	
335,65,	337,65,	346,358,	347,359,	
348,360,	345,357,	349,65,	350,65,	
342,65,	351,65,	340,65,	346,65,	
352,65,	348,65,	353,361,	355,65,	
347,65,	334,65,	356,65,	335,352,	
337,353,	339,65,	357,65,	334,351,	
341,65,	342,355,	354,362,	343,65,	
354,65,	343,356,	344,65,	345,65,	
335,65,	337,65,	346,358,	347,359,	
348,360,	345,357,	349,65,	350,65,	
342,65,	351,65,	359,364,	346,65,	
352,65,	348,65,	353,361,	355,65,	
347,65,	358,65,	356,65,	361,65,	
362,366,	360,365,	357,65,	358,363,	
359,65,	360,65,	363,65,	364,65,	
354,65,	367,370,	364,367,	365,368,	
366,65,	362,65,	368,65,	375,388,	
373,385,	370,379,	375,65,	378,391,	
373,65,	0,0,	359,364,	378,65,	
365,65,	366,369,	0,0,	0,0,	
0,0,	358,65,	370,65,	361,65,	
0,0,	360,365,	0,0,	358,363,	
359,65,	360,65,	363,65,	364,65,	
376,389,	367,370,	364,367,	365,368,	
366,65,	362,65,	368,65,	369,371,	
369,372,	370,379,	375,65,	371,380,	
373,65,	376,65,	369,373,	378,65,	
365,65,	371,381,	369,374,	374,386,	
371,65,	369,375,	370,65,	369,376,	
369,377,	372,383,	369,378,	371,382,	
377,65,	379,65,	377,390,	381,393,	
372,384,	374,387,	381,65,	372,65,	
374,65,	380,65,	382,65,	380,392,	
382,394,	383,395,	384,396,	386,398,	
384,65,	376,65,	385,65,	387,65,	
385,397,	390,403,	386,65,	387,399,	
371,65,	388,400,	389,402,	369,65,	
391,65,	391,404,	383,65,	388,401,	
377,65,	379,65,	392,65,	395,407,	
394,406,	396,65,	381,65,	372,65,	
374,65,	380,65,	382,65,	389,65,	
396,408,	397,409,	393,405,	403,415,	
384,65,	394,65,	385,65,	387,65,	
393,65,	390,65,	386,65,	398,410,	
403,65,	399,411,	397,65,	401,65,	
391,65,	401,413,	383,65,	388,65,	
400,65,	406,65,	392,65,	395,65,	
398,65,	396,65,	399,65,	400,412,	
402,414,	405,417,	404,65,	389,65,	
404,416,	407,65,	402,65,	408,65,	
414,65,	394,65,	409,419,	415,424,	
393,65,	410,65,	405,65,	415,65,	
403,65,	416,425,	397,65,	401,65,	
408,418,	409,65,	411,65,	413,65,	
400,65,	406,65,	410,420,	412,422,	
398,65,	0,0,	399,65,	417,426,	
412,65,	424,436,	404,65,	411,421,	
413,423,	407,65,	402,65,	408,65,	
414,65,	418,65,	418,427,	419,428,	
424,65,	410,65,	405,65,	415,65,	
417,65,	416,65,	420,65,	420,429,	
428,440,	409,65,	411,65,	413,65,	
419,65,	421,430,	421,431,	422,432,	
425,65,	423,433,	422,65,	425,437,	
412,65,	423,434,	423,435,	426,438,	
427,439,	432,444,	429,441,	426,65,	
430,442,	418,65,	431,443,	438,65,	
424,65,	434,446,	433,445,	0,0,	
417,65,	427,65,	420,65,	429,65,	
428,65,	430,65,	435,447,	431,65,	
419,65,	421,65,	434,65,	436,65,	
425,65,	437,449,	422,65,	433,65,	
439,450,	423,65,	440,65,	435,65,	
439,65,	432,65,	441,452,	426,65,	
436,448,	442,453,	441,65,	438,65,	
437,65,	446,457,	443,454,	440,451,	
0,0,	427,65,	443,65,	429,65,	
444,455,	430,65,	444,65,	431,65,	
442,65,	445,456,	434,65,	436,65,	
446,65,	447,458,	445,65,	433,65,	
448,459,	447,65,	440,65,	435,65,	
439,65,	449,65,	450,461,	449,460,	
453,466,	451,462,	441,65,	451,463,	
437,65,	452,465,	459,65,	448,65,	
451,464,	454,467,	443,65,	455,468,	
450,65,	453,65,	444,65,	456,469,	
442,65,	457,470,	458,471,	452,65,	
446,65,	455,65,	445,65,	454,65,	
460,65,	447,65,	461,65,	460,472,	
456,65,	449,65,	457,65,	462,473,	
458,65,	463,474,	451,65,	464,65,	
465,65,	466,476,	459,65,	448,65,	
469,65,	467,65,	472,481,	468,478,	
450,65,	453,65,	466,65,	473,65,	
470,479,	465,475,	471,65,	452,65,	
468,65,	455,65,	467,477,	454,65,	
460,65,	470,65,	461,65,	462,65,	
456,65,	474,65,	457,65,	471,480,	
458,65,	463,65,	451,65,	464,65,	
465,65,	485,65,	478,485,	476,65,	
469,65,	467,65,	472,65,	476,483,	
0,0,	475,482,	466,65,	473,65,	
475,65,	481,488,	471,65,	477,484,	
468,65,	478,65,	477,65,	480,487,	
479,65,	470,65,	480,65,	462,65,	
479,486,	474,65,	481,65,	482,489,	
483,490,	463,65,	484,491,	482,65,	
486,492,	485,65,	484,65,	476,65,	
487,493,	488,494,	489,495,	490,65,	
487,65,	483,65,	491,496,	492,65,	
475,65,	486,65,	493,497,	494,65,	
498,65,	478,65,	477,65,	488,65,	
479,65,	489,65,	480,65,	495,498,	
496,499,	491,65,	481,65,	499,65,	
500,65,	493,65,	0,0,	482,65,	
0,0,	497,500,	484,65,	0,0,	
495,65,	496,65,	0,0,	490,65,	
487,65,	483,65,	0,0,	492,65,	
0,0,	486,65,	497,65,	494,65,	
498,65,	0,0,	0,0,	488,65,	
0,0,	489,65,	0,0,	0,0,	
0,0,	491,65,	0,0,	499,65,	
500,65,	493,65,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
495,65,	496,65,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	497,65,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-1,	yysvec+1,	0,	
yycrank+-90,	0,		0,	
yycrank+-145,	yysvec+3,	0,	
yycrank+-207,	yysvec+1,	0,	
yycrank+-262,	yysvec+1,	0,	
yycrank+-4,	yysvec+1,	0,	
yycrank+-5,	yysvec+1,	0,	
yycrank+-7,	yysvec+1,	0,	
yycrank+-8,	yysvec+1,	0,	
yycrank+-351,	0,		0,	
yycrank+-9,	yysvec+11,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+0,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+208,	0,		yyvstop+8,
yycrank+0,	0,		yyvstop+11,
yycrank+0,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+17,
yycrank+0,	0,		yyvstop+20,
yycrank+0,	0,		yyvstop+23,
yycrank+0,	0,		yyvstop+26,
yycrank+0,	0,		yyvstop+29,
yycrank+2,	0,		yyvstop+32,
yycrank+0,	0,		yyvstop+35,
yycrank+0,	0,		yyvstop+38,
yycrank+0,	0,		yyvstop+41,
yycrank+0,	0,		yyvstop+44,
yycrank+0,	0,		yyvstop+47,
yycrank+393,	0,		yyvstop+50,
yycrank+11,	yysvec+30,	yyvstop+53,
yycrank+25,	yysvec+30,	yyvstop+56,
yycrank+127,	yysvec+30,	yyvstop+59,
yycrank+13,	yysvec+30,	yyvstop+62,
yycrank+29,	yysvec+30,	yyvstop+65,
yycrank+280,	yysvec+30,	yyvstop+68,
yycrank+128,	yysvec+30,	yyvstop+71,
yycrank+39,	yysvec+30,	yyvstop+74,
yycrank+33,	yysvec+30,	yyvstop+77,
yycrank+130,	yysvec+30,	yyvstop+80,
yycrank+112,	yysvec+30,	yyvstop+83,
yycrank+287,	yysvec+30,	yyvstop+86,
yycrank+295,	yysvec+30,	yyvstop+89,
yycrank+113,	yysvec+30,	yyvstop+92,
yycrank+292,	yysvec+30,	yyvstop+95,
yycrank+31,	yysvec+30,	yyvstop+98,
yycrank+0,	0,		yyvstop+101,
yycrank+0,	0,		yyvstop+104,
yycrank+0,	0,		yyvstop+107,
yycrank+136,	yysvec+30,	yyvstop+110,
yycrank+0,	0,		yyvstop+113,
yycrank+0,	0,		yyvstop+116,
yycrank+480,	0,		yyvstop+119,
yycrank+-602,	0,		yyvstop+122,
yycrank+-691,	0,		yyvstop+124,
yycrank+-780,	0,		yyvstop+126,
yycrank+0,	0,		yyvstop+128,
yycrank+0,	0,		yyvstop+131,
yycrank+0,	0,		yyvstop+135,
yycrank+0,	yysvec+16,	yyvstop+138,
yycrank+267,	yysvec+16,	0,	
yycrank+0,	yysvec+16,	0,	
yycrank+13,	yysvec+16,	yyvstop+142,
yycrank+0,	yysvec+24,	yyvstop+144,
yycrank+15,	yysvec+30,	yyvstop+146,
yycrank+111,	yysvec+30,	yyvstop+148,
yycrank+290,	yysvec+30,	yyvstop+150,
yycrank+131,	yysvec+30,	yyvstop+152,
yycrank+300,	yysvec+30,	yyvstop+154,
yycrank+370,	yysvec+30,	yyvstop+156,
yycrank+540,	yysvec+30,	yyvstop+158,
yycrank+116,	yysvec+30,	yyvstop+160,
yycrank+462,	yysvec+30,	yyvstop+162,
yycrank+188,	yysvec+30,	yyvstop+164,
yycrank+294,	yysvec+30,	yyvstop+166,
yycrank+531,	yysvec+30,	yyvstop+169,
yycrank+119,	yysvec+30,	yyvstop+171,
yycrank+457,	yysvec+30,	yyvstop+173,
yycrank+537,	yysvec+30,	yyvstop+175,
yycrank+533,	yysvec+30,	yyvstop+177,
yycrank+139,	yysvec+30,	yyvstop+179,
yycrank+373,	yysvec+30,	yyvstop+182,
yycrank+534,	yysvec+30,	yyvstop+184,
yycrank+542,	yysvec+30,	yyvstop+186,
yycrank+459,	yysvec+30,	yyvstop+188,
yycrank+545,	yysvec+30,	yyvstop+190,
yycrank+546,	yysvec+30,	yyvstop+192,
yycrank+153,	yysvec+30,	yyvstop+194,
yycrank+552,	yysvec+30,	yyvstop+196,
yycrank+621,	yysvec+30,	yyvstop+198,
yycrank+627,	yysvec+30,	yyvstop+200,
yycrank+289,	yysvec+30,	yyvstop+202,
yycrank+548,	yysvec+30,	yyvstop+204,
yycrank+617,	yysvec+30,	yyvstop+206,
yycrank+628,	yysvec+30,	yyvstop+208,
yycrank+629,	yysvec+30,	yyvstop+210,
yycrank+633,	yysvec+30,	yyvstop+212,
yycrank+631,	yysvec+30,	yyvstop+214,
yycrank+0,	yysvec+53,	yyvstop+216,
yycrank+-9,	yysvec+54,	0,	
yycrank+0,	0,		yyvstop+218,
yycrank+-10,	yysvec+55,	0,	
yycrank+-11,	yysvec+56,	0,	
yycrank+0,	0,		yyvstop+220,
yycrank+783,	0,		0,	
yycrank+14,	0,		0,	
yycrank+-869,	0,		0,	
yycrank+641,	yysvec+30,	yyvstop+222,
yycrank+372,	yysvec+30,	yyvstop+224,
yycrank+632,	yysvec+30,	yyvstop+226,
yycrank+729,	yysvec+30,	yyvstop+228,
yycrank+634,	yysvec+30,	yyvstop+230,
yycrank+711,	yysvec+30,	yyvstop+232,
yycrank+635,	yysvec+30,	yyvstop+234,
yycrank+709,	yysvec+30,	yyvstop+236,
yycrank+727,	yysvec+30,	yyvstop+238,
yycrank+793,	yysvec+30,	yyvstop+240,
yycrank+792,	yysvec+30,	yyvstop+242,
yycrank+551,	yysvec+30,	yyvstop+244,
yycrank+801,	yysvec+30,	yyvstop+246,
yycrank+802,	yysvec+30,	yyvstop+248,
yycrank+804,	yysvec+30,	yyvstop+250,
yycrank+713,	yysvec+30,	yyvstop+252,
yycrank+808,	yysvec+30,	yyvstop+254,
yycrank+640,	yysvec+30,	yyvstop+256,
yycrank+811,	yysvec+30,	yyvstop+258,
yycrank+810,	yysvec+30,	yyvstop+260,
yycrank+806,	yysvec+30,	yyvstop+263,
yycrank+730,	yysvec+30,	yyvstop+265,
yycrank+816,	yysvec+30,	yyvstop+267,
yycrank+883,	yysvec+30,	yyvstop+269,
yycrank+815,	yysvec+30,	yyvstop+271,
yycrank+878,	yysvec+30,	yyvstop+273,
yycrank+881,	yysvec+30,	yyvstop+275,
yycrank+884,	yysvec+30,	yyvstop+277,
yycrank+888,	yysvec+30,	yyvstop+279,
yycrank+889,	yysvec+30,	yyvstop+281,
yycrank+890,	yysvec+30,	yyvstop+283,
yycrank+891,	yysvec+30,	yyvstop+285,
yycrank+907,	yysvec+30,	yyvstop+287,
yycrank+897,	yysvec+30,	yyvstop+289,
yycrank+898,	yysvec+30,	yyvstop+291,
yycrank+638,	yysvec+30,	yyvstop+293,
yycrank+899,	yysvec+30,	yyvstop+295,
yycrank+0,	0,		yyvstop+297,
yycrank+904,	yysvec+30,	yyvstop+299,
yycrank+902,	yysvec+30,	yyvstop+301,
yycrank+945,	yysvec+30,	yyvstop+303,
yycrank+704,	yysvec+30,	yyvstop+305,
yycrank+814,	yysvec+30,	yyvstop+307,
yycrank+941,	yysvec+30,	yyvstop+309,
yycrank+819,	yysvec+30,	yyvstop+311,
yycrank+905,	yysvec+30,	yyvstop+313,
yycrank+940,	yysvec+30,	yyvstop+315,
yycrank+944,	yysvec+30,	yyvstop+317,
yycrank+946,	yysvec+30,	yyvstop+319,
yycrank+966,	yysvec+30,	yyvstop+321,
yycrank+951,	yysvec+30,	yyvstop+323,
yycrank+950,	yysvec+30,	yyvstop+325,
yycrank+968,	yysvec+30,	yyvstop+327,
yycrank+956,	yysvec+30,	yyvstop+329,
yycrank+959,	yysvec+30,	yyvstop+331,
yycrank+971,	yysvec+30,	yyvstop+333,
yycrank+975,	yysvec+30,	yyvstop+335,
yycrank+963,	yysvec+30,	yyvstop+337,
yycrank+953,	yysvec+30,	yyvstop+339,
yycrank+965,	yysvec+30,	yyvstop+341,
yycrank+1006,	yysvec+30,	yyvstop+343,
yycrank+1010,	yysvec+30,	yyvstop+345,
yycrank+1001,	yysvec+30,	yyvstop+347,
yycrank+1012,	yysvec+30,	yyvstop+349,
yycrank+1011,	yysvec+30,	yyvstop+351,
yycrank+1017,	yysvec+30,	yyvstop+353,
yycrank+1019,	yysvec+30,	yyvstop+355,
yycrank+1005,	yysvec+30,	yyvstop+357,
yycrank+1015,	yysvec+30,	yyvstop+360,
yycrank+1029,	yysvec+30,	yyvstop+362,
yycrank+1020,	yysvec+30,	yyvstop+364,
yycrank+1018,	yysvec+30,	yyvstop+366,
yycrank+1024,	yysvec+30,	yyvstop+369,
yycrank+1032,	yysvec+30,	yyvstop+371,
yycrank+1057,	yysvec+30,	yyvstop+373,
yycrank+1060,	yysvec+30,	yyvstop+375,
yycrank+1022,	yysvec+30,	yyvstop+377,
yycrank+1076,	yysvec+30,	yyvstop+380,
yycrank+1035,	yysvec+30,	yyvstop+382,
yycrank+1066,	yysvec+30,	yyvstop+385,
yycrank+1074,	yysvec+30,	yyvstop+387,
yycrank+1072,	yysvec+30,	yyvstop+389,
yycrank+1070,	yysvec+30,	yyvstop+391,
yycrank+1039,	yysvec+30,	yyvstop+393,
yycrank+1084,	yysvec+30,	yyvstop+396,
yycrank+1077,	yysvec+30,	yyvstop+398,
yycrank+1078,	yysvec+30,	yyvstop+400,
yycrank+1085,	yysvec+30,	yyvstop+403,
yycrank+1091,	yysvec+30,	yyvstop+405,
yycrank+1088,	yysvec+30,	yyvstop+407,
yycrank+1096,	yysvec+30,	yyvstop+409,
yycrank+1124,	yysvec+30,	yyvstop+411,
yycrank+1125,	yysvec+30,	yyvstop+413,
yycrank+1130,	yysvec+30,	yyvstop+415,
yycrank+1103,	yysvec+30,	yyvstop+417,
yycrank+1131,	yysvec+30,	yyvstop+419,
yycrank+1132,	yysvec+30,	yyvstop+421,
yycrank+1137,	yysvec+30,	yyvstop+423,
yycrank+1140,	yysvec+30,	yyvstop+425,
yycrank+1121,	yysvec+30,	yyvstop+427,
yycrank+1138,	yysvec+30,	yyvstop+430,
yycrank+1141,	yysvec+30,	yyvstop+432,
yycrank+1143,	yysvec+30,	yyvstop+434,
yycrank+1144,	yysvec+30,	yyvstop+436,
yycrank+1167,	yysvec+30,	yyvstop+438,
yycrank+1145,	yysvec+30,	yyvstop+440,
yycrank+1148,	yysvec+30,	yyvstop+442,
yycrank+1149,	yysvec+30,	yyvstop+444,
yycrank+1178,	yysvec+30,	yyvstop+446,
yycrank+1150,	yysvec+30,	yyvstop+448,
yycrank+1184,	yysvec+30,	yyvstop+450,
yycrank+1160,	yysvec+30,	yyvstop+452,
yycrank+1194,	yysvec+30,	yyvstop+454,
yycrank+1188,	yysvec+30,	yyvstop+456,
yycrank+1189,	yysvec+30,	yyvstop+458,
yycrank+1197,	yysvec+30,	yyvstop+460,
yycrank+1205,	yysvec+30,	yyvstop+462,
yycrank+1213,	yysvec+30,	yyvstop+464,
yycrank+1203,	yysvec+30,	yyvstop+466,
yycrank+1195,	yysvec+30,	yyvstop+468,
yycrank+1201,	yysvec+30,	yyvstop+471,
yycrank+1202,	yysvec+30,	yyvstop+474,
yycrank+1207,	yysvec+30,	yyvstop+477,
yycrank+1240,	yysvec+30,	yyvstop+479,
yycrank+1214,	yysvec+30,	yyvstop+481,
yycrank+1247,	yysvec+30,	yyvstop+483,
yycrank+1248,	yysvec+30,	yyvstop+485,
yycrank+1224,	yysvec+30,	yyvstop+487,
yycrank+1249,	yysvec+30,	yyvstop+489,
yycrank+1257,	yysvec+30,	yyvstop+491,
yycrank+1231,	yysvec+30,	yyvstop+493,
yycrank+1252,	yysvec+30,	yyvstop+495,
yycrank+1261,	yysvec+30,	yyvstop+497,
yycrank+1260,	yysvec+30,	yyvstop+499,
yycrank+1267,	yysvec+30,	yyvstop+501,
yycrank+1310,	yysvec+30,	yyvstop+503,
yycrank+1268,	yysvec+30,	yyvstop+505,
yycrank+1269,	yysvec+30,	yyvstop+507,
yycrank+1304,	yysvec+30,	yyvstop+509,
yycrank+1242,	yysvec+30,	yyvstop+511,
yycrank+1305,	yysvec+30,	yyvstop+514,
yycrank+1309,	yysvec+30,	yyvstop+516,
yycrank+1314,	yysvec+30,	yyvstop+518,
yycrank+1319,	yysvec+30,	yyvstop+520,
yycrank+1318,	yysvec+30,	yyvstop+522,
yycrank+1315,	yysvec+30,	yyvstop+524,
yycrank+1322,	yysvec+30,	yyvstop+526,
yycrank+1332,	yysvec+30,	yyvstop+528,
yycrank+1259,	yysvec+30,	yyvstop+530,
yycrank+1323,	yysvec+30,	yyvstop+533,
yycrank+1330,	yysvec+30,	yyvstop+535,
yycrank+1333,	yysvec+30,	yyvstop+537,
yycrank+1348,	yysvec+30,	yyvstop+539,
yycrank+1359,	yysvec+30,	yyvstop+541,
yycrank+1374,	yysvec+30,	yyvstop+543,
yycrank+1369,	yysvec+30,	yyvstop+545,
yycrank+1371,	yysvec+30,	yyvstop+547,
yycrank+1376,	yysvec+30,	yyvstop+549,
yycrank+1381,	yysvec+30,	yyvstop+551,
yycrank+1265,	yysvec+30,	yyvstop+553,
yycrank+1375,	yysvec+30,	yyvstop+556,
yycrank+1324,	yysvec+30,	yyvstop+558,
yycrank+1377,	yysvec+30,	yyvstop+560,
yycrank+1384,	yysvec+30,	yyvstop+562,
yycrank+1378,	yysvec+30,	yyvstop+564,
yycrank+1386,	yysvec+30,	yyvstop+567,
yycrank+1412,	yysvec+30,	yyvstop+569,
yycrank+1379,	yysvec+30,	yyvstop+571,
yycrank+1385,	yysvec+30,	yyvstop+573,
yycrank+1390,	yysvec+30,	yyvstop+575,
yycrank+1388,	yysvec+30,	yyvstop+577,
yycrank+1396,	yysvec+30,	yyvstop+580,
yycrank+1434,	yysvec+30,	yyvstop+582,
yycrank+1394,	yysvec+30,	yyvstop+584,
yycrank+1427,	yysvec+30,	yyvstop+587,
yycrank+1435,	yysvec+30,	yyvstop+589,
yycrank+1442,	yysvec+30,	yyvstop+591,
yycrank+1430,	yysvec+30,	yyvstop+593,
yycrank+1445,	yysvec+30,	yyvstop+595,
yycrank+1433,	yysvec+30,	yyvstop+597,
yycrank+1439,	yysvec+30,	yyvstop+600,
yycrank+1438,	yysvec+30,	yyvstop+602,
yycrank+1451,	yysvec+30,	yyvstop+605,
yycrank+1441,	yysvec+30,	yyvstop+607,
yycrank+1460,	yysvec+30,	yyvstop+609,
yycrank+1450,	yysvec+30,	yyvstop+611,
yycrank+1452,	yysvec+30,	yyvstop+613,
yycrank+1443,	yysvec+30,	yyvstop+615,
yycrank+1449,	yysvec+30,	yyvstop+618,
yycrank+1490,	yysvec+30,	yyvstop+620,
yycrank+1486,	yysvec+30,	yyvstop+622,
yycrank+1500,	yysvec+30,	yyvstop+624,
yycrank+1489,	yysvec+30,	yyvstop+626,
yycrank+1496,	yysvec+30,	yyvstop+628,
yycrank+1497,	yysvec+30,	yyvstop+630,
yycrank+1499,	yysvec+30,	yyvstop+632,
yycrank+1501,	yysvec+30,	yyvstop+634,
yycrank+1505,	yysvec+30,	yyvstop+636,
yycrank+1503,	yysvec+30,	yyvstop+638,
yycrank+1498,	yysvec+30,	yyvstop+640,
yycrank+1509,	yysvec+30,	yyvstop+642,
yycrank+1507,	yysvec+30,	yyvstop+644,
yycrank+1524,	yysvec+30,	yyvstop+646,
yycrank+1510,	yysvec+30,	yyvstop+648,
yycrank+1513,	yysvec+30,	yyvstop+651,
yycrank+1512,	yysvec+30,	yyvstop+653,
yycrank+1514,	yysvec+30,	yyvstop+656,
yycrank+1516,	yysvec+30,	yyvstop+658,
yycrank+1549,	yysvec+30,	yyvstop+661,
yycrank+1540,	yysvec+30,	yyvstop+663,
yycrank+1550,	yysvec+30,	yyvstop+665,
yycrank+1551,	yysvec+30,	yyvstop+667,
yycrank+1569,	yysvec+30,	yyvstop+670,
yycrank+1568,	yysvec+30,	yyvstop+672,
yycrank+1566,	yysvec+30,	yyvstop+674,
yycrank+1558,	yysvec+30,	yyvstop+676,
yycrank+1559,	yysvec+30,	yyvstop+679,
yycrank+1560,	yysvec+30,	yyvstop+682,
yycrank+1563,	yysvec+30,	yyvstop+684,
yycrank+1561,	yysvec+30,	yyvstop+686,
yycrank+1574,	yysvec+30,	yyvstop+688,
yycrank+1580,	yysvec+30,	yyvstop+690,
yycrank+1571,	yysvec+30,	yyvstop+692,
yycrank+1575,	yysvec+30,	yyvstop+694,
yycrank+1567,	yysvec+30,	yyvstop+696,
yycrank+1576,	yysvec+30,	yyvstop+699,
yycrank+1611,	yysvec+30,	yyvstop+701,
yycrank+1626,	yysvec+30,	yyvstop+703,
yycrank+1584,	yysvec+30,	yyvstop+705,
yycrank+1627,	yysvec+30,	yyvstop+708,
yycrank+1588,	yysvec+30,	yyvstop+710,
yycrank+1615,	yysvec+30,	yyvstop+713,
yycrank+1604,	yysvec+30,	yyvstop+715,
yycrank+1618,	yysvec+30,	yyvstop+718,
yycrank+1634,	yysvec+30,	yyvstop+721,
yycrank+1621,	yysvec+30,	yyvstop+723,
yycrank+1624,	yysvec+30,	yyvstop+725,
yycrank+1625,	yysvec+30,	yyvstop+728,
yycrank+1637,	yysvec+30,	yyvstop+730,
yycrank+1642,	yysvec+30,	yyvstop+732,
yycrank+1639,	yysvec+30,	yyvstop+734,
yycrank+1632,	yysvec+30,	yyvstop+736,
yycrank+1633,	yysvec+30,	yyvstop+739,
yycrank+1635,	yysvec+30,	yyvstop+742,
yycrank+1638,	yysvec+30,	yyvstop+745,
yycrank+1640,	yysvec+30,	yyvstop+748,
yycrank+1654,	yysvec+30,	yyvstop+750,
yycrank+1641,	yysvec+30,	yyvstop+752,
yycrank+1644,	yysvec+30,	yyvstop+755,
yycrank+1648,	yysvec+30,	yyvstop+758,
yycrank+1675,	yysvec+30,	yyvstop+761,
yycrank+1682,	yysvec+30,	yyvstop+763,
yycrank+1683,	yysvec+30,	yyvstop+765,
yycrank+1677,	yysvec+30,	yyvstop+767,
yycrank+1691,	yysvec+30,	yyvstop+770,
yycrank+1684,	yysvec+30,	yyvstop+772,
yycrank+1685,	yysvec+30,	yyvstop+775,
yycrank+1702,	yysvec+30,	yyvstop+777,
yycrank+1690,	yysvec+30,	yyvstop+779,
yycrank+1687,	yysvec+30,	yyvstop+781,
yycrank+1692,	yysvec+30,	yyvstop+783,
yycrank+1741,	yysvec+30,	yyvstop+786,
yycrank+1708,	yysvec+30,	yyvstop+788,
yycrank+1738,	yysvec+30,	yyvstop+790,
yycrank+1753,	yysvec+30,	yyvstop+792,
yycrank+1698,	yysvec+30,	yyvstop+794,
yycrank+1754,	yysvec+30,	yyvstop+796,
yycrank+1696,	yysvec+30,	yyvstop+798,
yycrank+1731,	yysvec+30,	yyvstop+800,
yycrank+1746,	yysvec+30,	yyvstop+802,
yycrank+1701,	yysvec+30,	yyvstop+804,
yycrank+1747,	yysvec+30,	yyvstop+806,
yycrank+1755,	yysvec+30,	yyvstop+809,
yycrank+1752,	yysvec+30,	yyvstop+811,
yycrank+1756,	yysvec+30,	yyvstop+813,
yycrank+1776,	yysvec+30,	yyvstop+815,
yycrank+1762,	yysvec+30,	yyvstop+817,
yycrank+1764,	yysvec+30,	yyvstop+819,
yycrank+1768,	yysvec+30,	yyvstop+821,
yycrank+1765,	yysvec+30,	yyvstop+823,
yycrank+1777,	yysvec+30,	yyvstop+825,
yycrank+1789,	yysvec+30,	yyvstop+827,
yycrank+1767,	yysvec+30,	yyvstop+829,
yycrank+1774,	yysvec+30,	yyvstop+831,
yycrank+1780,	yysvec+30,	yyvstop+833,
yycrank+1798,	yysvec+30,	yyvstop+836,
yycrank+1795,	yysvec+30,	yyvstop+838,
yycrank+1781,	yysvec+30,	yyvstop+840,
yycrank+1783,	yysvec+30,	yyvstop+842,
yycrank+1804,	yysvec+30,	yyvstop+844,
yycrank+1814,	yysvec+30,	yyvstop+846,
yycrank+1816,	yysvec+30,	yyvstop+848,
yycrank+1810,	yysvec+30,	yyvstop+850,
yycrank+1805,	yysvec+30,	yyvstop+852,
yycrank+1824,	yysvec+30,	yyvstop+854,
yycrank+1802,	yysvec+30,	yyvstop+856,
yycrank+1820,	yysvec+30,	yyvstop+858,
yycrank+1832,	yysvec+30,	yyvstop+860,
yycrank+1811,	yysvec+30,	yyvstop+862,
yycrank+1823,	yysvec+30,	yyvstop+865,
yycrank+1825,	yysvec+30,	yyvstop+868,
yycrank+1839,	yysvec+30,	yyvstop+870,
yycrank+1831,	yysvec+30,	yyvstop+872,
yycrank+1840,	yysvec+30,	yyvstop+874,
yycrank+1850,	yysvec+30,	yyvstop+876,
yycrank+1841,	yysvec+30,	yyvstop+878,
yycrank+1826,	yysvec+30,	yyvstop+880,
yycrank+1833,	yysvec+30,	yyvstop+883,
yycrank+1835,	yysvec+30,	yyvstop+885,
yycrank+1866,	yysvec+30,	yyvstop+887,
yycrank+1859,	yysvec+30,	yyvstop+889,
yycrank+1874,	yysvec+30,	yyvstop+891,
yycrank+1868,	yysvec+30,	yyvstop+893,
yycrank+1875,	yysvec+30,	yyvstop+895,
yycrank+1880,	yysvec+30,	yyvstop+897,
yycrank+1883,	yysvec+30,	yyvstop+899,
yycrank+1862,	yysvec+30,	yyvstop+901,
yycrank+1878,	yysvec+30,	yyvstop+903,
yycrank+1889,	yysvec+30,	yyvstop+905,
yycrank+1899,	yysvec+30,	yyvstop+907,
yycrank+1870,	yysvec+30,	yyvstop+909,
yycrank+1901,	yysvec+30,	yyvstop+911,
yycrank+1903,	yysvec+30,	yyvstop+913,
yycrank+1905,	yysvec+30,	yyvstop+915,
yycrank+1887,	yysvec+30,	yyvstop+917,
yycrank+1913,	yysvec+30,	yyvstop+919,
yycrank+1908,	yysvec+30,	yyvstop+921,
yycrank+1917,	yysvec+30,	yyvstop+923,
yycrank+1909,	yysvec+30,	yyvstop+925,
yycrank+1926,	yysvec+30,	yyvstop+928,
yycrank+1893,	yysvec+30,	yyvstop+930,
yycrank+1918,	yysvec+30,	yyvstop+933,
yycrank+1916,	yysvec+30,	yyvstop+935,
yycrank+1924,	yysvec+30,	yyvstop+937,
yycrank+1938,	yysvec+30,	yyvstop+939,
yycrank+1932,	yysvec+30,	yyvstop+941,
yycrank+1936,	yysvec+30,	yyvstop+943,
yycrank+1944,	yysvec+30,	yyvstop+945,
yycrank+1942,	yysvec+30,	yyvstop+947,
yycrank+1947,	yysvec+30,	yyvstop+949,
yycrank+1961,	yysvec+30,	yyvstop+951,
yycrank+1951,	yysvec+30,	yyvstop+953,
yycrank+1966,	yysvec+30,	yyvstop+955,
yycrank+1988,	yysvec+30,	yyvstop+957,
yycrank+1973,	yysvec+30,	yyvstop+959,
yycrank+1967,	yysvec+30,	yyvstop+961,
yycrank+1977,	yysvec+30,	yyvstop+963,
yycrank+1975,	yysvec+30,	yyvstop+965,
yycrank+1982,	yysvec+30,	yyvstop+967,
yycrank+1984,	yysvec+30,	yyvstop+969,
yycrank+1986,	yysvec+30,	yyvstop+971,
yycrank+1960,	yysvec+30,	yyvstop+973,
yycrank+1978,	yysvec+30,	yyvstop+976,
yycrank+1980,	yysvec+30,	yyvstop+978,
yycrank+2013,	yysvec+30,	yyvstop+981,
yycrank+2019,	yysvec+30,	yyvstop+983,
yycrank+1989,	yysvec+30,	yyvstop+985,
yycrank+1990,	yysvec+30,	yyvstop+988,
yycrank+2000,	yysvec+30,	yyvstop+991,
yycrank+1995,	yysvec+30,	yyvstop+993,
yycrank+2006,	yysvec+30,	yyvstop+996,
yycrank+1994,	yysvec+30,	yyvstop+998,
yycrank+2011,	yysvec+30,	yyvstop+1001,
yycrank+2004,	yysvec+30,	yyvstop+1003,
yycrank+1996,	yysvec+30,	yyvstop+1006,
yycrank+2001,	yysvec+30,	yyvstop+1008,
yycrank+2015,	yysvec+30,	yyvstop+1011,
yycrank+2034,	yysvec+30,	yyvstop+1014,
yycrank+2025,	yysvec+30,	yyvstop+1016,
yycrank+2040,	yysvec+30,	yyvstop+1018,
yycrank+2039,	yysvec+30,	yyvstop+1020,
yycrank+2042,	yysvec+30,	yyvstop+1022,
yycrank+2044,	yysvec+30,	yyvstop+1024,
yycrank+2048,	yysvec+30,	yyvstop+1026,
yycrank+2053,	yysvec+30,	yyvstop+1028,
yycrank+2063,	yysvec+30,	yyvstop+1030,
yycrank+2056,	yysvec+30,	yyvstop+1032,
yycrank+2023,	yysvec+30,	yyvstop+1034,
yycrank+2067,	yysvec+30,	yyvstop+1037,
yycrank+2062,	yysvec+30,	yyvstop+1039,
yycrank+2073,	yysvec+30,	yyvstop+1041,
yycrank+2075,	yysvec+30,	yyvstop+1043,
yycrank+2061,	yysvec+30,	yyvstop+1045,
yycrank+2079,	yysvec+30,	yyvstop+1048,
yycrank+2065,	yysvec+30,	yyvstop+1050,
yycrank+2083,	yysvec+30,	yyvstop+1053,
yycrank+2069,	yysvec+30,	yyvstop+1055,
yycrank+2090,	yysvec+30,	yyvstop+1058,
yycrank+2091,	yysvec+30,	yyvstop+1060,
yycrank+2100,	yysvec+30,	yyvstop+1062,
yycrank+2070,	yysvec+30,	yyvstop+1064,
yycrank+2081,	yysvec+30,	yyvstop+1067,
yycrank+2082,	yysvec+30,	yyvstop+1070,
0,	0,	0};
struct yywork *yytop = yycrank+2214;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,'$' ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,'$' ,'$' ,'$' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,'>' ,01  ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'H' ,'I' ,'J' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'S' ,'T' ,'U' ,'V' ,'W' ,
'X' ,'Y' ,'J' ,01  ,01  ,01  ,01  ,'J' ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'H' ,'I' ,'J' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'S' ,'T' ,'U' ,'V' ,'W' ,
'X' ,'Y' ,'J' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
