/* Generated by Interface Builder */

#import "Controller.h"
#import <appkit/Cell.h>
#import <appkit/Window.h>
#import <stdio.h>
#import <defaults.h>
#import <string.h>

char	*defname = "DefaultOpenApp";

@implementation Controller

/*
 * Figure out if the preference is set or not and say so on the Panel.
 */
- updateInstallCell
{
	const char *str;


	str	= NXReadDefault("Workspace",defname);

	if(str){
		char	buf[256];
		
		sprintf(buf,"filename: %s",str);
		[statusCell setStringValue:"EMACS Listener is installed"];
		[filenameCell setStringValue:buf];
	}
	else{
		[statusCell setStringValue:"EMACS Listener is NOT installed"];
		[filenameCell setStringValue:""];
	}

	return self;
}

- install:sender
{
	char	*name;

	name	= strrchr(NXArgv[0],'/');

	if(name){
		name++;
	}
	else{
		name	= "EL2";	/* default name */
	}

	NXWriteDefault("Workspace",defname,name);
	[self updateInstallCell];
	return self;
}

- uninstall:sender
{
	NXRemoveDefault("Workspace",defname);
	[self updateInstallCell];
	return self;
}

/* This one doesn't seem to get executed.  Strange... */
- windowDidExpose:sender
{
	[self updateInstallCell];
	return self;
}

- windowDidBecomeKey:sender
{
	[self updateInstallCell];
	return self;
}

@end
