
/*	Program By Fred Richards, Copyright 1990.	*/
/*							*/
/*	This software is provided free of charge	*/
/*	and without warranty.  The source code may	*/
/*	be distributed freely provided this copyright	*/
/*	notice remains in tact.				*/


#import <appkit/appkit.h>

@interface PlotView:View
{
    id		plotParam;	// The Plot Object containing
				// all the necessary parameters (and data)
    NXPoint	pointOffset;	// Distance from point of box, triangle, etc
				// corner or perimeter
    NXPoint	pointSize;	// The length of a box, cross, triangle, etc.
}

// Initialization methods:

// Attach to the Plot object

- setPlotParam:anObject;

// Set up the line width, drawing color and point size

- initPlot:sender;

// Erase the view

- clear:sender;

// Set the pen shade (NX_WHITE, NX_LTGRAY, NX_DKGRAY, NX_BLACK)

- setDrawColor:(float )color;

// Set the point size (and perimeter offset) relative to the View size

- setPointSize;

// Draw the given data set

- drawLines:sender;
- drawPoints:sender;
- drawCrosses:sender;
- drawXs:sender;
- drawBoxes:sender;
- drawTriangles:sender;

// Draw an individual point

- dotAt:(NXPoint )place;
- crossAt:(NXPoint )place;
- xAt:(NXPoint )place;
- boxAt:(NXPoint )place;
- triangleAt:(NXPoint )place;

// Details

- border;
- axes;

// This is necessary if printPSCode is going to work!

- drawSelf:(const NXRect *)rects :(int )rectCount;

// This will save just the image's PostScript code to a file

- savePSCode:(char *)aFile;

@end
