/*
  This file is part of PinYinEdit, a Chineses PinYin Editor.

  Copyright (C) 1994 William Wei
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "Controller.h"

@implementation Controller

unsigned short PinYinFieldFilter(unsigned short theChar, int flags)
{
  if (flags & NX_COMMANDMASK)
    {
      theChar = 0;
    } 
  else 
    {
      if (theChar == NX_DELETE)
	theChar = NX_BACKSPACE;
      else 
	if (theChar == NX_CR) 
	  {
	    theChar = (flags & NX_SHIFTMASK) ? '\n' : NX_RETURN;
	  } 
	else
	  if (theChar == '\t') 
	    {
	      theChar = (flags & NX_SHIFTMASK) ? NX_BACKTAB : NX_TAB;
	    } 
	  else 
	    if ((theChar < ' ') && (theChar != '\n') &&
		 (theChar != NX_BACKSPACE)) 
	      {
		theChar = 0;
	      } 
	    else if (theChar == ' ') 
	      { 
		theChar = NX_RETURN;
	      }
    }
  return (theChar);
}

- awakeFromNib
{
  char filePath[1024];
  int	length = [text textLength];
  
  strcpy(filePath, [[NXBundle mainBundle] directory]);
  strcat(filePath, "/PinYinToBig5Table.strings");
  pinyinTable = [[[NXStringTable alloc] init] readFromFile:filePath];
  if (!pinyinTable) 
    {
      NXRunAlertPanel(0,"Couldn't load file %s", 0,0,0,filePath);
      [NXApp terminate:self];
    }
  
  [text setCharWrap:YES];
  [text setSel:length :length];
  [text setSelFont:[Font newFont:"KaiSu-Regular" size:18]];
  
  [[inputPanel getFieldEditor:YES for:nil] setCharFilter:(NXCharFilterFunc)PinYinFieldFilter];
  [inputPanel makeKeyAndOrderFront:self];
  [pinyinForm selectTextAt:0];
  
  return self;
}

char* lowerCase(char* str)
{
  int ptr=-1;
  char offset = 'a' - 'A';
  
  if (!str) return str;
  
  while (str[++ptr] != '\0') 
    {
      str[ptr] = ('Z' > str[ptr]) && (str[ptr] > 'A') ? str[ptr]+offset : str[ptr];
    }
  
  return str;
}

- showInfo:sender
{
  if (!infoPanel) 
    {
      infoPanel = [NXApp loadNibSection:"InfoPanel.nib" owner:self withNames:NO];
    }
  [infoPanel orderFront:self];
  return self;
}

- pinyin:sender
{
  int	i = 0, count = 0, cellCount = [charMatrix cellCount];
  char*	str = (char *)[sender stringValue];
  const char* codes;
  char chin[3] = {'\0','\0','\0'};
  
  lowerCase(str);
  codes = [pinyinTable valueForStringKey:str];
  [inputPanel disableFlushWindow];
  if (codes)
    {
      while(codes[i] != '\0') 
	{
	  chin[0] = codes[i];
	  chin[1] = codes[i+1];
	  [[charMatrix findCellWithTag:i/2] setTitle:chin];
	  i += 2;
	  count++;
	}
    }
  for (;count < cellCount; count++) 
    {
      [[charMatrix findCellWithTag:count] setTitle:""];
    }
  [inputPanel reenableFlushWindow];
  
  [sender selectText:self];
  
  return self;
}

/* put the char into document window */
- draw:sender
{
  [text replaceSel:[[sender selectedCell] title]];
  [text scrollSelToVisible];
  [pinyinForm selectTextAt:0];
  
  return self;
}

- showDocWindow:sender
{
  [docWindow makeKeyAndOrderFront:self];
  return self;
}

- showInputPanel:sender;
{
  [inputPanel makeKeyAndOrderFront:self];
  [pinyinForm selectTextAt:0];
  return self;
}	

@end
