# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
    token.lm

    This file defines the tokens that the Expression grammar is built on.  To
    fully understand this file, you will need to understand lex.  The basic
    idea is that lex scans a text stream and breaks that stream up into tokens
    which are then fed to the grammar (defined in yacc).  Whitespace is ignored
    so the grammar is just fed a steady stream of significant tokens.
*/

/*
 * These are the routines lex calls to get another character as it parses.
 * By default they are macros which read from stdin. We toss the default
 * macro definitions and supply our own versions of these, which will feed
 * lex characters from the expression string we are parsing.
 */
#undef input
#undef unput
#undef output
static int input();
static void unput(char c);
static void output(char c);

#import <stdlib.h>
#import <string.h>
#import <math.h>
#import "exprDefs.h"
#import "y.tab.h"

/* global which holds the string we are parsing */
static const char *CurrText;

/* glue to get rid of compiler warnings */
extern yylook(), yyback();
static int yywrap();
# define YYNEWLINE 10
int yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{		/* whitespace - we ignore it */
	;
}
break;
case 2:
{		/* an integer */
	yylval.integer = atoi(yytext);
	return INTEGER;
}
break;
case 3:
{                   /* a float */
	yylval.real = atof(yytext);
	return NUMBER;
}
break;
case 4:
{	/* a radix number */
	int radix;
	register int mult = 1;
	register char *c, *stop;
	register unsigned int accum = 0;
	register int charVal;

	sscanf( yytext, "%d#", &radix );
	for( stop = yytext; *stop++ != '#'; ); /* skip the pound sign */
	for( c = yytext+yyleng-1; c >= stop; c--, mult *= radix ) {
	    if( *c >= '0' && *c <= '9' )
		charVal = *c - '0';
	    else if( *c >= 'A' && *c <= 'Z' )
		charVal = *c - 'A' + 10;
	    else
		charVal = *c - 'a' + 10;
	    accum += mult * charVal;
	}
	yylval.real = accum;
	return NUMBER;
}
break;
case 5:
{			/* the constant pi */
	yylval.real = M_PI;
	return NUMBER;
}
break;
case 6:
{			/* the constant e */
	yylval.real = M_E;
	return NUMBER;
}
break;
case 7:
 {			/* a single char that must be recognized */
	return yytext[0];
}
break;
case 8:
{	/* an identifier */
	yylval.string = NXZoneMalloc(NXDefaultMallocZone(), yyleng+1); 
	bcopy(yytext, yylval.string, yyleng);
	yylval.string[yyleng] = '\0';
	return IDENTIFIER;
}
break;
case 9:
{		/* other garbage chars (last rule is the default) */
	yylval.character = yytext[0];
	return BADCHAR;
}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/* inits the global string to the one we will parse */
void _EXPPrepareToScan(const char *text) {
    CurrText = text;
}

/* tells lex there's really no more input when we're done */
static int yywrap() {
    return 1;
}

/* returns the next char of the string we're parsing */
static int input() {
    return *CurrText++;
}

/* lets lex back up one char in the string we're parsing */
static void unput(char c) {
    --CurrText;
}

/* called by lex when it wants to output a char.  This should never happen. */
static void output(char c) {
    fprintf(stderr, "lex output function called with char '%c'\n", c);
}
int yyvstop[] ={
0,

9,
0,

1,
9,
0,

1,
0,

7,
9,
0,

7,
9,
0,

9,
0,

2,
9,
0,

8,
9,
0,

6,
8,
9,
0,

8,
9,
0,

3,
0,

3,
0,

2,
0,

8,
0,

5,
8,
0,

4,
0,

3,
0,

3,
0,

3,
0,

3,
0,

3,
0,
0};
# define YYTYPE unsigned char
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
4,5,	4,5,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	4,5,	
0,0,	0,0,	1,6,	0,0,	
0,0,	0,0,	0,0,	0,0,	
1,7,	0,0,	0,0,	1,8,	
2,8,	1,9,	7,13,	0,0,	
7,14,	7,14,	7,14,	7,14,	
7,14,	7,14,	7,14,	7,14,	
7,14,	7,14,	0,0,	0,0,	
0,0,	0,0,	1,10,	0,0,	
0,0,	0,0,	1,10,	8,15,	
8,15,	8,15,	8,15,	8,15,	
8,15,	8,15,	8,15,	8,15,	
8,15,	0,0,	0,0,	0,0,	
0,0,	0,0,	17,24,	17,24,	
17,24,	17,24,	17,24,	17,24,	
17,24,	17,24,	17,24,	17,24,	
1,10,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,11,	2,11,	
9,16,	15,22,	0,0,	17,25,	
24,30,	0,0,	0,0,	0,0,	
0,0,	1,12,	2,12,	9,17,	
12,21,	9,18,	9,18,	9,18,	
9,18,	9,18,	9,18,	9,18,	
9,18,	9,18,	9,18,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	15,22,	9,19,	17,25,	
24,30,	0,0,	0,0,	0,0,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	9,19,	0,0,	
0,0,	0,0,	10,20,	0,0,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	10,20,	10,20,	
10,20,	10,20,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	16,23,	16,23,	16,23,	
16,23,	19,26,	0,0,	19,26,	
0,0,	0,0,	19,27,	19,27,	
19,27,	19,27,	19,27,	19,27,	
19,27,	19,27,	19,27,	19,27,	
22,28,	0,0,	22,28,	0,0,	
0,0,	22,29,	22,29,	22,29,	
22,29,	22,29,	22,29,	22,29,	
22,29,	22,29,	22,29,	25,31,	
0,0,	25,31,	0,0,	0,0,	
25,32,	25,32,	25,32,	25,32,	
25,32,	25,32,	25,32,	25,32,	
25,32,	25,32,	26,27,	26,27,	
26,27,	26,27,	26,27,	26,27,	
26,27,	26,27,	26,27,	26,27,	
28,29,	28,29,	28,29,	28,29,	
28,29,	28,29,	28,29,	28,29,	
28,29,	28,29,	30,33,	0,0,	
30,33,	0,0,	0,0,	30,34,	
30,34,	30,34,	30,34,	30,34,	
30,34,	30,34,	30,34,	30,34,	
30,34,	31,32,	31,32,	31,32,	
31,32,	31,32,	31,32,	31,32,	
31,32,	31,32,	31,32,	33,34,	
33,34,	33,34,	33,34,	33,34,	
33,34,	33,34,	33,34,	33,34,	
33,34,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-2,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+3,	0,		yyvstop+3,
yycrank+0,	yysvec+4,	yyvstop+6,
yycrank+0,	0,		yyvstop+8,
yycrank+4,	0,		yyvstop+11,
yycrank+23,	0,		yyvstop+14,
yycrank+69,	0,		yyvstop+16,
yycrank+79,	0,		yyvstop+19,
yycrank+0,	yysvec+10,	yyvstop+22,
yycrank+11,	yysvec+10,	yyvstop+26,
yycrank+0,	yysvec+8,	0,	
yycrank+0,	yysvec+7,	0,	
yycrank+36,	yysvec+8,	yyvstop+29,
yycrank+154,	0,		0,	
yycrank+38,	0,		yyvstop+31,
yycrank+0,	yysvec+9,	yyvstop+33,
yycrank+234,	0,		0,	
yycrank+0,	yysvec+10,	yyvstop+35,
yycrank+0,	yysvec+10,	yyvstop+37,
yycrank+249,	0,		0,	
yycrank+0,	yysvec+16,	yyvstop+40,
yycrank+39,	yysvec+17,	yyvstop+42,
yycrank+264,	0,		0,	
yycrank+274,	0,		0,	
yycrank+0,	yysvec+26,	yyvstop+44,
yycrank+284,	0,		0,	
yycrank+0,	yysvec+28,	yyvstop+46,
yycrank+299,	0,		0,	
yycrank+309,	0,		0,	
yycrank+0,	yysvec+31,	yyvstop+48,
yycrank+319,	0,		0,	
yycrank+0,	yysvec+33,	yyvstop+50,
0,	0,	0};
struct yywork *yytop = yycrank+376;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,'%' ,01  ,01  ,
'%' ,'%' ,'%' ,'+' ,'%' ,'+' ,01  ,'%' ,
'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,'0' ,
'0' ,'0' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'E' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,'%' ,'_' ,
01  ,'A' ,'A' ,'A' ,'A' ,'E' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
#if	NeXT
int yylook(){
#else
yylook(){
#endif	NeXT
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
#if	NeXT
int yyback(p, m)
	int *p;
	int m;
#else
yyback(p, m)
	int *p;
#endif	NeXT
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
#if	NeXT
int yyinput(){
#else
yyinput(){
#endif	NeXT
	return(input());
	}
#if	NeXT
void yyoutput(c)
	int c; 
{
	output(c);
}
#else
yyoutput(c)
  int c; {
	output(c);
	}
#endif	NeXT
#if	NeXT
void yyunput(c)
	int c; 
{
	unput(c);
}
#else
yyunput(c)
   int c; {
	unput(c);
	}
#endif	NeXT
