
/*
    exprDefs.h

    Private defs used by Expression and the parsing modules.
*/

#import "Expression.h"

/* a type of function term we know how to parse */
typedef struct _Function {
    char *name;
    int minArgs;
    int maxArgs;
    EXPTermEvalFunc *evalFunc;
} Function;

typedef enum {		/* various types of terms we know about */
    constantTerm = 1,
    varTerm = 2,
    vectorTerm = 4,
    binOpTerm = 8,
    funcTerm = 16
} TermTag;

/* a term of an expression.
   Note that even if a constant is an integer, we store it as a float.  This
   ensures that divide by zero results in NaN ("not a number", a special
   floating point value) instead of a coredump due to an arithmetic exception.
 */
typedef struct _EXPTerm {
    TermTag tag;		/* type of term */
    union {
	struct {
	    BOOL isInt;		/* is this an integer? */
	    float val;		/* the constant value */
	} constant;
	struct {
	    char *name;		/* name of var */
	    float val;		/* value of var */
	} var;
	struct {
	    BOOL hasRange;	/* do we calc the vector or the range? */
	    BOOL changed;	/* do we need to recalc? */
	    short dimension;	/* dimension within which we vary */
	    char *name;		/* name of var */
	    int resolution;	/* last resolution we calc'ed at */
	    float min;		/* range of values */
	    float max;
	    float *vals;	/* list of values */
	} vector;
	struct {
	    char op;		/* char representing op (e.g. '+', '-',...) */ 
	} binOp;
	struct {
	    Function *type;	/* info for this type of function */
	} func;
    } data;
    int numSubterms;		/* number of subTerms from parse */
    struct _EXPTerm *subterms[1];	/* the subTerms */
} Term;


typedef struct _TermList {	/* a list of terms */
    int num;
    Term *terms[1];
} TermList;


/* declaration of functions shared between the parsing modules */

extern Term *_EXPAllocTerm(NXZone *zone, TermTag tag, int numSubterms, ...);
extern void _EXPFreeTerm(void *info, Term *data);
extern BOOL _EXPParseExpression(const char *text, NXHashTable *validTerms, Term **parseTree, NXHashTable *varTerms, NXZone *zone);
extern void _EXPPrepareToScan(const char *text);
