;;; To be used with NeXT Scorefile Package Version 3

(require :scorefile)
(use-package 'scorefile)
(score examp6)		
(header "
envelope bumps   = [(0,0)(.2,1)(.3 ,.5)|(.4,0.0)];
envelope ramp01 =  [(0,0)(.3,1)];
envelope ramp10 =  [(0,1)(.3,0)];
" )

(part nil	                        ; Generate names automatically
	("DBWave2vi")
	0		; Time specification
	:noteOn	
	(dt '(cycle '(.5 .25 .75 .5)) :quiet) 
	(timetag (accumulate-durs dt))
	(freq1  '(seq (pitches d2 e f g a bf d3 e :end)))
	(freq0  '(if (= (notenum) 1) (pval freq1) (lastval freq1)))
	(ampEnv "bumps")
	(waveform1 '(cycle '("BA" "0BA")) :string :always)
	(waveform0 '(cycle '("0BA" "BA")) :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt .25)
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	)

(write-score examp6)
(play)
