;;; To be used with NeXT Scorefile Package Version 3

(require :scorefile)
(use-package 'scorefile)
(score examp10)
(header "
envelope bumps   = [(0,0)(.2,1)(.3 ,.5)|(.4,0.0)];
envelope ramp01 =  [(0,0)(.05,1)];
envelope ramp10 =  [(0,1)(.05,0)];
" )

(part nil	                        ; Generate names automatically
      ("DBWave2vi")
      '(0 10)		; Time specification
      :noteOn	
      (dt .05 :quiet)
      (timetag (accumulate-durs dt))
      (freq1  'd3)
      (ampEnv "bumps")
      (waveform0 
       '(if (= (notenum) 1) "BA" 
	  (cycle '("BU" nil "BE" nil "BE" nil)))
		 :string)
      (waveform1 '(cycle '("BA" nil "BO" nil "BA" nil))
		 :string)
      (waveformAtt '(pval dt))
      (waveformEnv '(cycle '("ramp01" "ramp10")))
      (freqEnv "ramp01")
      (freqAtt .25)
      (svibAmp .01)
      ;; Randomize vibrato frequencies a bit.
      (svibFreq (+ 4.5 (random 1.0)))
      (rvibAmp .008)
      )

(write-score examp10)
(play)
