;;; To be used with NeXT Scorefile Package Version 3

(require :scorefile)
(use-package 'scorefile)
(score violin ((tempo 112) (samplingRate 44100)) 1 nil)

(header "
envelope ampVn1  =  [(0,0)(.06,0dB,1.3)(.09,-6dB)(.2,-6dB,1)|(.25,0,.9)];
envelope ampVn2  =  [(0,0)(.07,-4dB,1.3)(.1,-6dB)(.2,-6dB,1)|(.25,0,1)];
envelope intVn1  =  [(0,0)(.005,0,.5)(.06,0)(.15,1)];
" )

(part violinPart ("DBWave2vi") 0 :noteDur
      (dur '(if (< (notenum) 101) .21 4))
      (dur2 '(if (< (notenum) 101) .25 4) :quiet)
      (time (accumulate-durs dur2) :quiet)
      (timeTag '(max (+ (pval time) -.01 (random .02)) 0))
      (noteTag (unique-notetag)) ; all notes have same noteTag (rearticulate)
      (freq1 '(seq '(
		    b6 e5 e5 a6 e5 e5 g6 e5 e5 ef6 e5 e5 gf6 f6 b5 e5 
		    cs6 e6 e5 ds6 e5 g5 c6 b5 f5 e5 bf5 gf5
		    e6 a4 a4 d6 a4 a4 c6 a4 a4 af5 a4 a4 cf6 bf5 a4 ef5 
		    af5 g5 d5 a4 b4 gf5 a4 f5 ef5 a4 c5 g4
		    a5 d4 d4 gs5 d4 d4 f5 d4 d4 cs5 d4 d4 e5 ds5 as4 d4 
		    c5 g5 d4 fs5 d5 g4 bf4 d4 a4 f5 d4 cs5
		    g3 g3 g3 g4 g3 g3 g6 g3 g3 g7 g5 g5 g5 g5 g5 g5
		    g5 :end)))
      (amp '(- (env '((0 11)(4 5)(7 10)(11 4)(14 9)(18 3)(20.9 8)
		     (21 16)(23 16)(24 10)(25 18))) (random .5)) :db)
      (ampEnv '(timer (0 "ampVn1") (23.4 "ampVn2")))
      (waveform0 '(cycle '("VNA")) :string :always)
      (waveform1 '(cycle '("VNS")) :string :always)
      (waveformEnv "intVn1")
      (rvibAmp .005)
      (svibAmp '(if (< (notenum) 101) .001 .009))
      (svibFreq 4.5)
      (wavelen 256))

(write-score violin)
(play)
