;;; To be used with NeXT Scorefile Package Version 3
;;; An example of polyphonic voices with changing wave tables.

(require :scorefile)
(use-package 'scorefile)

(score examp8 ((tempo 42)(samplingRate 22050.0)))
(header "
envelope smooth  = [(0,0)(.3 ,1.0)|(1.4,0.0)];
envelope ramp01 =  [(0,0)(.3,1)];
envelope ramp10 =  [(0,1)(.3,0)];
" )

(defmacro firstnote () '(= (notenum) 1))

(part bass
	("DBWave2vi" )
	(+ (random .1) 0.0 )
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(.5 .25 .75 .5))) :quiet) 
	(timetag (accumulate-durs dur))
	(freq1  '(seq (pitches d2 e f g a bf d3 e a bf a :end)))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(ampAtt '(if (firstnote) 1.0 .3))
	(amp '(env '((0 20)(5 10))) :db)
	(waveform0 '(cycle '("0BE" "BU" "0BU" "BE" "0BE" "BE"))
		   :string :always)
	(waveform1 '(cycle '("BA" "0BA" "BO" "0BO" "BA" "0BA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing 0)
	)

(part tenor
	("DBWave2vi" )
	(+ (random .1) .5 )
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(1.0 .25 .5 .25))) :quiet) 
	(timetag (accumulate-durs dur))
	(freq1  '(seq (pitches f3 e a g c4 d f g a :end)))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(amp '(env '((0 20)(5 10))) :db)
	(ampAtt '(if (firstnote) 1.0 .3))
	(waveform0 '(cycle '("0TE" "TU" "0TU" "TE" "0TE" "TE"))
		   :string :always)
	(waveform1 '(cycle '("TA" "0TA" "TO" "0TO" "TA" "0TA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing -45)
	)

(part alto
	("DBWave2vi" )
 	(+ (random .1) 1.0)
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(.75 .25 .5 .5))) :quiet) 
	(timetag (accumulate-durs dur))
	(freq1  '(seq (pitches d4 c e d f a bf a :end)))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(amp '(+ .2 (env '((0 20)(5 10)))) :db)
	(ampAtt '(if (firstnote) 1.0 .3))
	(waveform0 '(cycle '("0SE" "SU" "0SU" "SE" "0SE" "SE"))
		   :string :always)
	(waveform1 '(cycle '("SA" "0SA" "SO" "0SO" "SA" "0SA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing 45)
	)

(part soprano1
	("DBWave2vi" )
	(+ 1.5 (random .1))
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(.5 .25 .5 .75))) :quiet) 
	(timetag (accumulate-durs dur))
	(freq1  '(seq (pitches g5 a f e c d e a4 :end)))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(amp '(env '((0 20)(5 10))) :db)
	(ampAtt '(if (firstnote) 1.0 .3))
	(waveform0 '(cycle '("0SE" "SU" "0SU" "SE" "0SE" "SE"))
		   :string :always)
	(waveform1 '(cycle '("SA" "0SA" "SO" "0SO" "SA" "0SA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing -33)
	)

(part soprano2
	("DBWave2vi" )
	(+ 1.5 (random .1))
	:noteOn	
	(dur '(if (firstnote) 1.0 (cycle '(.5 .25 .5 .75))) :quiet) 
	(timetag (accumulate-durs dur))
	(freq1  '(seq (pitches e5 f d c a4 bf g a :end)))
	(freq0  '(if (firstnote) (pval freq1) (lastval freq1)))
	(ampEnv "smooth")
	(ampAtt '(if (firstnote) 1.0 .3))
	(waveform0 '(cycle '("0SE" "SU" "0SU" "SE" "0SE" "SE"))
		   :string :always)
	(waveform1 '(cycle '("SA" "0SA" "SO" "0SO" "SA" "0SA"))
		   :string :always)
	(waveformAtt .25)
	(waveformEnv '(cycle '("ramp01" "ramp10")))
	(freqEnv "ramp01")
	(freqAtt '(/ (pval dur) 2.0))
	(svibAmp .01)
	;; Randomize vibrato frequencies a bit.
	(svibFreq '(+ 4.5 (random 1.0)))
	(rvibAmp .008)
	(bearing 33)
	)

(write-score examp8)
(run-program "playscore -w /tmp/examp8.snd examp8.score")

(score mixsounds ((samplingRate 22050.0)))
(part mixerpart1
      nil				; no part info 
      0					; offset time
      :noteDur
      (dur 0)				; duration of 0 means "the whole thing" when mixing soundfiles
      (timetag '(seq '(0 6 9 12 13 14 15 :end))) ;
      ("soundFile" "/tmp/examp8.snd" :string :always) 
      (amp '(env '((0.0 8)(15.0 29))) :db)
      )

(part mixerpart2
      nil				; no part info 
      '(0 15)				; offset time
      :noteDur
      (dur 0)				; duration of 0 means "the whole thing" when mixing soundfiles
      (dt '(cycle '(1 .5 .5 .333 .333 .333)) :quiet)
      (timetag (accumulate-durs dt))
      (amp .25)
      ("soundFile" "/NextLibrary/Sounds/Frog.snd" :string :always) 
      )

(write-score mixsounds)

;;; mix it
(run-program "mixsounds mixsounds.score /tmp/mix.snd")

;;; now play it
(run-program "sndplay /tmp/mix.snd")


