;;; To be used with NeXT Scorefile Package Version 3
(require :scorefile)
(use-package 'scorefile)
(score examp2)			; Create new score examp2

(header " 
envelope ampFn   = [(0,0)(.1,1)(.2,.7)|(.3,0.0)];
envelope indFn   = [(0,0)(.1,1)(.2,.7)|(.3,.7)];
" )				; String to go in header of output file

(part part1			; Create a new part, part1
      ("Fm1vi")			; Synthpatch to use. This is the "part info" 
      '(0 5)			; Timing offset and cut-off time.
      :noteOn			; Type of notes to use.
      
      ;; Now come the parameter definitions. 
      (timeTag '(cycle '(0 1 1.5 2 2.5 3 4 :end))) ; List of timeTags
      (freq '(cycle '(d5 e5)))	; Here we alternate pitches
      (amp .1)
      (ampEnv "ampFn")
      (ampAtt .1)
      (ampRel .2)
      (m1Ratio 1)
      (m1Ind1 1)
      (m1Ind0 0)
      (m1IndEnv "indFn")
      (m1IndAtt '(pval ampAtt))	; Access current value of ampAtt.
      (m1IndRel '(pval ampRel))
      (svibAmp .009)
      (svibFreq 4.5)
      (rvibAmp .005)
      (bearing 0))

(write-score examp2)			; Write it out

(play) ; play it
