#import "Credits.h"

static void tick(DPSTimedEntry timedEntry, double now, void *userData );

@interface Credits (Private )
- _scrollTick;
@end

@implementation Credits

- init
{
   [super init];

   origin.x = 0.0;
   origin.y = 0.0;
   seconds = 0.05;
   done = YES;
   
   return self;
}

- setScrollView: anObject
{
   char buf[MAXPATHLEN + 1];

   [[NXBundle mainBundle] getPath: buf forResource: "credits" ofType:"rtfd"];  

   scrollView = anObject;

   [scrollView setVertScrollerRequired: NO];
   clipView = [[scrollView docView] superview];
   text = [clipView docView];

   [text setMonoFont: NO];
   [text openRTFDFrom: buf];
   [text setSelectable: NO];
   [text setEditable: NO];

   return self;
}

- start: sender
{
   if(done)
   {
      done = NO;
      scrollFunc = DPSAddTimedEntry(seconds, tick, (void *)self, NX_BASETHRESHOLD);
   }
   
   return self;
}

- setSeconds: (double) sec
{
   seconds = sec;
   return self;
}

- (double) seconds
{
   return seconds;
}

@end

@implementation Credits (Private )

- _scrollTick;
{
   NXRect theSize;

   if(!done)
   {
      [text getFrame: &theSize];

      if(origin.y < theSize.size.height - 10)
	  origin.y += 1.0;
      else
      {
	 done = YES;
	 DPSRemoveTimedEntry(scrollFunc);
	 origin.y = 0;
      }
      
      [clipView rawScroll: &origin];
   }
   
   return self;
}


@end

static void tick(DPSTimedEntry timedEntry, double now, void *userData )
{
   [(id)userData _scrollTick];
}
