#import <objc/Storage.h>

/*
** StringStorage.h,v 1.4 1992/05/21 22:46:59 nwc Exp
**
** Copyright (c) 1991 Ronin Consulting, Inc.
**
** StringStorage is a subclass of Storage designed to store null 
** terminated character strings. Null termination is guaranteed, therefore
** should this object's setStringValue method be called with a (char *)0
** arguement the resulting value from stringValue will be a null terminated
** empty string, i.e. "" not (char *)0.
*/

@interface StringStorage : Storage

- init;
- init: (const char *) str;

- setStringValue: (const char *) str;	     /* Set the string value */
- setFStringValue: (const char *)format,...;
- (const char *) stringValue;		     /* return the string pointer */

- appendStringValue: (const char *)str;	     /* append another string to the strings contents */
- appendFStringValue: (const char *)format,...;
- appendCharValue: (char) c;		     /* append a character to the strings contents */

- (int) matchSubstring: (const char *)str;
- (char *) getSubstring: (const char *)str;
- replaceSubstring: (const char *)str with: (const char *)str2;


- (int) strlen;				     /* just (count - 1)...but cleaner */

- (unsigned int)hash;			     /* Provide a hash function */

- empty;				     /* override to ensure null termination */

@end
