#import "DocumentController.h"
#import "StringStorage.h"
#import <appkit/Application.h>
#import <appkit/nextstd.h>
#import <objc/NXBundle.h>
#import <sys/param.h>

@implementation DocumentController

- init
{
   [super init];

   docType = [[StringStorage alloc] init];
   panel = nil;
   return self;
}

-free
{
   [docType free];
   return [super free];
}


- setDocType: (const char *) str
{
   [docType setStringValue: str];
   return self;
}

- makeKeyAndOrderFront:sender
{
   if(!panel)
   {
      char buf[MAXPATHLEN + 1];

      if(!*[docType stringValue])
      {
	 NXLogError("Opening a document with unknown nib name.");
	 return nil;
      }


      if(![[NXBundle bundleForClass:[self class]] 
            getPath: buf forResource: [docType stringValue] ofType:"nib"])
      {
	 NXLogError("Could not find %s.nib\n",[docType stringValue]);
	 return nil;
      }
      
   
      [NXApp loadNibFile:buf owner:self withNames:NO fromZone:[self zone]];
   }
   
   [panel makeKeyAndOrderFront: sender];
   return self;
}

@end
