/*
 * in.timed	This file contains an implementation of the "server"
 *		for the TIMEP protocol, as described in RFC 868.  This
 *		protocol can be used to ask servers like this one for
 *		their current time-and-day.
 *
 * Usage:	in.timed [-v]
 *
 * Version:	@(#)in.timed.c		1.10	12/12/93
 *
 * Authors:	Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>


char *Version = "@(#)timed 1.10 (12/12/93)";


int opt_v = 0;				/* debugging output flag	*/


/* Answer an incoming TIMEP request. */
static int
timed(void)
{
  time_t now;
  time_t nettime;
  unsigned long val;

  (void) time(&now);
  nettime = now + (time_t) 2208988800UL;	/* adjust for 1 Jan 1900 GMT */
  val = (unsigned long) nettime;
  val = htonl(val);

  (void) write(1, (char *) &val, sizeof(unsigned long));

  return(0);
}


static void
usage(void)
{
  fprintf(stderr, "Usage: in.timed [-v]\n");
  exit(-1);
}


int
main(int argc, char *argv[])
{
  char who[128];
  int c;

  opterr = 0;
  while ((c = getopt(argc, argv, "v")) != EOF) switch(c) {
	case 'v':
		opt_v = 1;
		break;

	default:
		usage();
  }

  /* No more arguments allowed. */
  if (optind != argc) usage();

  /* Start the server. */
  c = timed();

  return(c);
}
