/* This file is part of the Project Athena Zephyr Notification System.
 * Created by: Mark W. Eichin <eichin@athena.mit.edu>
 * $Source: /mit/zephyr/src/zwgc/RCS/lexer.c,v $
 * $Author: eichin $
 *
 *	Copyright (c) 1988 by the Massachusetts Institute of Technology.
 *	For copying and distribution information, see the file
 *	"mit-copyright.h". 
 */
#include <zephyr/mit-copyright.h>
#ifndef lint
static char rcsid[] = "$Header: lexer.c,v 2.1 88/06/18 08:50:04 eichin Exp $";
#endif lint

#include "ropes.h"
#include "support.h"
#include "comp_types.h"
/*
 * lexer.c
 *
 * Ok. One more time.
 *
 * Lines can have leading whitespace, trailing comments, commands, and
 * arguments. The first token on a line is a command. A line with no
 * command should get slurped.
 *
 */
/*
 * char *line, *cmd, *args[];
 * int cmdlen;
 * 
 * lexit(&line, &cmd, &cmdlen, &args)
 * returns 0 for EOF, 1 for ok, 2 for slurp
 *
 */
#define LEXIT_EOF   0
#define LEXIT_OK    1
#define LEXIT_SLURP 2

int lexit(line, cmnd, cmndlen, args, arglen)
     char **line;
     char **cmnd;
     int *cmndlen;
     char **args;
     int *arglen;
{
  char *str = *line;
  
  while(*str && is_blank(*str)) str++;
  *cmnd = str;
  *cmndlen = 0;
  *arglen = 0;

  while(*str && is_symchar(*str))
    {
      str++;
      (*cmndlen)++;
    }

  if(*cmndlen)			/* got one, keep going... */
    {
      while(*str && is_blank(*str)) str++;
      *args = str;
      while(*str && *str != '#' && *str != '\n')
	{
	  str++;
	  (*arglen)++;
	}
    }
  /* either at end of line or in a comment aiming for it. */
  while(*str && (*(str++) != '\n'));
  *line = str;
  return((*cmndlen)?LEXIT_OK:((*str)?LEXIT_SLURP:LEXIT_EOF));
}

      
