/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#include <string.h>
#include "bb.h"

extern struct person *user;

void write_usr(struct person *record, long *userposn)
{
	int outfile;
	
	if ((outfile=err_open(makepath(USERFILE,"",""),O_WRONLY|O_APPEND|O_CREAT,0600))<0)
		exit(-1);
	Lock_File(outfile);
	write(outfile,record,sizeof(*record));
	*userposn=(lseek(outfile,0,1)-sizeof(*record));
	Unlock_File(outfile);
	close(outfile);
}

void update_user(struct person *record, long userposn)
{
	int outfile;
	
	outfile=openuserfile(O_RDWR|O_CREAT);
	/*Lock_File(outfile); */
	lseek(outfile,userposn,0);
	write(outfile,record,sizeof(*record));
	/*Unlock_File(outfile); */
	close(outfile);
}

void login_ok(struct person *usr, long *userposn)
{	
	/* main function */
	char name[NAMESIZE+1];
	int okay;
	do{
		get_login(name);
		if(is_old(usr,name,userposn))
			okay=old_usr(usr);
		else
			okay=new_usr(usr,name,userposn);
	}while (!okay);
	check_copies(*userposn); 	
}

void get_login(char *name)
{
	char *lname;
	fflush(stdin);
gstart:	printf("Please enter name: ");
	get_str(name,NAMESIZE);
	strip_name(name);
	if (feof(stdin)) exit(0);
	lname=(char *)getlogin();
	if (strlen(name)<1)
	{
		if (lname==NULL)
		{
			printf("Don't be shy.\n");
			goto gstart;
		}else
		{
			strncpy(name,lname,NAMESIZE);
			name[NAMESIZE]=0;
			if (stringcmp(name,"guest",-1))
				strcpy(name,getenv("UNAM"));
		}
	}	
}

void strip_name(char *string)
{
	char *array;
	int i,ptr=0;
	int len;
	
	len=strlen(string);
	array=(char *)malloc(len+1);
	for (i=0;i<len;i++)
	{
		if (isalnum(string[i]) || string[i]=='_' || string[i]=='-')
			array[ptr++]=string[i];
	}
	array[ptr]=0;
	strcpy(string,array);
	free(array);
}

int is_old(struct person *usr, char *name, long *userposn)
{
	int file,found=FALSE;

	if (access(makepath(USERFILE,"",""),00)) return(FALSE);
	file=openuserfile(O_RDONLY);
	while (!found && get_person(file,usr))
		if (stringcmp(usr->name,name,-1) && !u_del(usr->status))
			found=TRUE;
	if (found) 
		*userposn=lseek(file,0,1)-sizeof(struct person);
	close(file);
	return(found);
}

int get_person(int file, struct person *tmp)
{
	int no;
	if (!(no=read(file,tmp,sizeof(*tmp))))
	{
		return(FALSE);
	}else
	if (no<sizeof(*tmp))
	{
		perror("userfile");
		exit(-1);
	}else
		return(TRUE);
}

int old_usr(struct person *usr)
{
	char salt[3],passwd[PASSWDSIZE];
	char *name;

	name=(char *)getlogin();
	if (name==NULL || !stringcmp(usr->name,name,-1))
	{
		strncpy(salt,usr->passwd,2);
		fflush(stdin);
		strcpy(passwd,crypt(get_pass("Enter Password: "),salt));
		if (strcmp(passwd,usr->passwd))
		{
			printf("Login Incorrect.\n\n");
			exit(0);
		}
	}
	if (usr->status&(1<<3))
	{
		printf("Sorry, this username has been banned.\n");
		printf("Have a nice day. *:-)\n");
		exit(0);
	}
	printf("Hello %s.\n",usr->name);
	return(TRUE);
}

int new_usr(struct person *usr, char *name, long *userposn)
{
	char passwd[PASSWDSIZE],passwd2[PASSWDSIZE],salt[3];
	char c[10];
	do{
		printf("Did I get your name right %s ?",name);
		get_str(c,9);
	}while (!*c);
	if(*c=='y' || *c=='Y')
	{
		int diff=FALSE;
		pick_salt(salt);
		printf("We use a password on this BB.\n");
		do{
			if (diff) printf("Passwords did not match.\n");
			strcpy(passwd,crypt(get_pass("Enter password: "),salt));
			strcpy(passwd2,crypt(get_pass("Re-enter passwd: "),salt));
		}while ((diff=strcmp(passwd,passwd2)));
		strncpy(usr->passwd,passwd,PASSWDSIZE);
		strncpy(usr->name,name,NAMESIZE);
/*
printf("Please enter the following details so that we can register you as a\n");
printf("normal user of this bulletin board. without correct information you\n");
printf("will not be allowed to use the full facilities of this board.\n");
printf("DATA PROTECTION ACT:\n");
printf("Any data entered will be recorded in a computer database for the purpose\n");
printf("of the administration, operation and security of the computer society. By \n");
printf("entering this data you consent to the storage of this data, and become an\n");
printf("associate member of the society.\n");
printf("\nIf you do not wish to register, do not enter a name.\n");
*/

		printf("Real Name: ");
		get_str(usr->realname,REALNAMESIZE);
		if (!usr->realname[0])
		{
			printf("User record '%s' cancelled.\n",usr->name);
			printf("Goodbye.\n");
			exit(0);
		}
		printf("Email address: ");
		get_str(usr->contact,CONTACTSIZE);
		set_defaults(usr);
		user=usr;
		printf("Creating new user %s\n",name);
		log("CREATED");
		write_usr(usr,userposn);
		return(TRUE);
	}
	else return(FALSE);	
}

void set_defaults(struct person *tmp)
{
	int i;
	
	tmp->status=0;
	tmp->special=0;
	tmp->groups=0;
	tmp->folders[0]=SETALLLONG;
	tmp->folders[1]=SETALLLONG;
	tmp->lastlogin=time(0);
	tmp->timeused=0l;
	for (i=0;i<64;i++) tmp->lastread[i]=0;
	
	if (getuid()==geteuid()&&!internet) /* if you have run it as the owner */
	{
		char buff[11];
		printf("What status do you want to be ? [rms] ");
		get_str(buff,10);
		tmp->status=user_stats(buff,0);
		show_user_stats(tmp->status,buff,FALSE);
		printf("Status set to [%s]\n",buff);
	}else
	if (getuid()!=300 && !internet) /* a special restricted uid */
	{
		char buff[50];
		tmp->status|=1;
		tmp->groups|=1;
		sprintf(buff,"AutoRegister %s",getlogin());
		log(buff);
	}
	else
	{ /*must be an unregistered guest*/
		printf("You must register before being able to use this system fully.\n");
		printf("Until then you will not be able to write in most folders.\n");
	
	}
}

void pick_salt(char *salt)
{
	strcpy(salt,"ab");
}

void list_users(int newonly) 
{
	int file;
	struct person usr;
	long time;
	char stats[10],gr[10];
	int linecount=0;
	
	file=openuserfile(O_RDONLY);
	while (get_person(file,&usr))
	{
		if (!newonly || ( newonly && !u_reg(usr.status) ) )
		{
		time=usr.lastlogin;
		show_user_stats(usr.status,stats,TRUE);
		show_fold_groups(usr.groups,gr,TRUE);
		if (!u_del(usr.status))
		{
			linecount++;

			printf("%*s [%5s] [%8s] %s",NAMESIZE,usr.name,stats,gr,ctime(&time));
			if (linecount>=21)
			{
				char foo[6];
				printf("---more---\r");
				echo_off();
				get_str(foo,5);
				echo_on();
				if (foo[0]=='q'|| foo[0]=='Q') break;
				printf("            \r");
				linecount=0;
			}
		}
		}
	}
	close(file);
}


void list_users_since(long date) 
{
	int file;
	struct person usr;
	long time;
	char stats[10],gr[10];
	int linecount=0;
	
	file=openuserfile(O_RDONLY);
	while (get_person(file,&usr))
	{
		if (usr.lastlogin>date)
		{
		time=usr.lastlogin;
		show_user_stats(usr.status,stats,TRUE);
		show_fold_groups(usr.groups,gr,TRUE);
		if (!u_del(usr.status))
		{
			linecount++;
			printf("%*s [%5s] [%8s] %s",NAMESIZE,usr.name,stats,gr,ctime(&time));
			if (linecount>=21)
			{
				char foo[6];
				printf("---more---\r");
				echo_off();
				get_str(foo,5);
				echo_on();
				if (foo[0]=='q'|| foo[0]=='Q') break;
				printf("            \r");
				linecount=0;
			}
		}
		}
	}
	close(file);
}

void list_users_flags(int flags, int type, int inv)
/*type: 0=status 1=special 2=group */
/*inv: 0= with flags, 1=without flags */
{
	int file;
	struct person usr;
	long time;
	char stats[10],gr[10],spec[20];
	int linecount=0;
	int check;
	
	file=openuserfile(O_RDONLY);
	while (get_person(file,&usr))
	{
		if (type==0) check=usr.status;
		else
		if (type==1) check=usr.special;
		else
		if (type==2) check=usr.groups;

		check=check&flags;
		if (inv?check==0:check!=0)
		{
		time=usr.lastlogin;
		show_user_stats(usr.status,stats,TRUE);
		show_special(usr.special,spec,TRUE);
		show_fold_groups(usr.groups,gr,TRUE);
		if (!u_del(usr.status))
		{
			linecount++;
			printf("%*s [%s] [%s] [%s] %s",NAMESIZE,usr.name,stats,spec,gr,ctime(&time));
			if (linecount>=21)
			{
				char foo[6];
				printf("---more---\r");
				echo_off();
				get_str(foo,5);
				echo_on();
				if (foo[0]=='q'|| foo[0]=='Q') break;
				printf("            \r");
				linecount=0;
			}
		}
		}
	}
	close(file);
}


void search(char *args, char *ptr)
{
	int data;
	int inv=0;
	
	if (ptr[0]=='!')
	{
		inv=1;
		ptr++;
	}
	if (stringcmp(args,"status",2))
	{
		data=user_stats(ptr,0);
		list_users_flags(data,0,inv);
	}else
	if (stringcmp(args,"special",2))
	{
		data=set_special(ptr,0);
		list_users_flags(data,1,inv);
	}else
	if (stringcmp(args,"groups",2))
	{
		data=folder_groups(ptr,0);
		list_users_flags(data,2,inv);
	}
}
