/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/

#include "bb.h"
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

extern int remote;

void list_new_items(struct person *user, int flag)
/* flag true if only new messages to be listed */
{
	int file;
	int count=0,line=0;
	struct folder folstuff;
	struct folder *fol=&folstuff;
	
	if (nofolders())
		{printf("There are no folders to read !\n"); return;}	
	file=openfolderfile(O_RDONLY);
	while (get_folder_entry(file,fol))
	{
		if (f_active(fol->status) 
		   && (allowed_r(fol,user)
		   || allowed_w(fol,user))) /*allowed*/
		if (!flag || (flag && (fol->last-user->lastread[count])>0 
		          && allowed_r(fol,user)
		          && get_subscribe(user,count))) /* subscribed */
		{
			printf("%*s (",FOLNAMESIZE,fol->name);
			putchar(allowed_r(fol,user)?'r':'-');
			putchar(allowed_w(fol,user)?'w':'-');
			putchar(is_private(fol,user)?'p':'-');
			putchar(is_moderated(fol,user)?'m':'-');
			putchar(get_subscribe(user,count)?'S':'-');
			line++;
			if (flag)
			{
				printf(")     Last read message %4d of %-4d  %4d new\n",
				user->lastread[count],fol->last,
				fol->last-user->lastread[count]);
			}else
			{
				printf(") %4d Msgs  Topic: %s\n",
				fol->last==0?0:fol->last-fol->first+1,
				fol->topic);
			}
		}
		count++;
		if (line>=23)
		{
			char tmp[4];
			printf("---more--- Press <return> to continue.\r");
			get_str(tmp,3);
			if (tmp[0]=='q' || tmp[0]=='Q') {close(file);return;}
			line=0;
		}
	}
	close(file);
}

void new(struct person *user)
{		
	struct folder *data;	
	int folderfile;
	int folnum=0;
	
	data=(struct folder *)malloc(sizeof(*data));

	if (nofolders())
		{printf("There are no folders to read !\n"); return;}	
	folderfile=openfolderfile(O_RDONLY);
	while (get_folder_entry(folderfile,data))
	{
		if (data->status&1 /*active*/
		&& allowed_r(data,user) /* allowed to read */ 
	    	&& get_subscribe(user,folnum)  /* currently subscribed */
		&& !(data->last<data->first || data->last==0)
		&& !(data->last<=user->lastread[folnum])) 
		{
			if (!remote)
			{
				printf("Scanning folder %-*s\r",FOLNAMESIZE,data->name);
				fflush(stdout);
			}
			if (read_new(user,data,folnum)) break;
		}
		folnum++;
	}
	close(folderfile);
}

int  read_new(struct person *user, struct folder *data, int folnum)
{
	int indexfile,datafile;
	long posn;
	struct Header head;
	char tmp[80];

	if (access(makepath(data->name,INDEX_END,""),0)) 
		{printf("Error: cannot find index file for folder %s\n",data->name);return(-1);}
	if (access(makepath(data->name,TEXT_END,""),0)) 
		{printf("Error: cannot find text file for folder %s\n",data->name); return(-1);}
	if ((indexfile=err_open(makepath(data->name,INDEX_END,""),O_RDONLY,0))<0)
		{exit(-1);}
	if ((datafile=err_open(makepath(data->name,TEXT_END,""),O_RDONLY,0))<0)
		{exit(-1);}
	
	posn=(user->lastread[folnum]-data->first+1)*sizeof(struct Header);
	lseek(indexfile,posn,0);
	get_data(indexfile,&head);
	while (head.Ref<=user->lastread[folnum] && get_data(indexfile,&head));
	if (!remote) printf("\n");
	do{
	    user->lastread[folnum]=head.Ref;
	    if (is_private(data,user)&&!stringcmp(head.to,user->name,-1))
	    { /* private  and not to you */
	    }else
	    if (head.status&(1<<1))
	    {
	    	if (!remote) printf("Skipping deleted message.\n");
	    }else
	    if (head.status&(1<<3) && stringcmp(user->name,head.from,-1))
	    {
	    	/* was remotely posted by you. */
	    }else
	    {
		if (remote)
		{
			printf("MWYS\n");
			printf("%s\n",data->name);
		}
		display_article(&head,datafile);
		if (!remote)
		{
			DisplayStack();
			printf("Hit return for next message (%s - %d of %d)>",data->name,head.Ref,data->last);
			get_str(tmp,80);
			alarm(TIMEOUT);
			if (stringcmp(tmp,"catchup",2))
			{
				user->lastread[folnum]=data->last;
				printf("Catching up on folder %s\n",data->name);
				break;
			}else
			if (stringcmp(tmp,"skip",-1))
			{
				printf("Skipping this folder. %d messages left unread.\n",data->last-head.Ref);
				break;
			}else
			if (stringcmp(tmp,"reply",3))
			{
				long foo;
				foo=lseek(indexfile,0,1);
				add_msg(folnum,user,head.Ref);
				lseek(indexfile,foo,0);
				get_folder_number(data,folnum);
			}else
			if (stringcmp(tmp,"unsubscribe",5))
			{
				set_subscribe(user,folnum,FALSE);
				printf("Unsubscribing from %s.\n",data->name);
				break;
			}else
			if (strlen(tmp)) 
			{
				extern int last_mesg,currentfolder;
				close(datafile);
				close(indexfile);
				stack_str(tmp);
				currentfolder=folnum;
				last_mesg=head.Ref;
				return(TRUE);
			}
		}
	    }
	}while (get_data(indexfile,&head));
	close(datafile);
	close(indexfile);
	return(0);
}

void latest(struct person *user)
{
	int ffile,ifile;
	struct folder fold;
	struct Header index;
	char datestr[30],sub[40];
	
	if (nofolders())
	{
		printf("There are no folders to read !\n");
		return;
	}
	ffile=openfolderfile(O_RDONLY);

	printf("    Folder  Mesg        Date                 From    Subject\n");
	printf("    ======  ====        ====                 ====    =======\n");
	while (get_folder_entry(ffile,&fold))
	{
		if (f_active(fold.status) && allowed_r(&fold,user))
		{
			char *x;
			x=makepath(fold.name,INDEX_END,"");
			printf("%*s  ",FOLNAMESIZE,fold.name);
			if (access(x,00))
				printf("            <empty>\n");
			else
			{
				if ((ifile=err_open(x,O_RDONLY,0))<0)
					return;
				lseek(ifile,-1*sizeof(index),2);
				read(ifile,&index,sizeof(index));
				strcpy(datestr,ctime(&index.date));
				datestr[16]=0;
				strncpy(sub,index.subject,30);
				sub[27]=0;
				if (strlen(index.subject)>30)
					strcat(sub,"...");
				printf("%4d  %s  %*s  %s\n",fold.last,datestr,
				NAMESIZE,index.from,sub);
				close(ifile);
			}
		}
	}
	close(ffile);
}
