
/*********************************************************
 *     The Milliways III System is copyright 1992        *
 *      J.S.Mitchell. (arthur@sugalaxy.swan.ac.uk)       *
 *       see licence for furthur information.            *
 *********************************************************/
#include "bb.h"
#include <fcntl.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>

void create_folder_file(void)
{
	int file,i;
	struct folder *record;
	
	record=(struct folder *)malloc(sizeof(*record));
	record->status=0;
	file=open(makepath(FOLDERFILE,"",""),O_WRONLY|O_CREAT,0600);
	Lock_File(file);
	for (i=0;i<64;i++) 
		if (write(file,record,sizeof(*record))<0)
		{
			perror("creating blank folders");
			exit(-1);
		}
	Unlock_File(file);
	close(file);
	free(record);
}

int get_folder_entry(int file, struct folder *tmp)
{
	int no;
	if ((no=read(file,tmp,sizeof(*tmp)))<0)
	{
		perror("get_folder_entry");
		exit(-1);
	}
	return(no);
}

int foldernumber(char *name)
{
	/* return number of folder name */
	int file;
	int number=0;
	int no;
	struct folder fold;
	
	file=openfolderfile(O_RDONLY);
	do{
		no=get_folder_entry(file,&fold);
		number++;
	}while (no!=0 && !stringcmp(name,fold.name,strlen(name)));
	close(file);
	
	if (no==0) return(-1); else return(number-1);
}

void listfolders(struct person *user)
{
	/*list all the folders*/
	/* supposed to list folder names (wide format) */
}

void get_folder_number(struct folder *fol, int num)
{
	int file;
	int no;
	
	if (nofolders())
		{printf("There are no folders !\n");return;}
	file=openfolderfile(O_RDONLY);
	lseek(file,sizeof(*fol)*num,0);
	if ((no=read(file,fol,sizeof(*fol)))<0)
	{
		perror("get_folder_entry");
		exit(-1);
	}
	close(file);
}

void add_folder(void)
{
	struct folder *new;
	int file; /*folder file */
	int ufile; /* user file */
	struct person user;
	int yes;
	int folnum = -1;
	char tmp[11];
	char fullpath[30];

	if (nofolders()) create_folder_file();
	new=(struct folder *)malloc(sizeof(*new));
	file=openfolderfile(O_RDWR);
	do{
		yes=get_folder_entry(file,new);
		folnum++;
	}while (yes && ((new->status)&1));
	if (!yes)
	{
		printf("Sorry, no space for a new folder.\n");
		return;
	}
	if (lseek(file,-(sizeof(*new)),1)<0)
	{
		perror("add_folder (seek)");
		exit(-1);
	}
	printf("Create new folder :\n");
	printf("Folder name (%d chars): ",FOLNAMESIZE);
	get_str(new->name,FOLNAMESIZE);
	if (*(new->name)==0) return;
	printf("Folder topic (%d chars): ",TOPICSIZE);
	get_str(new->topic,TOPICSIZE);
	printf("Folder status (not in group) (arwRWpm): ");
	get_str(tmp,10);
	new->status=folder_stats(tmp,0)|1;
	printf("Folder status (in group) (arwRWpm): ");
	get_str(tmp,10);
	new->g_status=folder_stats(tmp,0)|1;
	printf("Folder groups (12345678): ");
	get_str(tmp,10);
	new->groups=folder_groups(tmp,0);
	new->first=0;
	new->last=0;
	printf("Creating folder %s - %s\n",new->name,new->topic);

	ufile=openuserfile(O_RDWR);
	Lock_File(ufile); /*user file*/
	while(get_person(ufile,&user))
	{
		lseek(ufile,-1*sizeof(user),1);
		user.lastread[folnum]=0;
		set_subscribe(&user,folnum,TRUE);
		write(ufile,&user,sizeof(user));
	}
	Unlock_File(ufile);
	Lock_File(file); /* folder file */
	if (write(file,new,sizeof(*new))<0)
	{
		perror("add_folder");
		exit(0);
	}
	Unlock_File(file);
	close(file);
	sprintf(fullpath,"Created Folder %s",new->name);
	log(fullpath);
}

void auto_subscribe(int folnum, int state)
{
	int ufile;
	struct person us;

	ufile=openuserfile(O_RDWR);
	Lock_File(ufile); /*user file*/
	while(get_person(ufile,&us))
	{
		lseek(ufile,-1*sizeof(us),1);
		set_subscribe(&us,folnum,state);
		write(ufile,&us,sizeof(us));
	}
	Unlock_File(ufile);
	close(ufile);
}
