/* memcpytest.c - test memcpy() */

#include <stdio.h>
#include <string.h>

#define NALIGN 4
#define NCOUNT 256

size_t count;
char *result;
char s[NCOUNT + NALIGN];
size_t salign;
char t[NCOUNT + NALIGN];
size_t talign;

main()
{
    register size_t i;

    for (count = 0; count < NCOUNT; ++count)
    {
	for (salign = 0; salign < NALIGN; ++salign)
	{
	    for (i = 0; i < sizeof s; ++i)
		s[i] = 2;
	    for (i = salign; i < salign + NCOUNT; ++i)
		s[i] = 1;
	    for (talign = 0; talign < NALIGN; ++talign)
	    {
		for (i = 0; i < sizeof t; ++i)
		    t[i] = 0;
		result = memcpy(t + talign, s + salign, count);
		if (result != t + talign)
		    error("bad result");
		if ((i = memnzero(t, talign)) != 0)
		    error("target undershot", i);
		if ((i = memneq(t + talign, s + salign, count)) != 0)
		    error("target not filled right", i);
		if ((i = memnzero(t + talign + count,
				  sizeof t - talign - count)) != 0)
		    error("target overshot", i);
	    }
	}
    }
}

error(s, i)
char *s;
size_t i;
{
    printf("%s, count = %u, salign = %u, talign = %u, index = %u\n",
	   s, count, salign, talign, i);
    for (i = 0; i < sizeof t; ++i)
	printf("%2u", t[i]);
    printf("\n");
}

memneq(s1, s2, count)
char *s1;
register char *s2;
register size_t count;
{
    register char *rs1;

    rs1 = s1;
    while (count--)
	if (*rs1++ != *s2++)
	    return rs1 - 1 - s1;
    return 0;
}

memnzero(s, count)
char *s;
register size_t count;
{
    register char *rs;

    rs = s;
    while (count--)
	if (*rs++ != 0)
	    return rs - 1 - s;
    return 0;
}
