/*
*   This routine is now a subroutine so it can be used by
*   the answer capability. It can also do more fancy things
*   like fork off the editor if the user needs the editor
*   to type his letter.
*
*   return:   FILE *, pointing to file containing input, or
*      NULL, if error or there was no input
*/

#include <stdio.h>
#include <ctype.h>
#include "mail.h"

extern char *edtmp, line[LSIZE], *strtok (), cclist[LSIZE], resub[80],
  reto[80];
extern char subject[70], *unalias (), *mktemp();
extern int rmail, ttyin, sflag;


extern int Mflag, jjb;

FILE *
readinput (inf, tobuf)
     FILE *inf;
     char *tobuf;
{
   register char *p;
   char buf[128], oldtobuf[TOSIZE], fnbuf[LSIZE], *fname;
   static first = 1;
   FILE *edfp, *nffp;
   long sum;

   if (first)
     {
	first = 0;
	strcpy(edtmp, mktemp (edtmp));
	unlink (edtmp);

     }
   if ((edfp = fopen (edtmp, "w+")) == NULL)
     {
	fprintf (stderr, "Cannot creat temp file\n");
	return NULL;

     }
   if (sflag == 1 && ttyin == 0)
     {
	fputs ("Subject: ", edfp);
	fputs (subject, edfp);
	fputs ("\n", edfp);
	fputs ("\n", edfp);
     }
   if (!rmail && ttyin && resub[0] == '\0')
     {
	printf ("To: %s\n", unalias (tobuf, 0));
	printf ("Subject: ");
	if (sflag == 1)
	  {
	     printf ("%s\n\n", subject);
	     fflush (stdout);
	  }
	else
	   fgets (subject, 68, inf);
	printf ("\n");
	fputs ("Subject: ", edfp);
	fputs (subject, edfp);
	fputs ("\n", edfp);
	fputs ("\n", edfp);
	/* new code starts here */
	if (Mflag)
	  {
	     copylet (jjb, edfp, ORDINARY, ">");
	     copylet (jjb, stdout, ORDINARY, ">");
	     fputs ("\n", edfp);
	     fputs ("\n", stdout);
	  }
	/* new code stops here */
     }
   if (resub[0] != '\0')
     {
	fprintf (edfp, resub);
	fprintf (edfp, reto);

     }
   while ((p = fgets (line, LSIZE, inf)) != NULL)
     {
	if (rmail)
	  {
	     char buf[256];

	     if (strncmp (line, "Return-Receipt-To: ", 19) == NULL)
{
	     sprintf (buf,
		      "echo \"The mail regarding \'%s\' of %s has been received.\"|%s -s \"RSVP to your mail\" \"%s\"&",
		      let[0].subject, let[0].postmark, "/bin/rmail", /* let[0].sender */ line[19]);
	     /* printf("%s\n", buf); */
	     puts (buf);
}
	  }
	if (!rmail && ttyin && (line[0] == '~'))
	  {
	     if (line[1] == '!')
	       {
		  char *cmd;

		  if (line[2] == '\n')
		     cmd = "sh -i";
		  else
		     cmd = &line[2];
		  mysystem (cmd);
		  continue;

	       }
	     else if (line[1] == 'r')
	       {
		  fname = strtok (&line[2], " \t\n");
		  if (!expand (fname, EX_ANY))
		    {
		       fprintf (stderr, "No match\n");
		       continue;

		    }
		  if (!(nffp = fopen (fname, "r")))
		    {
		       fprintf (stderr, "Can't open '%s' for read\n", fname);
		       continue;

		    }
		  while (fgets (fnbuf, LSIZE, nffp) != NULL)
		     fputs (fnbuf, edfp);
		  fclose (nffp);
		  fprintf (stderr, "[continue]\n");
		  continue;

	       }
	     else if (line[1] == 't')
	       {
		  for (p = &line[2]; *p && isspace (*p); ++p)
		     ;
		  if (*p == '\0')
		    {
		       fprintf (stderr, "%s\n", finddest (tobuf, ""));

		    }
		  else
		    {
		       /* Caveat: tobuf must be big enough! */
		       strcpy (oldtobuf, tobuf);
		       strcpy (tobuf, finddest (p, oldtobuf));
		       fprintf (stderr, "%s\n", tobuf);

		    }
		  continue;

	       }
	     else if (line[2] == '\n')
	       {
		  switch (line[1])
		    {

		    case 'v':
		    case 'e':
		       sprintf (buf, "%s %s", (line[1] == 'v') ? "vi" : "ed", edtmp);
		       fprintf (stderr, "%s\n", buf);
		       fclose (edfp);
		       mysystem (buf);
		       if ((edfp = fopen (edtmp, "r+")) == NULL)
			 {
			    fprintf (stderr, "Cannot reopen temp file\n");
			    return NULL;

			 }
		       fseek (edfp, 0L, 2);
		       break;
		    case 'x':
		       fclose (edfp);
		       return NULL;
		    case 'p':
		       fseek (edfp, 0L, 0);
		       while (fgets (line, LSIZE, edfp) != NULL)
			  fputs (line, stdout);
		       fflush (stdout);
		       fseek (edfp, 0L, 2);	/* as per man page on "w+" */
		       break;
		    default:
		       fprintf (stderr, "Type ~? for list of valid commands\n");
		       break;
		    case '?':
		       fprintf (stderr, "~t   print recipients\n");
		       fprintf (stderr, "~t person ...\n\tchange destination list to named persons\n");
		       fprintf (stderr, "~v   vi editor\n");
		       fprintf (stderr, "~e   ed\n");
		       fprintf (stderr, "~r filename\n\tread named file into letter\n");
		       fprintf (stderr, "~p   print letter to current position\n");
		       fprintf (stderr, "~x   exit, no contents\n");
		       fprintf (stderr, "~!cmd   execute shell cmd\n");
		       fprintf (stderr, "~?   this message\n");
		       fflush (stderr);
		       break;

		    }
		  fprintf (stderr, "[continue]\n");
		  continue;

	       }

	  }
	if (line[0] == '.' && line[1] == '\n')
	   break;
	fputs (p, edfp);

     }
   sum = ftell (edfp);
   if (sum)
     {
	if (ttyin)
	  {
	     printf ("Cc: ");
	     fflush (stdout);
	     if (fgets (line, LSIZE, inf) != NULL)
	       {
		  for (p = &line[0]; *p && isspace (*p); ++p)
		     ;
		  if (*p != '\0')
		     strcpy (cclist, p);

	       }


	  }

     }
   else
     {
	fclose (edfp);
	edfp = NULL;

     }
   return edfp;
}
