/* --------------------------------- mac2max.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Dump a macro file into text format. See 'max2mac'.
*/

#include "fly.h"
#include "keyname.h"


/* This is needed since "fly.h" defines it.
*/
struct status	NEAR st = {0};

static int NEAR
getshort (int *i, FILE *f)
{
	int	n;

	n = fgetc (f);
	if (ferror (f) || feof (f))
		return (0);
	n = (n<<8) + fgetc (f);
	if (ferror (f) || feof (f))
		return (1);
	*i = n;
	return (2);
}

static int NEAR
keyname (int key)
{
	int	i;

	for (i = 0; k_name[i].name; ++i) {
		if (k_name[i].value == key) {
			printf ("%s", k_name[i].name);
			return (1);
		}
	}
	return (0);
}

static int NEAR
shiftname (int shift)
{
	int	i;

	for (i = 0; k_name[i].name; ++i) {
		if (k_name[i].value && F(k_name[i].value & K_RAW)
		    && (k_name[i].value & shift) == k_name[i].value) {
			printf ("%s", k_name[i].name);
			return ((int)k_name[i].value);
		}
	}
	return (0);
}

static void NEAR
putkey (int key)
{
	int	i, t;

	if (keyname (key))
		return;

	for (i = key & K_SHIFTS; i && T(t = shiftname (i)); i ^= t)
		printf (" ");
	if (i)
		printf ("SHX%02X ", ((Uint)i)>>8);	/* unknown shift */

	key &= K_RAW;
	if (isprint (key))
		printf ("%c", key);
	else
		printf ("\\%u", key);
}

static void NEAR
listmac (char	*mname)
{
	int	i, j, t, len;
	FILE	*mac;

	mac = fopen (mname, RBMODE);
	if (!mac) {
		printf ("open '%s' failed", mname);
		return;
	}

	for (i = 0;; ++i) {
		if (2 != getshort (&t, mac))
			break;
		if (2 != getshort (&len, mac)) {
			printf ("read '%s' failed (1)", mname);
			goto ret;
		}
		printf ("def ");
		putkey (t);
		printf ("\n");
		for (j = 0; j < len; ++j) {
			if (2 != getshort (&t, mac)) {
				printf ("read '%s' failed (2)", mname);
				goto ret;
			}
			printf ("    ");
			putkey (t);
			printf ("\n");
		}
	}
	if (!feof (mac))
		printf ("read '%s' failed (3)", mname);
ret:
	fclose (mac);
}

int
main (int argc, char *argv[])
{
	char	*mname;

	if (argc < 2 || !(mname = argv[1]))
		mname = "fly.mac";

	listmac (mname);

	exit (0);
	return (0);
}
