# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.postgresqlflexibleservers import PostgreSQLManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPostgreSQLManagementFirewallRulesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PostgreSQLManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_firewall_rules_get(self, resource_group):
        response = self.client.firewall_rules.get(
            resource_group_name=resource_group.name,
            server_name="str",
            firewall_rule_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_firewall_rules_begin_create_or_update(self, resource_group):
        response = self.client.firewall_rules.begin_create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            firewall_rule_name="str",
            parameters={
                "properties": {"endIpAddress": "str", "startIpAddress": "str"},
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_firewall_rules_begin_delete(self, resource_group):
        response = self.client.firewall_rules.begin_delete(
            resource_group_name=resource_group.name,
            server_name="str",
            firewall_rule_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_firewall_rules_list_by_server(self, resource_group):
        response = self.client.firewall_rules.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
