# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ColorMapNames(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Available color maps for data visualization."""

    ACCENT = "accent"
    """Accent colormap - qualitative colormap with distinct colors."""
    ACCENT_R = "accent_r"
    """Reversed accent colormap."""
    AFMHOT = "afmhot"
    """Afmhot colormap - sequential black-red-yellow-white colormap."""
    AFMHOT_R = "afmhot_r"
    """Reversed afmhot colormap."""
    AI4_G_LULC = "ai4g-lulc"
    """AI for Good land use/land cover colormap."""
    ALOS_FNF = "alos-fnf"
    """ALOS forest/non-forest colormap."""
    ALOS_PALSAR_MASK = "alos-palsar-mask"
    """ALOS PALSAR mask colormap."""
    AUTUMN = "autumn"
    """Autumn colormap - sequential red-orange-yellow colormap."""
    AUTUMN_R = "autumn_r"
    """Reversed autumn colormap."""
    BINARY = "binary"
    """Binary colormap - simple black and white colormap."""
    BINARY_R = "binary_r"
    """Reversed binary colormap."""
    BLUES = "blues"
    """Blues colormap - sequential white to dark blue."""
    BLUES_R = "blues_r"
    """Reversed blues colormap."""
    BONE = "bone"
    """Bone colormap - grayscale with slight blue tint."""
    BONE_R = "bone_r"
    """Reversed bone colormap."""
    BRBG = "brbg"
    """BrBG colormap - diverging brown to blue-green."""
    BRBG_R = "brbg_r"
    """Reversed BrBG colormap."""
    BRG = "brg"
    """BrG colormap - diverging brown to green."""
    BRG_R = "brg_r"
    """Reversed BrG colormap."""
    BUGN = "bugn"
    """BuGn colormap - sequential white to dark green."""
    BUGN_R = "bugn_r"
    """Reversed BuGn colormap."""
    BUPU = "bupu"
    """BuPu colormap - sequential white to dark purple."""
    BUPU_R = "bupu_r"
    """Reversed BuPu colormap."""
    BWR = "bwr"
    """BWR colormap - diverging blue to red."""
    BWR_R = "bwr_r"
    """Reversed BWR colormap."""
    C_CAP = "c-cap"
    """C-CAP colormap - land cover classification."""
    CFASTIE = "cfastie"
    """Cfastie colormap - high contrast colormap."""
    CHESAPEAKE_LC13 = "chesapeake-lc-13"
    """Chesapeake land cover 13-class colormap."""
    CHESAPEAKE_LC7 = "chesapeake-lc-7"
    """Chesapeake land cover 7-class colormap."""
    CHESAPEAKE_LU = "chesapeake-lu"
    """Chesapeake land use colormap."""
    CHLORIS_BIOMASS = "chloris-biomass"
    """Chloris biomass colormap."""
    CIVIDIS = "cividis"
    """Cividis colormap - sequential yellow to blue."""
    CIVIDIS_R = "cividis_r"
    """Reversed cividis colormap."""
    CMRMAP = "cmrmap"
    """CMRmap colormap - perceptually uniform colormap."""
    CMRMAP_R = "cmrmap_r"
    """Reversed CMRmap colormap."""
    COOL = "cool"
    """Cool colormap - sequential cyan to magenta."""
    COOL_R = "cool_r"
    """Reversed cool colormap."""
    COOLWARM = "coolwarm"
    """Coolwarm colormap - diverging blue to red."""
    COOLWARM_R = "coolwarm_r"
    """Reversed coolwarm colormap."""
    COPPER = "copper"
    """Copper colormap - sequential black to copper."""
    COPPER_R = "copper_r"
    """Reversed copper colormap."""
    CUBEHELIX = "cubehelix"
    """Cubehelix colormap - sequential black to white with hue rotation."""
    CUBEHELIX_R = "cubehelix_r"
    """Reversed cubehelix colormap."""
    DARK2 = "dark2"
    """Dark2 colormap - qualitative colormap with distinct colors."""
    DARK2_R = "dark2_r"
    """Reversed dark2 colormap."""
    DRCOG_LULC = "drcog-lulc"
    """DRCog land use/land cover colormap."""
    ESA_CCI_LC = "esa-cci-lc"
    """ESA CCI land cover colormap."""
    ESA_WORLDCOVER = "esa-worldcover"
    """ESA WorldCover colormap."""
    FLAG = "flag"
    """Flag colormap - qualitative colormap with distinct colors."""
    FLAG_R = "flag_r"
    """Reversed flag colormap."""
    GAP_LULC = "gap-lulc"
    """GAP land use/land cover colormap."""
    GIST_EARTH = "gist_earth"
    """Gist_earth colormap - perceptually uniform colormap."""
    GIST_EARTH_R = "gist_earth_r"
    """Reversed gist_earth colormap."""
    GIST_GRAY = "gist_gray"
    """Gist_gray colormap - grayscale colormap."""
    GIST_GRAY_R = "gist_gray_r"
    """Reversed gist_gray colormap."""
    GIST_HEAT = "gist_heat"
    """Gist_heat colormap - sequential black-red-yellow-white colormap."""
    GIST_HEAT_R = "gist_heat_r"
    """Reversed gist_heat colormap."""
    GIST_NCAR = "gist_ncar"
    """Gist_ncar colormap - perceptually uniform colormap."""
    GIST_NCAR_R = "gist_ncar_r"
    """Reversed gist_ncar colormap."""
    GIST_RAINBOW = "gist_rainbow"
    """Gist_rainbow colormap - perceptually uniform colormap."""
    GIST_RAINBOW_R = "gist_rainbow_r"
    """Reversed gist_rainbow colormap."""
    GIST_STERN = "gist_stern"
    """Gist_stern colormap - perceptually uniform colormap."""
    GIST_STERN_R = "gist_stern_r"
    """Reversed gist_stern colormap."""
    GIST_YARG = "gist_yarg"
    """Gist_yarg colormap - grayscale colormap."""
    GIST_YARG_R = "gist_yarg_r"
    """Reversed gist_yarg colormap."""
    GNBU = "gnbu"
    """GnBu colormap - sequential white to dark blue-green."""
    GNBU_R = "gnbu_r"
    """Reversed GnBu colormap."""
    GNUPLOT = "gnuplot"
    """Gnuplot colormap - sequential black to white with hue rotation."""
    GNUPLOT2 = "gnuplot2"
    """Gnuplot2 colormap - sequential black to white with hue rotation."""
    GNUPLOT2_R = "gnuplot2_r"
    """Reversed gnuplot2 colormap."""
    GNUPLOT_R = "gnuplot_r"
    """Reversed gnuplot colormap."""
    GRAY = "gray"
    """Gray colormap - grayscale colormap."""
    GRAY_R = "gray_r"
    """Reversed gray colormap."""
    GREENS = "greens"
    """Greens colormap - sequential white to dark green."""
    GREENS_R = "greens_r"
    """Reversed greens colormap."""
    GREYS = "greys"
    """Greys colormap - sequential white to dark gray."""
    GREYS_R = "greys_r"
    """Reversed greys colormap."""
    HOT = "hot"
    """Hot colormap - sequential black-red-yellow-white colormap."""
    HOT_R = "hot_r"
    """Reversed hot colormap."""
    HSV = "hsv"
    """HSV colormap - hue-saturation-value colormap."""
    HSV_R = "hsv_r"
    """Reversed HSV colormap."""
    INFERNO = "inferno"
    """Inferno colormap - sequential black to yellow colormap."""
    INFERNO_R = "inferno_r"
    """Reversed inferno colormap."""
    IO_BII = "io-bii"
    """IO-BII colormap - biodiversity index colormap."""
    IO_LULC = "io-lulc"
    """IO-LULC colormap - land use/land cover colormap."""
    IO_LULC9_CLASS = "io-lulc-9-class"
    """IO-LULC 9-class colormap."""
    JET = "jet"
    """Jet colormap - sequential blue-green-yellow-red colormap."""
    JET_R = "jet_r"
    """Reversed jet colormap."""
    JRC_CHANGE = "jrc-change"
    """JRC change colormap."""
    JRC_EXTENT = "jrc-extent"
    """JRC extent colormap."""
    JRC_OCCURRENCE = "jrc-occurrence"
    """JRC occurrence colormap."""
    JRC_RECURRENCE = "jrc-recurrence"
    """JRC recurrence colormap."""
    JRC_SEASONALITY = "jrc-seasonality"
    """JRC seasonality colormap."""
    JRC_TRANSITIONS = "jrc-transitions"
    """JRC transitions colormap."""
    LIDAR_CLASSIFICATION = "lidar-classification"
    """Lidar classification colormap."""
    LIDAR_HAG = "lidar-hag"
    """Lidar height above ground colormap."""
    LIDAR_HAG_ALTERNATIVE = "lidar-hag-alternative"
    """Alternative lidar height above ground colormap."""
    LIDAR_INTENSITY = "lidar-intensity"
    """Lidar intensity colormap."""
    LIDAR_RETURNS = "lidar-returns"
    """Lidar returns colormap."""
    MAGMA = "magma"
    """Magma colormap - sequential black to yellow colormap."""
    MAGMA_R = "magma_r"
    """Reversed magma colormap."""
    MODIS10_A1 = "modis-10A1"
    """MODIS 10A1 colormap."""
    MODIS10_A2 = "modis-10A2"
    """MODIS 10A2 colormap."""
    MODIS13_A1_Q1 = "modis-13A1|Q1"
    """MODIS 13A1|Q1 colormap."""
    MODIS14_A1_A2 = "modis-14A1|A2"
    """MODIS 14A1|A2 colormap."""
    MODIS15_A2_H_A3_H = "modis-15A2H|A3H"
    """MODIS 15A2H|A3H colormap."""
    MODIS16_A3_GF_ET = "modis-16A3GF-ET"
    """MODIS 16A3GF-ET colormap."""
    MODIS16_A3_GF_PET = "modis-16A3GF-PET"
    """MODIS 16A3GF-PET colormap."""
    MODIS17_A2_H_A2_HGF = "modis-17A2H|A2HGF"
    """MODIS 17A2H|A2HGF colormap."""
    MODIS17_A3_HGF = "modis-17A3HGF"
    """MODIS 17A3HGF colormap."""
    MODIS64_A1 = "modis-64A1"
    """MODIS 64A1 colormap."""
    MTBS_SEVERITY = "mtbs-severity"
    """MTBS severity colormap."""
    NIPY_SPECTRAL = "nipy_spectral"
    """Nipy_spectral colormap - perceptually uniform colormap."""
    NIPY_SPECTRAL_R = "nipy_spectral_r"
    """Reversed nipy_spectral colormap."""
    NRCAN_LULC = "nrcan-lulc"
    """NRCAN land use/land cover colormap."""
    OCEAN = "ocean"
    """Ocean colormap - sequential blue to white colormap."""
    OCEAN_R = "ocean_r"
    """Reversed ocean colormap."""
    ORANGES = "oranges"
    """Oranges colormap - sequential white to dark orange."""
    ORANGES_R = "oranges_r"
    """Reversed oranges colormap."""
    ORRD = "orrd"
    """OrRd colormap - sequential white to dark red-orange."""
    ORRD_R = "orrd_r"
    """Reversed OrRd colormap."""
    PAIRED = "paired"
    """Paired colormap - qualitative colormap with distinct colors."""
    PAIRED_R = "paired_r"
    """Reversed paired colormap."""
    PASTEL1 = "pastel1"
    """Pastel1 colormap - qualitative colormap with pastel colors."""
    PASTEL1_R = "pastel1_r"
    """Reversed pastel1 colormap."""
    PASTEL2 = "pastel2"
    """Pastel2 colormap - qualitative colormap with pastel colors."""
    PASTEL2_R = "pastel2_r"
    """Reversed pastel2 colormap."""
    PINK = "pink"
    """Pink colormap - sequential white to dark pink."""
    PINK_R = "pink_r"
    """Reversed pink colormap."""
    PIYG = "piyg"
    """PiYG colormap - diverging pink to green."""
    PIYG_R = "piyg_r"
    """Reversed PiYG colormap."""
    PLASMA = "plasma"
    """Plasma colormap - sequential black to yellow colormap."""
    PLASMA_R = "plasma_r"
    """Reversed plasma colormap."""
    PRGN = "prgn"
    """PRGn colormap - diverging purple to green."""
    PRGN_R = "prgn_r"
    """Reversed PRGn colormap."""
    PRISM = "prism"
    """Prism colormap - qualitative colormap with distinct colors."""
    PRISM_R = "prism_r"
    """Reversed prism colormap."""
    PUBU = "pubu"
    """PuBu colormap - sequential white to dark blue."""
    PUBU_R = "pubu_r"
    """Reversed PuBu colormap."""
    PUBUGN = "pubugn"
    """PuBuGn colormap - sequential white to dark blue-green."""
    PUBUGN_R = "pubugn_r"
    """Reversed PuBuGn colormap."""
    PUOR = "puor"
    """PuOr colormap - diverging purple to orange."""
    PUOR_R = "puor_r"
    """Reversed PuOr colormap."""
    PURD = "purd"
    """PuRd colormap - sequential white to dark purple-red."""
    PURD_R = "purd_r"
    """Reversed PuRd colormap."""
    PURPLES = "purples"
    """Purples colormap - sequential white to dark purple."""
    PURPLES_R = "purples_r"
    """Reversed purples colormap."""
    QPE = "qpe"
    """QPE colormap - qualitative colormap with distinct colors."""
    RAINBOW = "rainbow"
    """Rainbow colormap - qualitative colormap with distinct colors."""
    RAINBOW_R = "rainbow_r"
    """Reversed rainbow colormap."""
    RDBU = "rdbu"
    """RdBu colormap - diverging red to blue."""
    RDBU_R = "rdbu_r"
    """Reversed RdBu colormap."""
    RDGY = "rdgy"
    """RdGy colormap - diverging red to gray."""
    RDGY_R = "rdgy_r"
    """Reversed RdGy colormap."""
    RDPU = "rdpu"
    """RdPu colormap - sequential white to dark red-purple."""
    RDPU_R = "rdpu_r"
    """Reversed RdPu colormap."""
    RDYLBU = "rdylbu"
    """RdYlBu colormap - diverging red to yellow to blue."""
    RDYLBU_R = "rdylbu_r"
    """Reversed RdYlBu colormap."""
    RDYLGN = "rdylgn"
    """RdYlGn colormap - diverging red to yellow to green."""
    RDYLGN_R = "rdylgn_r"
    """Reversed RdYlGn colormap."""
    REDS = "reds"
    """Reds colormap - sequential white to dark red."""
    REDS_R = "reds_r"
    """Reversed reds colormap."""
    RPLUMBO = "rplumbo"
    """Rplumbo colormap - qualitative colormap with distinct colors."""
    SCHWARZWALD = "schwarzwald"
    """Schwarzwald colormap - qualitative colormap with distinct colors."""
    SEISMIC = "seismic"
    """Seismic colormap - diverging blue to red."""
    SEISMIC_R = "seismic_r"
    """Reversed seismic colormap."""
    SET1 = "set1"
    """Set1 colormap - qualitative colormap with distinct colors."""
    SET1_R = "set1_r"
    """Reversed set1 colormap."""
    SET2 = "set2"
    """Set2 colormap - qualitative colormap with distinct colors."""
    SET2_R = "set2_r"
    """Reversed set2 colormap."""
    SET3 = "set3"
    """Set3 colormap - qualitative colormap with distinct colors."""
    SET3_R = "set3_r"
    """Reversed set3 colormap."""
    SPECTRAL = "spectral"
    """Spectral colormap - diverging red to yellow to blue."""
    SPECTRAL_R = "spectral_r"
    """Reversed spectral colormap."""
    SPRING = "spring"
    """Spring colormap - sequential magenta to yellow."""
    SPRING_R = "spring_r"
    """Reversed spring colormap."""
    SUMMER = "summer"
    """Summer colormap - sequential green to yellow."""
    SUMMER_R = "summer_r"
    """Reversed summer colormap."""
    TAB10 = "tab10"
    """Tab10 colormap - qualitative colormap with distinct colors."""
    TAB10_R = "tab10_r"
    """Reversed tab10 colormap."""
    TAB20 = "tab20"
    """Tab20 colormap - qualitative colormap with distinct colors."""
    TAB20_R = "tab20_r"
    """Reversed tab20 colormap."""
    TAB20_B = "tab20b"
    """Tab20b colormap - qualitative colormap with distinct colors."""
    TAB20_B_R = "tab20b_r"
    """Reversed tab20b colormap."""
    TAB20_C = "tab20c"
    """Tab20c colormap - qualitative colormap with distinct colors."""
    TAB20_C_R = "tab20c_r"
    """Reversed tab20c colormap."""
    TERRAIN = "terrain"
    """Terrain colormap - sequential black to white with hue rotation."""
    TERRAIN_R = "terrain_r"
    """Reversed terrain colormap."""
    TWILIGHT = "twilight"
    """Twilight colormap - diverging blue to red."""
    TWILIGHT_R = "twilight_r"
    """Reversed twilight colormap."""
    TWILIGHT_SHIFTED = "twilight_shifted"
    """Twilight shifted colormap - diverging blue to red."""
    TWILIGHT_SHIFTED_R = "twilight_shifted_r"
    """Reversed twilight shifted colormap."""
    USDA_CDL = "usda-cdl"
    """USDA CDL colormap - land cover classification."""
    USDA_CDL_CORN = "usda-cdl-corn"
    """USDA CDL corn colormap."""
    USDA_CDL_COTTON = "usda-cdl-cotton"
    """USDA CDL cotton colormap."""
    USDA_CDL_SOYBEANS = "usda-cdl-soybeans"
    """USDA CDL soybeans colormap."""
    USDA_CDL_WHEAT = "usda-cdl-wheat"
    """USDA CDL wheat colormap."""
    USGS_LCMAP = "usgs-lcmap"
    """USGS LCMAP colormap."""
    VIIRS10_A1 = "viirs-10a1"
    """VIIRS 10A1 colormap."""
    VIIRS13_A1 = "viirs-13a1"
    """VIIRS 13A1 colormap."""
    VIIRS14_A1 = "viirs-14a1"
    """VIIRS 14A1 colormap."""
    VIIRS15_A2_H = "viirs-15a2H"
    """VIIRS 15A2H colormap."""
    VIRIDIS = "viridis"
    """Viridis colormap - sequential black to yellow colormap."""
    VIRIDIS_R = "viridis_r"
    """Reversed viridis colormap."""
    WINTER = "winter"
    """Winter colormap - sequential blue to green."""
    WINTER_R = "winter_r"
    """Reversed winter colormap."""
    WISTIA = "wistia"
    """Wistia colormap - sequential white to yellow."""
    WISTIA_R = "wistia_r"
    """Reversed wistia colormap."""
    YLGN = "ylgn"
    """YlGn colormap - sequential white to dark green."""
    YLGN_R = "ylgn_r"
    """Reversed YlGn colormap."""
    YLGNBU = "ylgnbu"
    """YlGnBu colormap - sequential white to dark blue-green."""
    YLGNBU_R = "ylgnbu_r"
    """Reversed YlGnBu colormap."""
    YLORBR = "ylorbr"
    """YlOrBr colormap - sequential white to dark orange-brown."""
    YLORBR_R = "ylorbr_r"
    """Reversed YlOrBr colormap."""
    YLORRD = "ylorrd"
    """YlOrRd colormap - sequential white to dark red-orange."""
    YLORRD_R = "ylorrd_r"
    """Reversed YlOrRd colormap."""


class FeatureType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type identifier for GeoJSON Feature objects."""

    FEATURE = "Feature"
    """Standard GeoJSON Feature type identifier."""


class FilterLanguage(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Choices for filter-lang value in a POST request.

    Based on
    `https://github.com/stac-api-extensions/filter#queryables
    <https://github.com/stac-api-extensions/filter#queryables>`_

    Note the addition of cql2-json, which is used by the pgstac backend,
    but is not included in the spec above.

    Defines the supported filter languages for STAC API queries.
    """

    CQL_JSON = "cql-json"
    """Common Query Language in JSON format."""
    CQL2_JSON = "cql2-json"
    """Common Query Language 2 in JSON format."""
    CQL2_TEXT = "cql2-text"
    """Common Query Language 2 in text format."""


class GeometryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represents the type of a GeoJSON geometry."""

    POINT = "Point"
    """Represents a Point geometry."""
    LINE_STRING = "LineString"
    """Represents a LineString geometry."""
    POLYGON = "Polygon"
    """Represents a Polygon geometry."""
    MULTI_POINT = "MultiPoint"
    """Represents a MultiPoint geometry."""
    MULTI_LINE_STRING = "MultiLineString"
    """Represents a MultiLineString geometry."""
    MULTI_POLYGON = "MultiPolygon"
    """Represents a MultiPolygon geometry."""


class IngestionSourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Ingestion source type."""

    SHARED_ACCESS_SIGNATURE_TOKEN = "SasToken"
    """Azure Blob Storage SAS token."""
    BLOB_MANAGED_IDENTITY = "BlobManagedIdentity"
    """Azure Blob Managed Identity."""


class IngestionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Ingestion status."""

    READY = "Ready"
    """Ingestion accepted and ready to be run."""
    DELETING = "Deleting"
    """Ingestion is being deleting in the background."""


class IngestionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Ingestion type."""

    STATIC_CATALOG = "StaticCatalog"
    """Static STAC Catalog."""


class LegendConfigType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Legend type to make, one of: ``continuous``, ``classmap``, ``interval`` or ``none`` (note,
    ``none`` is a string literal).
    """

    CONTINUOUS = "continuous"
    """Continuous color ramp legend."""
    CLASSMAP = "classmap"
    """Classified map with discrete colors for classes."""
    INTERVAL = "interval"
    """Interval-based legend with discrete ranges."""
    NONE = "none"
    """No legend."""


class MosaicMetadataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of metadata resource in the system."""

    MOSAIC = "mosaic"
    """Metadata for a mosaic of multiple raster assets."""
    SEARCH = "search"
    """Metadata for a search query result."""


class NoDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NoDataType."""

    ALPHA = "Alpha"
    """Nodata represented by alpha channel."""
    MASK = "Mask"
    """Nodata represented by a mask."""
    INTERNAL = "Internal"
    """Nodata represented internally in the dataset."""
    NODATA = "Nodata"
    """Explicit nodata value defined in the dataset."""
    NONE = "None"
    """No nodata value defined."""


class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operation status."""

    PENDING = "Pending"
    """Operation accepted and ready to be run."""
    RUNNING = "Running"
    """Operation is running."""
    SUCCEEDED = "Succeeded"
    """Operation has already finished its execution."""
    CANCELED = "Canceled"
    """Operation canceled by the user."""
    CANCELING = "Canceling"
    """Operation is being canceling."""
    FAILED = "Failed"
    """Operation failed."""


class PartitionTypeScheme(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines partitioning schemes for temporal data organization."""

    YEAR = "year"
    """Partition data by year."""
    MONTH = "month"
    """Partition data by month."""
    NONE = "none"
    """No partitioning."""


class PixelSelection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Identifier selecting one of the TileMatrixSetId supported (default:
    'WebMercatorQuad')

    Represents the method used to select or compute pixels when creating
    composites from multiple sources.
    """

    FIRST = "first"
    """Select pixel from the first available image."""
    HIGHEST = "highest"
    """Select pixel with the highest value."""
    LOWEST = "lowest"
    """Select pixel with the lowest value."""
    MEAN = "mean"
    """Calculate mean of available pixels."""
    MEDIAN = "median"
    """Calculate median of available pixels."""
    STANDARD_DEVIATION = "stdev"
    """Calculate standard deviation of available pixels."""
    LAST_BAND_LOW = "lastbandlow"
    """Select image with lowest value in the last band."""
    LAST_BAND_HIGH = "lastbandhigh"
    """Select image with highest value in the last band."""


class RenderOptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the types of render options for map visualization."""

    RASTER_TILE = "raster-tile"
    """Raster tile rendering type."""
    VT_POLYGON = "vt-polygon"
    """Vector tile polygon rendering type."""
    VT_LINE = "vt-line"
    """Vector tile line rendering type."""


class Resampling(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resampling algorithm to use when reading source raster data at different resolutions."""

    NEAREST = "nearest"
    """Nearest neighbor - fastest method that selects the closest pixel value."""
    BILINEAR = "bilinear"
    """Bilinear interpolation - calculates output values using a weighted average of 2x2 input cells."""
    CUBIC = "cubic"
    """Cubic interpolation - uses a weighted average of 4x4 input cells for smoother results."""
    CUBIC_SPLINE = "cubic_spline"
    """Cubic spline interpolation - similar to cubic but preserves edges better."""
    LANCZOS = "lanczos"
    """Lanczos windowed sinc resampling - high-quality with minimal artifacts."""
    AVERAGE = "average"
    """Average resampling - calculates the mean of all contributing pixels."""
    MODE = "mode"
    """Mode resampling - selects the most common value from contributing pixels."""
    GAUSS = "gauss"
    """Gaussian weighted resampling - applies a gaussian weighting to contributing pixels."""
    RMS = "rms"
    """Root mean square resampling - useful for resampling error or deviation grids."""


class StacAssetUrlSigningMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Represent the signature type for asset URLs."""

    TRUE = "true"
    """Sign asset URLs in the response."""
    FALSE = "false"
    """Do not sign asset URLs in the response."""


class StacLinkType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MIME types for links."""

    IMAGE_TIFF_APPLICATION_GEOTIFF = "image/tiff; application=geotiff"
    """Represents an image/tiff with application=geotiff."""
    IMAGE_JP2 = "image/jp2"
    """Represents an image/jp2."""
    IMAGE_PNG = "image/png"
    """Represents an image/png."""
    IMAGE_JPEG = "image/jpeg"
    """Represents an image/jpeg."""
    IMAGE_JPG = "image/jpg"
    """Represents an image/jpg."""
    IMAGE_WEBP = "image/webp"
    """Represents an image/webp."""
    APPLICATION_X_BINARY = "application/x-binary"
    """Represents an application/x-binary."""
    APPLICATION_XML = "application/xml"
    """Represents an application/xml."""
    APPLICATION_JSON = "application/json"
    """Represents an application/json."""
    APPLICATION_GEO_JSON = "application/geo+json"
    """Represents an application/geo+json."""
    TEXT_HTML = "text/html"
    """Represents a text/html."""
    TEXT_PLAIN = "text/plain"
    """Represents a text/plain."""
    APPLICATION_X_PROTOBUF = "application/x-protobuf"
    """Represents an application/x-protobuf."""


class StacModelType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum discriminator for STAC item and collection types."""

    FEATURE = "Feature"
    """GeoJSON Feature type."""
    FEATURE_COLLECTION = "FeatureCollection"
    """GeoJSON FeatureCollection type."""


class StacQueryableDefinitionDataType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Queryable data types for the queryables extension. These are the data types supported by Basic
    CQL2.
    """

    STRING = "string"
    """Character strings. Example: 'This is a literal string.'."""
    NUMBER = "number"
    """Numbers including integers and floating point values. Examples: -100, 3.14159."""
    BOOLEAN = "boolean"
    """Booleans. Examples: true, false."""
    TIMESTAMP = "timestamp"
    """An instant with a granularity of a second or smaller. Example (JSON): { "timestamp":
    "1969-07-20T20:17:40Z" }."""
    DATE = "date"
    """An instant with a granularity of a day. Example (JSON): { "date": "1969-07-20" }."""


class StacSearchSortingDirection(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Defines the sorting directions for query results in STAC API."""

    ASC = "asc"
    """Sort results in ascending order."""
    DESC = "desc"
    """Sort results in descending order."""


class TerrainAlgorithm(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Supported algorithms for terrain and index-based analysis."""

    HILLSHADE = "hillshade"
    """Creates hillshade visualization from elevation data."""
    CONTOURS = "contours"
    """Generates elevation contour lines."""
    NORMALIZED_INDEX = "normalizedIndex"
    """Calculates normalized difference index between bands."""
    TERRARIUM = "terrarium"
    """Encodes elevation data in Mapbox Terrarium RGB format."""
    TERRAINRGB = "terrainrgb"
    """Encodes elevation data in Mapbox TerrainRGB format."""


class TileAddressingScheme(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scheme for tile addressing in TileJSON specification."""

    XYZ = "xyz"
    """XYZ tile addressing scheme with origin at top-left."""
    TMS = "tms"
    """TMS tile addressing scheme with origin at bottom-left."""


class TileMatrixCornerOfOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The corner of the tile matrix (*topLeft* or *bottomLeft*) used as the origin for numbering tile
    rows and columns. This corner is also a corner of the (0, 0) tile.
    """

    TOP_LEFT = "topLeft"
    """Origin at the top-left corner (Y increases downward)."""
    BOTTOM_LEFT = "bottomLeft"
    """Origin at the bottom-left corner (Y increases upward)."""


class TilerImageFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Image format specifier for tile and image requests."""

    PNG = "png"
    """Portable Network Graphics format - supports transparency."""
    NPY = "npy"
    """NumPy array format for raw data access."""
    TIF = "tif"
    """GeoTIFF format for georeferenced raster data."""
    JPEG = "jpeg"
    """JPEG format - smaller file size but lossy compression."""
    JPG = "jpg"
    """Alternate extension for JPEG format."""
    JP2 = "jp2"
    """JPEG 2000 format - supports both lossy and lossless compression."""
    WEBP = "webp"
    """WebP format - modern image format with good compression."""
    PNGRAW = "pngraw"
    """Raw PNG format for access to unprocessed data."""
