# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.agricultureplatform import AgriculturePlatformMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-agricultureplatform
# USAGE
    python agri_service_create_or_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = AgriculturePlatformMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.agri_service.begin_create_or_update(
        resource_group_name="rgopenapi",
        agri_service_resource_name="abc123",
        resource={
            "identity": {"type": "None", "userAssignedIdentities": {"key4955": {}}},
            "location": "pkneuknooprpqirnugzwbkiie",
            "properties": {
                "config": {},
                "dataConnectorCredentials": [
                    {
                        "key": "BackendAADApplicationCredentials",
                        "value": {"clientId": "dce298a8-1eec-481a-a8f9-a3cd5a8257b2"},
                    }
                ],
                "installedSolutions": [
                    {"key": "bayerAgPowered.cwum", "value": {"applicationName": "bayerAgPowered.cwum"}}
                ],
                "managedOnBehalfOfConfiguration": {},
            },
            "sku": {
                "capacity": 20,
                "family": "xerdhxyjwrypvxphavgrtjphtohf",
                "name": "kfl",
                "size": "r",
                "tier": "Free",
            },
            "tags": {"key137": "oxwansfetzzgdwl"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2024-06-01-preview/AgriService_CreateOrUpdate_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
