/* Getpass.c */

#define	PASSWD_LEN	127

#include "sys.h"
#include <stdio.h>
#include <signal.h>

#include "cmds.h"
#include "getpass.h"
#include "copyright.h"

#ifndef GETPASS

#ifndef NO_UNISTDH
#	include <unistd.h>
#endif

#ifdef BSD
#	include <sys/ioctl.h>
#endif

#ifdef TERMIOS
#		include <termios.h>
#else
#	ifdef SGTTYB
#		include <sgtty.h>
#	else
#		include <termio.h>
#	endif
#endif /* !TERMIOS */

int ioctl(int, int, ...);

#endif	/* GETPASS */




void echo(FILE *fp, int on)
{
#ifndef GETPASS		/* Otherwise just do nothing which is ok. */

#ifdef TERMIOS
	static struct termios orig, noecho, *tp;
#else
#	ifdef SGTTYB
	static struct sgttyb orig, noecho, *tp;
#	else
	static struct termio orig, noecho, *tp;
#	endif
#endif
	static int state = 0;
	int fd = fileno(fp);

	if (state == 0) {
#ifdef TERMIOS
		if (tcgetattr(fd, &orig) < 0)
			Perror("tcgetattr");
		noecho = orig;
		noecho.c_lflag &= ~ECHO;
#else
#	ifdef SGTTYB
		if (ioctl(fd, TIOCGETP, &orig) < 0)
			Perror("ioctl");
		noecho = orig;
		noecho.sg_flags &= ~ECHO;
#	else
		if (ioctl(fd, TCGETA, &orig) < 0)
			Perror("ioctl");
		noecho = orig;
		noecho.c_lflag &= ~ECHO;
#	endif
#endif
		state = 1;
	}
	tp = NULL;
	if (on && state == 2) {
		/* Turn echo back on. */
		tp = &orig;
		state = 1;
	} else if (!on && state == 1) {
		/* Turn echo off. */
		tp = &noecho;
		state = 2;
	}
	if (tp != NULL) {
#ifdef TERMIOS
		if (tcsetattr(fd, TCSAFLUSH, tp) < 0)
			Perror("tcsetattr");
#else
#	ifdef SGTTYB
		if (ioctl(fd, TIOCSETP, tp) < 0)
			Perror("ioctl");
#	else
		if (ioctl(fd, TCSETA, tp) < 0)
			Perror("ioctl");
#	endif
#endif	/* !TERMIOS */
	}

#endif	/* GETPASS */
}	/* echo */



#ifndef GETPASS

char *Getpass(char *promptstr)
{
	register int ch;
	register char *p;
	FILE *fp, *outfp;
	void (*oldintr)(int);
	static char buf[PASSWD_LEN + 1];

	/*
	 * read and write to /dev/tty if possible; else read from
	 * stdin and write to stderr.
	 */
	if ((outfp = fp = fopen("/dev/tty", "w+")) == NULL) {
		outfp = stderr;
		fp = stdin;
	}
	oldintr = signal(SIGINT, SIG_IGN);
	echo(fp, 0);		/* Turn echoing off. */
	(void) fputs(promptstr, outfp);
	(void) rewind(outfp);			/* implied flush */
	for (p = buf; (ch = getc(fp)) != EOF && ch != '\n';)
	  if (p < buf + PASSWD_LEN)
	    *p++ = ch;
			
	*p = '\0';
	(void)write(fileno(outfp), "\n", 1);
	echo(fp, 1);
	(void) signal(SIGINT, oldintr);
	if (fp != stdin)
		(void)fclose(fp);

	return(buf);
}	/* Getpass */

#endif /* GETPASS */

/* eof Getpass.c */
