/*-
 * Copyright (c) 2007 Warner Losh
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/7/contrib/bind9/lib/isc/arm/include/isc/atomic.h 174398 2007-12-07 08:31:23Z dougb $
 */

#ifndef ISC_ATOMIC_H
#define ISC_ATOMIC_H 1

#include <isc/platform.h>
#include <isc/types.h>
#include <machine/atomic.h>

#ifdef __FreeBSD__
static inline isc_int32_t
isc_atomic_xadd(isc_int32_t *p, isc_int32_t val)
{
	return atomic_fetchadd_int(p, val);
}

static inline void
isc_atomic_store(isc_int32_t *p, isc_int32_t val)
{
	atomic_store_rel_int(p, val);
}

static inline isc_int32_t
isc_atomic_cmpxchg(isc_int32_t *p, isc_int32_t cmpval, isc_int32_t val)
{
	register int done, ras_start;

	__asm __volatile("1:\n"
	    "adr	%1, 1b\n"
	    "mov	%0, #0xe0000004\n"
	    "str	%1, [%0]\n"
	    "mov	%0, #0xe0000008\n"
	    "adr	%1, 2f\n"
	    "str	%1, [%0]\n"
	    "ldr	%1, [%2]\n"
	    "cmp	%1, %3\n"
	    "streq	%4, [%2]\n"
	    "2:\n"
	    "mov	%3, #0\n"
	    "mov	%0, #0xe0000004\n"
	    "str	%3, [%0]\n"
	    "mov	%3, #0xffffffff\n"
	    "mov	%0, #0xe0000008\n"
	    "str	%3, [%0]\n"
	    : "=r" (ras_start), "=r" (done)
	    ,"+r" (p), "+r" (cmpval), "+r" (val) : : "memory");
	return (done);

}
#else /* !FreeBSD */

#error "unsupported compiler.  disable atomic ops by --disable-atomic"

#endif
#endif /* ISC_ATOMIC_H */
