
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Report.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Attribute.hxx>
#include <Message_Report.hxx>
#include <Message_CompositeAlerts.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Messenger.hxx>
#include <TColStd_HPackedMapOfInteger.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_AlertExtended.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_AsciiString.hxx>
#include <TCollection_ExtendedString.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <TCollection_ExtendedString.hxx>
#include <TCollection_AsciiString.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_Report.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_CompositeAlerts.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Message.hxx>
#include <Message_Alert.hxx>
#include <Message_AlertExtended.hxx>
#include <Message_Algorithm.hxx>
#include <Message_Attribute.hxx>
#include <Message_AttributeMeter.hxx>
#include <Message_AttributeObject.hxx>
#include <Message_AttributeStream.hxx>
#include <Message_CompositeAlerts.hxx>
#include <Message_ConsoleColor.hxx>
#include <Message_ExecStatus.hxx>
#include <Message_Gravity.hxx>
#include <Message_HArrayOfMsg.hxx>
#include <Message_LazyProgressScope.hxx>
#include <Message_Level.hxx>
#include <Message_ListIteratorOfListOfMsg.hxx>
#include <Message_ListOfAlert.hxx>
#include <Message_ListOfMsg.hxx>
#include <Message_Messenger.hxx>
#include <Message_MetricType.hxx>
#include <Message_Msg.hxx>
#include <Message_MsgFile.hxx>
#include <Message_Printer.hxx>
#include <Message_PrinterOStream.hxx>
#include <Message_PrinterSystemLog.hxx>
#include <Message_PrinterToReport.hxx>
#include <Message_ProgressIndicator.hxx>
#include <Message_ProgressRange.hxx>
#include <Message_ProgressScope.hxx>
#include <Message_ProgressSentry.hxx>
#include <Message_Report.hxx>
#include <Message_SequenceOfPrinters.hxx>
#include <Message_Status.hxx>
#include <Message_StatusType.hxx>

// template related includes

// ./opencascade/Message_HArrayOfMsg.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Message_ListOfAlert.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Message_ListOfMsg.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Message_ListOfMsg.hxx
#include "NCollection_tmpl.hxx"

// ./opencascade/Message_SequenceOfPrinters.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Message(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Message"));
py::object klass;

//Python trampoline classes
    class Py_Message_Printer : public Message_Printer{
    public:
        using Message_Printer::Message_Printer;


        // public pure virtual


        // protected pure virtual
        void send(const TCollection_AsciiString & theString,const Message_Gravity theGravity) const  override { PYBIND11_OVERLOAD_PURE(void,Message_Printer,send,theString,theGravity) };


        // private pure virtual

    };
    class Py_Message_ProgressIndicator : public Message_ProgressIndicator{
    public:
        using Message_ProgressIndicator::Message_ProgressIndicator;


        // public pure virtual


        // protected pure virtual
        void Show(const Message_ProgressScope & theScope,const Standard_Boolean isForce) override { PYBIND11_OVERLOAD_PURE(void,Message_ProgressIndicator,Show,theScope,isForce) };


        // private pure virtual

    };

// classes

    // Class Message from ./opencascade/Message.hxx
    klass = m.attr("Message");

    // default constructor
    register_default_constructor<Message , shared_ptr<Message>>(m,"Message");

    // nested enums

    static_cast<py::class_<Message , shared_ptr<Message>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DefaultMessenger_s",
                    (const opencascade::handle<Message_Messenger> & (*)() ) static_cast<const opencascade::handle<Message_Messenger> & (*)() >(&Message::DefaultMessenger),
                    R"#(Defines default messenger for OCCT applications. This is global static instance of the messenger. By default, it contains single printer directed to std::cout. It can be customized according to the application needs.)#" 
          )
        .def_static("Send_s",
                    (Message_Messenger::StreamBuffer (*)( Message_Gravity  ) ) static_cast<Message_Messenger::StreamBuffer (*)( Message_Gravity  ) >(&Message::Send),
                    R"#()#"  , py::arg("theGravity")
          )
        .def_static("Send_s",
                    (void (*)( const TCollection_AsciiString & ,  Message_Gravity  ) ) static_cast<void (*)( const TCollection_AsciiString & ,  Message_Gravity  ) >(&Message::Send),
                    R"#(None)#"  , py::arg("theMessage"),  py::arg("theGravity")
          )
        .def_static("SendFail_s",
                    (Message_Messenger::StreamBuffer (*)() ) static_cast<Message_Messenger::StreamBuffer (*)() >(&Message::SendFail),
                    R"#(None)#" 
          )
        .def_static("SendAlarm_s",
                    (Message_Messenger::StreamBuffer (*)() ) static_cast<Message_Messenger::StreamBuffer (*)() >(&Message::SendAlarm),
                    R"#(None)#" 
          )
        .def_static("SendWarning_s",
                    (Message_Messenger::StreamBuffer (*)() ) static_cast<Message_Messenger::StreamBuffer (*)() >(&Message::SendWarning),
                    R"#(None)#" 
          )
        .def_static("SendInfo_s",
                    (Message_Messenger::StreamBuffer (*)() ) static_cast<Message_Messenger::StreamBuffer (*)() >(&Message::SendInfo),
                    R"#(None)#" 
          )
        .def_static("SendTrace_s",
                    (Message_Messenger::StreamBuffer (*)() ) static_cast<Message_Messenger::StreamBuffer (*)() >(&Message::SendTrace),
                    R"#(None)#" 
          )
        .def_static("SendFail_s",
                    (void (*)( const TCollection_AsciiString &  ) ) static_cast<void (*)( const TCollection_AsciiString &  ) >(&Message::SendFail),
                    R"#(None)#"  , py::arg("theMessage")
          )
        .def_static("SendAlarm_s",
                    (void (*)( const TCollection_AsciiString &  ) ) static_cast<void (*)( const TCollection_AsciiString &  ) >(&Message::SendAlarm),
                    R"#(None)#"  , py::arg("theMessage")
          )
        .def_static("SendWarning_s",
                    (void (*)( const TCollection_AsciiString &  ) ) static_cast<void (*)( const TCollection_AsciiString &  ) >(&Message::SendWarning),
                    R"#(None)#"  , py::arg("theMessage")
          )
        .def_static("SendInfo_s",
                    (void (*)( const TCollection_AsciiString &  ) ) static_cast<void (*)( const TCollection_AsciiString &  ) >(&Message::SendInfo),
                    R"#(None)#"  , py::arg("theMessage")
          )
        .def_static("SendTrace_s",
                    (void (*)( const TCollection_AsciiString &  ) ) static_cast<void (*)( const TCollection_AsciiString &  ) >(&Message::SendTrace),
                    R"#(None)#"  , py::arg("theMessage")
          )
        .def_static("FillTime_s",
                    (TCollection_AsciiString (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Real  ) ) static_cast<TCollection_AsciiString (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Real  ) >(&Message::FillTime),
                    R"#(Returns the string filled with values of hours, minutes and seconds. Example: 1. (5, 12, 26.3345) returns "05h:12m:26.33s", 2. (0, 6, 34.496 ) returns "06m:34.50s", 3. (0, 0, 4.5 ) returns "4.50s")#"  , py::arg("Hour"),  py::arg("Minute"),  py::arg("Second")
          )
        .def_static("DefaultReport_s",
                    (const opencascade::handle<Message_Report> & (*)( const Standard_Boolean  ) ) static_cast<const opencascade::handle<Message_Report> & (*)( const Standard_Boolean  ) >(&Message::DefaultReport),
                    R"#(returns the only one instance of Report When theToCreate is true - automatically creates message report when not exist.)#"  , py::arg("theToCreate")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def_static("MetricFromString_s",
                    (Standard_Boolean (*)( const Standard_CString ,  Message_MetricType &  ) ) static_cast<Standard_Boolean (*)( const Standard_CString ,  Message_MetricType &  ) >(&Message::MetricFromString),
                    R"#(Determines the metric from the given string identifier.)#"  , py::arg("theString"),  py::arg("theType")
          )
        .def_static("MetricToString_s",
                    (Standard_CString (*)( const Message_MetricType  ) ) static_cast<Standard_CString (*)( const Message_MetricType  ) >(&Message::MetricToString),
                    R"#(Returns the string name for a given metric type.)#"  , py::arg("theType")
          )
        .def_static("MetricFromString_s",
                    (Message_MetricType (*)( const Standard_CString  ) ) static_cast<Message_MetricType (*)( const Standard_CString  ) >(&Message::MetricFromString),
                    R"#(Returns the metric type from the given string identifier.)#"  , py::arg("theString")
          )
        .def_static("ToOSDMetric_s",
                    (Standard_Boolean (*)( const Message_MetricType ,  OSD_MemInfo::Counter &  ) ) static_cast<Standard_Boolean (*)( const Message_MetricType ,  OSD_MemInfo::Counter &  ) >(&Message::ToOSDMetric),
                    R"#(Converts message metric to OSD memory info type.)#"  , py::arg("theMetric"),  py::arg("theMemInfo")
          )
        .def_static("ToMessageMetric_s",
                    (Standard_Boolean (*)( const OSD_MemInfo::Counter ,  Message_MetricType &  ) ) static_cast<Standard_Boolean (*)( const OSD_MemInfo::Counter ,  Message_MetricType &  ) >(&Message::ToMessageMetric),
                    R"#(Converts OSD memory info type to message metric.)#"  , py::arg("theMemInfo"),  py::arg("theMetric")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Message_Alert from ./opencascade/Message_Alert.hxx
    klass = m.attr("Message_Alert");

    // default constructor
    register_default_constructor<Message_Alert ,opencascade::handle<Message_Alert>>(m,"Message_Alert");

    // nested enums

    static_cast<py::class_<Message_Alert ,opencascade::handle<Message_Alert>  , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GetMessageKey",
             (Standard_CString (Message_Alert::*)() const) static_cast<Standard_CString (Message_Alert::*)() const>(&Message_Alert::GetMessageKey),
             R"#(Return a C string to be used as a key for generating text user messages describing this alert. The messages are generated with help of Message_Msg class, in Message_Report::Dump(). Base implementation returns dynamic type name of the instance.)#" 
          )
        .def("SupportsMerge",
             (Standard_Boolean (Message_Alert::*)() const) static_cast<Standard_Boolean (Message_Alert::*)() const>(&Message_Alert::SupportsMerge),
             R"#(Return true if this type of alert can be merged with other of the same type to avoid duplication. Basis implementation returns true.)#" 
          )
        .def("Merge",
             (Standard_Boolean (Message_Alert::*)( const opencascade::handle<Message_Alert> &  ) ) static_cast<Standard_Boolean (Message_Alert::*)( const opencascade::handle<Message_Alert> &  ) >(&Message_Alert::Merge),
             R"#(If possible, merge data contained in this alert to theTarget.)#"  , py::arg("theTarget")
          )
        .def("DumpJson",
             (void (Message_Alert::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_Alert::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_Alert::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_Alert::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_Alert::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_Alert::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_Alert::*)() const>(&Message_Alert::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_Algorithm from ./opencascade/Message_Algorithm.hxx
    klass = m.attr("Message_Algorithm");


    // nested enums

    static_cast<py::class_<Message_Algorithm ,opencascade::handle<Message_Algorithm>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status &  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status &  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with no parameter)#"  , py::arg("theStat")
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const Standard_Integer  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const Standard_Integer  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with integer parameter)#"  , py::arg("theStat"),  py::arg("theInt")
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const Standard_CString ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const Standard_CString ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter. If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_AsciiString & ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_AsciiString & ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const opencascade::handle<TCollection_HExtendedString> & ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const opencascade::handle<TCollection_HExtendedString> & ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")=static_cast<const Standard_Boolean>(Standard_True)
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const Message_Msg &  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const Message_Msg &  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with preformatted message. This message will be used directly to report the status; automatic generation of status messages will be disabled for it.)#"  , py::arg("theStat"),  py::arg("theMsg")
          )
        .def("ClearStatus",
             (void (Message_Algorithm::*)() ) static_cast<void (Message_Algorithm::*)() >(&Message_Algorithm::ClearStatus),
             R"#(Clear exec status of algorithm)#" 
          )
        .def("SetMessenger",
             (void (Message_Algorithm::*)( const opencascade::handle<Message_Messenger> &  ) ) static_cast<void (Message_Algorithm::*)( const opencascade::handle<Message_Messenger> &  ) >(&Message_Algorithm::SetMessenger),
             R"#(Sets messenger to algorithm)#"  , py::arg("theMsgr")
          )
        .def("GetMessenger",
             (opencascade::handle<Message_Messenger> (Message_Algorithm::*)() const) static_cast<opencascade::handle<Message_Messenger> (Message_Algorithm::*)() const>(&Message_Algorithm::GetMessenger),
             R"#(Returns messenger of algorithm. The returned handle is always non-null and can be used for sending messages.)#" 
          )
        .def("SendStatusMessages",
             (void (Message_Algorithm::*)( const Message_ExecStatus & ,  const Message_Gravity ,  const Standard_Integer  ) const) static_cast<void (Message_Algorithm::*)( const Message_ExecStatus & ,  const Message_Gravity ,  const Standard_Integer  ) const>(&Message_Algorithm::SendStatusMessages),
             R"#(Print messages for all status flags that have been set during algorithm execution, excluding statuses that are NOT set in theFilter.)#"  , py::arg("theFilter"),  py::arg("theTraceLevel")=static_cast<const Message_Gravity>(Message_Warning),  py::arg("theMaxCount")=static_cast<const Standard_Integer>(20)
          )
        .def("SendMessages",
             (void (Message_Algorithm::*)( const Message_Gravity ,  const Standard_Integer  ) const) static_cast<void (Message_Algorithm::*)( const Message_Gravity ,  const Standard_Integer  ) const>(&Message_Algorithm::SendMessages),
             R"#(Convenient variant of SendStatusMessages() with theFilter having defined all WARN, ALARM, and FAIL (but not DONE) status flags)#"  , py::arg("theTraceLevel")=static_cast<const Message_Gravity>(Message_Warning),  py::arg("theMaxCount")=static_cast<const Standard_Integer>(20)
          )
        .def("AddStatus",
             (void (Message_Algorithm::*)( const opencascade::handle<Message_Algorithm> &  ) ) static_cast<void (Message_Algorithm::*)( const opencascade::handle<Message_Algorithm> &  ) >(&Message_Algorithm::AddStatus),
             R"#(Add statuses to this algorithm from other algorithm (including messages))#"  , py::arg("theOther")
          )
        .def("AddStatus",
             (void (Message_Algorithm::*)( const Message_ExecStatus & ,  const opencascade::handle<Message_Algorithm> &  ) ) static_cast<void (Message_Algorithm::*)( const Message_ExecStatus & ,  const opencascade::handle<Message_Algorithm> &  ) >(&Message_Algorithm::AddStatus),
             R"#(Add statuses to this algorithm from other algorithm, but only those items are moved that correspond to statuses set in theStatus)#"  , py::arg("theStatus"),  py::arg("theOther")
          )
        .def("GetMessageNumbers",
             (opencascade::handle<TColStd_HPackedMapOfInteger> (Message_Algorithm::*)( const Message_Status &  ) const) static_cast<opencascade::handle<TColStd_HPackedMapOfInteger> (Message_Algorithm::*)( const Message_Status &  ) const>(&Message_Algorithm::GetMessageNumbers),
             R"#(Return the numbers associated with the indicated status; Null handle if no such status or no numbers associated with it)#"  , py::arg("theStatus")
          )
        .def("GetMessageStrings",
             (opencascade::handle<TColStd_HSequenceOfHExtendedString> (Message_Algorithm::*)( const Message_Status &  ) const) static_cast<opencascade::handle<TColStd_HSequenceOfHExtendedString> (Message_Algorithm::*)( const Message_Status &  ) const>(&Message_Algorithm::GetMessageStrings),
             R"#(Return the strings associated with the indicated status; Null handle if no such status or no strings associated with it)#"  , py::arg("theStatus")
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const Standard_CString ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const Standard_CString ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter. If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_AsciiString & ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_AsciiString & ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const opencascade::handle<TCollection_HAsciiString> & ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")
          )
        .def("SetStatus",
             (void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) ) static_cast<void (Message_Algorithm::*)( const Message_Status & ,  const TCollection_ExtendedString & ,  const Standard_Boolean  ) >(&Message_Algorithm::SetStatus),
             R"#(Sets status with string parameter If noRepetitions is True, the parameter will be added only if it has not been yet recorded for the same status flag)#"  , py::arg("theStat"),  py::arg("theStr"),  py::arg("noRepetitions")
          )
        .def("GetMessenger",
             (opencascade::handle<Message_Messenger> (Message_Algorithm::*)() const) static_cast<opencascade::handle<Message_Messenger> (Message_Algorithm::*)() const>(&Message_Algorithm::GetMessenger),
             R"#(Returns messenger of algorithm. The returned handle is always non-null and can be used for sending messages.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("PrepareReport_s",
                    (TCollection_ExtendedString (*)( const opencascade::handle<TColStd_HPackedMapOfInteger> & ,  const Standard_Integer  ) ) static_cast<TCollection_ExtendedString (*)( const opencascade::handle<TColStd_HPackedMapOfInteger> & ,  const Standard_Integer  ) >(&Message_Algorithm::PrepareReport),
                    R"#(Prepares a string containing a list of integers contained in theError map, but not more than theMaxCount)#"  , py::arg("theError"),  py::arg("theMaxCount")
          )
        .def_static("PrepareReport_s",
                    (TCollection_ExtendedString (*)(  const NCollection_Sequence<opencascade::handle<TCollection_HExtendedString>> & ,  const Standard_Integer  ) ) static_cast<TCollection_ExtendedString (*)(  const NCollection_Sequence<opencascade::handle<TCollection_HExtendedString>> & ,  const Standard_Integer  ) >(&Message_Algorithm::PrepareReport),
                    R"#(Prepares a string containing a list of names contained in theReportSeq sequence, but not more than theMaxCount)#"  , py::arg("theReportSeq"),  py::arg("theMaxCount")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_Algorithm::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_Algorithm::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetStatus",
             (const Message_ExecStatus & (Message_Algorithm::*)() const) static_cast<const Message_ExecStatus & (Message_Algorithm::*)() const>(&Message_Algorithm::GetStatus),
             R"#(Returns copy of exec status of algorithm)#"
             
         )
       .def("ChangeStatus",
             (Message_ExecStatus & (Message_Algorithm::*)() ) static_cast<Message_ExecStatus & (Message_Algorithm::*)() >(&Message_Algorithm::ChangeStatus),
             R"#(Returns exec status of algorithm)#"
             
             , py::return_value_policy::reference_internal
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_Algorithm::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_Algorithm::*)() const>(&Message_Algorithm::DynamicType),
             R"#(None)#"
             
         )
       .def("GetStatus",
             (const Message_ExecStatus & (Message_Algorithm::*)() const) static_cast<const Message_ExecStatus & (Message_Algorithm::*)() const>(&Message_Algorithm::GetStatus),
             R"#(Returns copy of exec status of algorithm)#"
             
         )
       .def("ChangeStatus",
             (Message_ExecStatus & (Message_Algorithm::*)() ) static_cast<Message_ExecStatus & (Message_Algorithm::*)() >(&Message_Algorithm::ChangeStatus),
             R"#(Returns exec status of algorithm)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Message_Attribute from ./opencascade/Message_Attribute.hxx
    klass = m.attr("Message_Attribute");


    // nested enums

    static_cast<py::class_<Message_Attribute ,opencascade::handle<Message_Attribute>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString & >()  , py::arg("theName")=static_cast<const TCollection_AsciiString &>(TCollection_AsciiString ( )) )
    // custom constructors
    // methods
        .def("GetMessageKey",
             (Standard_CString (Message_Attribute::*)() const) static_cast<Standard_CString (Message_Attribute::*)() const>(&Message_Attribute::GetMessageKey),
             R"#(Return a C string to be used as a key for generating text user messages describing this alert. The messages are generated with help of Message_Msg class, in Message_Report::Dump(). Base implementation returns dynamic type name of the instance.)#" 
          )
        .def("SetName",
             (void (Message_Attribute::*)( const TCollection_AsciiString &  ) ) static_cast<void (Message_Attribute::*)( const TCollection_AsciiString &  ) >(&Message_Attribute::SetName),
             R"#(Sets the custom name of alert)#"  , py::arg("theName")
          )
        .def("DumpJson",
             (void (Message_Attribute::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_Attribute::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_Attribute::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_Attribute::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_Attribute::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_Attribute::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_Attribute::*)() const>(&Message_Attribute::DynamicType),
             R"#(None)#"
             
         )
       .def("GetName",
             (const TCollection_AsciiString & (Message_Attribute::*)() const) static_cast<const TCollection_AsciiString & (Message_Attribute::*)() const>(&Message_Attribute::GetName),
             R"#(Returns custom name of alert if it is set)#"
             
         )
;

    // Class Message_CompositeAlerts from ./opencascade/Message_CompositeAlerts.hxx
    klass = m.attr("Message_CompositeAlerts");


    // nested enums

    static_cast<py::class_<Message_CompositeAlerts ,opencascade::handle<Message_CompositeAlerts>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("Alerts",
             (const Message_ListOfAlert & (Message_CompositeAlerts::*)( const Message_Gravity  ) const) static_cast<const Message_ListOfAlert & (Message_CompositeAlerts::*)( const Message_Gravity  ) const>(&Message_CompositeAlerts::Alerts),
             R"#(Returns list of collected alerts with specified gravity)#"  , py::arg("theGravity")
          )
        .def("AddAlert",
             (Standard_Boolean (Message_CompositeAlerts::*)( Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) ) static_cast<Standard_Boolean (Message_CompositeAlerts::*)( Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) >(&Message_CompositeAlerts::AddAlert),
             R"#(Add alert with specified gravity. If the alert supports merge it will be merged.)#"  , py::arg("theGravity"),  py::arg("theAlert")
          )
        .def("RemoveAlert",
             (Standard_Boolean (Message_CompositeAlerts::*)( Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) ) static_cast<Standard_Boolean (Message_CompositeAlerts::*)( Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) >(&Message_CompositeAlerts::RemoveAlert),
             R"#(Removes alert with specified gravity.)#"  , py::arg("theGravity"),  py::arg("theAlert")
          )
        .def("HasAlert",
             (Standard_Boolean (Message_CompositeAlerts::*)( const opencascade::handle<Message_Alert> &  ) ) static_cast<Standard_Boolean (Message_CompositeAlerts::*)( const opencascade::handle<Message_Alert> &  ) >(&Message_CompositeAlerts::HasAlert),
             R"#(Returns true if the alert belong the list of the child alerts.)#"  , py::arg("theAlert")
          )
        .def("HasAlert",
             (Standard_Boolean (Message_CompositeAlerts::*)( const opencascade::handle<Standard_Type> & ,  Message_Gravity  ) ) static_cast<Standard_Boolean (Message_CompositeAlerts::*)( const opencascade::handle<Standard_Type> & ,  Message_Gravity  ) >(&Message_CompositeAlerts::HasAlert),
             R"#(Returns true if specific type of alert is recorded with specified gravity)#"  , py::arg("theType"),  py::arg("theGravity")
          )
        .def("Clear",
             (void (Message_CompositeAlerts::*)() ) static_cast<void (Message_CompositeAlerts::*)() >(&Message_CompositeAlerts::Clear),
             R"#(Clears all collected alerts)#" 
          )
        .def("Clear",
             (void (Message_CompositeAlerts::*)( Message_Gravity  ) ) static_cast<void (Message_CompositeAlerts::*)( Message_Gravity  ) >(&Message_CompositeAlerts::Clear),
             R"#(Clears collected alerts with specified gravity)#"  , py::arg("theGravity")
          )
        .def("Clear",
             (void (Message_CompositeAlerts::*)( const opencascade::handle<Standard_Type> &  ) ) static_cast<void (Message_CompositeAlerts::*)( const opencascade::handle<Standard_Type> &  ) >(&Message_CompositeAlerts::Clear),
             R"#(Clears collected alerts with specified type)#"  , py::arg("theType")
          )
        .def("DumpJson",
             (void (Message_CompositeAlerts::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_CompositeAlerts::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_CompositeAlerts::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_CompositeAlerts::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_CompositeAlerts::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_CompositeAlerts::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_CompositeAlerts::*)() const>(&Message_CompositeAlerts::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_ExecStatus from ./opencascade/Message_ExecStatus.hxx
    klass = m.attr("Message_ExecStatus");


    // nested enums
        py::enum_<Message_ExecStatus::StatusRange>(klass, "StatusRange_e", R"#(Definitions of range of available statuses)#")
            .value("FirstStatus", Message_ExecStatus::StatusRange::FirstStatus)
            .value("StatusesPerType", Message_ExecStatus::StatusRange::StatusesPerType)
            .value("NbStatuses", Message_ExecStatus::StatusRange::NbStatuses)
            .value("LastStatus", Message_ExecStatus::StatusRange::LastStatus).export_values();

    static_cast<py::class_<Message_ExecStatus , shared_ptr<Message_ExecStatus>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< Message_Status >()  , py::arg("theStatus") )
    // custom constructors
    // methods
        .def("Set",
             (void (Message_ExecStatus::*)( Message_Status  ) ) static_cast<void (Message_ExecStatus::*)( Message_Status  ) >(&Message_ExecStatus::Set),
             R"#(Sets a status flag)#"  , py::arg("theStatus")
          )
        .def("IsSet",
             (Standard_Boolean (Message_ExecStatus::*)( Message_Status  ) const) static_cast<Standard_Boolean (Message_ExecStatus::*)( Message_Status  ) const>(&Message_ExecStatus::IsSet),
             R"#(Check status for being set)#"  , py::arg("theStatus")
          )
        .def("Clear",
             (void (Message_ExecStatus::*)( Message_Status  ) ) static_cast<void (Message_ExecStatus::*)( Message_Status  ) >(&Message_ExecStatus::Clear),
             R"#(Clear one status)#"  , py::arg("theStatus")
          )
        .def("IsDone",
             (Standard_Boolean (Message_ExecStatus::*)() const) static_cast<Standard_Boolean (Message_ExecStatus::*)() const>(&Message_ExecStatus::IsDone),
             R"#(Check if at least one status of each type is set)#" 
          )
        .def("IsFail",
             (Standard_Boolean (Message_ExecStatus::*)() const) static_cast<Standard_Boolean (Message_ExecStatus::*)() const>(&Message_ExecStatus::IsFail),
             R"#(None)#" 
          )
        .def("IsWarn",
             (Standard_Boolean (Message_ExecStatus::*)() const) static_cast<Standard_Boolean (Message_ExecStatus::*)() const>(&Message_ExecStatus::IsWarn),
             R"#(None)#" 
          )
        .def("IsAlarm",
             (Standard_Boolean (Message_ExecStatus::*)() const) static_cast<Standard_Boolean (Message_ExecStatus::*)() const>(&Message_ExecStatus::IsAlarm),
             R"#(None)#" 
          )
        .def("SetAllDone",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::SetAllDone),
             R"#(Set all statuses of each type)#" 
          )
        .def("SetAllWarn",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::SetAllWarn),
             R"#(None)#" 
          )
        .def("SetAllAlarm",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::SetAllAlarm),
             R"#(None)#" 
          )
        .def("SetAllFail",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::SetAllFail),
             R"#(None)#" 
          )
        .def("ClearAllDone",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::ClearAllDone),
             R"#(Clear all statuses of each type)#" 
          )
        .def("ClearAllWarn",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::ClearAllWarn),
             R"#(None)#" 
          )
        .def("ClearAllAlarm",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::ClearAllAlarm),
             R"#(None)#" 
          )
        .def("ClearAllFail",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::ClearAllFail),
             R"#(None)#" 
          )
        .def("Clear",
             (void (Message_ExecStatus::*)() ) static_cast<void (Message_ExecStatus::*)() >(&Message_ExecStatus::Clear),
             R"#(Clear all statuses)#" 
          )
        .def("Add",
             (void (Message_ExecStatus::*)( const Message_ExecStatus &  ) ) static_cast<void (Message_ExecStatus::*)( const Message_ExecStatus &  ) >(&Message_ExecStatus::Add),
             R"#(Add statuses to me from theOther execution status)#"  , py::arg("theOther")
          )
        .def("And",
             (void (Message_ExecStatus::*)( const Message_ExecStatus &  ) ) static_cast<void (Message_ExecStatus::*)( const Message_ExecStatus &  ) >(&Message_ExecStatus::And),
             R"#(Leave only the statuses common with theOther)#"  , py::arg("theOther")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("StatusIndex_s",
                    (Standard_Integer (*)( Message_Status  ) ) static_cast<Standard_Integer (*)( Message_Status  ) >(&Message_ExecStatus::StatusIndex),
                    R"#(Returns index of status in whole range [FirstStatus, LastStatus])#"  , py::arg("theStatus")
          )
        .def_static("LocalStatusIndex_s",
                    (Standard_Integer (*)( Message_Status  ) ) static_cast<Standard_Integer (*)( Message_Status  ) >(&Message_ExecStatus::LocalStatusIndex),
                    R"#(Returns index of status inside type of status (Done or Warn or, etc) in range [1, StatusesPerType])#"  , py::arg("theStatus")
          )
        .def_static("TypeOfStatus_s",
                    (Message_StatusType (*)( Message_Status  ) ) static_cast<Message_StatusType (*)( Message_Status  ) >(&Message_ExecStatus::TypeOfStatus),
                    R"#(Returns status type (DONE, WARN, ALARM, or FAIL))#"  , py::arg("theStatus")
          )
        .def_static("StatusByIndex_s",
                    (Message_Status (*)( const Standard_Integer  ) ) static_cast<Message_Status (*)( const Standard_Integer  ) >(&Message_ExecStatus::StatusByIndex),
                    R"#(Returns status with index theIndex in whole range [FirstStatus, LastStatus])#"  , py::arg("theIndex")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Message_Level from ./opencascade/Message_Level.hxx
    klass = m.attr("Message_Level");


    // nested enums

    static_cast<py::class_<Message_Level , shared_ptr<Message_Level>  >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString & >()  , py::arg("theName")=static_cast<const TCollection_AsciiString &>(TCollection_AsciiString ( )) )
    // custom constructors
    // methods
        .def("SetRootAlert",
             (void (Message_Level::*)( const opencascade::handle<Message_AlertExtended> & ,  const Standard_Boolean  ) ) static_cast<void (Message_Level::*)( const opencascade::handle<Message_AlertExtended> & ,  const Standard_Boolean  ) >(&Message_Level::SetRootAlert),
             R"#(Sets the root alert. Starts collects alert metrics if active.)#"  , py::arg("theAlert"),  py::arg("isRequiredToStart")
          )
        .def("AddAlert",
             (Standard_Boolean (Message_Level::*)( const Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) ) static_cast<Standard_Boolean (Message_Level::*)( const Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) >(&Message_Level::AddAlert),
             R"#(Adds new alert on the level. Stops the last alert metric, appends the alert and starts the alert metrics collecting. Sets root alert beforehand this method using, if the root is NULL, it does nothing.)#"  , py::arg("theGravity"),  py::arg("theAlert")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("RootAlert",
             (const opencascade::handle<Message_AlertExtended> & (Message_Level::*)() const) static_cast<const opencascade::handle<Message_AlertExtended> & (Message_Level::*)() const>(&Message_Level::RootAlert),
             R"#(Returns root alert of the level)#"
             
         )
;

    // Class Message_Messenger from ./opencascade/Message_Messenger.hxx
    klass = m.attr("Message_Messenger");


    // nested enums

    static_cast<py::class_<Message_Messenger ,opencascade::handle<Message_Messenger>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Message_Printer> & >()  , py::arg("thePrinter") )
    // custom constructors
    // methods
        .def("AddPrinter",
             (Standard_Boolean (Message_Messenger::*)( const opencascade::handle<Message_Printer> &  ) ) static_cast<Standard_Boolean (Message_Messenger::*)( const opencascade::handle<Message_Printer> &  ) >(&Message_Messenger::AddPrinter),
             R"#(Add a printer to the messenger. The printer will be added only if it is not yet in the list. Returns True if printer has been added.)#"  , py::arg("thePrinter")
          )
        .def("RemovePrinter",
             (Standard_Boolean (Message_Messenger::*)( const opencascade::handle<Message_Printer> &  ) ) static_cast<Standard_Boolean (Message_Messenger::*)( const opencascade::handle<Message_Printer> &  ) >(&Message_Messenger::RemovePrinter),
             R"#(Removes specified printer from the messenger. Returns True if this printer has been found in the list and removed.)#"  , py::arg("thePrinter")
          )
        .def("RemovePrinters",
             (Standard_Integer (Message_Messenger::*)( const opencascade::handle<Standard_Type> &  ) ) static_cast<Standard_Integer (Message_Messenger::*)( const opencascade::handle<Standard_Type> &  ) >(&Message_Messenger::RemovePrinters),
             R"#(Removes printers of specified type (including derived classes) from the messenger. Returns number of removed printers.)#"  , py::arg("theType")
          )
        .def("Send",
             (void (Message_Messenger::*)( const Standard_CString ,  const Message_Gravity  ) const) static_cast<void (Message_Messenger::*)( const Standard_CString ,  const Message_Gravity  ) const>(&Message_Messenger::Send),
             R"#(Dispatch a message to all the printers in the list. Three versions of string representations are accepted for convenience, by default all are converted to ExtendedString.)#"  , py::arg("theString"),  py::arg("theGravity")=static_cast<const Message_Gravity>(Message_Warning)
          )
        .def("Send",
             (void (Message_Messenger::*)(  const std::stringstream & ,  const Message_Gravity  ) const) static_cast<void (Message_Messenger::*)(  const std::stringstream & ,  const Message_Gravity  ) const>(&Message_Messenger::Send),
             R"#(See above)#"  , py::arg("theStream"),  py::arg("theGravity")=static_cast<const Message_Gravity>(Message_Warning)
          )
        .def("Send",
             (void (Message_Messenger::*)( const TCollection_AsciiString & ,  const Message_Gravity  ) const) static_cast<void (Message_Messenger::*)( const TCollection_AsciiString & ,  const Message_Gravity  ) const>(&Message_Messenger::Send),
             R"#(See above)#"  , py::arg("theString"),  py::arg("theGravity")=static_cast<const Message_Gravity>(Message_Warning)
          )
        .def("Send",
             (void (Message_Messenger::*)( const TCollection_ExtendedString & ,  const Message_Gravity  ) const) static_cast<void (Message_Messenger::*)( const TCollection_ExtendedString & ,  const Message_Gravity  ) const>(&Message_Messenger::Send),
             R"#(See above)#"  , py::arg("theString"),  py::arg("theGravity")=static_cast<const Message_Gravity>(Message_Warning)
          )
        .def("Send",
             (Message_Messenger::StreamBuffer (Message_Messenger::*)( Message_Gravity  ) ) static_cast<Message_Messenger::StreamBuffer (Message_Messenger::*)( Message_Gravity  ) >(&Message_Messenger::Send),
             R"#(Create string buffer for message of specified type)#"  , py::arg("theGravity")
          )
        .def("Send",
             (void (Message_Messenger::*)( const opencascade::handle<Standard_Transient> & ,  const Message_Gravity  ) const) static_cast<void (Message_Messenger::*)( const opencascade::handle<Standard_Transient> & ,  const Message_Gravity  ) const>(&Message_Messenger::Send),
             R"#(See above)#"  , py::arg("theObject"),  py::arg("theGravity")=static_cast<const Message_Gravity>(Message_Warning)
          )
        .def("SendFail",
             (Message_Messenger::StreamBuffer (Message_Messenger::*)() ) static_cast<Message_Messenger::StreamBuffer (Message_Messenger::*)() >(&Message_Messenger::SendFail),
             R"#(Create string buffer for sending Fail message)#" 
          )
        .def("SendAlarm",
             (Message_Messenger::StreamBuffer (Message_Messenger::*)() ) static_cast<Message_Messenger::StreamBuffer (Message_Messenger::*)() >(&Message_Messenger::SendAlarm),
             R"#(Create string buffer for sending Alarm message)#" 
          )
        .def("SendWarning",
             (Message_Messenger::StreamBuffer (Message_Messenger::*)() ) static_cast<Message_Messenger::StreamBuffer (Message_Messenger::*)() >(&Message_Messenger::SendWarning),
             R"#(Create string buffer for sending Warning message)#" 
          )
        .def("SendInfo",
             (Message_Messenger::StreamBuffer (Message_Messenger::*)() ) static_cast<Message_Messenger::StreamBuffer (Message_Messenger::*)() >(&Message_Messenger::SendInfo),
             R"#(Create string buffer for sending Info message)#" 
          )
        .def("SendTrace",
             (Message_Messenger::StreamBuffer (Message_Messenger::*)() ) static_cast<Message_Messenger::StreamBuffer (Message_Messenger::*)() >(&Message_Messenger::SendTrace),
             R"#(Create string buffer for sending Trace message)#" 
          )
        .def("SendFail",
             (void (Message_Messenger::*)( const TCollection_AsciiString &  ) ) static_cast<void (Message_Messenger::*)( const TCollection_AsciiString &  ) >(&Message_Messenger::SendFail),
             R"#(Short-cut to Send (theMessage, Message_Fail))#"  , py::arg("theMessage")
          )
        .def("SendAlarm",
             (void (Message_Messenger::*)( const TCollection_AsciiString &  ) ) static_cast<void (Message_Messenger::*)( const TCollection_AsciiString &  ) >(&Message_Messenger::SendAlarm),
             R"#(Short-cut to Send (theMessage, Message_Alarm))#"  , py::arg("theMessage")
          )
        .def("SendWarning",
             (void (Message_Messenger::*)( const TCollection_AsciiString &  ) ) static_cast<void (Message_Messenger::*)( const TCollection_AsciiString &  ) >(&Message_Messenger::SendWarning),
             R"#(Short-cut to Send (theMessage, Message_Warning))#"  , py::arg("theMessage")
          )
        .def("SendInfo",
             (void (Message_Messenger::*)( const TCollection_AsciiString &  ) ) static_cast<void (Message_Messenger::*)( const TCollection_AsciiString &  ) >(&Message_Messenger::SendInfo),
             R"#(Short-cut to Send (theMessage, Message_Info))#"  , py::arg("theMessage")
          )
        .def("SendTrace",
             (void (Message_Messenger::*)( const TCollection_AsciiString &  ) ) static_cast<void (Message_Messenger::*)( const TCollection_AsciiString &  ) >(&Message_Messenger::SendTrace),
             R"#(Short-cut to Send (theMessage, Message_Trace))#"  , py::arg("theMessage")
          )
        .def("DumpJson",
             (void (Message_Messenger::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_Messenger::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_Messenger::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_Messenger::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_Messenger::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_Messenger::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_Messenger::*)() const>(&Message_Messenger::DynamicType),
             R"#(None)#"
             
         )
       .def("Printers",
             (const Message_SequenceOfPrinters & (Message_Messenger::*)() const) static_cast<const Message_SequenceOfPrinters & (Message_Messenger::*)() const>(&Message_Messenger::Printers),
             R"#(Returns current sequence of printers)#"
             
         )
       .def("ChangePrinters",
             (Message_SequenceOfPrinters & (Message_Messenger::*)() ) static_cast<Message_SequenceOfPrinters & (Message_Messenger::*)() >(&Message_Messenger::ChangePrinters),
             R"#(Returns sequence of printers The sequence can be modified.)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Message_Msg from ./opencascade/Message_Msg.hxx
    klass = m.attr("Message_Msg");


    // nested enums

    static_cast<py::class_<Message_Msg , shared_ptr<Message_Msg>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Message_Msg & >()  , py::arg("theMsg") )
        .def(py::init< const Standard_CString >()  , py::arg("theKey") )
        .def(py::init< const TCollection_ExtendedString & >()  , py::arg("theKey") )
    // custom constructors
    // methods
        .def("Set",
             (void (Message_Msg::*)( const Standard_CString  ) ) static_cast<void (Message_Msg::*)( const Standard_CString  ) >(&Message_Msg::Set),
             R"#(Set a message body text -- can be used as alternative to using messages from resource file)#"  , py::arg("theMsg")
          )
        .def("Set",
             (void (Message_Msg::*)( const TCollection_ExtendedString &  ) ) static_cast<void (Message_Msg::*)( const TCollection_ExtendedString &  ) >(&Message_Msg::Set),
             R"#(Set a message body text -- can be used as alternative to using messages from resource file)#"  , py::arg("theMsg")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const Standard_CString  ) ) static_cast<Message_Msg & (Message_Msg::*)( const Standard_CString  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const TCollection_AsciiString &  ) ) static_cast<Message_Msg & (Message_Msg::*)( const TCollection_AsciiString &  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const TCollection_ExtendedString &  ) ) static_cast<Message_Msg & (Message_Msg::*)( const TCollection_ExtendedString &  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HExtendedString> &  ) ) static_cast<Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HExtendedString> &  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const Standard_Integer  ) ) static_cast<Message_Msg & (Message_Msg::*)( const Standard_Integer  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..d, %..i, %..o, %..u, %..x or %..X conversion)#"  , py::arg("theInt")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const Standard_Real  ) ) static_cast<Message_Msg & (Message_Msg::*)( const Standard_Real  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..f, %..e, %..E, %..g or %..G conversion)#"  , py::arg("theReal")
          )
        .def("IsEdited",
             (Standard_Boolean (Message_Msg::*)() const) static_cast<Standard_Boolean (Message_Msg::*)() const>(&Message_Msg::IsEdited),
             R"#(Tells if Value differs from Original)#" 
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const TCollection_AsciiString &  ) ) static_cast<Message_Msg & (Message_Msg::*)( const TCollection_AsciiString &  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HAsciiString> &  ) ) static_cast<Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HAsciiString> &  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("Arg",
             (Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HExtendedString> &  ) ) static_cast<Message_Msg & (Message_Msg::*)( const opencascade::handle<TCollection_HExtendedString> &  ) >(&Message_Msg::Arg),
             R"#(Set a value for %..s conversion)#"  , py::arg("theString")
          )
        .def("IsEdited",
             (Standard_Boolean (Message_Msg::*)() const) static_cast<Standard_Boolean (Message_Msg::*)() const>(&Message_Msg::IsEdited),
             R"#(Tells if Value differs from Original)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Original",
             (const TCollection_ExtendedString & (Message_Msg::*)() const) static_cast<const TCollection_ExtendedString & (Message_Msg::*)() const>(&Message_Msg::Original),
             R"#(Returns the original message text)#"
             
         )
       .def("Value",
             (const TCollection_ExtendedString & (Message_Msg::*)() const) static_cast<const TCollection_ExtendedString & (Message_Msg::*)() const>(&Message_Msg::Value),
             R"#(Returns current state of the message text with parameters to the moment)#"
             
         )
       .def("Get",
             (const TCollection_ExtendedString & (Message_Msg::*)() ) static_cast<const TCollection_ExtendedString & (Message_Msg::*)() >(&Message_Msg::Get),
             R"#(Return the resulting message string with all parameters filled. If some parameters were not yet filled by calls to methods Arg (or <<), these parameters are filled by the word UNKNOWN)#"
             
         )
       .def("Original",
             (const TCollection_ExtendedString & (Message_Msg::*)() const) static_cast<const TCollection_ExtendedString & (Message_Msg::*)() const>(&Message_Msg::Original),
             R"#(Returns the original message text)#"
             
         )
       .def("Value",
             (const TCollection_ExtendedString & (Message_Msg::*)() const) static_cast<const TCollection_ExtendedString & (Message_Msg::*)() const>(&Message_Msg::Value),
             R"#(Returns current state of the message text with parameters to the moment)#"
             
         )
;

    // Class Message_MsgFile from ./opencascade/Message_MsgFile.hxx
    klass = m.attr("Message_MsgFile");

    // default constructor
    register_default_constructor<Message_MsgFile , shared_ptr<Message_MsgFile>>(m,"Message_MsgFile");

    // nested enums

    static_cast<py::class_<Message_MsgFile , shared_ptr<Message_MsgFile>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Load_s",
                    (Standard_Boolean (*)( const Standard_CString ,  const Standard_CString  ) ) static_cast<Standard_Boolean (*)( const Standard_CString ,  const Standard_CString  ) >(&Message_MsgFile::Load),
                    R"#(Load message file <theFileName> from directory <theDirName> or its sub-directory)#"  , py::arg("theDirName"),  py::arg("theFileName")
          )
        .def_static("LoadFile_s",
                    (Standard_Boolean (*)( const Standard_CString  ) ) static_cast<Standard_Boolean (*)( const Standard_CString  ) >(&Message_MsgFile::LoadFile),
                    R"#(Load the messages from the given file, additive to any previously loaded messages. Messages with same keywords, if already present, are replaced with the new ones.)#"  , py::arg("theFName")
          )
        .def_static("LoadFromEnv_s",
                    (Standard_Boolean (*)( const Standard_CString ,  const Standard_CString ,  const Standard_CString  ) ) static_cast<Standard_Boolean (*)( const Standard_CString ,  const Standard_CString ,  const Standard_CString  ) >(&Message_MsgFile::LoadFromEnv),
                    R"#(Loads the messages from the file with name (without extension) given by environment variable. Extension of the file name is given separately. If its not defined, it is taken: - by default from environment CSF_LANGUAGE, - if not defined either, as "us".)#"  , py::arg("theEnvName"),  py::arg("theFileName"),  py::arg("theLangExt")=static_cast<const Standard_CString>("")
          )
        .def_static("LoadFromString_s",
                    (Standard_Boolean (*)( const Standard_CString ,  const Standard_Integer  ) ) static_cast<Standard_Boolean (*)( const Standard_CString ,  const Standard_Integer  ) >(&Message_MsgFile::LoadFromString),
                    R"#(Loads the messages from the given text buffer.)#"  , py::arg("theContent"),  py::arg("theLength")=static_cast<const Standard_Integer>(- 1)
          )
        .def_static("AddMsg_s",
                    (Standard_Boolean (*)( const TCollection_AsciiString & ,  const TCollection_ExtendedString &  ) ) static_cast<Standard_Boolean (*)( const TCollection_AsciiString & ,  const TCollection_ExtendedString &  ) >(&Message_MsgFile::AddMsg),
                    R"#(Adds new message to the map. Parameter <key> gives the key of the message, <text> defines the message itself. If there already was defined the message identified by the same keyword, it is replaced with the new one.)#"  , py::arg("key"),  py::arg("text")
          )
        .def_static("HasMsg_s",
                    (Standard_Boolean (*)( const TCollection_AsciiString &  ) ) static_cast<Standard_Boolean (*)( const TCollection_AsciiString &  ) >(&Message_MsgFile::HasMsg),
                    R"#(Returns True if message with specified keyword is registered)#"  , py::arg("key")
          )
        .def_static("Msg_s",
                    (const TCollection_ExtendedString & (*)( const Standard_CString  ) ) static_cast<const TCollection_ExtendedString & (*)( const Standard_CString  ) >(&Message_MsgFile::Msg),
                    R"#(None)#"  , py::arg("key")
          )
        .def_static("Msg_s",
                    (const TCollection_ExtendedString & (*)( const TCollection_AsciiString &  ) ) static_cast<const TCollection_ExtendedString & (*)( const TCollection_AsciiString &  ) >(&Message_MsgFile::Msg),
                    R"#(Gives the text for the message identified by the keyword <key>. If there are no messages with such keyword defined, the error message is returned. In that case reference to static string is returned, it can be changed with next call(s) to Msg(). Note: The error message is constructed like 'Unknown message: <key>', and can itself be customized by defining message with key Message_Msg_BadKeyword.)#"  , py::arg("key")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Message_Printer from ./opencascade/Message_Printer.hxx
    klass = m.attr("Message_Printer");


    // nested enums

    static_cast<py::class_<Message_Printer ,opencascade::handle<Message_Printer> ,Py_Message_Printer , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("GetTraceLevel",
             (Message_Gravity (Message_Printer::*)() const) static_cast<Message_Gravity (Message_Printer::*)() const>(&Message_Printer::GetTraceLevel),
             R"#(Return trace level used for filtering messages; messages with lover gravity will be ignored.)#" 
          )
        .def("SetTraceLevel",
             (void (Message_Printer::*)( const Message_Gravity  ) ) static_cast<void (Message_Printer::*)( const Message_Gravity  ) >(&Message_Printer::SetTraceLevel),
             R"#(Set trace level used for filtering messages. By default, trace level is Message_Info, so that all messages are output)#"  , py::arg("theTraceLevel")
          )
        .def("Send",
             (void (Message_Printer::*)( const TCollection_ExtendedString & ,  const Message_Gravity  ) const) static_cast<void (Message_Printer::*)( const TCollection_ExtendedString & ,  const Message_Gravity  ) const>(&Message_Printer::Send),
             R"#(Send a string message with specified trace level. The last Boolean argument is deprecated and unused. Default implementation redirects to send().)#"  , py::arg("theString"),  py::arg("theGravity")
          )
        .def("Send",
             (void (Message_Printer::*)( const Standard_CString ,  const Message_Gravity  ) const) static_cast<void (Message_Printer::*)( const Standard_CString ,  const Message_Gravity  ) const>(&Message_Printer::Send),
             R"#(Send a string message with specified trace level. The last Boolean argument is deprecated and unused. Default implementation redirects to send().)#"  , py::arg("theString"),  py::arg("theGravity")
          )
        .def("Send",
             (void (Message_Printer::*)( const TCollection_AsciiString & ,  const Message_Gravity  ) const) static_cast<void (Message_Printer::*)( const TCollection_AsciiString & ,  const Message_Gravity  ) const>(&Message_Printer::Send),
             R"#(Send a string message with specified trace level. The last Boolean argument is deprecated and unused. Default implementation redirects to send().)#"  , py::arg("theString"),  py::arg("theGravity")
          )
        .def("SendStringStream",
             (void (Message_Printer::*)(  const std::stringstream & ,  const Message_Gravity  ) const) static_cast<void (Message_Printer::*)(  const std::stringstream & ,  const Message_Gravity  ) const>(&Message_Printer::SendStringStream),
             R"#(Send a string message with specified trace level. Stream is converted to string value. Default implementation calls first method Send().)#"  , py::arg("theStream"),  py::arg("theGravity")
          )
        .def("SendObject",
             (void (Message_Printer::*)( const opencascade::handle<Standard_Transient> & ,  const Message_Gravity  ) const) static_cast<void (Message_Printer::*)( const opencascade::handle<Standard_Transient> & ,  const Message_Gravity  ) const>(&Message_Printer::SendObject),
             R"#(Send a string message with specified trace level. The object is converted to string in format: <object kind> : <object pointer>. Default implementation calls first method Send().)#"  , py::arg("theObject"),  py::arg("theGravity")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_Printer::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_Printer::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_Printer::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_Printer::*)() const>(&Message_Printer::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_ProgressIndicator from ./opencascade/Message_ProgressIndicator.hxx
    klass = m.attr("Message_ProgressIndicator");


    // nested enums

    static_cast<py::class_<Message_ProgressIndicator ,opencascade::handle<Message_ProgressIndicator> ,Py_Message_ProgressIndicator , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("Start",
             (Message_ProgressRange (Message_ProgressIndicator::*)() ) static_cast<Message_ProgressRange (Message_ProgressIndicator::*)() >(&Message_ProgressIndicator::Start),
             R"#(Resets the indicator to zero, calls Reset(), and returns the range. This range refers to the scope that has no name and is initialized with max value 1 and step 1. Use this method to get the top level range for progress indication.)#" 
          )
        .def("GetPosition",
             (Standard_Real (Message_ProgressIndicator::*)() const) static_cast<Standard_Real (Message_ProgressIndicator::*)() const>(&Message_ProgressIndicator::GetPosition),
             R"#(Returns total progress position ranged from 0 to 1. Should not be called concurrently while the progress is advancing, except from implementation of method Show().)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_ProgressIndicator::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_ProgressIndicator::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("Start_s",
                    (Message_ProgressRange (*)( const opencascade::handle<Message_ProgressIndicator> &  ) ) static_cast<Message_ProgressRange (*)( const opencascade::handle<Message_ProgressIndicator> &  ) >(&Message_ProgressIndicator::Start),
                    R"#(If argument is non-null handle, returns theProgress->Start(). Otherwise, returns dummy range that can be safely used in the algorithms but not bound to progress indicator.)#"  , py::arg("theProgress")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_ProgressIndicator::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_ProgressIndicator::*)() const>(&Message_ProgressIndicator::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_ProgressRange from ./opencascade/Message_ProgressRange.hxx
    klass = m.attr("Message_ProgressRange");


    // nested enums

    static_cast<py::class_<Message_ProgressRange , shared_ptr<Message_ProgressRange>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Message_ProgressRange & >()  , py::arg("theOther") )
    // custom constructors
    // methods
        .def("UserBreak",
             (Standard_Boolean (Message_ProgressRange::*)() const) static_cast<Standard_Boolean (Message_ProgressRange::*)() const>(&Message_ProgressRange::UserBreak),
             R"#(Returns true if ProgressIndicator signals UserBreak)#" 
          )
        .def("More",
             (Standard_Boolean (Message_ProgressRange::*)() const) static_cast<Standard_Boolean (Message_ProgressRange::*)() const>(&Message_ProgressRange::More),
             R"#(Returns false if ProgressIndicator signals UserBreak)#" 
          )
        .def("IsActive",
             (Standard_Boolean (Message_ProgressRange::*)() const) static_cast<Standard_Boolean (Message_ProgressRange::*)() const>(&Message_ProgressRange::IsActive),
             R"#(Returns true if this progress range is attached to some indicator.)#" 
          )
        .def("Close",
             (void (Message_ProgressRange::*)() ) static_cast<void (Message_ProgressRange::*)() >(&Message_ProgressRange::Close),
             R"#(Closes the current range and advances indicator)#" 
          )
        .def("IsActive",
             (Standard_Boolean (Message_ProgressRange::*)() const) static_cast<Standard_Boolean (Message_ProgressRange::*)() const>(&Message_ProgressRange::IsActive),
             R"#(Returns true if this progress range is attached to some indicator.)#" 
          )
        .def("UserBreak",
             (Standard_Boolean (Message_ProgressRange::*)() const) static_cast<Standard_Boolean (Message_ProgressRange::*)() const>(&Message_ProgressRange::UserBreak),
             R"#(Returns true if ProgressIndicator signals UserBreak)#" 
          )
        .def("Close",
             (void (Message_ProgressRange::*)() ) static_cast<void (Message_ProgressRange::*)() >(&Message_ProgressRange::Close),
             R"#(Closes the current range and advances indicator)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Message_ProgressScope from ./opencascade/Message_ProgressScope.hxx
    klass = m.attr("Message_ProgressScope");


    // nested enums

    static_cast<py::class_<Message_ProgressScope , shared_ptr<Message_ProgressScope>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Message_ProgressRange &,const TCollection_AsciiString &,Standard_Real,Standard_Boolean >()  , py::arg("theRange"),  py::arg("theName"),  py::arg("theMax"),  py::arg("isInfinite")=static_cast<Standard_Boolean>(false) )
    // custom constructors
    // methods
        .def("SetName",
             (void (Message_ProgressScope::*)( const TCollection_AsciiString &  ) ) static_cast<void (Message_ProgressScope::*)( const TCollection_AsciiString &  ) >(&Message_ProgressScope::SetName),
             R"#(Sets the name of the scope.)#"  , py::arg("theName")
          )
        .def("UserBreak",
             (Standard_Boolean (Message_ProgressScope::*)() const) static_cast<Standard_Boolean (Message_ProgressScope::*)() const>(&Message_ProgressScope::UserBreak),
             R"#(Returns true if ProgressIndicator signals UserBreak)#" 
          )
        .def("More",
             (Standard_Boolean (Message_ProgressScope::*)() const) static_cast<Standard_Boolean (Message_ProgressScope::*)() const>(&Message_ProgressScope::More),
             R"#(Returns false if ProgressIndicator signals UserBreak)#" 
          )
        .def("Next",
             (Message_ProgressRange (Message_ProgressScope::*)( Standard_Real  ) ) static_cast<Message_ProgressRange (Message_ProgressScope::*)( Standard_Real  ) >(&Message_ProgressScope::Next),
             R"#(Advances position by specified step and returns the range covering this step)#"  , py::arg("theStep")=static_cast<Standard_Real>(1.)
          )
        .def("Show",
             (void (Message_ProgressScope::*)() ) static_cast<void (Message_ProgressScope::*)() >(&Message_ProgressScope::Show),
             R"#(Force update of presentation of the progress indicator. Should not be called concurrently.)#" 
          )
        .def("IsActive",
             (Standard_Boolean (Message_ProgressScope::*)() const) static_cast<Standard_Boolean (Message_ProgressScope::*)() const>(&Message_ProgressScope::IsActive),
             R"#(Returns true if this progress scope is attached to some indicator.)#" 
          )
        .def("Name",
             (Standard_CString (Message_ProgressScope::*)() const) static_cast<Standard_CString (Message_ProgressScope::*)() const>(&Message_ProgressScope::Name),
             R"#(Returns the name of the scope (may be null). Scopes with null name (e.g. root scope) should be bypassed when reporting progress to the user.)#" 
          )
        .def("Parent",
             (const Message_ProgressScope * (Message_ProgressScope::*)() const) static_cast<const Message_ProgressScope * (Message_ProgressScope::*)() const>(&Message_ProgressScope::Parent),
             R"#(Returns parent scope (null for top-level scope))#" 
          )
        .def("MaxValue",
             (Standard_Real (Message_ProgressScope::*)() const) static_cast<Standard_Real (Message_ProgressScope::*)() const>(&Message_ProgressScope::MaxValue),
             R"#(Returns the maximal value of progress in this scope)#" 
          )
        .def("Value",
             (Standard_Real (Message_ProgressScope::*)() const) static_cast<Standard_Real (Message_ProgressScope::*)() const>(&Message_ProgressScope::Value),
             R"#(Returns the current value of progress in this scope.)#" 
          )
        .def("IsInfinite",
             (Standard_Boolean (Message_ProgressScope::*)() const) static_cast<Standard_Boolean (Message_ProgressScope::*)() const>(&Message_ProgressScope::IsInfinite),
             R"#(Returns the infinite flag)#" 
          )
        .def("GetPortion",
             (Standard_Real (Message_ProgressScope::*)() const) static_cast<Standard_Real (Message_ProgressScope::*)() const>(&Message_ProgressScope::GetPortion),
             R"#(Get the portion of the indicator covered by this scope (from 0 to 1))#" 
          )
        .def("Close",
             (void (Message_ProgressScope::*)() ) static_cast<void (Message_ProgressScope::*)() >(&Message_ProgressScope::Close),
             R"#(Closes the scope and advances the progress to its end. Closed scope should not be used.)#" 
          )
        .def("Close",
             (void (Message_ProgressScope::*)() ) static_cast<void (Message_ProgressScope::*)() >(&Message_ProgressScope::Close),
             R"#(Closes the scope and advances the progress to its end. Closed scope should not be used.)#" 
          )
        .def("UserBreak",
             (Standard_Boolean (Message_ProgressScope::*)() const) static_cast<Standard_Boolean (Message_ProgressScope::*)() const>(&Message_ProgressScope::UserBreak),
             R"#(Returns true if ProgressIndicator signals UserBreak)#" 
          )
        .def("Next",
             (Message_ProgressRange (Message_ProgressScope::*)( Standard_Real  ) ) static_cast<Message_ProgressRange (Message_ProgressScope::*)( Standard_Real  ) >(&Message_ProgressScope::Next),
             R"#(Advances position by specified step and returns the range covering this step)#"  , py::arg("theStep")
          )
        .def("Show",
             (void (Message_ProgressScope::*)() ) static_cast<void (Message_ProgressScope::*)() >(&Message_ProgressScope::Show),
             R"#(Force update of presentation of the progress indicator. Should not be called concurrently.)#" 
          )
        .def("Value",
             (Standard_Real (Message_ProgressScope::*)() const) static_cast<Standard_Real (Message_ProgressScope::*)() const>(&Message_ProgressScope::Value),
             R"#(Returns the current value of progress in this scope.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Message_Report from ./opencascade/Message_Report.hxx
    klass = m.attr("Message_Report");


    // nested enums

    static_cast<py::class_<Message_Report ,opencascade::handle<Message_Report>  , Standard_Transient >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("AddAlert",
             (void (Message_Report::*)( Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) ) static_cast<void (Message_Report::*)( Message_Gravity ,  const opencascade::handle<Message_Alert> &  ) >(&Message_Report::AddAlert),
             R"#(Add alert with specified gravity. This method is thread-safe, i.e. alerts can be added from parallel threads safely.)#"  , py::arg("theGravity"),  py::arg("theAlert")
          )
        .def("GetAlerts",
             (const Message_ListOfAlert & (Message_Report::*)( Message_Gravity  ) const) static_cast<const Message_ListOfAlert & (Message_Report::*)( Message_Gravity  ) const>(&Message_Report::GetAlerts),
             R"#(Returns list of collected alerts with specified gravity)#"  , py::arg("theGravity")
          )
        .def("HasAlert",
             (Standard_Boolean (Message_Report::*)( const opencascade::handle<Standard_Type> &  ) ) static_cast<Standard_Boolean (Message_Report::*)( const opencascade::handle<Standard_Type> &  ) >(&Message_Report::HasAlert),
             R"#(Returns true if specific type of alert is recorded)#"  , py::arg("theType")
          )
        .def("HasAlert",
             (Standard_Boolean (Message_Report::*)( const opencascade::handle<Standard_Type> & ,  Message_Gravity  ) ) static_cast<Standard_Boolean (Message_Report::*)( const opencascade::handle<Standard_Type> & ,  Message_Gravity  ) >(&Message_Report::HasAlert),
             R"#(Returns true if specific type of alert is recorded with specified gravity)#"  , py::arg("theType"),  py::arg("theGravity")
          )
        .def("IsActiveInMessenger",
             (Standard_Boolean (Message_Report::*)( const opencascade::handle<Message_Messenger> &  ) const) static_cast<Standard_Boolean (Message_Report::*)( const opencascade::handle<Message_Messenger> &  ) const>(&Message_Report::IsActiveInMessenger),
             R"#(Returns true if a report printer for the current report is registered in the messenger)#"  , py::arg("theMessenger")=static_cast<const opencascade::handle<Message_Messenger> &>(NULL)
          )
        .def("ActivateInMessenger",
             (void (Message_Report::*)( const Standard_Boolean ,  const opencascade::handle<Message_Messenger> &  ) ) static_cast<void (Message_Report::*)( const Standard_Boolean ,  const opencascade::handle<Message_Messenger> &  ) >(&Message_Report::ActivateInMessenger),
             R"#(Creates an instance of Message_PrinterToReport with the current report and register it in messenger)#"  , py::arg("toActivate"),  py::arg("theMessenger")=static_cast<const opencascade::handle<Message_Messenger> &>(NULL)
          )
        .def("UpdateActiveInMessenger",
             (void (Message_Report::*)( const opencascade::handle<Message_Messenger> &  ) ) static_cast<void (Message_Report::*)( const opencascade::handle<Message_Messenger> &  ) >(&Message_Report::UpdateActiveInMessenger),
             R"#(Updates internal flag IsActiveInMessenger. It becomes true if messenger contains at least one instance of Message_PrinterToReport.)#"  , py::arg("theMessenger")=static_cast<const opencascade::handle<Message_Messenger> &>(NULL)
          )
        .def("AddLevel",
             (void (Message_Report::*)( Message_Level * ,  const TCollection_AsciiString &  ) ) static_cast<void (Message_Report::*)( Message_Level * ,  const TCollection_AsciiString &  ) >(&Message_Report::AddLevel),
             R"#(Add new level of alerts)#"  , py::arg("theLevel"),  py::arg("theName")
          )
        .def("RemoveLevel",
             (void (Message_Report::*)( Message_Level *  ) ) static_cast<void (Message_Report::*)( Message_Level *  ) >(&Message_Report::RemoveLevel),
             R"#(Remove level of alerts)#"  , py::arg("theLevel")
          )
        .def("Clear",
             (void (Message_Report::*)() ) static_cast<void (Message_Report::*)() >(&Message_Report::Clear),
             R"#(Clears all collected alerts)#" 
          )
        .def("Clear",
             (void (Message_Report::*)( Message_Gravity  ) ) static_cast<void (Message_Report::*)( Message_Gravity  ) >(&Message_Report::Clear),
             R"#(Clears collected alerts with specified gravity)#"  , py::arg("theGravity")
          )
        .def("Clear",
             (void (Message_Report::*)( const opencascade::handle<Standard_Type> &  ) ) static_cast<void (Message_Report::*)( const opencascade::handle<Standard_Type> &  ) >(&Message_Report::Clear),
             R"#(Clears collected alerts with specified type)#"  , py::arg("theType")
          )
        .def("SetActiveMetric",
             (void (Message_Report::*)( const Message_MetricType ,  const Standard_Boolean  ) ) static_cast<void (Message_Report::*)( const Message_MetricType ,  const Standard_Boolean  ) >(&Message_Report::SetActiveMetric),
             R"#(Sets metrics to compute when alerts are performed)#"  , py::arg("theMetricType"),  py::arg("theActivate")
          )
        .def("ClearMetrics",
             (void (Message_Report::*)() ) static_cast<void (Message_Report::*)() >(&Message_Report::ClearMetrics),
             R"#(Removes all activated metrics)#" 
          )
        .def("Limit",
             (Standard_Integer (Message_Report::*)() const) static_cast<Standard_Integer (Message_Report::*)() const>(&Message_Report::Limit),
             R"#(Returns maximum number of collecting alerts. If the limit is achieved, first alert is removed, the new alert is added in the container.)#" 
          )
        .def("SetLimit",
             (void (Message_Report::*)( const Standard_Integer  ) ) static_cast<void (Message_Report::*)( const Standard_Integer  ) >(&Message_Report::SetLimit),
             R"#(Sets maximum number of collecting alerts.)#"  , py::arg("theLimit")
          )
        .def("Dump",
             (void (Message_Report::*)( std::ostream &  ) ) static_cast<void (Message_Report::*)( std::ostream &  ) >(&Message_Report::Dump),
             R"#(Dumps all collected alerts to stream)#"  , py::arg("theOS")
          )
        .def("Dump",
             (void (Message_Report::*)( std::ostream & ,  Message_Gravity  ) ) static_cast<void (Message_Report::*)( std::ostream & ,  Message_Gravity  ) >(&Message_Report::Dump),
             R"#(Dumps collected alerts with specified gravity to stream)#"  , py::arg("theOS"),  py::arg("theGravity")
          )
        .def("SendMessages",
             (void (Message_Report::*)( const opencascade::handle<Message_Messenger> &  ) ) static_cast<void (Message_Report::*)( const opencascade::handle<Message_Messenger> &  ) >(&Message_Report::SendMessages),
             R"#(Sends all collected alerts to messenger.)#"  , py::arg("theMessenger")
          )
        .def("SendMessages",
             (void (Message_Report::*)( const opencascade::handle<Message_Messenger> & ,  Message_Gravity  ) ) static_cast<void (Message_Report::*)( const opencascade::handle<Message_Messenger> & ,  Message_Gravity  ) >(&Message_Report::SendMessages),
             R"#(Dumps collected alerts with specified gravity to messenger. Default implementation creates Message_Msg object with a message key returned by alert, and sends it in the messenger.)#"  , py::arg("theMessenger"),  py::arg("theGravity")
          )
        .def("Merge",
             (void (Message_Report::*)( const opencascade::handle<Message_Report> &  ) ) static_cast<void (Message_Report::*)( const opencascade::handle<Message_Report> &  ) >(&Message_Report::Merge),
             R"#(Merges data from theOther report into this)#"  , py::arg("theOther")
          )
        .def("Merge",
             (void (Message_Report::*)( const opencascade::handle<Message_Report> & ,  Message_Gravity  ) ) static_cast<void (Message_Report::*)( const opencascade::handle<Message_Report> & ,  Message_Gravity  ) >(&Message_Report::Merge),
             R"#(Merges alerts with specified gravity from theOther report into this)#"  , py::arg("theOther"),  py::arg("theGravity")
          )
        .def("DumpJson",
             (void (Message_Report::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_Report::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_Report::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_Report::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_Report::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("ActiveMetrics",
             (const NCollection_IndexedMap<Message_MetricType> & (Message_Report::*)() const) static_cast<const NCollection_IndexedMap<Message_MetricType> & (Message_Report::*)() const>(&Message_Report::ActiveMetrics),
             R"#(Returns computed metrics when alerts are performed)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_Report::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_Report::*)() const>(&Message_Report::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_AlertExtended from ./opencascade/Message_AlertExtended.hxx
    klass = m.attr("Message_AlertExtended");


    // nested enums

    static_cast<py::class_<Message_AlertExtended ,opencascade::handle<Message_AlertExtended>  , Message_Alert >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("GetMessageKey",
             (Standard_CString (Message_AlertExtended::*)() const) static_cast<Standard_CString (Message_AlertExtended::*)() const>(&Message_AlertExtended::GetMessageKey),
             R"#(Return a C string to be used as a key for generating text user messages describing this alert. The messages are generated with help of Message_Msg class, in Message_Report::Dump(). Base implementation returns dynamic type name of the instance.)#" 
          )
        .def("SetAttribute",
             (void (Message_AlertExtended::*)( const opencascade::handle<Message_Attribute> &  ) ) static_cast<void (Message_AlertExtended::*)( const opencascade::handle<Message_Attribute> &  ) >(&Message_AlertExtended::SetAttribute),
             R"#(Sets container of the alert attributes)#"  , py::arg("theAttribute")
          )
        .def("CompositeAlerts",
             (opencascade::handle<Message_CompositeAlerts> (Message_AlertExtended::*)( const Standard_Boolean  ) ) static_cast<opencascade::handle<Message_CompositeAlerts> (Message_AlertExtended::*)( const Standard_Boolean  ) >(&Message_AlertExtended::CompositeAlerts),
             R"#(Returns class provided hierarchy of alerts if created or create if the parameter is true)#"  , py::arg("theToCreate")=static_cast<const Standard_Boolean>(Standard_False)
          )
        .def("SupportsMerge",
             (Standard_Boolean (Message_AlertExtended::*)() const) static_cast<Standard_Boolean (Message_AlertExtended::*)() const>(&Message_AlertExtended::SupportsMerge),
             R"#(Return true if this type of alert can be merged with other of the same type to avoid duplication. Hierarchical alerts can not be merged Basis implementation returns true.)#" 
          )
        .def("Merge",
             (Standard_Boolean (Message_AlertExtended::*)( const opencascade::handle<Message_Alert> &  ) ) static_cast<Standard_Boolean (Message_AlertExtended::*)( const opencascade::handle<Message_Alert> &  ) >(&Message_AlertExtended::Merge),
             R"#(If possible, merge data contained in this alert to theTarget. Base implementation always returns false.)#"  , py::arg("theTarget")
          )
        .def("DumpJson",
             (void (Message_AlertExtended::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_AlertExtended::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_AlertExtended::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("AddAlert_s",
                    (opencascade::handle<Message_Alert> (*)( const opencascade::handle<Message_Report> & ,  const opencascade::handle<Message_Attribute> & ,  const Message_Gravity  ) ) static_cast<opencascade::handle<Message_Alert> (*)( const opencascade::handle<Message_Report> & ,  const opencascade::handle<Message_Attribute> & ,  const Message_Gravity  ) >(&Message_AlertExtended::AddAlert),
                    R"#(Creates new instance of the alert and put it into report with Message_Info gravity. It does nothing if such kind of gravity is not active in the report)#"  , py::arg("theReport"),  py::arg("theAttribute"),  py::arg("theGravity")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_AlertExtended::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_AlertExtended::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("Attribute",
             (const opencascade::handle<Message_Attribute> & (Message_AlertExtended::*)() const) static_cast<const opencascade::handle<Message_Attribute> & (Message_AlertExtended::*)() const>(&Message_AlertExtended::Attribute),
             R"#(Returns container of the alert attributes)#"
             
         )
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_AlertExtended::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_AlertExtended::*)() const>(&Message_AlertExtended::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_AttributeMeter from ./opencascade/Message_AttributeMeter.hxx
    klass = m.attr("Message_AttributeMeter");


    // nested enums

    static_cast<py::class_<Message_AttributeMeter ,opencascade::handle<Message_AttributeMeter>  , Message_Attribute >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString & >()  , py::arg("theName")=static_cast<const TCollection_AsciiString &>(TCollection_AsciiString ( )) )
    // custom constructors
    // methods
        .def("HasMetric",
             (Standard_Boolean (Message_AttributeMeter::*)( const Message_MetricType &  ) const) static_cast<Standard_Boolean (Message_AttributeMeter::*)( const Message_MetricType &  ) const>(&Message_AttributeMeter::HasMetric),
             R"#(Checks whether the attribute has values for the metric)#"  , py::arg("theMetric")
          )
        .def("IsMetricValid",
             (Standard_Boolean (Message_AttributeMeter::*)( const Message_MetricType &  ) const) static_cast<Standard_Boolean (Message_AttributeMeter::*)( const Message_MetricType &  ) const>(&Message_AttributeMeter::IsMetricValid),
             R"#(Returns true when both values of the metric are set.)#"  , py::arg("theMetric")
          )
        .def("StartValue",
             (Standard_Real (Message_AttributeMeter::*)( const Message_MetricType &  ) const) static_cast<Standard_Real (Message_AttributeMeter::*)( const Message_MetricType &  ) const>(&Message_AttributeMeter::StartValue),
             R"#(Returns start value for the metric)#"  , py::arg("theMetric")
          )
        .def("SetStartValue",
             (void (Message_AttributeMeter::*)( const Message_MetricType & ,  const Standard_Real  ) ) static_cast<void (Message_AttributeMeter::*)( const Message_MetricType & ,  const Standard_Real  ) >(&Message_AttributeMeter::SetStartValue),
             R"#(Sets start values for the metric)#"  , py::arg("theMetric"),  py::arg("theValue")
          )
        .def("StopValue",
             (Standard_Real (Message_AttributeMeter::*)( const Message_MetricType &  ) const) static_cast<Standard_Real (Message_AttributeMeter::*)( const Message_MetricType &  ) const>(&Message_AttributeMeter::StopValue),
             R"#(Returns stop value for the metric)#"  , py::arg("theMetric")
          )
        .def("SetStopValue",
             (void (Message_AttributeMeter::*)( const Message_MetricType & ,  const Standard_Real  ) ) static_cast<void (Message_AttributeMeter::*)( const Message_MetricType & ,  const Standard_Real  ) >(&Message_AttributeMeter::SetStopValue),
             R"#(Sets stop values for the metric)#"  , py::arg("theMetric"),  py::arg("theValue")
          )
        .def("DumpJson",
             (void (Message_AttributeMeter::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_AttributeMeter::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_AttributeMeter::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("UndefinedMetricValue_s",
                    (Standard_Real (*)() ) static_cast<Standard_Real (*)() >(&Message_AttributeMeter::UndefinedMetricValue),
                    R"#(Returns default value of the metric when it is not defined)#" 
          )
        .def_static("StartAlert_s",
                    (void (*)( const opencascade::handle<Message_AlertExtended> &  ) ) static_cast<void (*)( const opencascade::handle<Message_AlertExtended> &  ) >(&Message_AttributeMeter::StartAlert),
                    R"#(Sets start values of default report metrics into the alert)#"  , py::arg("theAlert")
          )
        .def_static("StopAlert_s",
                    (void (*)( const opencascade::handle<Message_AlertExtended> &  ) ) static_cast<void (*)( const opencascade::handle<Message_AlertExtended> &  ) >(&Message_AttributeMeter::StopAlert),
                    R"#(Sets stop values of default report metrics into the alert)#"  , py::arg("theAlert")
          )
        .def_static("SetAlertMetrics_s",
                    (void (*)( const opencascade::handle<Message_AlertExtended> & ,  const Standard_Boolean  ) ) static_cast<void (*)( const opencascade::handle<Message_AlertExtended> & ,  const Standard_Boolean  ) >(&Message_AttributeMeter::SetAlertMetrics),
                    R"#(Sets current values of default report metrics into the alert. Processed only alert with Message_AttributeMeter attribute)#"  , py::arg("theAlert"),  py::arg("theStartValue")
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_AttributeMeter::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_AttributeMeter::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_AttributeMeter::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_AttributeMeter::*)() const>(&Message_AttributeMeter::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_AttributeObject from ./opencascade/Message_AttributeObject.hxx
    klass = m.attr("Message_AttributeObject");


    // nested enums

    static_cast<py::class_<Message_AttributeObject ,opencascade::handle<Message_AttributeObject>  , Message_Attribute >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Standard_Transient> &,const TCollection_AsciiString & >()  , py::arg("theObject"),  py::arg("theName")=static_cast<const TCollection_AsciiString &>(TCollection_AsciiString ( )) )
    // custom constructors
    // methods
        .def("SetObject",
             (void (Message_AttributeObject::*)( const opencascade::handle<Standard_Transient> &  ) ) static_cast<void (Message_AttributeObject::*)( const opencascade::handle<Standard_Transient> &  ) >(&Message_AttributeObject::SetObject),
             R"#(Sets the object)#"  , py::arg("theObject")
          )
        .def("DumpJson",
             (void (Message_AttributeObject::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_AttributeObject::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_AttributeObject::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_AttributeObject::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_AttributeObject::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_AttributeObject::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_AttributeObject::*)() const>(&Message_AttributeObject::DynamicType),
             R"#(None)#"
             
         )
       .def("Object",
             (const opencascade::handle<Standard_Transient> & (Message_AttributeObject::*)() const) static_cast<const opencascade::handle<Standard_Transient> & (Message_AttributeObject::*)() const>(&Message_AttributeObject::Object),
             R"#(Returns object)#"
             
         )
;

    // Class Message_AttributeStream from ./opencascade/Message_AttributeStream.hxx
    klass = m.attr("Message_AttributeStream");


    // nested enums

    static_cast<py::class_<Message_AttributeStream ,opencascade::handle<Message_AttributeStream>  , Message_Attribute >>(klass)
    // constructors
        .def(py::init<  const std::stringstream &,const TCollection_AsciiString & >()  , py::arg("theStream"),  py::arg("theName")=static_cast<const TCollection_AsciiString &>(TCollection_AsciiString ( )) )
    // custom constructors
    // methods
        .def("SetStream",
             (void (Message_AttributeStream::*)(  const std::stringstream &  ) ) static_cast<void (Message_AttributeStream::*)(  const std::stringstream &  ) >(&Message_AttributeStream::SetStream),
             R"#(Sets stream value)#"  , py::arg("theStream")
          )
        .def("DumpJson",
             (void (Message_AttributeStream::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Message_AttributeStream::*)( std::ostream & ,  Standard_Integer  ) const>(&Message_AttributeStream::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_AttributeStream::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_AttributeStream::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_AttributeStream::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_AttributeStream::*)() const>(&Message_AttributeStream::DynamicType),
             R"#(None)#"
             
         )
       .def("Stream",
             (const Standard_SStream & (Message_AttributeStream::*)() const) static_cast<const Standard_SStream & (Message_AttributeStream::*)() const>(&Message_AttributeStream::Stream),
             R"#(Returns stream value)#"
             
         )
;

    // Class Message_PrinterOStream from ./opencascade/Message_PrinterOStream.hxx
    klass = m.attr("Message_PrinterOStream");


    // nested enums

    static_cast<py::class_<Message_PrinterOStream ,opencascade::handle<Message_PrinterOStream>  , Message_Printer >>(klass)
    // constructors
        .def(py::init< const Message_Gravity >()  , py::arg("theTraceLevel")=static_cast<const Message_Gravity>(Message_Info) )
        .def(py::init< const Standard_CString,const Standard_Boolean,const Message_Gravity >()  , py::arg("theFileName"),  py::arg("theDoAppend"),  py::arg("theTraceLevel")=static_cast<const Message_Gravity>(Message_Info) )
    // custom constructors
    // methods
        .def("Close",
             (void (Message_PrinterOStream::*)() ) static_cast<void (Message_PrinterOStream::*)() >(&Message_PrinterOStream::Close),
             R"#(Flushes the output stream and destroys it if it has been specified externally with option doFree (or if it is internal file stream))#" 
          )
        .def("ToColorize",
             (Standard_Boolean (Message_PrinterOStream::*)() const) static_cast<Standard_Boolean (Message_PrinterOStream::*)() const>(&Message_PrinterOStream::ToColorize),
             R"#(Returns TRUE if text output into console should be colorized depending on message gravity; TRUE by default.)#" 
          )
        .def("SetToColorize",
             (void (Message_PrinterOStream::*)( Standard_Boolean  ) ) static_cast<void (Message_PrinterOStream::*)( Standard_Boolean  ) >(&Message_PrinterOStream::SetToColorize),
             R"#(Set if text output into console should be colorized depending on message gravity.)#"  , py::arg("theToColorize")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_PrinterOStream::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_PrinterOStream::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("SetConsoleTextColor_s",
                    (void (*)( std::ostream * ,  Message_ConsoleColor ,  bool  ) ) static_cast<void (*)( std::ostream * ,  Message_ConsoleColor ,  bool  ) >(&Message_PrinterOStream::SetConsoleTextColor),
                    R"#(Setup console text color.)#"  , py::arg("theOStream"),  py::arg("theTextColor"),  py::arg("theIsIntenseText")=static_cast<bool>(false)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_PrinterOStream::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_PrinterOStream::*)() const>(&Message_PrinterOStream::DynamicType),
             R"#(None)#"
             
         )
       .def("GetStream",
             (Standard_OStream & (Message_PrinterOStream::*)() const) static_cast<Standard_OStream & (Message_PrinterOStream::*)() const>(&Message_PrinterOStream::GetStream),
             R"#(Returns reference to the output stream)#"
             
             , py::return_value_policy::reference_internal
         )
;

    // Class Message_PrinterSystemLog from ./opencascade/Message_PrinterSystemLog.hxx
    klass = m.attr("Message_PrinterSystemLog");


    // nested enums

    static_cast<py::class_<Message_PrinterSystemLog ,opencascade::handle<Message_PrinterSystemLog>  , Message_Printer >>(klass)
    // constructors
        .def(py::init< const TCollection_AsciiString &,const Message_Gravity >()  , py::arg("theEventSourceName"),  py::arg("theTraceLevel")=static_cast<const Message_Gravity>(Message_Info) )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_PrinterSystemLog::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_PrinterSystemLog::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_PrinterSystemLog::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_PrinterSystemLog::*)() const>(&Message_PrinterSystemLog::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Message_PrinterToReport from ./opencascade/Message_PrinterToReport.hxx
    klass = m.attr("Message_PrinterToReport");


    // nested enums

    static_cast<py::class_<Message_PrinterToReport ,opencascade::handle<Message_PrinterToReport>  , Message_Printer >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetReport",
             (void (Message_PrinterToReport::*)( const opencascade::handle<Message_Report> &  ) ) static_cast<void (Message_PrinterToReport::*)( const opencascade::handle<Message_Report> &  ) >(&Message_PrinterToReport::SetReport),
             R"#(Sets the printer report)#"  , py::arg("theReport")
          )
        .def("SendStringStream",
             (void (Message_PrinterToReport::*)(  const std::stringstream & ,  const Message_Gravity  ) const) static_cast<void (Message_PrinterToReport::*)(  const std::stringstream & ,  const Message_Gravity  ) const>(&Message_PrinterToReport::SendStringStream),
             R"#(Send a string message with specified trace level. Stream is converted to string value. Default implementation calls first method Send().)#"  , py::arg("theStream"),  py::arg("theGravity")
          )
        .def("SendObject",
             (void (Message_PrinterToReport::*)( const opencascade::handle<Standard_Transient> & ,  const Message_Gravity  ) const) static_cast<void (Message_PrinterToReport::*)( const opencascade::handle<Standard_Transient> & ,  const Message_Gravity  ) const>(&Message_PrinterToReport::SendObject),
             R"#(Send a string message with specified trace level. The object is converted to string in format: <object kind> : <object pointer>. The parameter theToPutEol specified whether end-of-line should be added to the end of the message. Default implementation calls first method Send().)#"  , py::arg("theObject"),  py::arg("theGravity")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Message_PrinterToReport::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Message_PrinterToReport::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Message_PrinterToReport::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Message_PrinterToReport::*)() const>(&Message_PrinterToReport::DynamicType),
             R"#(None)#"
             
         )
       .def("Report",
             (const opencascade::handle<Message_Report> & (Message_PrinterToReport::*)() const) static_cast<const opencascade::handle<Message_Report> & (Message_PrinterToReport::*)() const>(&Message_PrinterToReport::Report),
             R"#(Returns the current or default report)#"
             
         )
;

    // Class Message_ProgressSentry from ./opencascade/Message_ProgressSentry.hxx
    klass = m.attr("Message_ProgressSentry");


    // nested enums

    static_cast<py::class_<Message_ProgressSentry , shared_ptr<Message_ProgressSentry>  , Message_ProgressScope >>(klass)
    // constructors
        .def(py::init< const Message_ProgressRange &,const Standard_CString,const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Boolean,const Standard_Real >()  , py::arg("theRange"),  py::arg("theName"),  py::arg("theMin"),  py::arg("theMax"),  py::arg("theStep"),  py::arg("theIsInf")=static_cast<const Standard_Boolean>(Standard_False),  py::arg("theNewScopeSpan")=static_cast<const Standard_Real>(0.0) )
    // custom constructors
    // methods
        .def("Relieve",
             (void (Message_ProgressSentry::*)() ) static_cast<void (Message_ProgressSentry::*)() >(&Message_ProgressSentry::Relieve),
             R"#(Method Relieve() was replaced by Close() in Message_ProgressScope)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/Message.hxx
// ./opencascade/Message_Alert.hxx
// ./opencascade/Message_AlertExtended.hxx
// ./opencascade/Message_Algorithm.hxx
// ./opencascade/Message_Attribute.hxx
// ./opencascade/Message_AttributeMeter.hxx
// ./opencascade/Message_AttributeObject.hxx
// ./opencascade/Message_AttributeStream.hxx
// ./opencascade/Message_CompositeAlerts.hxx
// ./opencascade/Message_ConsoleColor.hxx
// ./opencascade/Message_ExecStatus.hxx
// ./opencascade/Message_Gravity.hxx
// ./opencascade/Message_HArrayOfMsg.hxx
// ./opencascade/Message_LazyProgressScope.hxx
// ./opencascade/Message_Level.hxx
// ./opencascade/Message_ListIteratorOfListOfMsg.hxx
// ./opencascade/Message_ListOfAlert.hxx
// ./opencascade/Message_ListOfMsg.hxx
// ./opencascade/Message_Messenger.hxx
// ./opencascade/Message_MetricType.hxx
// ./opencascade/Message_Msg.hxx
// ./opencascade/Message_MsgFile.hxx
// ./opencascade/Message_Printer.hxx
// ./opencascade/Message_PrinterOStream.hxx
// ./opencascade/Message_PrinterSystemLog.hxx
// ./opencascade/Message_PrinterToReport.hxx
// ./opencascade/Message_ProgressIndicator.hxx
// ./opencascade/Message_ProgressRange.hxx
// ./opencascade/Message_ProgressScope.hxx
// ./opencascade/Message_ProgressSentry.hxx
// ./opencascade/Message_Report.hxx
// ./opencascade/Message_SequenceOfPrinters.hxx
// ./opencascade/Message_Status.hxx
// ./opencascade/Message_StatusType.hxx

// Additional functions

// operators

// register typdefs
    register_template_NCollection_Array1<NCollection_Handle<Message_Msg>>(m,"Message_ArrayOfMsg");
    register_template_NCollection_List<opencascade::handle<Message_Alert>>(m,"Message_ListOfAlert");
    register_template_NCollection_List<Message_Msg>(m,"Message_ListOfMsg");
    register_template_NCollection_Sequence<opencascade::handle<Message_Printer>>(m,"Message_SequenceOfPrinters");


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
