# Description

A clear and concise description of your changes.

## Motivation and Context

Why is this change required?  What problem does it solve?

## Related Issue

Except for trivial changes like correcting typos, this project only
accepts pull requests related to open issues.  If suggesting a new
feature or change, please discuss it in an issue first.  If fixing a
bug, there should be an issue describing the bug, with steps to
reproduce.

Please link to the issue here: https://github.com/tkem/cachetools/issues/###

## Has this been tested and documented?

This project uses [tox](https://tox.wiki) for test automization.
Before submitting a pull request, run `tox` in the project's root and
make sure all tests are passing.

When adding new features or code not already covered by existing unit
tests, please also add some tests covering your changes under the
`tests` directory.  For new features, please consider adding to the
existing documentation under the `docs` directory.
