
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <gl.h>
#include <device.h>

#include "fdefs.h"

int gx_smrv3(vstruct,num_vert,fmat)
VERTEX_STRUCT vstruct[];
int num_vert;
float fmat[][3];
{
	int i,iptr;
	float ka,kd,ks;
	float mt[20];
	float r,g,b;
	float ns;

	ka = fmat[KCO][0];
	kd = fmat[KCO][1];
	ks = fmat[KCO][2];

	ns = fmat[NSV][0];

	for(i=0; i<num_vert; i++){
		iptr = 0;

		r = (float)vstruct[i].cv[0] / 255.0;
		g = (float)vstruct[i].cv[1] / 255.0;
		b = (float)vstruct[i].cv[2] / 255.0;

		mt[iptr++] = (float)SPECULAR;

		mt[iptr++] = ks * fmat[LCO][0];
		mt[iptr++] = ks * fmat[LCO][1];
		mt[iptr++] = ks * fmat[LCO][2];
/*
		mt[iptr++] = ks * r;
		mt[iptr++] = ks * g;
		mt[iptr++] = ks * b;
*/
		mt[iptr++] = (float)DIFFUSE;
		mt[iptr++] = kd * r;
		mt[iptr++] = kd * g;
		mt[iptr++] = kd * b;
		mt[iptr++] = (float)SHININESS;
		mt[iptr++] = ns;
		mt[iptr++] = (float)AMBIENT;
		mt[iptr++] = ka * r;
		mt[iptr++] = ka * g;
		mt[iptr++] = ka * b;
		mt[iptr++] = LMNULL;
		lmdef(DEFMATERIAL, i + 1, iptr, mt);
	}

	return(0);
}
