
/*****************************************************************************
* 
* The following source code is in the public domain.
* Specifically, we give to the public domain all rights for future licensing
* of the source code, all resale rights, and all publishing rights.
* 
* We ask, but do not require, that the following message be included in all
* derived works:
* 
* Portions developed at the National Center for Supercomputing Applications at
* the University of Illinois at Urbana-Champaign.
* 
* THE UNIVERSITY OF ILLINOIS GIVES NO WARRANTY, EXPRESSED OR IMPLIED, FOR THE
* SOFTWARE AND/OR DOCUMENTATION PROVIDED, INCLUDING, WITHOUT LIMITATION,
* WARRANTY OF MERCHANTABILITY AND WARRANTY OF FITNESS FOR A PARTICULAR PURPOSE
* 
****************************************************************************/

#include <math.h>

#include "fdefs.h"

int gx_pnorm(vstruct,pstruct,rlist,num_vert,num_poly)
VERTEX_STRUCT vstruct[];
POLY_STRUCT pstruct[];
int rlist[];
int num_vert,num_poly;
{
	float x1,y1,z1,x2,y2,z2,x3,y3,z3;
	float x21,y21,z21,x32,y32,z32;
	float a,b,c,nval,rnorm;
	int i;
	int vi,vr1,vr2,vr3;

	for(i=0; i<num_poly; i++){
		vi = pstruct[i].vs;	
		vr1 = rlist[vi++];
		vr2 = rlist[vi++];
		vr3 = rlist[vi];

		x1 = vstruct[vr1].v[0];
		y1 = vstruct[vr1].v[1];
		z1 = vstruct[vr1].v[2];
		x2 = vstruct[vr2].v[0];
		y2 = vstruct[vr2].v[1];
		z2 = vstruct[vr2].v[2];
		x3 = vstruct[vr3].v[0];
		y3 = vstruct[vr3].v[1];
		z3 = vstruct[vr3].v[2];

        	x21 = x2 - x1;
        	y21 = y2 - y1;
        	z21 = z2 - z1;

        	x32 = x3 - x2;
        	y32 = y3 - y2;
        	z32 = z3 - z2;

        	a = (y21 * z32) - (y32 * z21);
        	b = (x32 * z21) - (x21 * z32);
        	c = (x21 * y32) - (x32 * y21);
		nval = ((a * a) + (b * b) + (c * c));
		rnorm = fsqrt( nval );

		pstruct[i].np[0] = -a / rnorm;
		pstruct[i].np[1] = -b / rnorm;
		pstruct[i].np[2] = -c / rnorm;
	}

	return(0);
}
