/* Fast GF(2^m) library routines */
/*
  Copyright (c) by Declan Malone 2009.
  Licensed under the terms of the GNU General Public License and
  the GNU Lesser (Library) General Public License.
*/

#include <stdio.h>
#include <stdlib.h>
#include "FastGF2.h"

static const gf2_u8  poly_u8  = 0x1b;
static const gf2_u16 poly_u16 = 0x2b;
static const gf2_u32 poly_u32 = 0x8d;

static const gf2_s16 fast_gf2_log[] = {
  -256, 255, 25, 1, 50, 2, 26, 198,
  75, 199, 27, 104, 51, 238, 223, 3,
  100, 4, 224, 14, 52, 141, 129, 239,
  76, 113, 8, 200, 248, 105, 28, 193,
  125, 194, 29, 181, 249, 185, 39, 106,
  77, 228, 166, 114, 154, 201, 9, 120,
  101, 47, 138, 5, 33, 15, 225, 36,
  18, 240, 130, 69, 53, 147, 218, 142,
  150, 143, 219, 189, 54, 208, 206, 148,
  19, 92, 210, 241, 64, 70, 131, 56,
  102, 221, 253, 48, 191, 6, 139, 98,
  179, 37, 226, 152, 34, 136, 145, 16,
  126, 110, 72, 195, 163, 182, 30, 66,
  58, 107, 40, 84, 250, 133, 61, 186,
  43, 121, 10, 21, 155, 159, 94, 202,
  78, 212, 172, 229, 243, 115, 167, 87,
  175, 88, 168, 80, 244, 234, 214, 116,
  79, 174, 233, 213, 231, 230, 173, 232,
  44, 215, 117, 122, 235, 22, 11, 245,
  89, 203, 95, 176, 156, 169, 81, 160,
  127, 12, 246, 111, 23, 196, 73, 236,
  216, 67, 31, 45, 164, 118, 123, 183,
  204, 187, 62, 90, 251, 96, 177, 134,
  59, 82, 161, 108, 170, 85, 41, 157,
  151, 178, 135, 144, 97, 190, 220, 252,
  188, 149, 207, 205, 55, 63, 91, 209,
  83, 57, 132, 60, 65, 162, 109, 71,
  20, 42, 158, 93, 86, 242, 211, 171,
  68, 17, 146, 217, 35, 32, 46, 137,
  180, 124, 184, 38, 119, 153, 227, 165,
  103, 74, 237, 222, 197, 49, 254, 24,
  13, 99, 140, 128, 192, 247, 112, 7,
};

static const gf2_u8 fast_gf2_exp[] = {
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  1, 3, 5, 15, 17, 51, 85, 255,
  26, 46, 114, 150, 161, 248, 19, 53,
  95, 225, 56, 72, 216, 115, 149, 164,
  247, 2, 6, 10, 30, 34, 102, 170,
  229, 52, 92, 228, 55, 89, 235, 38,
  106, 190, 217, 112, 144, 171, 230, 49,
  83, 245, 4, 12, 20, 60, 68, 204,
  79, 209, 104, 184, 211, 110, 178, 205,
  76, 212, 103, 169, 224, 59, 77, 215,
  98, 166, 241, 8, 24, 40, 120, 136,
  131, 158, 185, 208, 107, 189, 220, 127,
  129, 152, 179, 206, 73, 219, 118, 154,
  181, 196, 87, 249, 16, 48, 80, 240,
  11, 29, 39, 105, 187, 214, 97, 163,
  254, 25, 43, 125, 135, 146, 173, 236,
  47, 113, 147, 174, 233, 32, 96, 160,
  251, 22, 58, 78, 210, 109, 183, 194,
  93, 231, 50, 86, 250, 21, 63, 65,
  195, 94, 226, 61, 71, 201, 64, 192,
  91, 237, 44, 116, 156, 191, 218, 117,
  159, 186, 213, 100, 172, 239, 42, 126,
  130, 157, 188, 223, 122, 142, 137, 128,
  155, 182, 193, 88, 232, 35, 101, 175,
  234, 37, 111, 177, 200, 67, 197, 84,
  252, 31, 33, 99, 165, 244, 7, 9,
  27, 45, 119, 153, 176, 203, 70, 202,
  69, 207, 74, 222, 121, 139, 134, 145,
  168, 227, 62, 66, 198, 81, 243, 14,
  18, 54, 90, 238, 41, 123, 141, 140,
  143, 138, 133, 148, 167, 242, 13, 23,
  57, 75, 221, 124, 132, 151, 162, 253,
  28, 36, 108, 180, 199, 82, 246, 1,
  3, 5, 15, 17, 51, 85, 255, 26,
  46, 114, 150, 161, 248, 19, 53, 95,
  225, 56, 72, 216, 115, 149, 164, 247,
  2, 6, 10, 30, 34, 102, 170, 229,
  52, 92, 228, 55, 89, 235, 38, 106,
  190, 217, 112, 144, 171, 230, 49, 83,
  245, 4, 12, 20, 60, 68, 204, 79,
  209, 104, 184, 211, 110, 178, 205, 76,
  212, 103, 169, 224, 59, 77, 215, 98,
  166, 241, 8, 24, 40, 120, 136, 131,
  158, 185, 208, 107, 189, 220, 127, 129,
  152, 179, 206, 73, 219, 118, 154, 181,
  196, 87, 249, 16, 48, 80, 240, 11,
  29, 39, 105, 187, 214, 97, 163, 254,
  25, 43, 125, 135, 146, 173, 236, 47,
  113, 147, 174, 233, 32, 96, 160, 251,
  22, 58, 78, 210, 109, 183, 194, 93,
  231, 50, 86, 250, 21, 63, 65, 195,
  94, 226, 61, 71, 201, 64, 192, 91,
  237, 44, 116, 156, 191, 218, 117, 159,
  186, 213, 100, 172, 239, 42, 126, 130,
  157, 188, 223, 122, 142, 137, 128, 155,
  182, 193, 88, 232, 35, 101, 175, 234,
  37, 111, 177, 200, 67, 197, 84, 252,
  31, 33, 99, 165, 244, 7, 9, 27,
  45, 119, 153, 176, 203, 70, 202, 69,
  207, 74, 222, 121, 139, 134, 145, 168,
  227, 62, 66, 198, 81, 243, 14, 18,
  54, 90, 238, 41, 123, 141, 140, 143,
  138, 133, 148, 167, 242, 13, 23, 57,
  75, 221, 124, 132, 151, 162, 253, 28,
  36, 108, 180, 199, 82, 246, 1, 0,
  /* The following are needed to make 1/0 = 0 on some platforms */
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
};

static const gf2_u16 fast_gf2_lmul[] = {
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 16, 32, 48, 64, 80, 96, 112,
  128, 144, 160, 176, 192, 208, 224, 240,
  256, 272, 288, 304, 320, 336, 352, 368,
  384, 400, 416, 432, 448, 464, 480, 496,
  512, 528, 544, 560, 576, 592, 608, 624,
  640, 656, 672, 688, 704, 720, 736, 752,
  768, 784, 800, 816, 832, 848, 864, 880,
  896, 912, 928, 944, 960, 976, 992, 1008,
  1024, 1040, 1056, 1072, 1088, 1104, 1120, 1136,
  1152, 1168, 1184, 1200, 1216, 1232, 1248, 1264,
  1280, 1296, 1312, 1328, 1344, 1360, 1376, 1392,
  1408, 1424, 1440, 1456, 1472, 1488, 1504, 1520,
  1536, 1552, 1568, 1584, 1600, 1616, 1632, 1648,
  1664, 1680, 1696, 1712, 1728, 1744, 1760, 1776,
  1792, 1808, 1824, 1840, 1856, 1872, 1888, 1904,
  1920, 1936, 1952, 1968, 1984, 2000, 2016, 2032,
  2048, 2064, 2080, 2096, 2112, 2128, 2144, 2160,
  2176, 2192, 2208, 2224, 2240, 2256, 2272, 2288,
  2304, 2320, 2336, 2352, 2368, 2384, 2400, 2416,
  2432, 2448, 2464, 2480, 2496, 2512, 2528, 2544,
  2560, 2576, 2592, 2608, 2624, 2640, 2656, 2672,
  2688, 2704, 2720, 2736, 2752, 2768, 2784, 2800,
  2816, 2832, 2848, 2864, 2880, 2896, 2912, 2928,
  2944, 2960, 2976, 2992, 3008, 3024, 3040, 3056,
  3072, 3088, 3104, 3120, 3136, 3152, 3168, 3184,
  3200, 3216, 3232, 3248, 3264, 3280, 3296, 3312,
  3328, 3344, 3360, 3376, 3392, 3408, 3424, 3440,
  3456, 3472, 3488, 3504, 3520, 3536, 3552, 3568,
  3584, 3600, 3616, 3632, 3648, 3664, 3680, 3696,
  3712, 3728, 3744, 3760, 3776, 3792, 3808, 3824,
  3840, 3856, 3872, 3888, 3904, 3920, 3936, 3952,
  3968, 3984, 4000, 4016, 4032, 4048, 4064, 4080,
  0, 32, 64, 96, 128, 160, 192, 224,
  256, 288, 320, 352, 384, 416, 448, 480,
  512, 544, 576, 608, 640, 672, 704, 736,
  768, 800, 832, 864, 896, 928, 960, 992,
  1024, 1056, 1088, 1120, 1152, 1184, 1216, 1248,
  1280, 1312, 1344, 1376, 1408, 1440, 1472, 1504,
  1536, 1568, 1600, 1632, 1664, 1696, 1728, 1760,
  1792, 1824, 1856, 1888, 1920, 1952, 1984, 2016,
  2048, 2080, 2112, 2144, 2176, 2208, 2240, 2272,
  2304, 2336, 2368, 2400, 2432, 2464, 2496, 2528,
  2560, 2592, 2624, 2656, 2688, 2720, 2752, 2784,
  2816, 2848, 2880, 2912, 2944, 2976, 3008, 3040,
  3072, 3104, 3136, 3168, 3200, 3232, 3264, 3296,
  3328, 3360, 3392, 3424, 3456, 3488, 3520, 3552,
  3584, 3616, 3648, 3680, 3712, 3744, 3776, 3808,
  3840, 3872, 3904, 3936, 3968, 4000, 4032, 4064,
  4096, 4128, 4160, 4192, 4224, 4256, 4288, 4320,
  4352, 4384, 4416, 4448, 4480, 4512, 4544, 4576,
  4608, 4640, 4672, 4704, 4736, 4768, 4800, 4832,
  4864, 4896, 4928, 4960, 4992, 5024, 5056, 5088,
  5120, 5152, 5184, 5216, 5248, 5280, 5312, 5344,
  5376, 5408, 5440, 5472, 5504, 5536, 5568, 5600,
  5632, 5664, 5696, 5728, 5760, 5792, 5824, 5856,
  5888, 5920, 5952, 5984, 6016, 6048, 6080, 6112,
  6144, 6176, 6208, 6240, 6272, 6304, 6336, 6368,
  6400, 6432, 6464, 6496, 6528, 6560, 6592, 6624,
  6656, 6688, 6720, 6752, 6784, 6816, 6848, 6880,
  6912, 6944, 6976, 7008, 7040, 7072, 7104, 7136,
  7168, 7200, 7232, 7264, 7296, 7328, 7360, 7392,
  7424, 7456, 7488, 7520, 7552, 7584, 7616, 7648,
  7680, 7712, 7744, 7776, 7808, 7840, 7872, 7904,
  7936, 7968, 8000, 8032, 8064, 8096, 8128, 8160,
  0, 48, 96, 80, 192, 240, 160, 144,
  384, 432, 480, 464, 320, 368, 288, 272,
  768, 816, 864, 848, 960, 1008, 928, 912,
  640, 688, 736, 720, 576, 624, 544, 528,
  1536, 1584, 1632, 1616, 1728, 1776, 1696, 1680,
  1920, 1968, 2016, 2000, 1856, 1904, 1824, 1808,
  1280, 1328, 1376, 1360, 1472, 1520, 1440, 1424,
  1152, 1200, 1248, 1232, 1088, 1136, 1056, 1040,
  3072, 3120, 3168, 3152, 3264, 3312, 3232, 3216,
  3456, 3504, 3552, 3536, 3392, 3440, 3360, 3344,
  3840, 3888, 3936, 3920, 4032, 4080, 4000, 3984,
  3712, 3760, 3808, 3792, 3648, 3696, 3616, 3600,
  2560, 2608, 2656, 2640, 2752, 2800, 2720, 2704,
  2944, 2992, 3040, 3024, 2880, 2928, 2848, 2832,
  2304, 2352, 2400, 2384, 2496, 2544, 2464, 2448,
  2176, 2224, 2272, 2256, 2112, 2160, 2080, 2064,
  6144, 6192, 6240, 6224, 6336, 6384, 6304, 6288,
  6528, 6576, 6624, 6608, 6464, 6512, 6432, 6416,
  6912, 6960, 7008, 6992, 7104, 7152, 7072, 7056,
  6784, 6832, 6880, 6864, 6720, 6768, 6688, 6672,
  7680, 7728, 7776, 7760, 7872, 7920, 7840, 7824,
  8064, 8112, 8160, 8144, 8000, 8048, 7968, 7952,
  7424, 7472, 7520, 7504, 7616, 7664, 7584, 7568,
  7296, 7344, 7392, 7376, 7232, 7280, 7200, 7184,
  5120, 5168, 5216, 5200, 5312, 5360, 5280, 5264,
  5504, 5552, 5600, 5584, 5440, 5488, 5408, 5392,
  5888, 5936, 5984, 5968, 6080, 6128, 6048, 6032,
  5760, 5808, 5856, 5840, 5696, 5744, 5664, 5648,
  4608, 4656, 4704, 4688, 4800, 4848, 4768, 4752,
  4992, 5040, 5088, 5072, 4928, 4976, 4896, 4880,
  4352, 4400, 4448, 4432, 4544, 4592, 4512, 4496,
  4224, 4272, 4320, 4304, 4160, 4208, 4128, 4112,
  0, 64, 128, 192, 256, 320, 384, 448,
  512, 576, 640, 704, 768, 832, 896, 960,
  1024, 1088, 1152, 1216, 1280, 1344, 1408, 1472,
  1536, 1600, 1664, 1728, 1792, 1856, 1920, 1984,
  2048, 2112, 2176, 2240, 2304, 2368, 2432, 2496,
  2560, 2624, 2688, 2752, 2816, 2880, 2944, 3008,
  3072, 3136, 3200, 3264, 3328, 3392, 3456, 3520,
  3584, 3648, 3712, 3776, 3840, 3904, 3968, 4032,
  4096, 4160, 4224, 4288, 4352, 4416, 4480, 4544,
  4608, 4672, 4736, 4800, 4864, 4928, 4992, 5056,
  5120, 5184, 5248, 5312, 5376, 5440, 5504, 5568,
  5632, 5696, 5760, 5824, 5888, 5952, 6016, 6080,
  6144, 6208, 6272, 6336, 6400, 6464, 6528, 6592,
  6656, 6720, 6784, 6848, 6912, 6976, 7040, 7104,
  7168, 7232, 7296, 7360, 7424, 7488, 7552, 7616,
  7680, 7744, 7808, 7872, 7936, 8000, 8064, 8128,
  8192, 8256, 8320, 8384, 8448, 8512, 8576, 8640,
  8704, 8768, 8832, 8896, 8960, 9024, 9088, 9152,
  9216, 9280, 9344, 9408, 9472, 9536, 9600, 9664,
  9728, 9792, 9856, 9920, 9984, 10048, 10112, 10176,
  10240, 10304, 10368, 10432, 10496, 10560, 10624, 10688,
  10752, 10816, 10880, 10944, 11008, 11072, 11136, 11200,
  11264, 11328, 11392, 11456, 11520, 11584, 11648, 11712,
  11776, 11840, 11904, 11968, 12032, 12096, 12160, 12224,
  12288, 12352, 12416, 12480, 12544, 12608, 12672, 12736,
  12800, 12864, 12928, 12992, 13056, 13120, 13184, 13248,
  13312, 13376, 13440, 13504, 13568, 13632, 13696, 13760,
  13824, 13888, 13952, 14016, 14080, 14144, 14208, 14272,
  14336, 14400, 14464, 14528, 14592, 14656, 14720, 14784,
  14848, 14912, 14976, 15040, 15104, 15168, 15232, 15296,
  15360, 15424, 15488, 15552, 15616, 15680, 15744, 15808,
  15872, 15936, 16000, 16064, 16128, 16192, 16256, 16320,
  0, 80, 160, 240, 320, 272, 480, 432,
  640, 720, 544, 624, 960, 912, 864, 816,
  1280, 1360, 1440, 1520, 1088, 1040, 1248, 1200,
  1920, 2000, 1824, 1904, 1728, 1680, 1632, 1584,
  2560, 2640, 2720, 2800, 2880, 2832, 3040, 2992,
  2176, 2256, 2080, 2160, 2496, 2448, 2400, 2352,
  3840, 3920, 4000, 4080, 3648, 3600, 3808, 3760,
  3456, 3536, 3360, 3440, 3264, 3216, 3168, 3120,
  5120, 5200, 5280, 5360, 5440, 5392, 5600, 5552,
  5760, 5840, 5664, 5744, 6080, 6032, 5984, 5936,
  4352, 4432, 4512, 4592, 4160, 4112, 4320, 4272,
  4992, 5072, 4896, 4976, 4800, 4752, 4704, 4656,
  7680, 7760, 7840, 7920, 8000, 7952, 8160, 8112,
  7296, 7376, 7200, 7280, 7616, 7568, 7520, 7472,
  6912, 6992, 7072, 7152, 6720, 6672, 6880, 6832,
  6528, 6608, 6432, 6512, 6336, 6288, 6240, 6192,
  10240, 10320, 10400, 10480, 10560, 10512, 10720, 10672,
  10880, 10960, 10784, 10864, 11200, 11152, 11104, 11056,
  11520, 11600, 11680, 11760, 11328, 11280, 11488, 11440,
  12160, 12240, 12064, 12144, 11968, 11920, 11872, 11824,
  8704, 8784, 8864, 8944, 9024, 8976, 9184, 9136,
  8320, 8400, 8224, 8304, 8640, 8592, 8544, 8496,
  9984, 10064, 10144, 10224, 9792, 9744, 9952, 9904,
  9600, 9680, 9504, 9584, 9408, 9360, 9312, 9264,
  15360, 15440, 15520, 15600, 15680, 15632, 15840, 15792,
  16000, 16080, 15904, 15984, 16320, 16272, 16224, 16176,
  14592, 14672, 14752, 14832, 14400, 14352, 14560, 14512,
  15232, 15312, 15136, 15216, 15040, 14992, 14944, 14896,
  13824, 13904, 13984, 14064, 14144, 14096, 14304, 14256,
  13440, 13520, 13344, 13424, 13760, 13712, 13664, 13616,
  13056, 13136, 13216, 13296, 12864, 12816, 13024, 12976,
  12672, 12752, 12576, 12656, 12480, 12432, 12384, 12336,
  0, 96, 192, 160, 384, 480, 320, 288,
  768, 864, 960, 928, 640, 736, 576, 544,
  1536, 1632, 1728, 1696, 1920, 2016, 1856, 1824,
  1280, 1376, 1472, 1440, 1152, 1248, 1088, 1056,
  3072, 3168, 3264, 3232, 3456, 3552, 3392, 3360,
  3840, 3936, 4032, 4000, 3712, 3808, 3648, 3616,
  2560, 2656, 2752, 2720, 2944, 3040, 2880, 2848,
  2304, 2400, 2496, 2464, 2176, 2272, 2112, 2080,
  6144, 6240, 6336, 6304, 6528, 6624, 6464, 6432,
  6912, 7008, 7104, 7072, 6784, 6880, 6720, 6688,
  7680, 7776, 7872, 7840, 8064, 8160, 8000, 7968,
  7424, 7520, 7616, 7584, 7296, 7392, 7232, 7200,
  5120, 5216, 5312, 5280, 5504, 5600, 5440, 5408,
  5888, 5984, 6080, 6048, 5760, 5856, 5696, 5664,
  4608, 4704, 4800, 4768, 4992, 5088, 4928, 4896,
  4352, 4448, 4544, 4512, 4224, 4320, 4160, 4128,
  12288, 12384, 12480, 12448, 12672, 12768, 12608, 12576,
  13056, 13152, 13248, 13216, 12928, 13024, 12864, 12832,
  13824, 13920, 14016, 13984, 14208, 14304, 14144, 14112,
  13568, 13664, 13760, 13728, 13440, 13536, 13376, 13344,
  15360, 15456, 15552, 15520, 15744, 15840, 15680, 15648,
  16128, 16224, 16320, 16288, 16000, 16096, 15936, 15904,
  14848, 14944, 15040, 15008, 15232, 15328, 15168, 15136,
  14592, 14688, 14784, 14752, 14464, 14560, 14400, 14368,
  10240, 10336, 10432, 10400, 10624, 10720, 10560, 10528,
  11008, 11104, 11200, 11168, 10880, 10976, 10816, 10784,
  11776, 11872, 11968, 11936, 12160, 12256, 12096, 12064,
  11520, 11616, 11712, 11680, 11392, 11488, 11328, 11296,
  9216, 9312, 9408, 9376, 9600, 9696, 9536, 9504,
  9984, 10080, 10176, 10144, 9856, 9952, 9792, 9760,
  8704, 8800, 8896, 8864, 9088, 9184, 9024, 8992,
  8448, 8544, 8640, 8608, 8320, 8416, 8256, 8224,
  0, 112, 224, 144, 448, 432, 288, 336,
  896, 1008, 864, 784, 576, 560, 672, 720,
  1792, 1904, 2016, 1936, 1728, 1712, 1568, 1616,
  1152, 1264, 1120, 1040, 1344, 1328, 1440, 1488,
  3584, 3696, 3808, 3728, 4032, 4016, 3872, 3920,
  3456, 3568, 3424, 3344, 3136, 3120, 3232, 3280,
  2304, 2416, 2528, 2448, 2240, 2224, 2080, 2128,
  2688, 2800, 2656, 2576, 2880, 2864, 2976, 3024,
  7168, 7280, 7392, 7312, 7616, 7600, 7456, 7504,
  8064, 8176, 8032, 7952, 7744, 7728, 7840, 7888,
  6912, 7024, 7136, 7056, 6848, 6832, 6688, 6736,
  6272, 6384, 6240, 6160, 6464, 6448, 6560, 6608,
  4608, 4720, 4832, 4752, 5056, 5040, 4896, 4944,
  4480, 4592, 4448, 4368, 4160, 4144, 4256, 4304,
  5376, 5488, 5600, 5520, 5312, 5296, 5152, 5200,
  5760, 5872, 5728, 5648, 5952, 5936, 6048, 6096,
  14336, 14448, 14560, 14480, 14784, 14768, 14624, 14672,
  15232, 15344, 15200, 15120, 14912, 14896, 15008, 15056,
  16128, 16240, 16352, 16272, 16064, 16048, 15904, 15952,
  15488, 15600, 15456, 15376, 15680, 15664, 15776, 15824,
  13824, 13936, 14048, 13968, 14272, 14256, 14112, 14160,
  13696, 13808, 13664, 13584, 13376, 13360, 13472, 13520,
  12544, 12656, 12768, 12688, 12480, 12464, 12320, 12368,
  12928, 13040, 12896, 12816, 13120, 13104, 13216, 13264,
  9216, 9328, 9440, 9360, 9664, 9648, 9504, 9552,
  10112, 10224, 10080, 10000, 9792, 9776, 9888, 9936,
  8960, 9072, 9184, 9104, 8896, 8880, 8736, 8784,
  8320, 8432, 8288, 8208, 8512, 8496, 8608, 8656,
  10752, 10864, 10976, 10896, 11200, 11184, 11040, 11088,
  10624, 10736, 10592, 10512, 10304, 10288, 10400, 10448,
  11520, 11632, 11744, 11664, 11456, 11440, 11296, 11344,
  11904, 12016, 11872, 11792, 12096, 12080, 12192, 12240,
  0, 128, 256, 384, 512, 640, 768, 896,
  1024, 1152, 1280, 1408, 1536, 1664, 1792, 1920,
  2048, 2176, 2304, 2432, 2560, 2688, 2816, 2944,
  3072, 3200, 3328, 3456, 3584, 3712, 3840, 3968,
  4096, 4224, 4352, 4480, 4608, 4736, 4864, 4992,
  5120, 5248, 5376, 5504, 5632, 5760, 5888, 6016,
  6144, 6272, 6400, 6528, 6656, 6784, 6912, 7040,
  7168, 7296, 7424, 7552, 7680, 7808, 7936, 8064,
  8192, 8320, 8448, 8576, 8704, 8832, 8960, 9088,
  9216, 9344, 9472, 9600, 9728, 9856, 9984, 10112,
  10240, 10368, 10496, 10624, 10752, 10880, 11008, 11136,
  11264, 11392, 11520, 11648, 11776, 11904, 12032, 12160,
  12288, 12416, 12544, 12672, 12800, 12928, 13056, 13184,
  13312, 13440, 13568, 13696, 13824, 13952, 14080, 14208,
  14336, 14464, 14592, 14720, 14848, 14976, 15104, 15232,
  15360, 15488, 15616, 15744, 15872, 16000, 16128, 16256,
  16384, 16512, 16640, 16768, 16896, 17024, 17152, 17280,
  17408, 17536, 17664, 17792, 17920, 18048, 18176, 18304,
  18432, 18560, 18688, 18816, 18944, 19072, 19200, 19328,
  19456, 19584, 19712, 19840, 19968, 20096, 20224, 20352,
  20480, 20608, 20736, 20864, 20992, 21120, 21248, 21376,
  21504, 21632, 21760, 21888, 22016, 22144, 22272, 22400,
  22528, 22656, 22784, 22912, 23040, 23168, 23296, 23424,
  23552, 23680, 23808, 23936, 24064, 24192, 24320, 24448,
  24576, 24704, 24832, 24960, 25088, 25216, 25344, 25472,
  25600, 25728, 25856, 25984, 26112, 26240, 26368, 26496,
  26624, 26752, 26880, 27008, 27136, 27264, 27392, 27520,
  27648, 27776, 27904, 28032, 28160, 28288, 28416, 28544,
  28672, 28800, 28928, 29056, 29184, 29312, 29440, 29568,
  29696, 29824, 29952, 30080, 30208, 30336, 30464, 30592,
  30720, 30848, 30976, 31104, 31232, 31360, 31488, 31616,
  31744, 31872, 32000, 32128, 32256, 32384, 32512, 32640,
  0, 144, 288, 432, 576, 720, 864, 1008,
  1152, 1040, 1440, 1328, 1728, 1616, 2016, 1904,
  2304, 2448, 2080, 2224, 2880, 3024, 2656, 2800,
  3456, 3344, 3232, 3120, 4032, 3920, 3808, 3696,
  4608, 4752, 4896, 5040, 4160, 4304, 4448, 4592,
  5760, 5648, 6048, 5936, 5312, 5200, 5600, 5488,
  6912, 7056, 6688, 6832, 6464, 6608, 6240, 6384,
  8064, 7952, 7840, 7728, 7616, 7504, 7392, 7280,
  9216, 9360, 9504, 9648, 9792, 9936, 10080, 10224,
  8320, 8208, 8608, 8496, 8896, 8784, 9184, 9072,
  11520, 11664, 11296, 11440, 12096, 12240, 11872, 12016,
  10624, 10512, 10400, 10288, 11200, 11088, 10976, 10864,
  13824, 13968, 14112, 14256, 13376, 13520, 13664, 13808,
  12928, 12816, 13216, 13104, 12480, 12368, 12768, 12656,
  16128, 16272, 15904, 16048, 15680, 15824, 15456, 15600,
  15232, 15120, 15008, 14896, 14784, 14672, 14560, 14448,
  18432, 18576, 18720, 18864, 19008, 19152, 19296, 19440,
  19584, 19472, 19872, 19760, 20160, 20048, 20448, 20336,
  16640, 16784, 16416, 16560, 17216, 17360, 16992, 17136,
  17792, 17680, 17568, 17456, 18368, 18256, 18144, 18032,
  23040, 23184, 23328, 23472, 22592, 22736, 22880, 23024,
  24192, 24080, 24480, 24368, 23744, 23632, 24032, 23920,
  21248, 21392, 21024, 21168, 20800, 20944, 20576, 20720,
  22400, 22288, 22176, 22064, 21952, 21840, 21728, 21616,
  27648, 27792, 27936, 28080, 28224, 28368, 28512, 28656,
  26752, 26640, 27040, 26928, 27328, 27216, 27616, 27504,
  25856, 26000, 25632, 25776, 26432, 26576, 26208, 26352,
  24960, 24848, 24736, 24624, 25536, 25424, 25312, 25200,
  32256, 32400, 32544, 32688, 31808, 31952, 32096, 32240,
  31360, 31248, 31648, 31536, 30912, 30800, 31200, 31088,
  30464, 30608, 30240, 30384, 30016, 30160, 29792, 29936,
  29568, 29456, 29344, 29232, 29120, 29008, 28896, 28784,
  0, 160, 320, 480, 640, 544, 960, 864,
  1280, 1440, 1088, 1248, 1920, 1824, 1728, 1632,
  2560, 2720, 2880, 3040, 2176, 2080, 2496, 2400,
  3840, 4000, 3648, 3808, 3456, 3360, 3264, 3168,
  5120, 5280, 5440, 5600, 5760, 5664, 6080, 5984,
  4352, 4512, 4160, 4320, 4992, 4896, 4800, 4704,
  7680, 7840, 8000, 8160, 7296, 7200, 7616, 7520,
  6912, 7072, 6720, 6880, 6528, 6432, 6336, 6240,
  10240, 10400, 10560, 10720, 10880, 10784, 11200, 11104,
  11520, 11680, 11328, 11488, 12160, 12064, 11968, 11872,
  8704, 8864, 9024, 9184, 8320, 8224, 8640, 8544,
  9984, 10144, 9792, 9952, 9600, 9504, 9408, 9312,
  15360, 15520, 15680, 15840, 16000, 15904, 16320, 16224,
  14592, 14752, 14400, 14560, 15232, 15136, 15040, 14944,
  13824, 13984, 14144, 14304, 13440, 13344, 13760, 13664,
  13056, 13216, 12864, 13024, 12672, 12576, 12480, 12384,
  20480, 20640, 20800, 20960, 21120, 21024, 21440, 21344,
  21760, 21920, 21568, 21728, 22400, 22304, 22208, 22112,
  23040, 23200, 23360, 23520, 22656, 22560, 22976, 22880,
  24320, 24480, 24128, 24288, 23936, 23840, 23744, 23648,
  17408, 17568, 17728, 17888, 18048, 17952, 18368, 18272,
  16640, 16800, 16448, 16608, 17280, 17184, 17088, 16992,
  19968, 20128, 20288, 20448, 19584, 19488, 19904, 19808,
  19200, 19360, 19008, 19168, 18816, 18720, 18624, 18528,
  30720, 30880, 31040, 31200, 31360, 31264, 31680, 31584,
  32000, 32160, 31808, 31968, 32640, 32544, 32448, 32352,
  29184, 29344, 29504, 29664, 28800, 28704, 29120, 29024,
  30464, 30624, 30272, 30432, 30080, 29984, 29888, 29792,
  27648, 27808, 27968, 28128, 28288, 28192, 28608, 28512,
  26880, 27040, 26688, 26848, 27520, 27424, 27328, 27232,
  26112, 26272, 26432, 26592, 25728, 25632, 26048, 25952,
  25344, 25504, 25152, 25312, 24960, 24864, 24768, 24672,
  0, 176, 352, 464, 704, 624, 928, 784,
  1408, 1328, 1248, 1104, 1856, 2032, 1568, 1680,
  2816, 2992, 2656, 2768, 2496, 2416, 2208, 2064,
  3712, 3632, 4064, 3920, 3136, 3312, 3360, 3472,
  5632, 5808, 5984, 6096, 5312, 5232, 5536, 5392,
  4992, 4912, 4832, 4688, 4416, 4592, 4128, 4240,
  7424, 7600, 7264, 7376, 8128, 8048, 7840, 7696,
  6272, 6192, 6624, 6480, 6720, 6896, 6944, 7056,
  11264, 11440, 11616, 11728, 11968, 11888, 12192, 12048,
  10624, 10544, 10464, 10320, 11072, 11248, 10784, 10896,
  9984, 10160, 9824, 9936, 9664, 9584, 9376, 9232,
  8832, 8752, 9184, 9040, 8256, 8432, 8480, 8592,
  14848, 15024, 15200, 15312, 14528, 14448, 14752, 14608,
  16256, 16176, 16096, 15952, 15680, 15856, 15392, 15504,
  12544, 12720, 12384, 12496, 13248, 13168, 12960, 12816,
  13440, 13360, 13792, 13648, 13888, 14064, 14112, 14224,
  22528, 22704, 22880, 22992, 23232, 23152, 23456, 23312,
  23936, 23856, 23776, 23632, 24384, 24560, 24096, 24208,
  21248, 21424, 21088, 21200, 20928, 20848, 20640, 20496,
  22144, 22064, 22496, 22352, 21568, 21744, 21792, 21904,
  19968, 20144, 20320, 20432, 19648, 19568, 19872, 19728,
  19328, 19248, 19168, 19024, 18752, 18928, 18464, 18576,
  17664, 17840, 17504, 17616, 18368, 18288, 18080, 17936,
  16512, 16432, 16864, 16720, 16960, 17136, 17184, 17296,
  29696, 29872, 30048, 30160, 30400, 30320, 30624, 30480,
  29056, 28976, 28896, 28752, 29504, 29680, 29216, 29328,
  32512, 32688, 32352, 32464, 32192, 32112, 31904, 31760,
  31360, 31280, 31712, 31568, 30784, 30960, 31008, 31120,
  25088, 25264, 25440, 25552, 24768, 24688, 24992, 24848,
  26496, 26416, 26336, 26192, 25920, 26096, 25632, 25744,
  26880, 27056, 26720, 26832, 27584, 27504, 27296, 27152,
  27776, 27696, 28128, 27984, 28224, 28400, 28448, 28560,
  0, 192, 384, 320, 768, 960, 640, 576,
  1536, 1728, 1920, 1856, 1280, 1472, 1152, 1088,
  3072, 3264, 3456, 3392, 3840, 4032, 3712, 3648,
  2560, 2752, 2944, 2880, 2304, 2496, 2176, 2112,
  6144, 6336, 6528, 6464, 6912, 7104, 6784, 6720,
  7680, 7872, 8064, 8000, 7424, 7616, 7296, 7232,
  5120, 5312, 5504, 5440, 5888, 6080, 5760, 5696,
  4608, 4800, 4992, 4928, 4352, 4544, 4224, 4160,
  12288, 12480, 12672, 12608, 13056, 13248, 12928, 12864,
  13824, 14016, 14208, 14144, 13568, 13760, 13440, 13376,
  15360, 15552, 15744, 15680, 16128, 16320, 16000, 15936,
  14848, 15040, 15232, 15168, 14592, 14784, 14464, 14400,
  10240, 10432, 10624, 10560, 11008, 11200, 10880, 10816,
  11776, 11968, 12160, 12096, 11520, 11712, 11392, 11328,
  9216, 9408, 9600, 9536, 9984, 10176, 9856, 9792,
  8704, 8896, 9088, 9024, 8448, 8640, 8320, 8256,
  24576, 24768, 24960, 24896, 25344, 25536, 25216, 25152,
  26112, 26304, 26496, 26432, 25856, 26048, 25728, 25664,
  27648, 27840, 28032, 27968, 28416, 28608, 28288, 28224,
  27136, 27328, 27520, 27456, 26880, 27072, 26752, 26688,
  30720, 30912, 31104, 31040, 31488, 31680, 31360, 31296,
  32256, 32448, 32640, 32576, 32000, 32192, 31872, 31808,
  29696, 29888, 30080, 30016, 30464, 30656, 30336, 30272,
  29184, 29376, 29568, 29504, 28928, 29120, 28800, 28736,
  20480, 20672, 20864, 20800, 21248, 21440, 21120, 21056,
  22016, 22208, 22400, 22336, 21760, 21952, 21632, 21568,
  23552, 23744, 23936, 23872, 24320, 24512, 24192, 24128,
  23040, 23232, 23424, 23360, 22784, 22976, 22656, 22592,
  18432, 18624, 18816, 18752, 19200, 19392, 19072, 19008,
  19968, 20160, 20352, 20288, 19712, 19904, 19584, 19520,
  17408, 17600, 17792, 17728, 18176, 18368, 18048, 17984,
  16896, 17088, 17280, 17216, 16640, 16832, 16512, 16448,
  0, 208, 416, 368, 832, 912, 736, 560,
  1664, 1616, 1824, 2032, 1472, 1296, 1120, 1200,
  3328, 3536, 3232, 3184, 3648, 3728, 4064, 3888,
  2944, 2896, 2592, 2800, 2240, 2064, 2400, 2480,
  6656, 6864, 7072, 7024, 6464, 6544, 6368, 6192,
  7296, 7248, 7456, 7664, 8128, 7952, 7776, 7856,
  5888, 6096, 5792, 5744, 5184, 5264, 5600, 5424,
  4480, 4432, 4128, 4336, 4800, 4624, 4960, 5040,
  13312, 13520, 13728, 13680, 14144, 14224, 14048, 13872,
  12928, 12880, 13088, 13296, 12736, 12560, 12384, 12464,
  14592, 14800, 14496, 14448, 14912, 14992, 15328, 15152,
  16256, 16208, 15904, 16112, 15552, 15376, 15712, 15792,
  11776, 11984, 12192, 12144, 11584, 11664, 11488, 11312,
  10368, 10320, 10528, 10736, 11200, 11024, 10848, 10928,
  8960, 9168, 8864, 8816, 8256, 8336, 8672, 8496,
  9600, 9552, 9248, 9456, 9920, 9744, 10080, 10160,
  26624, 26832, 27040, 26992, 27456, 27536, 27360, 27184,
  28288, 28240, 28448, 28656, 28096, 27920, 27744, 27824,
  25856, 26064, 25760, 25712, 26176, 26256, 26592, 26416,
  25472, 25424, 25120, 25328, 24768, 24592, 24928, 25008,
  29184, 29392, 29600, 29552, 28992, 29072, 28896, 28720,
  29824, 29776, 29984, 30192, 30656, 30480, 30304, 30384,
  32512, 32720, 32416, 32368, 31808, 31888, 32224, 32048,
  31104, 31056, 30752, 30960, 31424, 31248, 31584, 31664,
  23552, 23760, 23968, 23920, 24384, 24464, 24288, 24112,
  23168, 23120, 23328, 23536, 22976, 22800, 22624, 22704,
  20736, 20944, 20640, 20592, 21056, 21136, 21472, 21296,
  22400, 22352, 22048, 22256, 21696, 21520, 21856, 21936,
  17920, 18128, 18336, 18288, 17728, 17808, 17632, 17456,
  16512, 16464, 16672, 16880, 17344, 17168, 16992, 17072,
  19200, 19408, 19104, 19056, 18496, 18576, 18912, 18736,
  19840, 19792, 19488, 19696, 20160, 19984, 20320, 20400,
  0, 224, 448, 288, 896, 864, 576, 672,
  1792, 2016, 1728, 1568, 1152, 1120, 1344, 1440,
  3584, 3808, 4032, 3872, 3456, 3424, 3136, 3232,
  2304, 2528, 2240, 2080, 2688, 2656, 2880, 2976,
  7168, 7392, 7616, 7456, 8064, 8032, 7744, 7840,
  6912, 7136, 6848, 6688, 6272, 6240, 6464, 6560,
  4608, 4832, 5056, 4896, 4480, 4448, 4160, 4256,
  5376, 5600, 5312, 5152, 5760, 5728, 5952, 6048,
  14336, 14560, 14784, 14624, 15232, 15200, 14912, 15008,
  16128, 16352, 16064, 15904, 15488, 15456, 15680, 15776,
  13824, 14048, 14272, 14112, 13696, 13664, 13376, 13472,
  12544, 12768, 12480, 12320, 12928, 12896, 13120, 13216,
  9216, 9440, 9664, 9504, 10112, 10080, 9792, 9888,
  8960, 9184, 8896, 8736, 8320, 8288, 8512, 8608,
  10752, 10976, 11200, 11040, 10624, 10592, 10304, 10400,
  11520, 11744, 11456, 11296, 11904, 11872, 12096, 12192,
  28672, 28896, 29120, 28960, 29568, 29536, 29248, 29344,
  30464, 30688, 30400, 30240, 29824, 29792, 30016, 30112,
  32256, 32480, 32704, 32544, 32128, 32096, 31808, 31904,
  30976, 31200, 30912, 30752, 31360, 31328, 31552, 31648,
  27648, 27872, 28096, 27936, 28544, 28512, 28224, 28320,
  27392, 27616, 27328, 27168, 26752, 26720, 26944, 27040,
  25088, 25312, 25536, 25376, 24960, 24928, 24640, 24736,
  25856, 26080, 25792, 25632, 26240, 26208, 26432, 26528,
  18432, 18656, 18880, 18720, 19328, 19296, 19008, 19104,
  20224, 20448, 20160, 20000, 19584, 19552, 19776, 19872,
  17920, 18144, 18368, 18208, 17792, 17760, 17472, 17568,
  16640, 16864, 16576, 16416, 17024, 16992, 17216, 17312,
  21504, 21728, 21952, 21792, 22400, 22368, 22080, 22176,
  21248, 21472, 21184, 21024, 20608, 20576, 20800, 20896,
  23040, 23264, 23488, 23328, 22912, 22880, 22592, 22688,
  23808, 24032, 23744, 23584, 24192, 24160, 24384, 24480,
  0, 240, 480, 272, 960, 816, 544, 720,
  1920, 1904, 1632, 1680, 1088, 1200, 1440, 1360,
  3840, 4080, 3808, 3600, 3264, 3120, 3360, 3536,
  2176, 2160, 2400, 2448, 2880, 2992, 2720, 2640,
  7680, 7920, 8160, 7952, 7616, 7472, 7200, 7376,
  6528, 6512, 6240, 6288, 6720, 6832, 7072, 6992,
  4352, 4592, 4320, 4112, 4800, 4656, 4896, 5072,
  5760, 5744, 5984, 6032, 5440, 5552, 5280, 5200,
  15360, 15600, 15840, 15632, 16320, 16176, 15904, 16080,
  15232, 15216, 14944, 14992, 14400, 14512, 14752, 14672,
  13056, 13296, 13024, 12816, 12480, 12336, 12576, 12752,
  13440, 13424, 13664, 13712, 14144, 14256, 13984, 13904,
  8704, 8944, 9184, 8976, 8640, 8496, 8224, 8400,
  9600, 9584, 9312, 9360, 9792, 9904, 10144, 10064,
  11520, 11760, 11488, 11280, 11968, 11824, 12064, 12240,
  10880, 10864, 11104, 11152, 10560, 10672, 10400, 10320,
  30720, 30960, 31200, 30992, 31680, 31536, 31264, 31440,
  32640, 32624, 32352, 32400, 31808, 31920, 32160, 32080,
  30464, 30704, 30432, 30224, 29888, 29744, 29984, 30160,
  28800, 28784, 29024, 29072, 29504, 29616, 29344, 29264,
  26112, 26352, 26592, 26384, 26048, 25904, 25632, 25808,
  24960, 24944, 24672, 24720, 25152, 25264, 25504, 25424,
  26880, 27120, 26848, 26640, 27328, 27184, 27424, 27600,
  28288, 28272, 28512, 28560, 27968, 28080, 27808, 27728,
  17408, 17648, 17888, 17680, 18368, 18224, 17952, 18128,
  17280, 17264, 16992, 17040, 16448, 16560, 16800, 16720,
  19200, 19440, 19168, 18960, 18624, 18480, 18720, 18896,
  19584, 19568, 19808, 19856, 20288, 20400, 20128, 20048,
  23040, 23280, 23520, 23312, 22976, 22832, 22560, 22736,
  23936, 23920, 23648, 23696, 24128, 24240, 24480, 24400,
  21760, 22000, 21728, 21520, 22208, 22064, 22304, 22480,
  21120, 21104, 21344, 21392, 20800, 20912, 20640, 20560,
};

static const gf2_u16 fast_gf2_rmul[] = {
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 1, 2, 3, 4, 5, 6, 7,
  8, 9, 10, 11, 12, 13, 14, 15,
  16, 17, 18, 19, 20, 21, 22, 23,
  24, 25, 26, 27, 28, 29, 30, 31,
  32, 33, 34, 35, 36, 37, 38, 39,
  40, 41, 42, 43, 44, 45, 46, 47,
  48, 49, 50, 51, 52, 53, 54, 55,
  56, 57, 58, 59, 60, 61, 62, 63,
  64, 65, 66, 67, 68, 69, 70, 71,
  72, 73, 74, 75, 76, 77, 78, 79,
  80, 81, 82, 83, 84, 85, 86, 87,
  88, 89, 90, 91, 92, 93, 94, 95,
  96, 97, 98, 99, 100, 101, 102, 103,
  104, 105, 106, 107, 108, 109, 110, 111,
  112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127,
  128, 129, 130, 131, 132, 133, 134, 135,
  136, 137, 138, 139, 140, 141, 142, 143,
  144, 145, 146, 147, 148, 149, 150, 151,
  152, 153, 154, 155, 156, 157, 158, 159,
  160, 161, 162, 163, 164, 165, 166, 167,
  168, 169, 170, 171, 172, 173, 174, 175,
  176, 177, 178, 179, 180, 181, 182, 183,
  184, 185, 186, 187, 188, 189, 190, 191,
  192, 193, 194, 195, 196, 197, 198, 199,
  200, 201, 202, 203, 204, 205, 206, 207,
  208, 209, 210, 211, 212, 213, 214, 215,
  216, 217, 218, 219, 220, 221, 222, 223,
  224, 225, 226, 227, 228, 229, 230, 231,
  232, 233, 234, 235, 236, 237, 238, 239,
  240, 241, 242, 243, 244, 245, 246, 247,
  248, 249, 250, 251, 252, 253, 254, 255,
  0, 2, 4, 6, 8, 10, 12, 14,
  16, 18, 20, 22, 24, 26, 28, 30,
  32, 34, 36, 38, 40, 42, 44, 46,
  48, 50, 52, 54, 56, 58, 60, 62,
  64, 66, 68, 70, 72, 74, 76, 78,
  80, 82, 84, 86, 88, 90, 92, 94,
  96, 98, 100, 102, 104, 106, 108, 110,
  112, 114, 116, 118, 120, 122, 124, 126,
  128, 130, 132, 134, 136, 138, 140, 142,
  144, 146, 148, 150, 152, 154, 156, 158,
  160, 162, 164, 166, 168, 170, 172, 174,
  176, 178, 180, 182, 184, 186, 188, 190,
  192, 194, 196, 198, 200, 202, 204, 206,
  208, 210, 212, 214, 216, 218, 220, 222,
  224, 226, 228, 230, 232, 234, 236, 238,
  240, 242, 244, 246, 248, 250, 252, 254,
  256, 258, 260, 262, 264, 266, 268, 270,
  272, 274, 276, 278, 280, 282, 284, 286,
  288, 290, 292, 294, 296, 298, 300, 302,
  304, 306, 308, 310, 312, 314, 316, 318,
  320, 322, 324, 326, 328, 330, 332, 334,
  336, 338, 340, 342, 344, 346, 348, 350,
  352, 354, 356, 358, 360, 362, 364, 366,
  368, 370, 372, 374, 376, 378, 380, 382,
  384, 386, 388, 390, 392, 394, 396, 398,
  400, 402, 404, 406, 408, 410, 412, 414,
  416, 418, 420, 422, 424, 426, 428, 430,
  432, 434, 436, 438, 440, 442, 444, 446,
  448, 450, 452, 454, 456, 458, 460, 462,
  464, 466, 468, 470, 472, 474, 476, 478,
  480, 482, 484, 486, 488, 490, 492, 494,
  496, 498, 500, 502, 504, 506, 508, 510,
  0, 3, 6, 5, 12, 15, 10, 9,
  24, 27, 30, 29, 20, 23, 18, 17,
  48, 51, 54, 53, 60, 63, 58, 57,
  40, 43, 46, 45, 36, 39, 34, 33,
  96, 99, 102, 101, 108, 111, 106, 105,
  120, 123, 126, 125, 116, 119, 114, 113,
  80, 83, 86, 85, 92, 95, 90, 89,
  72, 75, 78, 77, 68, 71, 66, 65,
  192, 195, 198, 197, 204, 207, 202, 201,
  216, 219, 222, 221, 212, 215, 210, 209,
  240, 243, 246, 245, 252, 255, 250, 249,
  232, 235, 238, 237, 228, 231, 226, 225,
  160, 163, 166, 165, 172, 175, 170, 169,
  184, 187, 190, 189, 180, 183, 178, 177,
  144, 147, 150, 149, 156, 159, 154, 153,
  136, 139, 142, 141, 132, 135, 130, 129,
  384, 387, 390, 389, 396, 399, 394, 393,
  408, 411, 414, 413, 404, 407, 402, 401,
  432, 435, 438, 437, 444, 447, 442, 441,
  424, 427, 430, 429, 420, 423, 418, 417,
  480, 483, 486, 485, 492, 495, 490, 489,
  504, 507, 510, 509, 500, 503, 498, 497,
  464, 467, 470, 469, 476, 479, 474, 473,
  456, 459, 462, 461, 452, 455, 450, 449,
  320, 323, 326, 325, 332, 335, 330, 329,
  344, 347, 350, 349, 340, 343, 338, 337,
  368, 371, 374, 373, 380, 383, 378, 377,
  360, 363, 366, 365, 356, 359, 354, 353,
  288, 291, 294, 293, 300, 303, 298, 297,
  312, 315, 318, 317, 308, 311, 306, 305,
  272, 275, 278, 277, 284, 287, 282, 281,
  264, 267, 270, 269, 260, 263, 258, 257,
  0, 4, 8, 12, 16, 20, 24, 28,
  32, 36, 40, 44, 48, 52, 56, 60,
  64, 68, 72, 76, 80, 84, 88, 92,
  96, 100, 104, 108, 112, 116, 120, 124,
  128, 132, 136, 140, 144, 148, 152, 156,
  160, 164, 168, 172, 176, 180, 184, 188,
  192, 196, 200, 204, 208, 212, 216, 220,
  224, 228, 232, 236, 240, 244, 248, 252,
  256, 260, 264, 268, 272, 276, 280, 284,
  288, 292, 296, 300, 304, 308, 312, 316,
  320, 324, 328, 332, 336, 340, 344, 348,
  352, 356, 360, 364, 368, 372, 376, 380,
  384, 388, 392, 396, 400, 404, 408, 412,
  416, 420, 424, 428, 432, 436, 440, 444,
  448, 452, 456, 460, 464, 468, 472, 476,
  480, 484, 488, 492, 496, 500, 504, 508,
  512, 516, 520, 524, 528, 532, 536, 540,
  544, 548, 552, 556, 560, 564, 568, 572,
  576, 580, 584, 588, 592, 596, 600, 604,
  608, 612, 616, 620, 624, 628, 632, 636,
  640, 644, 648, 652, 656, 660, 664, 668,
  672, 676, 680, 684, 688, 692, 696, 700,
  704, 708, 712, 716, 720, 724, 728, 732,
  736, 740, 744, 748, 752, 756, 760, 764,
  768, 772, 776, 780, 784, 788, 792, 796,
  800, 804, 808, 812, 816, 820, 824, 828,
  832, 836, 840, 844, 848, 852, 856, 860,
  864, 868, 872, 876, 880, 884, 888, 892,
  896, 900, 904, 908, 912, 916, 920, 924,
  928, 932, 936, 940, 944, 948, 952, 956,
  960, 964, 968, 972, 976, 980, 984, 988,
  992, 996, 1000, 1004, 1008, 1012, 1016, 1020,
  0, 5, 10, 15, 20, 17, 30, 27,
  40, 45, 34, 39, 60, 57, 54, 51,
  80, 85, 90, 95, 68, 65, 78, 75,
  120, 125, 114, 119, 108, 105, 102, 99,
  160, 165, 170, 175, 180, 177, 190, 187,
  136, 141, 130, 135, 156, 153, 150, 147,
  240, 245, 250, 255, 228, 225, 238, 235,
  216, 221, 210, 215, 204, 201, 198, 195,
  320, 325, 330, 335, 340, 337, 350, 347,
  360, 365, 354, 359, 380, 377, 374, 371,
  272, 277, 282, 287, 260, 257, 270, 267,
  312, 317, 306, 311, 300, 297, 294, 291,
  480, 485, 490, 495, 500, 497, 510, 507,
  456, 461, 450, 455, 476, 473, 470, 467,
  432, 437, 442, 447, 420, 417, 430, 427,
  408, 413, 402, 407, 396, 393, 390, 387,
  640, 645, 650, 655, 660, 657, 670, 667,
  680, 685, 674, 679, 700, 697, 694, 691,
  720, 725, 730, 735, 708, 705, 718, 715,
  760, 765, 754, 759, 748, 745, 742, 739,
  544, 549, 554, 559, 564, 561, 574, 571,
  520, 525, 514, 519, 540, 537, 534, 531,
  624, 629, 634, 639, 612, 609, 622, 619,
  600, 605, 594, 599, 588, 585, 582, 579,
  960, 965, 970, 975, 980, 977, 990, 987,
  1000, 1005, 994, 999, 1020, 1017, 1014, 1011,
  912, 917, 922, 927, 900, 897, 910, 907,
  952, 957, 946, 951, 940, 937, 934, 931,
  864, 869, 874, 879, 884, 881, 894, 891,
  840, 845, 834, 839, 860, 857, 854, 851,
  816, 821, 826, 831, 804, 801, 814, 811,
  792, 797, 786, 791, 780, 777, 774, 771,
  0, 6, 12, 10, 24, 30, 20, 18,
  48, 54, 60, 58, 40, 46, 36, 34,
  96, 102, 108, 106, 120, 126, 116, 114,
  80, 86, 92, 90, 72, 78, 68, 66,
  192, 198, 204, 202, 216, 222, 212, 210,
  240, 246, 252, 250, 232, 238, 228, 226,
  160, 166, 172, 170, 184, 190, 180, 178,
  144, 150, 156, 154, 136, 142, 132, 130,
  384, 390, 396, 394, 408, 414, 404, 402,
  432, 438, 444, 442, 424, 430, 420, 418,
  480, 486, 492, 490, 504, 510, 500, 498,
  464, 470, 476, 474, 456, 462, 452, 450,
  320, 326, 332, 330, 344, 350, 340, 338,
  368, 374, 380, 378, 360, 366, 356, 354,
  288, 294, 300, 298, 312, 318, 308, 306,
  272, 278, 284, 282, 264, 270, 260, 258,
  768, 774, 780, 778, 792, 798, 788, 786,
  816, 822, 828, 826, 808, 814, 804, 802,
  864, 870, 876, 874, 888, 894, 884, 882,
  848, 854, 860, 858, 840, 846, 836, 834,
  960, 966, 972, 970, 984, 990, 980, 978,
  1008, 1014, 1020, 1018, 1000, 1006, 996, 994,
  928, 934, 940, 938, 952, 958, 948, 946,
  912, 918, 924, 922, 904, 910, 900, 898,
  640, 646, 652, 650, 664, 670, 660, 658,
  688, 694, 700, 698, 680, 686, 676, 674,
  736, 742, 748, 746, 760, 766, 756, 754,
  720, 726, 732, 730, 712, 718, 708, 706,
  576, 582, 588, 586, 600, 606, 596, 594,
  624, 630, 636, 634, 616, 622, 612, 610,
  544, 550, 556, 554, 568, 574, 564, 562,
  528, 534, 540, 538, 520, 526, 516, 514,
  0, 7, 14, 9, 28, 27, 18, 21,
  56, 63, 54, 49, 36, 35, 42, 45,
  112, 119, 126, 121, 108, 107, 98, 101,
  72, 79, 70, 65, 84, 83, 90, 93,
  224, 231, 238, 233, 252, 251, 242, 245,
  216, 223, 214, 209, 196, 195, 202, 205,
  144, 151, 158, 153, 140, 139, 130, 133,
  168, 175, 166, 161, 180, 179, 186, 189,
  448, 455, 462, 457, 476, 475, 466, 469,
  504, 511, 502, 497, 484, 483, 490, 493,
  432, 439, 446, 441, 428, 427, 418, 421,
  392, 399, 390, 385, 404, 403, 410, 413,
  288, 295, 302, 297, 316, 315, 306, 309,
  280, 287, 278, 273, 260, 259, 266, 269,
  336, 343, 350, 345, 332, 331, 322, 325,
  360, 367, 358, 353, 372, 371, 378, 381,
  896, 903, 910, 905, 924, 923, 914, 917,
  952, 959, 950, 945, 932, 931, 938, 941,
  1008, 1015, 1022, 1017, 1004, 1003, 994, 997,
  968, 975, 966, 961, 980, 979, 986, 989,
  864, 871, 878, 873, 892, 891, 882, 885,
  856, 863, 854, 849, 836, 835, 842, 845,
  784, 791, 798, 793, 780, 779, 770, 773,
  808, 815, 806, 801, 820, 819, 826, 829,
  576, 583, 590, 585, 604, 603, 594, 597,
  632, 639, 630, 625, 612, 611, 618, 621,
  560, 567, 574, 569, 556, 555, 546, 549,
  520, 527, 518, 513, 532, 531, 538, 541,
  672, 679, 686, 681, 700, 699, 690, 693,
  664, 671, 662, 657, 644, 643, 650, 653,
  720, 727, 734, 729, 716, 715, 706, 709,
  744, 751, 742, 737, 756, 755, 762, 765,
  0, 8, 16, 24, 32, 40, 48, 56,
  64, 72, 80, 88, 96, 104, 112, 120,
  128, 136, 144, 152, 160, 168, 176, 184,
  192, 200, 208, 216, 224, 232, 240, 248,
  256, 264, 272, 280, 288, 296, 304, 312,
  320, 328, 336, 344, 352, 360, 368, 376,
  384, 392, 400, 408, 416, 424, 432, 440,
  448, 456, 464, 472, 480, 488, 496, 504,
  512, 520, 528, 536, 544, 552, 560, 568,
  576, 584, 592, 600, 608, 616, 624, 632,
  640, 648, 656, 664, 672, 680, 688, 696,
  704, 712, 720, 728, 736, 744, 752, 760,
  768, 776, 784, 792, 800, 808, 816, 824,
  832, 840, 848, 856, 864, 872, 880, 888,
  896, 904, 912, 920, 928, 936, 944, 952,
  960, 968, 976, 984, 992, 1000, 1008, 1016,
  1024, 1032, 1040, 1048, 1056, 1064, 1072, 1080,
  1088, 1096, 1104, 1112, 1120, 1128, 1136, 1144,
  1152, 1160, 1168, 1176, 1184, 1192, 1200, 1208,
  1216, 1224, 1232, 1240, 1248, 1256, 1264, 1272,
  1280, 1288, 1296, 1304, 1312, 1320, 1328, 1336,
  1344, 1352, 1360, 1368, 1376, 1384, 1392, 1400,
  1408, 1416, 1424, 1432, 1440, 1448, 1456, 1464,
  1472, 1480, 1488, 1496, 1504, 1512, 1520, 1528,
  1536, 1544, 1552, 1560, 1568, 1576, 1584, 1592,
  1600, 1608, 1616, 1624, 1632, 1640, 1648, 1656,
  1664, 1672, 1680, 1688, 1696, 1704, 1712, 1720,
  1728, 1736, 1744, 1752, 1760, 1768, 1776, 1784,
  1792, 1800, 1808, 1816, 1824, 1832, 1840, 1848,
  1856, 1864, 1872, 1880, 1888, 1896, 1904, 1912,
  1920, 1928, 1936, 1944, 1952, 1960, 1968, 1976,
  1984, 1992, 2000, 2008, 2016, 2024, 2032, 2040,
  0, 9, 18, 27, 36, 45, 54, 63,
  72, 65, 90, 83, 108, 101, 126, 119,
  144, 153, 130, 139, 180, 189, 166, 175,
  216, 209, 202, 195, 252, 245, 238, 231,
  288, 297, 306, 315, 260, 269, 278, 287,
  360, 353, 378, 371, 332, 325, 350, 343,
  432, 441, 418, 427, 404, 413, 390, 399,
  504, 497, 490, 483, 476, 469, 462, 455,
  576, 585, 594, 603, 612, 621, 630, 639,
  520, 513, 538, 531, 556, 549, 574, 567,
  720, 729, 706, 715, 756, 765, 742, 751,
  664, 657, 650, 643, 700, 693, 686, 679,
  864, 873, 882, 891, 836, 845, 854, 863,
  808, 801, 826, 819, 780, 773, 798, 791,
  1008, 1017, 994, 1003, 980, 989, 966, 975,
  952, 945, 938, 931, 924, 917, 910, 903,
  1152, 1161, 1170, 1179, 1188, 1197, 1206, 1215,
  1224, 1217, 1242, 1235, 1260, 1253, 1278, 1271,
  1040, 1049, 1026, 1035, 1076, 1085, 1062, 1071,
  1112, 1105, 1098, 1091, 1148, 1141, 1134, 1127,
  1440, 1449, 1458, 1467, 1412, 1421, 1430, 1439,
  1512, 1505, 1530, 1523, 1484, 1477, 1502, 1495,
  1328, 1337, 1314, 1323, 1300, 1309, 1286, 1295,
  1400, 1393, 1386, 1379, 1372, 1365, 1358, 1351,
  1728, 1737, 1746, 1755, 1764, 1773, 1782, 1791,
  1672, 1665, 1690, 1683, 1708, 1701, 1726, 1719,
  1616, 1625, 1602, 1611, 1652, 1661, 1638, 1647,
  1560, 1553, 1546, 1539, 1596, 1589, 1582, 1575,
  2016, 2025, 2034, 2043, 1988, 1997, 2006, 2015,
  1960, 1953, 1978, 1971, 1932, 1925, 1950, 1943,
  1904, 1913, 1890, 1899, 1876, 1885, 1862, 1871,
  1848, 1841, 1834, 1827, 1820, 1813, 1806, 1799,
  0, 10, 20, 30, 40, 34, 60, 54,
  80, 90, 68, 78, 120, 114, 108, 102,
  160, 170, 180, 190, 136, 130, 156, 150,
  240, 250, 228, 238, 216, 210, 204, 198,
  320, 330, 340, 350, 360, 354, 380, 374,
  272, 282, 260, 270, 312, 306, 300, 294,
  480, 490, 500, 510, 456, 450, 476, 470,
  432, 442, 420, 430, 408, 402, 396, 390,
  640, 650, 660, 670, 680, 674, 700, 694,
  720, 730, 708, 718, 760, 754, 748, 742,
  544, 554, 564, 574, 520, 514, 540, 534,
  624, 634, 612, 622, 600, 594, 588, 582,
  960, 970, 980, 990, 1000, 994, 1020, 1014,
  912, 922, 900, 910, 952, 946, 940, 934,
  864, 874, 884, 894, 840, 834, 860, 854,
  816, 826, 804, 814, 792, 786, 780, 774,
  1280, 1290, 1300, 1310, 1320, 1314, 1340, 1334,
  1360, 1370, 1348, 1358, 1400, 1394, 1388, 1382,
  1440, 1450, 1460, 1470, 1416, 1410, 1436, 1430,
  1520, 1530, 1508, 1518, 1496, 1490, 1484, 1478,
  1088, 1098, 1108, 1118, 1128, 1122, 1148, 1142,
  1040, 1050, 1028, 1038, 1080, 1074, 1068, 1062,
  1248, 1258, 1268, 1278, 1224, 1218, 1244, 1238,
  1200, 1210, 1188, 1198, 1176, 1170, 1164, 1158,
  1920, 1930, 1940, 1950, 1960, 1954, 1980, 1974,
  2000, 2010, 1988, 1998, 2040, 2034, 2028, 2022,
  1824, 1834, 1844, 1854, 1800, 1794, 1820, 1814,
  1904, 1914, 1892, 1902, 1880, 1874, 1868, 1862,
  1728, 1738, 1748, 1758, 1768, 1762, 1788, 1782,
  1680, 1690, 1668, 1678, 1720, 1714, 1708, 1702,
  1632, 1642, 1652, 1662, 1608, 1602, 1628, 1622,
  1584, 1594, 1572, 1582, 1560, 1554, 1548, 1542,
  0, 11, 22, 29, 44, 39, 58, 49,
  88, 83, 78, 69, 116, 127, 98, 105,
  176, 187, 166, 173, 156, 151, 138, 129,
  232, 227, 254, 245, 196, 207, 210, 217,
  352, 363, 374, 381, 332, 327, 346, 337,
  312, 307, 302, 293, 276, 287, 258, 265,
  464, 475, 454, 461, 508, 503, 490, 481,
  392, 387, 414, 405, 420, 431, 434, 441,
  704, 715, 726, 733, 748, 743, 762, 753,
  664, 659, 654, 645, 692, 703, 674, 681,
  624, 635, 614, 621, 604, 599, 586, 577,
  552, 547, 574, 565, 516, 527, 530, 537,
  928, 939, 950, 957, 908, 903, 922, 913,
  1016, 1011, 1006, 997, 980, 991, 962, 969,
  784, 795, 774, 781, 828, 823, 810, 801,
  840, 835, 862, 853, 868, 879, 882, 889,
  1408, 1419, 1430, 1437, 1452, 1447, 1466, 1457,
  1496, 1491, 1486, 1477, 1524, 1535, 1506, 1513,
  1328, 1339, 1318, 1325, 1308, 1303, 1290, 1281,
  1384, 1379, 1406, 1397, 1348, 1359, 1362, 1369,
  1248, 1259, 1270, 1277, 1228, 1223, 1242, 1233,
  1208, 1203, 1198, 1189, 1172, 1183, 1154, 1161,
  1104, 1115, 1094, 1101, 1148, 1143, 1130, 1121,
  1032, 1027, 1054, 1045, 1060, 1071, 1074, 1081,
  1856, 1867, 1878, 1885, 1900, 1895, 1914, 1905,
  1816, 1811, 1806, 1797, 1844, 1855, 1826, 1833,
  2032, 2043, 2022, 2029, 2012, 2007, 1994, 1985,
  1960, 1955, 1982, 1973, 1924, 1935, 1938, 1945,
  1568, 1579, 1590, 1597, 1548, 1543, 1562, 1553,
  1656, 1651, 1646, 1637, 1620, 1631, 1602, 1609,
  1680, 1691, 1670, 1677, 1724, 1719, 1706, 1697,
  1736, 1731, 1758, 1749, 1764, 1775, 1778, 1785,
  0, 12, 24, 20, 48, 60, 40, 36,
  96, 108, 120, 116, 80, 92, 72, 68,
  192, 204, 216, 212, 240, 252, 232, 228,
  160, 172, 184, 180, 144, 156, 136, 132,
  384, 396, 408, 404, 432, 444, 424, 420,
  480, 492, 504, 500, 464, 476, 456, 452,
  320, 332, 344, 340, 368, 380, 360, 356,
  288, 300, 312, 308, 272, 284, 264, 260,
  768, 780, 792, 788, 816, 828, 808, 804,
  864, 876, 888, 884, 848, 860, 840, 836,
  960, 972, 984, 980, 1008, 1020, 1000, 996,
  928, 940, 952, 948, 912, 924, 904, 900,
  640, 652, 664, 660, 688, 700, 680, 676,
  736, 748, 760, 756, 720, 732, 712, 708,
  576, 588, 600, 596, 624, 636, 616, 612,
  544, 556, 568, 564, 528, 540, 520, 516,
  1536, 1548, 1560, 1556, 1584, 1596, 1576, 1572,
  1632, 1644, 1656, 1652, 1616, 1628, 1608, 1604,
  1728, 1740, 1752, 1748, 1776, 1788, 1768, 1764,
  1696, 1708, 1720, 1716, 1680, 1692, 1672, 1668,
  1920, 1932, 1944, 1940, 1968, 1980, 1960, 1956,
  2016, 2028, 2040, 2036, 2000, 2012, 1992, 1988,
  1856, 1868, 1880, 1876, 1904, 1916, 1896, 1892,
  1824, 1836, 1848, 1844, 1808, 1820, 1800, 1796,
  1280, 1292, 1304, 1300, 1328, 1340, 1320, 1316,
  1376, 1388, 1400, 1396, 1360, 1372, 1352, 1348,
  1472, 1484, 1496, 1492, 1520, 1532, 1512, 1508,
  1440, 1452, 1464, 1460, 1424, 1436, 1416, 1412,
  1152, 1164, 1176, 1172, 1200, 1212, 1192, 1188,
  1248, 1260, 1272, 1268, 1232, 1244, 1224, 1220,
  1088, 1100, 1112, 1108, 1136, 1148, 1128, 1124,
  1056, 1068, 1080, 1076, 1040, 1052, 1032, 1028,
  0, 13, 26, 23, 52, 57, 46, 35,
  104, 101, 114, 127, 92, 81, 70, 75,
  208, 221, 202, 199, 228, 233, 254, 243,
  184, 181, 162, 175, 140, 129, 150, 155,
  416, 429, 442, 439, 404, 409, 398, 387,
  456, 453, 466, 479, 508, 497, 486, 491,
  368, 381, 362, 359, 324, 329, 350, 339,
  280, 277, 258, 271, 300, 289, 310, 315,
  832, 845, 858, 855, 884, 889, 878, 867,
  808, 805, 818, 831, 796, 785, 774, 779,
  912, 925, 906, 903, 932, 937, 958, 947,
  1016, 1013, 994, 1007, 972, 961, 982, 987,
  736, 749, 762, 759, 724, 729, 718, 707,
  648, 645, 658, 671, 700, 689, 678, 683,
  560, 573, 554, 551, 516, 521, 542, 531,
  600, 597, 578, 591, 620, 609, 630, 635,
  1664, 1677, 1690, 1687, 1716, 1721, 1710, 1699,
  1768, 1765, 1778, 1791, 1756, 1745, 1734, 1739,
  1616, 1629, 1610, 1607, 1636, 1641, 1662, 1651,
  1592, 1589, 1570, 1583, 1548, 1537, 1558, 1563,
  1824, 1837, 1850, 1847, 1812, 1817, 1806, 1795,
  1864, 1861, 1874, 1887, 1916, 1905, 1894, 1899,
  2032, 2045, 2026, 2023, 1988, 1993, 2014, 2003,
  1944, 1941, 1922, 1935, 1964, 1953, 1974, 1979,
  1472, 1485, 1498, 1495, 1524, 1529, 1518, 1507,
  1448, 1445, 1458, 1471, 1436, 1425, 1414, 1419,
  1296, 1309, 1290, 1287, 1316, 1321, 1342, 1331,
  1400, 1397, 1378, 1391, 1356, 1345, 1366, 1371,
  1120, 1133, 1146, 1143, 1108, 1113, 1102, 1091,
  1032, 1029, 1042, 1055, 1084, 1073, 1062, 1067,
  1200, 1213, 1194, 1191, 1156, 1161, 1182, 1171,
  1240, 1237, 1218, 1231, 1260, 1249, 1270, 1275,
  0, 14, 28, 18, 56, 54, 36, 42,
  112, 126, 108, 98, 72, 70, 84, 90,
  224, 238, 252, 242, 216, 214, 196, 202,
  144, 158, 140, 130, 168, 166, 180, 186,
  448, 462, 476, 466, 504, 502, 484, 490,
  432, 446, 428, 418, 392, 390, 404, 410,
  288, 302, 316, 306, 280, 278, 260, 266,
  336, 350, 332, 322, 360, 358, 372, 378,
  896, 910, 924, 914, 952, 950, 932, 938,
  1008, 1022, 1004, 994, 968, 966, 980, 986,
  864, 878, 892, 882, 856, 854, 836, 842,
  784, 798, 780, 770, 808, 806, 820, 826,
  576, 590, 604, 594, 632, 630, 612, 618,
  560, 574, 556, 546, 520, 518, 532, 538,
  672, 686, 700, 690, 664, 662, 644, 650,
  720, 734, 716, 706, 744, 742, 756, 762,
  1792, 1806, 1820, 1810, 1848, 1846, 1828, 1834,
  1904, 1918, 1900, 1890, 1864, 1862, 1876, 1882,
  2016, 2030, 2044, 2034, 2008, 2006, 1988, 1994,
  1936, 1950, 1932, 1922, 1960, 1958, 1972, 1978,
  1728, 1742, 1756, 1746, 1784, 1782, 1764, 1770,
  1712, 1726, 1708, 1698, 1672, 1670, 1684, 1690,
  1568, 1582, 1596, 1586, 1560, 1558, 1540, 1546,
  1616, 1630, 1612, 1602, 1640, 1638, 1652, 1658,
  1152, 1166, 1180, 1170, 1208, 1206, 1188, 1194,
  1264, 1278, 1260, 1250, 1224, 1222, 1236, 1242,
  1120, 1134, 1148, 1138, 1112, 1110, 1092, 1098,
  1040, 1054, 1036, 1026, 1064, 1062, 1076, 1082,
  1344, 1358, 1372, 1362, 1400, 1398, 1380, 1386,
  1328, 1342, 1324, 1314, 1288, 1286, 1300, 1306,
  1440, 1454, 1468, 1458, 1432, 1430, 1412, 1418,
  1488, 1502, 1484, 1474, 1512, 1510, 1524, 1530,
  0, 15, 30, 17, 60, 51, 34, 45,
  120, 119, 102, 105, 68, 75, 90, 85,
  240, 255, 238, 225, 204, 195, 210, 221,
  136, 135, 150, 153, 180, 187, 170, 165,
  480, 495, 510, 497, 476, 467, 450, 461,
  408, 407, 390, 393, 420, 427, 442, 437,
  272, 287, 270, 257, 300, 291, 306, 317,
  360, 359, 374, 377, 340, 347, 330, 325,
  960, 975, 990, 977, 1020, 1011, 994, 1005,
  952, 951, 934, 937, 900, 907, 922, 917,
  816, 831, 814, 801, 780, 771, 786, 797,
  840, 839, 854, 857, 884, 891, 874, 869,
  544, 559, 574, 561, 540, 531, 514, 525,
  600, 599, 582, 585, 612, 619, 634, 629,
  720, 735, 718, 705, 748, 739, 754, 765,
  680, 679, 694, 697, 660, 667, 650, 645,
  1920, 1935, 1950, 1937, 1980, 1971, 1954, 1965,
  2040, 2039, 2022, 2025, 1988, 1995, 2010, 2005,
  1904, 1919, 1902, 1889, 1868, 1859, 1874, 1885,
  1800, 1799, 1814, 1817, 1844, 1851, 1834, 1829,
  1632, 1647, 1662, 1649, 1628, 1619, 1602, 1613,
  1560, 1559, 1542, 1545, 1572, 1579, 1594, 1589,
  1680, 1695, 1678, 1665, 1708, 1699, 1714, 1725,
  1768, 1767, 1782, 1785, 1748, 1755, 1738, 1733,
  1088, 1103, 1118, 1105, 1148, 1139, 1122, 1133,
  1080, 1079, 1062, 1065, 1028, 1035, 1050, 1045,
  1200, 1215, 1198, 1185, 1164, 1155, 1170, 1181,
  1224, 1223, 1238, 1241, 1268, 1275, 1258, 1253,
  1440, 1455, 1470, 1457, 1436, 1427, 1410, 1421,
  1496, 1495, 1478, 1481, 1508, 1515, 1530, 1525,
  1360, 1375, 1358, 1345, 1388, 1379, 1394, 1405,
  1320, 1319, 1334, 1337, 1300, 1307, 1290, 1285,
};

static const gf2_u16 fast_gf2_shift_u16[] = {
  0, 43, 86, 125, 172, 135, 250, 209,
  344, 371, 270, 293, 500, 479, 418, 393,
  688, 667, 742, 717, 540, 567, 586, 609,
  1000, 963, 958, 917, 836, 879, 786, 825,
  1376, 1355, 1334, 1309, 1484, 1511, 1434, 1457,
  1080, 1043, 1134, 1093, 1172, 1215, 1218, 1257,
  2000, 2043, 1926, 1965, 1916, 1879, 1834, 1793,
  1672, 1699, 1758, 1781, 1572, 1551, 1650, 1625,
  2752, 2795, 2710, 2749, 2668, 2631, 2618, 2577,
  2968, 2995, 3022, 3045, 2868, 2847, 2914, 2889,
  2160, 2139, 2086, 2061, 2268, 2295, 2186, 2209,
  2344, 2307, 2430, 2389, 2436, 2479, 2514, 2553,
  4000, 3979, 4086, 4061, 3852, 3879, 3930, 3953,
  3832, 3795, 3758, 3717, 3668, 3711, 3586, 3625,
  3344, 3387, 3398, 3437, 3516, 3479, 3562, 3521,
  3144, 3171, 3102, 3125, 3300, 3279, 3250, 3225,
  5504, 5547, 5590, 5629, 5420, 5383, 5498, 5457,
  5336, 5363, 5262, 5285, 5236, 5215, 5154, 5129,
  5936, 5915, 5990, 5965, 6044, 6071, 6090, 6113,
  5736, 5699, 5694, 5653, 5828, 5871, 5778, 5817,
  4320, 4299, 4278, 4253, 4172, 4199, 4122, 4145,
  4536, 4499, 4590, 4549, 4372, 4415, 4418, 4457,
  4688, 4731, 4614, 4653, 4860, 4823, 4778, 4737,
  4872, 4899, 4958, 4981, 5028, 5007, 5106, 5081,
  8000, 8043, 7958, 7997, 8172, 8135, 8122, 8081,
  7704, 7731, 7758, 7781, 7860, 7839, 7906, 7881,
  7664, 7643, 7590, 7565, 7516, 7543, 7434, 7457,
  7336, 7299, 7422, 7381, 7172, 7215, 7250, 7289,
  6688, 6667, 6774, 6749, 6796, 6823, 6874, 6897,
  7032, 6995, 6958, 6917, 7124, 7167, 7042, 7081,
  6288, 6331, 6342, 6381, 6204, 6167, 6250, 6209,
  6600, 6627, 6558, 6581, 6500, 6479, 6450, 6425,
};

static const gf2_u32 fast_gf2_shift_u32[] = {
  0, 141, 282, 407, 564, 697, 814, 931, 
  1128, 1253, 1394, 1535, 1628, 1745, 1862, 1995, 
  2256, 2141, 2506, 2375, 2788, 2665, 3070, 2931, 
  3256, 3125, 3490, 3375, 3724, 3585, 3990, 3867, 
  4512, 4397, 4282, 4151, 5012, 4889, 4750, 4611, 
  5576, 5445, 5330, 5215, 6140, 6001, 5862, 5739, 
  6512, 6653, 6250, 6375, 6980, 7113, 6750, 6867, 
  7448, 7573, 7170, 7311, 7980, 8097, 7734, 7867, 
  9024, 9165, 8794, 8919, 8564, 8697, 8302, 8419, 
  10024, 10149, 9778, 9919, 9500, 9617, 9222, 9355, 
  11152, 11037, 10890, 10759, 10660, 10537, 10430, 10291, 
  12280, 12149, 12002, 11887, 11724, 11585, 11478, 11355, 
  13024, 12909, 13306, 13175, 12500, 12377, 12750, 12611, 
  13960, 13829, 14226, 14111, 13500, 13361, 13734, 13611, 
  14896, 15037, 15146, 15271, 14340, 14473, 14622, 14739, 
  15960, 16085, 16194, 16335, 15468, 15585, 15734, 15867, 
  18048, 17933, 18330, 18199, 17588, 17465, 17838, 17699, 
  17128, 16997, 17394, 17279, 16604, 16465, 16838, 16715, 
  20048, 20189, 20298, 20423, 19556, 19689, 19838, 19955, 
  19000, 19125, 19234, 19375, 18444, 18561, 18710, 18843, 
  22304, 22445, 22074, 22199, 21780, 21913, 21518, 21635, 
  21320, 21445, 21074, 21215, 20860, 20977, 20582, 20715, 
  24560, 24445, 24298, 24167, 24004, 23881, 23774, 23635, 
  23448, 23317, 23170, 23055, 22956, 22817, 22710, 22587, 
  26048, 25933, 25818, 25687, 26612, 26489, 26350, 26211, 
  25000, 24869, 24754, 24639, 25500, 25361, 25222, 25099, 
  27920, 28061, 27658, 27783, 28452, 28585, 28222, 28339, 
  27000, 27125, 26722, 26863, 27468, 27585, 27222, 27355, 
  29792, 29933, 30074, 30199, 30292, 30425, 30542, 30659, 
  28680, 28805, 28946, 29087, 29244, 29361, 29478, 29611, 
  31920, 31805, 32170, 32039, 32388, 32265, 32670, 32531, 
  30936, 30805, 31170, 31055, 31468, 31329, 31734, 31611, 
};

static gf2_u16 gf2_fast_u16_mul (gf2_u16 a, gf2_u16 b);
static gf2_u32 gf2_fast_u32_mul (gf2_u32 a, gf2_u32 b);

static gf2_u16 gf2_long_mod_inverse_u16 (gf2_u16 x);
static gf2_u32 gf2_long_mod_inverse_u32 (gf2_u32 x);

static gf2_u16 gf2_long_mod_power_u16 (gf2_u16 x, gf2_u16 y);
static gf2_u32 gf2_long_mod_power_u32 (gf2_u32 x, gf2_u32 y);

gf2_u32 gf2_mul (int width, gf2_u32 a, gf2_u32 b) {
  /* keep 8-bit log/exp tables handy */
  static const gf2_s16 *log_table=fast_gf2_log;
  static const gf2_u8  *exp_table=fast_gf2_exp+512;

  switch (width) {
  case 8:
    return exp_table[log_table[a] + log_table[b]];
  case 16:
    return gf2_fast_u16_mul(a,b);
  case 32:
    return gf2_fast_u32_mul(a,b);
  default:
    fprintf (stderr, "gf2_mul: width %d not one of (8,16,32)\n",width);
    return 0;
  }
}

gf2_u32 gf2_inv (int width, gf2_u32 a) {
  /* keep 8-bit log/exp tables handy */
  static const gf2_s16 *log_table=fast_gf2_log;
  static const gf2_u8  *exp_table=fast_gf2_exp+512;

  switch (width) {
  case 8:
    return exp_table[255-log_table[a]];
  case 16:
    return gf2_long_mod_inverse_u16(a);
  case 32:
    return gf2_long_mod_inverse_u32(a);
  default:
    fprintf (stderr, "gf2_inv: width %d not one of (8,16,32)\n",width);
    return 0;
  }
}

gf2_u32 gf2_div (int width, gf2_u32 a, gf2_u32 b) {
  /* keep 8-bit log/exp tables handy */
  static const gf2_s16 *log_table=fast_gf2_log;
  static const gf2_u8  *exp_table=fast_gf2_exp+512;

  switch (width) {
  case 8:
    return exp_table[255 + log_table[a] - log_table[b]];
  case 16:
    return gf2_fast_u16_mul(a, gf2_long_mod_inverse_u16(b));
  case 32:
    return gf2_fast_u32_mul(a, gf2_long_mod_inverse_u32(b));
  default:
    fprintf (stderr, "gf2_div: width %d not one of (8,16,32)\n",width);
    return 0;
  }
}

gf2_u32 gf2_pow (int width, gf2_u32 a, gf2_u32 b) {
  /* keep 8-bit log/exp tables handy */
  static const gf2_s16 *log_table=fast_gf2_log;
  static const gf2_u8  *exp_table=fast_gf2_exp+512;

  switch (width) {
  case 8:
    return exp_table[(log_table[ (gf2_u8) a ] *  (gf2_u8) b) % 255];
  case 16:
    return gf2_long_mod_power_u16(a, b);
  case 32:
    return gf2_long_mod_power_u32(a, b);
  default:
    fprintf (stderr, "gf2_pow: width %d not one of (8,16,32)\n",width);
    return 0;
  }
}

/* Multiplication */

static gf2_u16 gf2_fast_u16_mul (gf2_u16 a, gf2_u16 b) {
  static const gf2_u16 *lmul_table=fast_gf2_lmul;
  static const gf2_u16 *rmul_table=fast_gf2_rmul;
  static const gf2_u16 *shift_tab =fast_gf2_shift_u16;

  /* break a into four nibbles, b into two 8-bit words */
  gf2_u16 a3=((a >> 4 ) & 0x0f00);
  gf2_u16 a2=((a      ) & 0x0f00);
  gf2_u16 a1=((a << 4 ) & 0x0f00);
  gf2_u16 a0=((a << 8 ) & 0x0f00);
  gf2_u16 b1=((b >> 8 ) & 0x00ff);
  gf2_u16 b0=((b      ) & 0x00ff);

  gf2_u16 c = lmul_table[a3 | b1] ^ rmul_table[a2 | b1] ;

  /* no safe shifts */
  c = (c << 8) ^ shift_tab[c >> 8];
  c ^=  lmul_table[a3 | b0] ^ rmul_table[a2 | b0];
  c ^=  lmul_table[a1 | b1] ^ rmul_table[a0 | b1];
  c = (c << 8) ^ shift_tab[c >> 8];

  return c ^ lmul_table[a1 | b0] ^ rmul_table[a0 | b0];
}

static gf2_u32 gf2_fast_u32_mul (gf2_u32 a, gf2_u32 b) {
  static const gf2_u16 *lmul_table=fast_gf2_lmul;
  static const gf2_u16 *rmul_table=fast_gf2_rmul;
  static const gf2_u32 *shift_tab=fast_gf2_shift_u32;

  /* break a into 8 nibbles, b into four 8-bit words */
  gf2_u16 a7=((a >> 20) & 0x0f00);
  gf2_u16 a6=((a >> 16) & 0x0f00);
  gf2_u16 a5=((a >> 12) & 0x0f00);
  gf2_u16 a4=((a >> 8 ) & 0x0f00);
  gf2_u16 a3=((a >> 4 ) & 0x0f00);
  gf2_u16 a2=((a      ) & 0x0f00);
  gf2_u16 a1=((a << 4 ) & 0x0f00);
  gf2_u16 a0=((a << 8 ) & 0x0f00);
  gf2_u16 b3=((b >> 24) & 0x00ff);
  gf2_u16 b2=((b >> 16) & 0x00ff);
  gf2_u16 b1=((b >>  8) & 0x00ff);
  gf2_u16 b0=((b      ) & 0x00ff);

  gf2_u32 c = lmul_table[a7 | b3] ^ rmul_table[a6 | b3] ;

  c <<= 8;  /* the first 2 shifts are safe from overflow. */
  c ^=  lmul_table[a7 | b2] ^ rmul_table[a6 | b2];
  c ^=  lmul_table[a5 | b3] ^ rmul_table[a4 | b3];
  c <<= 8;  /* the first 2 shifts are safe from overflow. */
  c ^=  lmul_table[a7 | b1] ^ rmul_table[a6 | b1];
  c ^=  lmul_table[a5 | b2] ^ rmul_table[a4 | b2];
  c ^=  lmul_table[a3 | b3] ^ rmul_table[a2 | b3];
  c = (c << 8) ^ shift_tab[c >> 24];
  c ^=  lmul_table[a7 | b0] ^ rmul_table[a6 | b0];
  c ^=  lmul_table[a5 | b1] ^ rmul_table[a4 | b1];
  c ^=  lmul_table[a3 | b2] ^ rmul_table[a2 | b2];
  c ^=  lmul_table[a1 | b3] ^ rmul_table[a0 | b3];
  c = (c << 8) ^ shift_tab[c >> 24];
  c ^=  lmul_table[a5 | b0] ^ rmul_table[a4 | b0];
  c ^=  lmul_table[a3 | b1] ^ rmul_table[a2 | b1];
  c ^=  lmul_table[a1 | b2] ^ rmul_table[a0 | b2];
  c = (c << 8) ^ shift_tab[c >> 24];
  c ^=  lmul_table[a3 | b0] ^ rmul_table[a2 | b0];
  c ^=  lmul_table[a1 | b1] ^ rmul_table[a0 | b1];
  c = (c << 8) ^ shift_tab[c >> 24];

  return c ^ lmul_table[a1 | b0] ^ rmul_table[a0 | b0];
}

/* Inverse */

static unsigned char size_of_byte[256]= {
  0,1,2,2,3,3,3,3,4,4,4,4,4,4,4,4, 5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
  6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6, 6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7, 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
  7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7, 7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
  8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
};

static int size_in_bits_u16 (gf2_u16 word) {
  if (word & 0xff00) {
    return 8 + size_of_byte[word >> 8];
  } else {
    return size_of_byte[word];
  }
}

static gf2_u16 gf2_long_mod_inverse_u16 (gf2_u16 x) {
  gf2_u16 u,v,z,g,t; 
  int i; 
  if (x < 2) return x; 
  u = poly_u16; v = x; z = 0; g = 1;
  i=16 + 1 - size_in_bits_u16(v);
  u^=(v<<i); z^=(g<<i); 
  while (u != 1) { 
    i=size_in_bits_u16(u) - size_in_bits_u16(v);
    if (i < 0) { 
      t=u; u=v; v=t; 
      t=z; z=g; g=t; 
      i=-i;
    } 
    u ^= (v << i); z ^= (g << i);
  }
  return z;
}

static int size_in_bits_u32 (gf2_u32 word) {
  if (word & 0xff000000l) {
    return 24 + size_of_byte[word >> 24];
  } else if (word & 0xff0000) {
    return 16 + size_of_byte[word >> 16];
  } else if (word & 0xff00) {
    return 8 + size_of_byte[word >> 8 ];
  } else {
    return size_of_byte[word];
  }
}

static gf2_u32 gf2_long_mod_inverse_u32 (gf2_u32 x) {
  gf2_u32 u,v,z,g,t;
  int i;
  if (x < 2) return x;
  u = poly_u32; v = x; z = 0; g = 1;
  i=32 + 1 - size_in_bits_u32(v);
  u^=(v<<i); z^=(g<<i);
  while (u != 1) {
    i=size_in_bits_u32(u) - size_in_bits_u32(v);
    if (i < 0) {
      t=u; u=v; v=t;
      t=z; z=g; g=t;
      i=-i;
    }
    u ^= (v << i); z ^= (g << i);
  }
  return z;
}

/* Power */

static gf2_u16 gf2_long_mod_power_u16 (gf2_u16 x, gf2_u16 y) {
  gf2_u16 z = x;
  gf2_u16 mask = 0x8000;
  if ((y == 0) || (y == 0xffff)) return 1;
  mask >>= (16 - size_in_bits_u16(y));
  while (mask>>=1) {
    z=gf2_fast_u16_mul(z,z);
    if (y & mask) {
      z=gf2_fast_u16_mul(x,z);
    }
  }
  return z;
}

static gf2_u32 gf2_long_mod_power_u32 (gf2_u32 x, gf2_u32 y) {
  gf2_u32 z = x;
  gf2_u32 mask = 0x80000000l;
  if ((y == 0) || (y == 0xffffffffl)) return 1;
  mask >>= (32 - size_in_bits_u32(y));
  while (mask>>=1) {
    z=gf2_fast_u32_mul(z,z);
    if (y & mask) {
      z=gf2_fast_u32_mul(x,z);
    }
  }
  return z;
}

gf2_u32 gf2_info(int bits) {
  switch(bits) {
  case 8:
    return poly_u8;
  case 16:
    return poly_u16;
  case 32:
    return poly_u32;
  default:
    return sizeof(size_of_byte) + sizeof(fast_gf2_log) +
      sizeof(fast_gf2_exp) + sizeof(fast_gf2_lmul) +
      sizeof(fast_gf2_rmul) + sizeof(fast_gf2_shift_u16) +
      sizeof(fast_gf2_shift_u32);
  }
}
