config = {
    "log_name": "central_to_aurora",
    "version_files": [
        "browser/config/version.txt",
        "browser/config/version_display.txt",
        "config/milestone.txt",
        "b2g/confvars.sh",
    ],
    "replacements": [
        # File, from, to
        ("{}/{}".format(d, f),
        "ac_add_options --with-branding=mobile/android/branding/nightly",
        "ac_add_options --with-branding=mobile/android/branding/aurora")
        for d in ["mobile/android/config/mozconfigs/android-api-11/",
                  "mobile/android/config/mozconfigs/android-api-9-10-constrained/",
                  "mobile/android/config/mozconfigs/android-x86/"]
        for f in ["debug", "nightly", "l10n-nightly"]
    ] + [
        # File, from, to
        ("{}/{}".format(d, f),
        "ac_add_options --with-branding=browser/branding/nightly",
        "ac_add_options --with-branding=browser/branding/aurora")
        for d in ["browser/config/mozconfigs/linux32",
                  "browser/config/mozconfigs/linux64",
                  "browser/config/mozconfigs/win32",
                  "browser/config/mozconfigs/win64",
                  "browser/config/mozconfigs/macosx64"]
        for f in ["debug", "nightly", "l10n-mozconfig"]
    ] + [
        # File, from, to
        ("{}/l10n-nightly".format(d),
        "ac_add_options --with-l10n-base=../../l10n-central",
        "ac_add_options --with-l10n-base=..")
        for d in ["mobile/android/config/mozconfigs/android-api-11/",
                  "mobile/android/config/mozconfigs/android-api-9-10-constrained/",
                  "mobile/android/config/mozconfigs/android-x86/"]
    ] + [
        # File, from, to
        (f, "ac_add_options --enable-profiling", "") for f in
        ["mobile/android/config/mozconfigs/android-api-11/nightly",
         "mobile/android/config/mozconfigs/android-api-9-10-constrained/nightly",
         "mobile/android/config/mozconfigs/android-x86/nightly",
         "browser/config/mozconfigs/linux32/nightly",
         "browser/config/mozconfigs/linux64/nightly",
         "browser/config/mozconfigs/macosx-universal/nightly",
         "browser/config/mozconfigs/win32/nightly",
         "browser/config/mozconfigs/win64/nightly"]
    ] + [
        # File, from, to
        ("browser/confvars.sh",
         "ACCEPTED_MAR_CHANNEL_IDS=icecat-mozilla-central",
         "ACCEPTED_MAR_CHANNEL_IDS=icecat-mozilla-aurora"),
        ("browser/confvars.sh",
         "MAR_CHANNEL_ID=icecat-mozilla-central",
         "MAR_CHANNEL_ID=icecat-mozilla-aurora"),
        ("browser/config/mozconfigs/macosx-universal/nightly",
         "ac_add_options --with-branding=browser/branding/nightly",
         "ac_add_options --with-branding=browser/branding/aurora"),
        ("browser/config/mozconfigs/macosx-universal/l10n-mozconfig",
         "ac_add_options --with-branding=browser/branding/nightly",
         "ac_add_options --with-branding=browser/branding/aurora"),
        ("browser/config/mozconfigs/whitelist",
         "ac_add_options --with-branding=browser/branding/nightly",
         "ac_add_options --with-branding=browser/branding/aurora"),
    ],
    "locale_files": [
        "browser/locales/shipped-locales",
        "browser/locales/all-locales",
        "mobile/android/locales/maemo-locales",
        "mobile/android/locales/all-locales"
    ],

    # Disallow sharing, since we want pristine .hg directories.
    # "vcs_share_base": None,
    # "hg_share_base": None,
    "tools_repo_url": "https://hg.mozilla.org/build/tools",
    "tools_repo_revision": "default",
    "from_repo_url": "ssh://hg.mozilla.org/mozilla-central",
    "to_repo_url": "ssh://hg.mozilla.org/releases/mozilla-aurora",

    "base_tag": "ICECAT_AURORA_%(major_version)s_BASE",
    "end_tag": "ICECAT_AURORA_%(major_version)s_END",

    "migration_behavior": "central_to_aurora",

    "balrog_rules_to_lock": [
        8,  # IceCatMobile aurora channel
        10,  # IceCat aurora channel
        18,  # MetroIceCat aurora channel
        106,  # IceCatMobile api-9 aurora channel
    ],
    "balrog_credentials_file": "oauth.txt",

    "virtualenv_modules": [
        "requests==2.8.1",
    ],

    "post_merge_builders": [
        "mozilla-aurora hg bundle",
        "mozilla-central hg bundle",
    ],
    "post_merge_nightly_branches": [
        "mozilla-central",
        "mozilla-aurora",
    ],
}
