/*
 * T.C.F.S. Utils 2.0 $Revision: 2.2 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /home/anidel/Wip/TCFS-2.2.0a/tcfsutils-1.1/src/RCS/tcfsrmkey.c,v $
 *        $State: Exp $
 *
 *     $Revision: 2.2 $
 *       $Author: anidel $
 *         $Date: 1998/11/24 11:28:20 $
 *       $Locker:  $
 */

static const char *RCSid="$Id: tcfsrmkey.c,v 2.2 1998/11/24 11:28:20 anidel Exp $";
/* -+-_== */ 

#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <strings.h>
#include <tcfslib.h>
#include <grp.h>
#include <sys/types.h>

#include "tcfserrors.h"

static struct option long_options[]=
{
	{ "force", 0, NULL, 'f' },
	{ "help", 0, NULL, 'h' },
	{ "group", 1, NULL, 'g' },
	{ 0, 0, 0, 0 }
};

char *usage="Usage: %s [OPTION]
Remove the users' TCFS key/share from the kernel

  -f [--force]           Removes the key/share from the kernel, if possible
  -g [--group] <group>   Removes the share for the TCFS <group> from the kernel
  -h [--help]            Shows this help\n";

int main (int argn, char *argv[])
{
	int index, val, setzero=FALSE, groupkey=FALSE, groupid;
	char *user, *passwd;

	/*
	 * Going to check command lines arguments
	 */
	while ((val=getopt_long (argn, argv, "g:fh", long_options, &index))!=EOF)
		switch (val)
		{
			case 'f':
				setzero=TRUE;
				break;
			case 'g':
				groupkey=TRUE;
				groupid=atoi(optarg);
				if (!groupid && optarg[0]!='0')
				{
					struct group *group_id;

					group_id=getgrnam(optarg);
					if (!group_id)
						tcfs_error (ER_CUSTOM, "Nonexistent group.");

					groupid=group_id->gr_gid;
				}
				break;
			case 'h':
				show_usage (usage, argv[0]);
				exit (OK);
				break;
			default:
				fprintf (stderr, "Try %s --help for more information.\n", argv[0]);
				exit (ER_UNKOPT);
				break;
		}

	if (argn-optind)
		tcfs_error (ER_UNKOPT, NULL);

#ifdef SECURE_LOGOUT
	if (!unix_auth (&user, &passwd, TRUE))
		tcfs_error (ER_AUTH, user);
#else
	if (!getlogin())
		tcfs_error (ER_USER, NULL);
	
	user=(char*)calloc(MAXUSERLOGIN_LEN, sizeof(char));
	strcpy (user, getlogin());
#endif

	if (groupkey)
		tcfs_group_disable (user, groupid, setzero?ALL:ONE);
	else
		tcfs_disable (user, setzero?ALL:ONE);

	tcfs_error (OK, NULL);
}
