#include <asm/segment.h>

#include <linux/errno.h>
#include <linux/fs.h>
#include <linux/ioctl.h>
#include <linux/sched.h>
#include <linux/mm.h>
#include <linux/malloc.h>
#include <linux/kdes.h>
#include <linux/tcfs_fs.h>

#include <linux/locks.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
/* This is for kernel_thread */
#define __KERNEL_SYSCALLS__
#include <linux/unistd.h>
/* These are the function needed to handle keys hash table */ 
#include "hash.h"

/* Implementation of TCFS ioctl functions. 
   Currently we have to handle some ioctl to put des keys into the
   kernel. Moreover we have to handle some ioctl for the extended 
   attributes. Here we have GETFLAGS and SETFLAGS to handle these
   attributes in a way compatible with the ext2 extended attributes.
   This means that one can use TCFS as a standard NFS file system
   and handle ext2 extended attributes via NFS as they are local.
   When we will develop XATTRD for other filesystem we will make it
   compatible with ext2 way so one can use ext2 extended attrs on
   filesystems other then ext2 !!!! */

int tcfs_ioctl(struct inode * inode, struct file * filp, unsigned int cmd,
unsigned long arg)
{
	struct login lg;
	struct tgroup gl; 
	int uid, gid;
	int err=0;
	des_key_schedule * ks;
	struct gid_hash_entry * ghtmp;
	struct hash_entry * he;
	unsigned int mode;
	struct tcfs_fattr fattr;
	int error;
	char tcfs_version[]={
                        TCFS_VERSION,
                        TCFS_VERSION_MINOR,
                        0,
			CIPHER_DES
                    }; 

	switch(cmd) {
	case TCFS_IOC_GETFLAGS:
		err = verify_area(VERIFY_WRITE, (int *) arg, sizeof(int));
		if (err)
			return err;
		put_user(inode->u.tcfs_i.tcfs_fl.cflag,(int *) arg);
		return 0;
	case TCFS_IOC_SETFLAGS:
		if (current->uid != inode->i_uid) {
			err=-EACCES;
			return err;
		}
		err = verify_area(VERIFY_READ, (int *) arg, sizeof(int));
		if (err)
			return err;
		memcpy_fromfs(&mode,(unsigned int *)arg,sizeof(int));
		TCFS_SEMW_DOWN(inode);
		err=tcfs_proc_seteattr(inode,&(inode->i_sb->u.tcfs_sb.x_server),inode->u.tcfs_i.pathname,mode,filp);
		TCFS_SEMW_UP(inode);
		error=tcfs_proc_getattr(TCFS_SERVER(inode), TCFS_FH(inode), &fattr);
		if (!error)
			tcfs_refresh_inode(inode,&fattr);
		return err;
	case TCFS_IOC_GETVERSION:
		err = verify_area(VERIFY_WRITE, (long *) arg, sizeof(long));
		if (err)
			return err;
		put_user(*(long *)tcfs_version, (long *)arg);
		return 0;
	case TCFS_IOC_SETVERSION: /* for compatibility purpouses */
		return 0;
	case TCFS_IOC_LOGIN:
		err = verify_area(VERIFY_READ, (unsigned char *) arg, sizeof(lg));
		if (err) {
			return err;
		}
		memcpy_fromfs(&lg,(struct login *)arg,sizeof(lg));
		/* ARGH ... here we have all we need ... UID, LEN of the deskey and DESKEY
		   We may initialize des and put the structure in a user key cache we have to
		   construct */
		ks=(des_key_schedule *)kmalloc(sizeof(des_key_schedule),GFP_KERNEL);  
		if (ks==NULL) {
			printk("TCFS: Unable to get a free page\n");
			return -ENOMEM;
		}
		des_set_key((des_cblock *)lg.deskey,*ks);
		if (hash_add(lg.uid,lg.deskey,ks)==NULL) {
			kfree(ks);
		}
		return 0;
	case TCFS_IOC_LOGOUT:
		printk("in TCFS_IOC_LOGOUT    \n");
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(uid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&uid,(unsigned int *)arg,sizeof(uid));
		printk(" TCFS_IOC_LOGOUT uid %u\n",uid);
		hash_rem_count(uid);
		return 0;
	case TCFS_IOC_FULLOUT:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(uid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&uid,(unsigned int *)arg,sizeof(uid));
		hash_rem_all(uid);
		return 0;
	case TCFS_IOC_SETFIX:
		if ((he=hash_lookup(current->uid))==NULL)
			return -EINVAL;
		he->permanent=1;
		return 0;
	case TCFS_IOC_GETFIX:
		err = verify_area(VERIFY_WRITE, (unsigned char *) arg, sizeof(unsigned char));
		if (err) {
			return err;
		}
		he=hash_lookup(current->uid);
		if (he==NULL)
			return -EINVAL;
		put_user(he->permanent,(unsigned char *)arg);
		return 0;
	case TCFS_IOC_GETCOUNT:
		err = verify_area(VERIFY_WRITE, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		he=hash_lookup(current->uid);
		if (he==NULL) {
			return -EINVAL;
			put_user(0,(unsigned int *)arg);
		}
		put_user(he->count,(unsigned int *)arg);
		return 0;
	case TCFS_IOC_DELFIX:
		he=hash_lookup(current->uid);
		if (he==NULL)
			return -EINVAL;
		hash_rem_permanent(current->uid);
		return 0;
	case TCFS_IOC_GLOGIN:
		err = verify_area(VERIFY_READ, (unsigned char *) arg, sizeof(gl));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gl,(struct tgroup *)arg,sizeof(gl));
#ifdef 1
		{
			int i;
			printk ("La chiave utente appena passata e': ");
			for (i=0;i<9;i++)
				printk ("%u:", gl.deskey[i]);
			printk ("\n");
		}
#endif

		if ((ghtmp=gid_hash_lookup(gl.gid))==NULL) 
			ghtmp=gid_hash_add(gl.gid);
		if (gid_uid_add(gl.gid,gl.uid,gl.deskey)==NULL)
			return 0;
		if (ghtmp->ins<gl.soglia)
			return 0; 
                if (ghtmp->ins>gl.soglia) {
/*			printk("A key already exist\n");*/
			return 0;
		}
		/* If we don't reach legal number then we don't interpolate keys */
		memset(ghtmp->gidkey,'\0',20);
		interp(ghtmp->key,ghtmp->ins,ghtmp->gidkey);
		if (ghtmp->ks==NULL) {
			ks=(des_key_schedule *)kmalloc(sizeof(des_key_schedule),GFP_KERNEL);  
			if (ks==NULL) {
				printk("TCFS: Unable to get a free page\n");
				return -ENOMEM;
			}
			ghtmp->ks=ks;
		}
		des_set_key((des_cblock *)ghtmp->gidkey,*(ghtmp->ks));
		return 0;
	case TCFS_IOC_GLOGOUT:
		err = verify_area(VERIFY_READ, (unsigned char *) arg, sizeof(gl));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gl,(struct tgroup *)arg,sizeof(gl));
		if ((ghtmp=gid_hash_lookup(gl.gid))==NULL) 
			return 0;
		gid_uid_rem_count(gl.gid,gl.uid);
		if (ghtmp->ins==0) {
			gid_hash_rem(gl.gid);
			return 0;
		}
		if (ghtmp->ins<gl.soglia) {
			printk("Removing group key\n");
			ks=ghtmp->ks;
			ghtmp->ks=NULL;
			kfree(ks);
			memset(ghtmp->gidkey,'\0',20);
			/* If we reach minimum number, we remove key */
		}
		return 0;
	case TCFS_IOC_GFULLOUT:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(gid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		gid_uid_rem_all(gid,current->uid);
		return 0;
	case TCFS_IOC_GSETFIX:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(gid));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		he->permanent=1;
		return 0;
	case TCFS_IOC_GGETFIX:
		err = verify_area(VERIFY_WRITE, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		put_user(he->permanent,(unsigned int *)arg);
		return 0;
	case TCFS_IOC_GGETCOUNT:
		err = verify_area(VERIFY_WRITE, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		put_user(he->count,(unsigned int *)arg);
		return 0;
	case TCFS_IOC_GDELFIX:
		err = verify_area(VERIFY_READ, (unsigned int *) arg, sizeof(unsigned int));
		if (err) {
			return err;
		}
		memcpy_fromfs(&gid,(unsigned int *)arg,sizeof(gid));
		if ((ghtmp=gid_hash_lookup(gid))==NULL)
			return -EINVAL;
		if ((he=gid_uid_lookup(ghtmp->key,current->uid))==NULL)
			return -EINVAL;
		gid_uid_rem_permanent(gid,current->uid);
		return 0;
	default:
			return -ENOTTY;
	}
}
