#include <linux/mm.h>
#include <linux/malloc.h>
/* On some kernel versions this is wait.h */
#include <asm/semaphore.h>
#include <linux/tcfs.h>
#include <linux/tcfs_fs_sb.h>
#include <linux/tcfs_fs.h>
#define INTERP
#include "hash.h"
#undef INTERP

int inverse[257]={
      0,1,129,86,193,103,43,147,225,200,180,187,150,178,
      202,120,241,121,100,230,90,49,222,190,75,72,89,238,
      101,195,60,199,249,148,189,235,50,132,115,145,45,163,
      153,6,111,40,95,175,166,21,36,126,173,97,119,243,179,248,
      226,61,30,59,228,102,253,87,74,234,223,149,246,181,25,
      169,66,24,186,247,201,244,151,165,210,96,205,127,3,65,
      184,26,20,209,176,152,216,46,83,53,139,135,18,28,63,5,
      215,164,177,245,188,224,250,44,218,116,124,38,113,134,
      159,54,15,17,158,140,114,220,51,85,255,2,172,206,37,143,
      117,99,240,242,203,98,123,144,219,133,141,39,213,7,33,69,
      12,80,93,42,252,194,229,239,122,118,204,174,211,41,105,
      81,48,237,231,73,192,254,130,52,161,47,92,106,13,56,10,
      71,233,191,88,232,76,11,108,34,23,183,170,4,155,29,198,
      227,196,31,9,78,14,138,160,84,131,221,236,91,82,162,217,
      146,251,104,94,212,112,142,125,207,22,68,109,8,58,197,
      62,156,19,168,185,182,67,35,208,167,27,157,136,16,137,
      55,79,107,70,77,57,32,110,214,154,64,171,128,256
};

struct keys {
	int uid;
	unsigned int key[8];
};

union bobbit { 
	unsigned char byte;
	struct {
		unsigned char b1:1;
		unsigned char b2:1;
		unsigned char b3:1;
		unsigned char b4:1;
		unsigned char b5:1;
		unsigned char b6:1;
		unsigned char b7:1;
		unsigned char b8:1;
	} bf;
};

unsigned int mod(long a) 
{
	register unsigned long eax asm("ax");
	register unsigned long edx asm("dx");
	unsigned long tmp=257;
	if (a<0) {
		while (a<0) a+=257;
		return a;
	}
	eax=a;
	edx=0;
	__asm__("divl %2"
			:"=a" (eax), "=d" (edx)
			:"r" (tmp), 
			"0" (eax), "1" (edx));
	return (int) edx;
}

void interp(struct hash_entry *ks,int n,unsigned char *gidkey)
{
	unsigned int tp,kkk;
	struct hash_entry *htmp=ks;
	int i=0,j,idx;
	struct keys *ktmp;
	unsigned int inv,ttt;
	union bobbit obits;
	
	ktmp=(struct keys*)kmalloc(sizeof(struct keys)*n,GFP_KERNEL);
	if (ktmp==NULL)
		return;
	while (htmp!=NULL && i<n) {
		ktmp[i].uid=htmp->uid;
		obits.byte=htmp->deskey[8];
		ktmp[i].key[0]=mod(obits.bf.b1<<8 | htmp->deskey[0]);
		ktmp[i].key[1]=mod(obits.bf.b2<<8 | htmp->deskey[1]);
		ktmp[i].key[2]=mod(obits.bf.b3<<8 | htmp->deskey[2]);
		ktmp[i].key[3]=mod(obits.bf.b4<<8 | htmp->deskey[3]);
		ktmp[i].key[4]=mod(obits.bf.b5<<8 | htmp->deskey[4]);
		ktmp[i].key[5]=mod(obits.bf.b6<<8 | htmp->deskey[5]);
		ktmp[i].key[6]=mod(obits.bf.b7<<8 | htmp->deskey[6]);
		ktmp[i].key[7]=mod(obits.bf.b8<<8 | htmp->deskey[7]);
#ifdef LIGHT_DEBUG_TCFS
		printk("La chiave passata di %d e' %u:%u:%u:%u:%u:%u:%u:%u:%u\n",
			ktmp[i].uid,
			htmp->deskey[0],
			htmp->deskey[1],
			htmp->deskey[2],
			htmp->deskey[3],
			htmp->deskey[4],
			htmp->deskey[5],
			htmp->deskey[6],
			htmp->deskey[7],
			htmp->deskey[8]);

		printk("La chiave di %d e' %u:%u:%u:%u:%u:%u:%u:%u\n",
			ktmp[i].uid,
			ktmp[i].key[0],
			ktmp[i].key[1],
			ktmp[i].key[2],
			ktmp[i].key[3],
			ktmp[i].key[4],
			ktmp[i].key[5],
			ktmp[i].key[6],
			ktmp[i].key[7]);
#endif
		i++;
		htmp=htmp->next;
	}

#ifdef LIGHT_DEBUG_TCFS
	printk ("La chiave segreta e': ");
#endif
	for (idx=0;idx<8;idx++) {
		kkk=0;
		for (i=0;i<n;i++) {
			tp=1;
			for (j=0;j<n;j++) {
				if (j!=i) {
					inv = inverse[mod(ktmp[i].uid-ktmp[j].uid)];
					ttt = mod(inv * mod(-ktmp[j].uid));
					tp = mod(tp * ttt);
				}
			}
			tp *= mod(ktmp[i].key[idx]);
			kkk=(tp+kkk);
		}
		gidkey[idx]=(unsigned char)mod(kkk);
#ifdef LIGHT_DEBUG_TCFS
		printk ("%u:", gidkey[idx]);
#endif
	}
#ifdef LIGHT_DEBUG_TCFS
	printk ("\n");
#endif
	kfree(ktmp);
}

/*void eval(int uid,unsigned char *ret)
{
	char key[8]="abcdefgh";
	int i;
	for (i=0;i<8;i++) {
		ret[i]=mod(2*uid*uid+5*uid+key[i]);
	}
}*/

void doinverse(void)
/* This function calculate the inverse of a number modulo 257 */
{
	int i,j;
	for (i=0;i<257;i++) {
		for (j=0;j<257;j++) {
			if (mod((i*j))==1)
				inverse[i]=j;
		}
	}
}

/*main()
{
	int i;
	unsigned char key[20];
	struct gid_hash_entry *htmp;

	doinverse();
	
	htmp=gid_hash_add(10);

	eval(5100,key);
	gid_uid_add(10,	5100,key);
	eval(5150,key);
	gid_uid_add(10,	5150,key);
	eval(5200,key);
	gid_uid_add(10,	5200,key);
	
	interp(htmp->key,3,key);
	key[8]='\0';
	printf("%s\n",key);
}*/
