#include <linux/kdes.h>
#include <linux/mm.h>
#include <linux/sched.h>
#include <linux/kernel.h>

void mkendes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long * xi;
	int i;
	char *tmp;

/*
#ifdef TCFS_DEBUG
	{       
                int i;  
                char *pnt;
    
		printk("TCFS_debug: in mkendes\n");
                printk("TCFS_debug: input key: ");
    
                pnt=(char *)&ks[0];
                for(i=0;i<16;i++,pnt++){
                        printk("%x:",(unsigned int)*pnt);
                }       
    		printk("\n");
	} 
#endif
*/

	xi=(long *)block;
	tmp=block;
	des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,ks,DES_ENCRYPT);
	tmp+=8;
	for (i=1;i<nb/8;i++) {
		*(xi+2)^=*xi;
		*(xi+3)^=*(xi+1);
		des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,ks,DES_ENCRYPT);
		tmp+=8;
		xi+=2;
	}
/*
#ifdef TCFS_DEBUG
	printk ("TCFS_debug: exiting mkendes\n");
#endif
*/
}

void mkdedes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long * xi,xo[2],xa[2];
	int i;
	char *tmp;

	xi=(long *)block;
	tmp=block;
	xo[0]=*xi; xo[1]=*(xi+1);
	des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,ks,DES_DECRYPT);
	tmp+=8;
	xi=(long *)tmp;
	for (i=1;i<nb/8;i++) {
		xa[0]=*xi; xa[1]=*(xi+1);
		des_ecb_encrypt((des_cblock *)tmp,(des_cblock *)tmp,ks,DES_DECRYPT);
		*(xi)^=xo[0];
		*(xi+1)^=xo[1];
		xo[0]=xa[0];  
		xo[1]=xa[1];
		tmp+=8;
		xi+=2;
	}
}

void mendes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long xo[2],in[2];
	int i;
	unsigned char *tmp;

/*
#ifdef TCFS_DEBUG
	{       
                int i;  
                char *pnt;
    
		printk("TCFS_debug: in mendes\n");
                printk("TCFS_debug: input key: ");
    
                pnt=(char *)&ks[0];
                for(i=0;i<16;i++,pnt++){
                        printk("%x:",(unsigned int)*pnt);
                }       
    		printk("\n");
        }
#endif
*/
	memcpy_fromfs(in,(long *)block,8L);
	tmp=block;
	des_ecb_encrypt((des_cblock *)in,(des_cblock *)in,ks,DES_ENCRYPT);
	memcpy_tofs((unsigned long *)tmp,in,8L);
	xo[0]=in[0]; xo[1]=in[1];
	tmp+=8;
	for (i=1;i<nb;i++) {
		memcpy_fromfs(in,(unsigned long *)tmp,8L);
		in[0]^=xo[0];
		in[1]^=xo[1];
		des_ecb_encrypt((des_cblock *)in,(des_cblock *)in,ks,DES_ENCRYPT);
		memcpy_tofs((unsigned long *)tmp,in,8L);
		xo[0]=in[0]; xo[1]=in[1];
		tmp+=8;
	}
/*
#ifdef TCFS_DEBUG
	printk("TCFS_debug: exiting mendes\n");
#endif
*/
}

void mdedes(char *block,int nb,des_key_schedule *ks)
{
	unsigned long xo[2],xa[2],xt[2];
	int i;
	unsigned char *tmp;

/*
#ifdef TCFS_DEBUG
	{       
                int i;  
                char *pnt;
    
		printk("TCFS_debug: in mdedes\n");
                printk("TCFS_debug: input key: ");
    
                pnt=(char *)&ks[0];
                for(i=0;i<16;i++,pnt++){
                        printk("%x:",(unsigned int)*pnt);
                }       
    		printk("\n");
        }
#endif
*/

	tmp=block;
	memcpy_fromfs(xo,(unsigned long *)tmp,8L);
	xt[0]=xo[0]; xt[1]=xo[1];
	des_ecb_encrypt((des_cblock *)xt,(des_cblock *)xt,ks,DES_DECRYPT);
	memcpy_tofs((unsigned long *)block,xt,8L);
	tmp+=8;
	for (i=1;i<nb;i++) {
		memcpy_fromfs(xa,(unsigned long *)tmp,8L);
		xt[0]=xa[0]; xt[1]=xa[1];
		des_ecb_encrypt((des_cblock *)xt,(des_cblock *)xt,ks,DES_DECRYPT);
		xt[0]^=xo[0]; xt[1]^=xo[1];
		memcpy_tofs((unsigned long *)tmp,xt,8L);
		xo[0]=xa[0]; xo[1]=xa[1];
		tmp+=8;
	}
/*
#ifdef TCFS_DEBUG
	printk("TCFS_debug: exiting mdedes\n");
#endif
*/
}
