/*
 * T.C.F.S. 2.0.1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */

/*
 * linux/include/linux/tcfsiod.h
 *
 * Declarations for asynchronous TCFS RPC calls.
 *
 */

#ifndef _LINUX_TCFSIOD_H
#define _LINUX_TCFSIOD_H

#include <linux/tcrpcsock.h>
#include <linux/tcfs_fs.h>

#ifdef __KERNEL__

/*
 * This is the callback handler for tcfsiod requests.
 * Note that the callback procedure must NOT sleep.
 */
struct tcfsiod_req;
typedef int	(*tcfsiod_callback_t)(int result, struct tcfsiod_req *);

/*
 * This is the tcfsiod request struct.
 */
struct tcfsiod_req {
	struct tcfsiod_req *	rq_next;
	struct tcfsiod_req *	rq_prev;
	struct wait_queue *	rq_wait;
	struct tcrpc_ioreq	rq_rpcreq;
	tcfsiod_callback_t	rq_callback;
	struct tcfs_server *	rq_server;
	struct inode *		rq_inode;
	struct page *		rq_page;

	/* user creds */
	uid_t			rq_fsuid;
	gid_t			rq_fsgid;
	int			rq_groups[NGROUPS];

	/* retry handling */
	int			rq_retries;
};

struct tcfsiod_req *	tcfsiod_reserve(struct tcfs_server *);
void			tcfsiod_release(struct tcfsiod_req *);
void			tcfsiod_enqueue(struct tcfsiod_req *);
int			tcfsiod(void);


#endif /* __KERNEL__ */
#endif /* _LINUX_TCFSIOD_H */
