/*
 * T.C.F.S. 2.0 Alpha 1 
 *
 *      	   This  program  handles  RPC  "NFS"  data  requests
 *              adopting a secure transfer protocol.
 *                 This   is  an  unsecure   and  unchecked  version,
 *              use at your own risk.
 *
 *              Please, report Bugs to: <tcfs@edu-gw.dia.unisa.it>
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@edu-gw.dia.unisa.it>
 *		Angelo Celentano, <angcel@edu-gw.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@edu-gw.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@edu-gw.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@edu-gw.dia.unisa.it>
 *
 *   Permission to  use, copy, and modify  this software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies  of  any  software  which  is  or  includes a  copy  or
 * modification of this software and in all copies  of the supporting
 * documentation for such software.
 *
 *   This  software is  distribuited  under  the  GNU General  Public
 * License  (version  2, June  1991). Check  the  file  'COPYING'  for
 * more  infos. Some  parts of  this  software  derive  from the  NFS
 * implementation in the Linux kernel 2.0.x.
 *
 * This software  maybe be used  for any  purpose provided  the above
 * copyright  notice  is retained.  It  is  supplied  as is,  with no
 * warranty expressed or implied.
 *
 */

/* -+-_== */

#define DES8(a)		((int)((((int)(a) % 8)!=0)?(((int)(a) & 0xfffffff8)+8):(int)(a)))

#ifdef TCFS_DES

#include <linux/kdes.h>

void ides(char *buffer,int numblocks, des_key_schedule *ks,int mode);
void ikdes(char *buffer,int numblocks, des_key_schedule *ks,int mode);

/* Use these defines to crypt and decrypt */
#define encrypt(x,y,z) ides(x,y,z,DES_ENCRYPT)
#define decrypt(x,y,z) ides(x,y,z,DES_DECRYPT)
/* These are for encryption in kernel memory */
#define kencrypt(x,y,z) ikdes(x,y,z,DES_ENCRYPT)
#define kdecrypt(x,y,z) ikdes(x,y,z,DES_DECRYPT)

void mkencrypt(char *,int,des_key_schedule *);
void mkdecrypt(char *,int,des_key_schedule *);
void mencrypt(char *,int,des_key_schedule *);
void mdecrypt(char *,int,des_key_schedule *);

#elif TCFS_IDEA

#include <linux/idea.h>

void encrypt(char *, int, idea_key_schedule *);
void decrypt(char *, int, idea_key_schedule *);
void kencrypt(char *, int, idea_key_schedule *);
void kdecrypt(char *, int, idea_key_schedule *);

void mkencrypt(char *,int,idea_key_schedule *);
void mkdecrypt(char *,int,idea_key_schedule *);
void mencrypt(char *,int,idea_key_schedule *);
void mdecrypt(char *,int,idea_key_schedule *);

#elif TCFS_RC5

#include <linux/rc5.h>

void encrypt(char *, int, rc5_key_schedule *);
void decrypt(char *, int, rc5_key_schedule *);
void kencrypt(char *, int, rc5_key_schedule *);
void kdecrypt(char *, int, rc5_key_schedule *);

void mkencrypt(char *,int,rc5_key_schedule *);
void mkdecrypt(char *,int,rc5_key_schedule *);
void mencrypt(char *,int,rc5_key_schedule *);
void mdecrypt(char *,int,rc5_key_schedule *);


#endif
