/*
 * T.C.F.S. Utils 2.0 $Revision: 1.6 $
 *
 * Authors:	Giuseppe Cattaneo, <cattaneo@udsab.dia.unisa.it>
 *		Giuseppe Persiano, <giuper@udsab.dia.unisa.it>
 *		Luigi Catuogno, <luicat@mikonos.dia.unisa.it>
 *		Angelo Celentano, <angcel@mikonos.dia.unisa.it>
 *		Andrea Cozzolino, <andcoz@mikonos.dia.unisa.it>
 *		Aniello Del Sorbo, <anidel@mikonos.dia.unisa.it>
 *		Ermelindo Mauriello, <ermmau@mikonos.dia.unisa.it>
 *		Raffaele Pisapia, <rafpis@mikonos.dia.unisa.it>
 *
 * Permission  to use,  copy,  and modify this  software  without fee
 * is hereby granted, provided that this entire notice is included in
 * all  copies  of  any  software  which  is  or includes  a copy  or
 * modification of this  software and in all copies of the supporting
 * documentation for such software.
 *
 * This  software maybe  be used for  any purpose provided  the above 
 * copyright  notice  is  retained.  It is  supplied as  is, with  no 
 * warranty expressed or implied.
 */

/*
 *       $Source: /usr/src/linux-2.0.33/fs/tcfs/contrib/utils/lib/RCS/tcfs_dbmaint.c,v $
 *        $State: Exp $
 *
 *     $Revision: 1.6 $
 *       $Author: luicat $
 *         $Date: 1998/01/23 09:35:08 $
 *       $Locker: root $
 */

static const char *RCSid="$Id: tcfs_dbmaint.c,v 1.6 1998/01/23 09:35:08 luicat Exp root $";
/* -+-_== */ 

#include <stdio.h>
#include <stdarg.h>
#include <strings.h>
#include <gdbm.h>
#include <syslog.h>
#include <sys/types.h>
#include <fcntl.h>

#include "tcfslib.h"

int 
tcfspwdbr_new (tcfspwdb **new)
{
  *new = (tcfspwdb *) malloc (sizeof (struct tcfspwdb_r));
  if (!(*new))
    return 0;

  bzero ((void *) *new, sizeof (struct tcfspwdb_r));

  return 1;
}

int 
tcfspwdbr_edit (tcfspwdb *t, int flags,...)
{
  va_list argv;
  tcfspwdb *tmp;
  char *d;


  if (!tcfspwdbr_new (&tmp))
    return 0;

  bcopy (t, tmp, sizeof (struct tcfspwdb_r));

  va_start (argv, flags);

  if (flags & F_USR)
    {
      d = va_arg (argv, char *);
      memcpy (tmp->user, d, strlen (d));
    }

  if (flags & F_PWD)
    {
      d = va_arg (argv, char *);
      memcpy (tmp->upw, d, strlen (d));
    }

  bcopy (tmp, t, sizeof (struct tcfspwdb_r));
  free (tmp);
  va_end (argv);
  return 1;
}


int 
tcfspwdbr_read (tcfspwdb *t, int flags,...)
{
  va_list argv;
  int r;
  char *d;
  int *d2;

  va_start (argv, flags);

  if (flags & F_USR)
    {
      d = va_arg (argv, char *);
      bzero (d, UserLen);
      strcpy (d, t->user);
    }

  if (flags & F_PWD)
    {
      d = va_arg (argv, char *);
      bzero (d, PassLen);
      strcpy (d, t->upw);
    }

  va_end (argv);
  return 0;
}

int 
tcfspwdbr_dispose (tcfspwdb *t)
{
  return free (t);
}

tcfspwdb *
tcfs_gdbm_getpwnam (char *user, tcfspwdb *dest)
{
  GDBM_FILE pdb;
  datum srchkey, r;
  tcfspwdb *p;

  pdb = gdbm_open (TCFSPWDB, TCFSPWDBSIZ, GDBM_READER, 0644, 0);
  if (!pdb)
    return 0;

  if (dest == 0)
    if (!tcfspwdbr_new (&p))
      {
	gdbm_close (pdb);
	return 0;
      }
    else
      dest = p;


  srchkey.dptr = user;
  srchkey.dsize = strlen (user);

  r = gdbm_fetch (pdb, srchkey);
  if (!(r.dptr))
    {
      gdbm_close (pdb);
      return 0;
    }

  bcopy (r.dptr, dest, sizeof (struct tcfspwdb_r));

  gdbm_close (pdb);
  return dest;
}

int 
tcfs_gdbm_putpwnam (char *user, tcfspwdb *src, int flags)
{
  GDBM_FILE pdb;
  static datum srchkey, d;
  int open_flag = 0, owf = 0;


  if (access (TCFSPWDB, 0644) < 0)
    open_flag = GDBM_WRCREAT;
  else
    open_flag = GDBM_WRITER;

  pdb = gdbm_open (TCFSPWDB, TCFSPWDBSIZ, open_flag, 0644, 0);
  if (!pdb)
    return 0;

  srchkey.dptr = user;
  srchkey.dsize = strlen (user);

  if (flags != U_DEL)
    {
      d.dptr = (char *) src;
      d.dsize = sizeof (struct tcfspwdb_r);

      switch (flags)
	{
	case U_NEW:
	  owf = GDBM_INSERT;
	  break;
	case U_CHG:
	  owf = GDBM_REPLACE;
	  break;
	}

      if (gdbm_store (pdb, srchkey, d, owf))
	{
	  gdbm_close (pdb);
	  return 0;
	}
    }
  else if (gdbm_delete (pdb, srchkey))
    {
      gdbm_close (pdb);
      return 0;
    }

  gdbm_close (pdb);
  return 1;
}


tcfspwdb *
tcfs_text_strgetpwnam (char *str, tcfspwdb *dest)
{
  static char *v[NumOfField], **a, *i;
  tcfspwdb *r;

  r = NULL;
  if (!str)
    return NULL;

  i = str;
  if (!dest)
    {
      r = (tcfspwdb *) malloc (sizeof (struct tcfspwdb_r));
      if (!r)
	{
	  syslog (LOG_ERR, "malloc failed");
	  exit (1);
	}
    }
  else
    r = dest;

  bzero (r->user, MaxUserLen);
  bzero (r->upw, UUKEYSIZE);


  for (a = v; (*a = strsep (&i, ":")) != NULL;)
    if (**a != '\0')
      ++a;
    else
      (*(*a - 1) = '\0'), ++a;

  memcpy (r->user, v[0], strlen (v[0]));
  memcpy (r->upw, v[1], strlen (v[1]));

  return r;
}

void 
tcfs_text_strputpwnam (tcfspwdb *f, char *line)
{
  sprintf (line, "%s:%s", f->user, f->upw);
  return;
}

tcfspwdb *
tcfs_text_getpwnam (char *u, tcfspwdb *dest)
{
  tcfspwdb *r;
  static char *var[2], **ap, *is;
  static char line[MaxLineLen];
  int done = 0, lockf;

  FILE *pwdf;

  r = NULL;

  if ((lockf = open (TCFSPWDLOCK, O_RDONLY)) != -1)
    {
      syslog (LOG_ERR, "tcfspasswd locked");
      goto fine;
    }

  pwdf = fopen (TCFSPWDFILE, "r");
  if (!pwdf)
    {
      syslog (LOG_ERR, "cannot open tcfspasswd file");
      goto fine;
    }

  while (!feof (pwdf))
    {
      fgets (line, MaxLineLen, pwdf);
      if (feof (pwdf))
	break;

      is = line;
      for (ap = var; (*ap = strsep (&is, ":")) != NULL;)
	if (**ap != '\0')
	  ++ap;
	else
	  (*(*ap - 1) = '\0'), ++ap;

      if (!strncmp (u, var[0], strlen (u)))
	{
	  done = 1;
	  break;
	}
    }

  fclose (pwdf);
  if (!done)
    goto fine;

  if (!dest)
    {
      r = (tcfspwdb *) malloc (sizeof (struct tcfspwdb_r));
      if (!r)
	{
	  syslog (LOG_ERR, "malloc failed");
	  close (lockf);
	  unlink (TCFSPWDLOCK);
	  exit (1);
	}
    }
  else
    {
      r = dest;
    }

  bzero (r->user, MaxUserLen);
  bzero (r->upw, UUKEYSIZE);
  memcpy (r->user, var[0], strlen (var[0]));
  memcpy (r->upw, var[1], strlen (var[1]));
fine:
  close (lockf);
  unlink (TCFSPWDLOCK);
  return r;
}


int 
tcfs_textdb_putpwnam (tcfspwdb *f, int flags)
{
  char *user;
  FILE *tcfstmp, *tcfspwd;
  static struct tcfspwdb_r e;
  char entry[MaxLineLen], line[MaxLineLen];
  int done = 0, found = 0;

  user = f->user;

  if (!(tcfstmp = fopen (TCFSPWDTMP, "w")))
    {
      syslog (LOG_ERR, "Can't open /etc/tcfstmp, can't update key file");
      return 0;
    }

  tcfspwd = fopen (TCFSPWDFILE, "r");

  while (!feof (tcfspwd))
    {

      fgets (entry, MaxLineLen, tcfspwd);
      if (feof (tcfspwd))
	break;


      if (strncmp (entry, user, strlen (user)) != 0)
	{
	  fwrite (entry, 1, strlen (entry), tcfstmp);
	}
      else
	{
	  found = 1;

	  if (!tcfs_text_strgetpwnam (entry, &e))
	    return 0;

	  if (flags & U_DEL)
	    {
	      done = 1;
	      continue;
	    }

	  if (flags & U_CHG)
	    {
	      tcfs_text_strputpwnam (f, line);
	      fprintf (tcfstmp, "%s\n", line);
	      done = 1;
	      continue;
	    }
	}
    }
  fclose (tcfspwd);

  if ((!done) && (!found))
    {
      fclose (tcfstmp);
      unlink (tcfstmp);
      return 0;
    }

  if ((!done) && (found))
    {
      tcfs_text_strputpwnam (f, line);
      fprintf (tcfstmp, "%s\n", line);
      fclose (tcfstmp);
    }

  unlink (TCFSPWDOLD);
  link (TCFSPWDFILE, TCFSPWDOLD);
  unlink (TCFSPWDFILE);
  link (TCFSPWDTMP, TCFSPWDFILE);
  unlink (TCFSPWDTMP);
  chmod (TCFSPWDFILE, 0644);
  syslog (LOG_INFO, "tcfspasswd updated");
  return 1;
}

int 
tcfs_chgkey (char *u, char *o, char *p)
{
  tcfspwdb *f=NULL, *g=NULL;
  char *tmp, *tmp1;
  int x = 0;

  if (!(tmp=(char*)malloc(UUKEYSIZE)))
  	return 0;

  if (!(tmp1=(char*)malloc(UUKEYSIZE)))
  	return 0;

  if (tcfspwdbr_new (&f))
    if (g = tcfs_getpwnam (u, 0))
      if (tcfs_decrypt_key (u, o, g->upw, &tmp))
	if (tcfs_encrypt_key (u, p, tmp, &tmp1))
	{
	  memcpy (f->upw, tmp1, UUKEYSIZE); /* (char **)&(f->upw))) */
	  if (tcfs_putpwnam (u, f, U_CHG))
	    x = 1;
	}

  if (tmp)
    free (tmp);
  if (tmp1)
    free (tmp1);
  if (g)
    free (g);
  if (f)
    free (f);

  return x;
}
