/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/luicat/source/lib/RCS/unix_auth.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 1999/10/28 10:24:48 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */



#include <stdio.h>
#include <unistd.h>
#include <sys/param.h>
#include <string.h>
#include <tcfslib.h>
#include <pwd.h>
#include <tcfserrors.h>

int unix_auth (char **user, char **password, int flag)
{
	char *luser, *passwd;
#ifdef SHADOW_PASSWORD
	struct spwd *sp;
#else
	struct passwd *passentry;
#endif

	luser=(char*)calloc (MAXLOGNAME, sizeof(char));
	passwd=(char*)calloc (_PASSWORD_LEN, sizeof(char));

	if (!luser || !passwd)
		tcfs_error (ER_MEM, NULL);

	if (flag)
		strcpy (luser, getlogin());
	else
	{
		printf ("Enter user: ");
		fgets(luser,MAXLOGNAME,stdin);
		luser[strlen(luser)-1]='\0';
	}

/*
	strcpy (passwd, getpass ("password:"));
*/
	passwd=getpass("password:");
	
#ifdef SHADOW_PASSWORD
	if ((sp=getspnam(luser))==NULL)
	{
		bzero (passwd, strlen(passwd));
		return 0;
	}

	if (strcmp(crypt (passwd, sp->sp_pwdp), sp->sp_pwdp))
	{
#else
	if ((passentry=getpwnam(luser))==NULL)
	{
		bzero (passwd, strlen(passwd));
		return 0;
	}

	if (strcmp (crypt (passwd, passentry->pw_passwd), passentry->pw_passwd))
	{
#endif
		return 0;
	}

	*user=luser;
	*password=passwd;

	return 1;
}
