/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/luicat/source/lib/RCS/tcfs_getfspath.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 1999/10/28 10:24:48 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */



#include<stdio.h>

#define TCFSTAB "/usr/tcfs/etc/tcfstab"

int tcfs_getfspath(char *label, char *path)
{
	FILE *fp;
	char l[155];
	char *a[2];
	char x;
	int done=0;
	int i=0,j=0;

	if(fp=fopen(TCFSTAB,"r"))
	{
		while((x=fgetc(fp))!=EOF)	
		{
		 switch(x)
		 {
		  case ':':
			 if(!j)
			 {
			   l[i++]='\0';
		 	   j=1;
			   a[j]=l+i;
			   break;
			 }

		  default:
			 l[i++]=x;
			 break;
			
		  case'\n':
			 l[i]='\0';
			   if(j && (!strcmp(a[0],label)) && (l[0]!='#'))
			     	{	
					strcpy(path,a[1]);
					done=1;
					break;
				}
			    else
			    {	
			   	i=j=0;
				a[0]=l;
			   	continue;
			    }

		 }
		 if(done)
				break;
		 a[0]=l;
		}
	fclose(fp);
	}

	return done;
}
