/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/luicat/source/bin/RCS/tcfsrun.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 1999/10/28 10:13:00 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */



#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/wait.h>
#include <kdes.h>
#include <tcfs.h>

char *cmd_def="/bin/sh";
char *usage=
"usage: tcfsrun [-p mount-point | -f fs-label] [cmd] [args...]";
void main(int argc, char *argv[], char *envp[])
{
	char *key,*fs,*cmd,x;
	char *args,fspath[255],cmdname[255];
	uid_t uid;
	pid_t pid;
	int es,i=1;
	int havefspath=0,havecmd=0;

	uid=getuid();

	switch(x=getopt(argc,argv,"m:l:"))
	{
	 case 'p':
		strcpy(fspath,optarg);
		havefspath=1;
		break;
	 case 'f':
		es=tcfs_getfspath(optarg,fspath);
		if(!es)
		{
			fprintf(stderr,"filesystem label not found!\n");
			exit(1);
		}
		havefspath=1;
		break;
	}
	if(!havefspath || argc-optind)
	{
		strcpy(cmdname,argv[optind]);
		havecmd=1;
		cmd=cmdname;
	}

	if(!havefspath)
		{
			es=tcfs_getfspath("default",fspath);
			if(!es)
				exit(1);
		}

	if(!havecmd)
		cmd=cmd_def;

	key=getpass("tcfs key:");

	pid=fork();
	if(!pid) 
		{
		 pid=getpid();
		 if(tcfs_proc_enable(fspath,uid,pid,key)!=-1)
		 {
			setuid(uid);
		 	execve(cmd,argv+optind,envp);
		 }

		 fprintf(stderr,"Operation failed\n");
		 exit(1);
		}
	
	wait(0);
	if (tcfs_proc_disable(fspath,uid,pid)==-1)
	{
		fprintf (stderr,"Problems removing process key\n");
		exit(1);
	}
	exit(0);
}


